/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.types.meta;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openl.binding.IMemberBoundNode;
import org.openl.binding.impl.NodeUsage;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.types.CellMetaInfo;
import org.openl.rules.lang.xls.types.meta.MetaInfoReader;
import org.openl.rules.table.CellKey;
import org.openl.rules.table.CompositeGrid;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.properties.TableProperties;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.java.JavaOpenClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseMetaInfoReader<T extends IMemberBoundNode>
implements MetaInfoReader {
    protected static final CellMetaInfo NOT_FOUND = new CellMetaInfo(null, false);
    private static final Logger LOG = LoggerFactory.getLogger(BaseMetaInfoReader.class);
    private final Map<CellKey, List<NodeUsage>> constantsMap = new HashMap<CellKey, List<NodeUsage>>();
    private T boundNode;

    public BaseMetaInfoReader(T boundNode) {
        this.boundNode = boundNode;
    }

    public void setBoundNode(T boundNode) {
        this.boundNode = boundNode;
    }

    public T getBoundNode() {
        return this.boundNode;
    }

    public void addConstant(ICell cell, NodeUsage nodeUsage) {
        int row = cell.getAbsoluteRow();
        int col = cell.getAbsoluteColumn();
        List nodeUsages = this.constantsMap.computeIfAbsent(CellKey.CellKeyFactory.getCellKey(col, row), e -> new ArrayList());
        nodeUsages.add(nodeUsage);
    }

    protected IGridTable getGridTable() {
        if (this.getTableSyntaxNode().getGridTable().getGrid() instanceof CompositeGrid) {
            return ((CompositeGrid)this.getTableSyntaxNode().getGridTable().getGrid()).getGridTables()[0];
        }
        return this.getTableSyntaxNode().getGridTable();
    }

    @Override
    public final CellMetaInfo getMetaInfo(int row, int col) {
        try {
            if (!IGridRegion.Tool.contains(this.getGridTable().getRegion(), col, row)) {
                return null;
            }
            List<NodeUsage> nodeUsages = this.constantsMap.get(CellKey.CellKeyFactory.getCellKey(col, row));
            if (nodeUsages != null) {
                return new CellMetaInfo((IOpenClass)JavaOpenClass.STRING, false, nodeUsages);
            }
            if (this.isHeaderRow(row)) {
                return this.isHeaderCell(row, col) ? this.getHeaderMetaInfo() : null;
            }
            if (this.isProperties(row, col)) {
                return this.getPropertiesMetaInfo(row, col);
            }
            return this.getBodyMetaInfo(row, col);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public void prepare(IGridRegion region) {
    }

    @Override
    public void release() {
    }

    protected abstract TableSyntaxNode getTableSyntaxNode();

    protected abstract CellMetaInfo getHeaderMetaInfo();

    protected abstract CellMetaInfo getBodyMetaInfo(int var1, int var2);

    protected boolean isNeededCell(CellKey cellKey, int row, int col) {
        return cellKey.getColumn() == col && cellKey.getRow() == row;
    }

    protected boolean isNeededCell(ICell cell, int row, int col) {
        return cell.getAbsoluteColumn() == col && cell.getAbsoluteRow() == row;
    }

    private boolean isHeaderRow(int row) {
        TableSyntaxNode syntaxNode = this.getTableSyntaxNode();
        return syntaxNode.getTable().getCell(0, 0).getAbsoluteRow() == row;
    }

    private boolean isHeaderCell(int row, int col) {
        TableSyntaxNode syntaxNode = this.getTableSyntaxNode();
        return this.isNeededCell(syntaxNode.getTable().getCell(0, 0), row, col);
    }

    private boolean isProperties(int row, int col) {
        TableSyntaxNode tableSyntaxNode = this.getTableSyntaxNode();
        if (!tableSyntaxNode.hasPropertiesDefinedInTable()) {
            return false;
        }
        ILogicalTable propertiesSection = tableSyntaxNode.getTableProperties().getPropertiesSection();
        ICell firstCell = propertiesSection.getCell(0, 0);
        int r = row - firstCell.getAbsoluteRow();
        int c = col - firstCell.getAbsoluteColumn();
        return c >= -1 && r >= 0 && r < propertiesSection.getHeight() && c < propertiesSection.getWidth();
    }

    private CellMetaInfo getPropertiesMetaInfo(int row, int col) {
        ILogicalTable propertiesSection = this.getTableSyntaxNode().getTableProperties().getPropertiesSection();
        ICell firstCell = propertiesSection.getCell(0, 0);
        int r = row - firstCell.getAbsoluteRow();
        int c = col - firstCell.getAbsoluteColumn();
        if (c == 1) {
            String fieldName = propertiesSection.getCell(0, r).getStringValue();
            IOpenField field = JavaOpenClass.getOpenClass(TableProperties.class).getField(fieldName);
            if (field != null) {
                IOpenClass type = field.getType();
                if (type.getAggregateInfo().isAggregate(type)) {
                    return new CellMetaInfo(type.getAggregateInfo().getComponentType(type), true);
                }
                return new CellMetaInfo(type, false);
            }
            return null;
        }
        return null;
    }
}

