/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.prebind;

import java.util.Set;
import org.openl.ICompileContext;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IMemberBoundNode;
import org.openl.conf.IUserContext;
import org.openl.dependency.CompiledDependency;
import org.openl.rules.binding.RulesModuleBindingContext;
import org.openl.rules.calc.SpreadsheetBoundNode;
import org.openl.rules.constants.ConstantsTableBoundNode;
import org.openl.rules.data.IDataBase;
import org.openl.rules.datatype.binding.AliasDatatypeBoundNode;
import org.openl.rules.datatype.binding.DatatypeTableBoundNode;
import org.openl.rules.dt.ADtColumnsDefinitionTableBoundNode;
import org.openl.rules.lang.xls.XlsBinder;
import org.openl.rules.lang.xls.XlsHelper;
import org.openl.rules.lang.xls.binding.XlsMetaInfo;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.lang.xls.prebind.IPrebindHandler;
import org.openl.rules.lang.xls.prebind.XlsLazyModuleOpenClass;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.syntax.XlsModuleSyntaxNode;
import org.openl.rules.property.PropertyTableBoundNode;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.xls.RulesCompileContext;

public class XlsPreBinder
extends XlsBinder {
    private final IPrebindHandler prebindHandler;

    public XlsPreBinder(IUserContext userContext, IPrebindHandler prebindHandler) {
        super((ICompileContext)new RulesCompileContext(), userContext);
        this.prebindHandler = prebindHandler;
    }

    @Override
    protected void finalizeBind(IMemberBoundNode memberBoundNode, TableSyntaxNode tableSyntaxNode, RulesModuleBindingContext rulesModuleBindingContext) {
        if (memberBoundNode instanceof DatatypeTableBoundNode || memberBoundNode instanceof AliasDatatypeBoundNode || memberBoundNode instanceof PropertyTableBoundNode || memberBoundNode instanceof ConstantsTableBoundNode || memberBoundNode instanceof ADtColumnsDefinitionTableBoundNode || memberBoundNode instanceof SpreadsheetBoundNode) {
            try {
                memberBoundNode.finalizeBind((IBindingContext)rulesModuleBindingContext);
            }
            catch (SyntaxNodeException error) {
                this.processError(error, tableSyntaxNode, rulesModuleBindingContext);
            }
            catch (Exception | LinkageError t) {
                SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((Throwable)t, (ISyntaxNode)tableSyntaxNode);
                this.processError(error, tableSyntaxNode, rulesModuleBindingContext);
            }
        }
    }

    @Override
    protected XlsModuleOpenClass createModuleOpenClass(XlsModuleSyntaxNode moduleNode, OpenL openl, IDataBase dbase, Set<CompiledDependency> moduleDependencies, IBindingContext bindingContext) {
        if (this.prebindHandler != null) {
            return new XlsLazyModuleOpenClass(XlsHelper.getModuleName(moduleNode), new XlsMetaInfo(moduleNode), openl, dbase, moduleDependencies, Thread.currentThread().getContextClassLoader(), bindingContext, this.prebindHandler);
        }
        return new XlsModuleOpenClass(XlsHelper.getModuleName(moduleNode), new XlsMetaInfo(moduleNode), openl, dbase, moduleDependencies, Thread.currentThread().getContextClassLoader(), bindingContext);
    }
}

