/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.load;

import org.apache.poi.ss.usermodel.Workbook;
import org.openl.rules.lang.xls.SpreadsheetConstants;
import org.openl.rules.lang.xls.load.LazySheetLoader;
import org.openl.rules.lang.xls.load.SheetLoader;
import org.openl.rules.lang.xls.load.WorkbookLoadUtils;
import org.openl.rules.lang.xls.load.WorkbookLoader;
import org.openl.source.IOpenSourceCodeModule;

public class GreedyLazyWorkbookLoader
implements WorkbookLoader {
    private final IOpenSourceCodeModule fileSource;
    private Workbook workbook;
    private SpreadsheetConstants spreadsheetConstants;

    public GreedyLazyWorkbookLoader(IOpenSourceCodeModule fileSource) {
        this.fileSource = fileSource;
    }

    @Override
    public Workbook getWorkbook() {
        if (this.workbook == null) {
            this.workbook = WorkbookLoadUtils.loadWorkbook(this.fileSource);
        }
        return this.workbook;
    }

    @Override
    public SheetLoader getSheetLoader(int sheetIndex) {
        return new LazySheetLoader(this, sheetIndex);
    }

    @Override
    public boolean isCanUnload() {
        return false;
    }

    @Override
    public void setCanUnload(boolean canUnload) {
    }

    @Override
    public int getNumberOfSheets() {
        return this.getWorkbook().getNumberOfSheets();
    }

    @Override
    public SpreadsheetConstants getSpreadsheetConstants() {
        if (this.spreadsheetConstants == null) {
            this.spreadsheetConstants = new SpreadsheetConstants(this.getWorkbook().getSpreadsheetVersion());
        }
        return this.spreadsheetConstants;
    }
}

