/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.classes;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.openl.rules.lang.xls.classes.ClassLocator;
import org.openl.rules.lang.xls.classes.DirectoryClassLocator;
import org.openl.rules.lang.xls.classes.JarClassLocator;
import org.openl.rules.lang.xls.classes.LocatorExceptionHandler;
import org.openl.rules.lang.xls.classes.LoggingExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassFinder {
    private static final Class[] NO_CLASSES = new Class[0];
    private static final Logger LOG = LoggerFactory.getLogger(ClassFinder.class);
    private final Map<String, ClassLocator> locators = new HashMap<String, ClassLocator>();

    public ClassFinder() {
        this(Collections.singletonList(new LoggingExceptionHandler()));
    }

    public ClassFinder(List<? extends LocatorExceptionHandler> handlers) {
        this.initDefaultLocators(handlers);
    }

    public void setLocator(String protocol, ClassLocator locator) {
        this.locators.put(protocol.toLowerCase(), locator);
    }

    public Class<?>[] getClasses(String packageName) {
        return this.getClasses(packageName, Thread.currentThread().getContextClassLoader());
    }

    public Class<?>[] getClasses(String packageName, ClassLoader classLoader) {
        Enumeration<URL> resources;
        String path = packageName.replace('.', '/');
        try {
            resources = classLoader.getResources(path);
        }
        catch (IOException e) {
            LOG.debug(e.getMessage(), (Throwable)e);
            return NO_CLASSES;
        }
        HashSet classes = new HashSet();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            String protocol = resource.getProtocol();
            if (protocol == null) continue;
            ClassLocator locator = this.locators.get(protocol.toLowerCase());
            if (locator != null) {
                classes.addAll(locator.getClasses(resource, packageName, classLoader));
                continue;
            }
            LOG.warn("A ClassLocator for protocol '{}' is not found.", (Object)protocol);
        }
        return classes.toArray(new Class[0]);
    }

    private void initDefaultLocators(List<? extends LocatorExceptionHandler> handlers) {
        this.setLocator("file", new DirectoryClassLocator(handlers));
        this.setLocator("jar", new JarClassLocator(handlers));
        this.setLocator("wsjar", new JarClassLocator(handlers));
        this.setLocator("zip", new JarClassLocator(handlers));
    }
}

