/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.binding;

import com.rits.cloning.Cloner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.openl.CompiledOpenClass;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.MethodUtil;
import org.openl.binding.exception.AmbiguousFieldException;
import org.openl.binding.exception.DuplicatedFieldException;
import org.openl.binding.exception.DuplicatedMethodException;
import org.openl.binding.exception.DuplicatedTypeException;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.component.ComponentOpenClass;
import org.openl.binding.impl.module.ModuleOpenClass;
import org.openl.binding.impl.module.ModuleSpecificType;
import org.openl.classloader.OpenLClassLoader;
import org.openl.dependency.CompiledDependency;
import org.openl.engine.ExtendableModuleOpenClass;
import org.openl.engine.OpenLSystemProperties;
import org.openl.exception.OpenlNotCheckedException;
import org.openl.message.OpenLMessagesUtils;
import org.openl.rules.binding.RulesModuleBindingContext;
import org.openl.rules.calc.CustomSpreadsheetResultOpenClass;
import org.openl.rules.calc.SpreadsheetResultOpenClass;
import org.openl.rules.constants.ConstantOpenField;
import org.openl.rules.convertor.ObjectToDataOpenCastConvertor;
import org.openl.rules.data.DataOpenField;
import org.openl.rules.data.IDataBase;
import org.openl.rules.data.ITable;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.lang.xls.binding.DuplicatedTableException;
import org.openl.rules.lang.xls.binding.XlsDefinitions;
import org.openl.rules.lang.xls.binding.XlsMetaInfo;
import org.openl.rules.lang.xls.binding.wrapper.WrapperLogic;
import org.openl.rules.lang.xls.syntax.XlsModuleSyntaxNode;
import org.openl.rules.method.ExecutableRulesMethod;
import org.openl.rules.table.OpenLArgumentsCloner;
import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.table.properties.PropertiesHelper;
import org.openl.rules.table.properties.def.TablePropertyDefinition;
import org.openl.rules.table.properties.def.TablePropertyDefinitionUtils;
import org.openl.rules.testmethod.TestSuiteMethod;
import org.openl.rules.types.DuplicateMemberThrowExceptionHelper;
import org.openl.rules.types.OpenMethodDispatcher;
import org.openl.rules.types.impl.MatchingOpenMethodDispatcher;
import org.openl.rules.types.impl.OverloadedMethodsDispatcherTable;
import org.openl.syntax.code.IParsedCode;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethod;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.impl.DomainOpenClass;
import org.openl.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XlsModuleOpenClass
extends ModuleOpenClass
implements ExtendableModuleOpenClass {
    private static final Logger LOG = LoggerFactory.getLogger(ModuleOpenClass.class);
    private final IDataBase dataBase;
    private final boolean useDecisionTableDispatcher;
    private final boolean dispatchingValidationEnabled;
    private Collection<String> imports = Collections.emptySet();
    private final ClassLoader classLoader;
    private final OpenLClassLoader classGenerationClassLoader;
    private RulesModuleBindingContext rulesModuleBindingContext;
    private final XlsDefinitions xlsDefinitions = new XlsDefinitions();
    private SpreadsheetResultOpenClass spreadsheetResultOpenClass;
    private ITableProperties globalTableProperties;
    private final Map<String, List<IOpenField>> hiddenFields = new HashMap<String, List<IOpenField>>();
    private final Map<String, List<IOpenField>> hiddenLowerCasedFields = new HashMap<String, List<IOpenField>>();
    private final ObjectToDataOpenCastConvertor objectToDataOpenCastConvertor = new ObjectToDataOpenCastConvertor();
    private volatile OpenLArgumentsCloner cloner;

    public RulesModuleBindingContext getRulesModuleBindingContext() {
        return this.rulesModuleBindingContext;
    }

    public XlsModuleOpenClass(String moduleName, XlsMetaInfo xlsMetaInfo, OpenL openl, IDataBase dbase, Set<CompiledDependency> usingModules, ClassLoader classLoader, IBindingContext bindingContext) {
        super(moduleName, openl);
        this.dataBase = dbase;
        this.xlsMetaInfo = xlsMetaInfo;
        this.useDecisionTableDispatcher = OpenLSystemProperties.isDTDispatchingMode(bindingContext.getExternalParams());
        this.dispatchingValidationEnabled = OpenLSystemProperties.isDispatchingValidationEnabled(bindingContext.getExternalParams());
        this.classLoader = classLoader;
        this.classGenerationClassLoader = new OpenLClassLoader(null);
        this.classGenerationClassLoader.addClassLoader(classLoader);
        this.rulesModuleBindingContext = new RulesModuleBindingContext(bindingContext, this);
        this.globalTableProperties = TablePropertyDefinitionUtils.buildGlobalTableProperties();
        if (OpenLSystemProperties.isCustomSpreadsheetTypesSupported(bindingContext.getExternalParams())) {
            this.spreadsheetResultOpenClass = new SpreadsheetResultOpenClass(this);
        }
        if (usingModules != null) {
            this.setDependencies(usingModules);
            this.initDependencies();
        }
        this.initImports(xlsMetaInfo.getXlsModuleNode());
    }

    public ITableProperties getGlobalTableProperties() {
        return this.globalTableProperties;
    }

    public ObjectToDataOpenCastConvertor getObjectToDataOpenCastConvertor() {
        return this.objectToDataOpenCastConvertor;
    }

    public void addGlobalTableProperties(ITableProperties globalProperties) {
        if (globalProperties != null) {
            if (this.getGlobalTableProperties().getPriority() < globalProperties.getPriority()) {
                this.globalTableProperties = globalProperties;
            } else if (Objects.equals(this.getGlobalTableProperties().getPriority(), globalProperties.getPriority())) {
                Map<String, Object> mergedTableProperties = TablePropertyDefinitionUtils.mergeGlobalProperties(this.globalTableProperties.getGlobalProperties(), globalProperties.getGlobalProperties());
                this.globalTableProperties = TablePropertyDefinitionUtils.buildGlobalTableProperties(mergedTableProperties);
            }
        }
    }

    public boolean isUseDecisionTableDispatcher() {
        return this.useDecisionTableDispatcher;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public OpenLClassLoader getClassGenerationClassLoader() {
        return this.classGenerationClassLoader;
    }

    private void initImports(XlsModuleSyntaxNode xlsModuleSyntaxNode) {
        this.imports = Collections.unmodifiableSet(new HashSet<String>(xlsModuleSyntaxNode.getImports()));
    }

    public IDataBase getDataBase() {
        return this.dataBase;
    }

    protected void addXlsDefinitions(CompiledDependency dependency) {
        IOpenClass openClass = dependency.getCompiledOpenClass().getOpenClassWithErrors();
        if (openClass instanceof XlsModuleOpenClass) {
            XlsModuleOpenClass xlsModuleOpenClass = (XlsModuleOpenClass)openClass;
            this.xlsDefinitions.addAll(xlsModuleOpenClass.getXlsDefinitions());
        }
    }

    public XlsDefinitions getXlsDefinitions() {
        return this.xlsDefinitions;
    }

    protected IOpenClass processDependencyTypeBeforeAdding(IOpenClass type) {
        if (type instanceof ModuleSpecificType) {
            IOpenClass existingType = this.findType(type.getName());
            if (existingType != null) {
                ModuleSpecificType existingModuleRelatedType = (ModuleSpecificType)existingType;
                existingModuleRelatedType.updateWithType(type);
                return existingType;
            }
            return ((ModuleSpecificType)type).makeCopyForModule((ModuleOpenClass)this);
        }
        return super.processDependencyTypeBeforeAdding(type);
    }

    protected void initDependencies() {
        ArrayList<IOpenField> fields = new ArrayList<IOpenField>();
        HashMap<String, ITable> dataTables = new HashMap<String, ITable>();
        for (CompiledDependency dependency : this.getDependencies()) {
            this.addDependencyTypes(dependency);
            this.addXlsDefinitions(dependency);
            this.addGlobalTableProperties(dependency);
            this.addMethods(dependency);
            this.collectDataTables(dependency, dataTables);
            this.collectDependencyFields(dependency, fields);
        }
        this.addDataTablesFromDependencies(dataTables);
        this.addFieldsFromDependencies(fields);
        for (IOpenClass type : this.getTypes()) {
            if (!(type instanceof CustomSpreadsheetResultOpenClass)) continue;
            ((CustomSpreadsheetResultOpenClass)type).fixModuleFieldTypes();
        }
    }

    public IOpenField getField(String fname, boolean strictMatch) throws AmbiguousFieldException {
        IOpenField field = super.getField(fname, strictMatch);
        if (field == null && (strictMatch && this.hiddenFields.containsKey(fname) || !strictMatch && this.hiddenLowerCasedFields.containsKey(fname))) {
            throw new AmbiguousFieldException(fname, strictMatch ? this.hiddenFields.get(fname) : this.hiddenLowerCasedFields.get(fname.toLowerCase()));
        }
        return field;
    }

    private void addFieldsFromDependencies(List<IOpenField> fields) {
        int i;
        HashSet<Integer> fieldsToHide = new HashSet<Integer>();
        for (i = 0; i < fields.size() - 1; ++i) {
            for (int j = i + 1; j < fields.size(); ++j) {
                IOpenField openField1 = fields.get(i);
                IOpenField openField2 = fields.get(j);
                if (!Objects.equals(openField1.getName(), openField2.getName()) || !(openField1 instanceof DataOpenField) || !(openField2 instanceof DataOpenField) || !XlsNodeTypes.XLS_DATA.equals((Object)((DataOpenField)openField1).getNodeType()) || !XlsNodeTypes.XLS_DATA.equals((Object)((DataOpenField)openField2).getNodeType()) || Objects.equals(((DataOpenField)openField1).getUri(), ((DataOpenField)openField2).getUri())) continue;
                fieldsToHide.add(i);
                fieldsToHide.add(j);
            }
        }
        for (i = 0; i < fields.size(); ++i) {
            if (!fieldsToHide.contains(i)) {
                this.addField(fields.get(i));
                continue;
            }
            IOpenField f = fields.get(i);
            this.hiddenFields.computeIfAbsent(f.getName(), e -> new ArrayList()).add(f);
            this.hiddenLowerCasedFields.computeIfAbsent(f.getName().toLowerCase(), e -> new ArrayList()).add(f);
        }
    }

    private void collectDependencyFields(CompiledDependency dependency, List<IOpenField> depFields) {
        CompiledOpenClass compiledOpenClass = dependency.getCompiledOpenClass();
        for (IOpenField depField : compiledOpenClass.getOpenClassWithErrors().getFields()) {
            if (!this.isDependencyFieldInheritable(depField)) continue;
            depFields.add(depField);
        }
    }

    private void collectDataTables(CompiledDependency dependency, Map<String, ITable> dataTables) {
        XlsModuleOpenClass xlsModuleOpenClass;
        IOpenClass openClass = dependency.getCompiledOpenClass().getOpenClassWithErrors();
        if (openClass instanceof XlsModuleOpenClass && (xlsModuleOpenClass = (XlsModuleOpenClass)openClass).getDataBase() != null) {
            for (ITable table : xlsModuleOpenClass.getDataBase().getTables()) {
                if (!XlsNodeTypes.XLS_DATA.equals((Object)table.getXlsNodeType())) continue;
                if (!dataTables.containsKey(table.getName())) {
                    dataTables.put(table.getName(), table);
                    continue;
                }
                ITable existingTable = dataTables.get(table.getName());
                if (existingTable == null || Objects.equals(existingTable.getUri(), table.getUri())) continue;
                dataTables.put(table.getName(), null);
            }
        }
    }

    private void addDataTablesFromDependencies(Map<String, ITable> dataTables) {
        for (ITable table : dataTables.values()) {
            if (table == null) continue;
            try {
                this.getDataBase().registerTable(table);
            }
            catch (DuplicatedTableException e) {
                this.rulesModuleBindingContext.addError(e);
            }
            catch (OpenlNotCheckedException e) {
                this.addError(e);
            }
        }
    }

    private void addDependencyTypes(CompiledDependency dependency) {
        CompiledOpenClass compiledOpenClass = dependency.getCompiledOpenClass();
        for (IOpenClass type : compiledOpenClass.getTypes()) {
            try {
                IOpenClass openClass = this.processDependencyTypeBeforeAdding(type);
                try {
                    this.addType(openClass);
                }
                catch (DuplicatedTypeException ex) {
                    if (openClass instanceof DomainOpenClass) {
                        this.rulesModuleBindingContext.addMessage(OpenLMessagesUtils.newWarnMessage((String)ex.getMessage()));
                        continue;
                    }
                    this.addError(ex);
                }
            }
            catch (OpenlNotCheckedException e) {
                this.addError(e);
            }
        }
    }

    protected void addGlobalTableProperties(CompiledDependency dependency) {
        IOpenClass openClass = dependency.getCompiledOpenClass().getOpenClassWithErrors();
        if (openClass instanceof XlsModuleOpenClass) {
            XlsModuleOpenClass xlsModuleOpenClass = (XlsModuleOpenClass)openClass;
            this.addGlobalTableProperties(xlsModuleOpenClass.getGlobalTableProperties());
        }
    }

    protected void addMethods(CompiledDependency dependency) throws DuplicatedMethodException {
        CompiledOpenClass compiledOpenClass = dependency.getCompiledOpenClass();
        for (IOpenMethod dependencyMethod : compiledOpenClass.getOpenClassWithErrors().getMethods()) {
            if (dependencyMethod.isConstructor() || dependencyMethod instanceof ComponentOpenClass.GetOpenClass) continue;
            try {
                if (!this.isDependencyMethodInheritable(dependencyMethod)) continue;
                this.addMethod(dependencyMethod);
            }
            catch (OpenlNotCheckedException e) {
                LOG.debug(String.format("An exception occurred during adding the method '%s'.", MethodUtil.printMethod((String)dependencyMethod.getName(), (IOpenClass[])dependencyMethod.getSignature().getParameterTypes())), (Throwable)e);
                this.addError(e);
            }
        }
    }

    public Collection<String> getImports() {
        return this.imports;
    }

    protected boolean isDependencyMethodInheritable(IOpenMethod openMethod) {
        if (openMethod instanceof TestSuiteMethod) {
            return false;
        }
        return super.isDependencyMethodInheritable(openMethod);
    }

    protected boolean isDependencyFieldInheritable(IOpenField openField) {
        if (openField instanceof ConstantOpenField || openField instanceof DataOpenField && XlsNodeTypes.XLS_DATA.equals((Object)((DataOpenField)openField).getNodeType())) {
            return true;
        }
        return super.isDependencyFieldInheritable(openField);
    }

    public void applyToDependentParsedCode(IParsedCode parsedCode) {
        Objects.requireNonNull(parsedCode, "parsedCode cannot be null");
        if (parsedCode.getTopNode() instanceof XlsModuleSyntaxNode) {
            XlsModuleSyntaxNode xlsModuleSyntaxNode = (XlsModuleSyntaxNode)parsedCode.getTopNode();
            for (String value : this.getImports()) {
                xlsModuleSyntaxNode.addImport(value);
            }
        }
    }

    public SpreadsheetResultOpenClass getSpreadsheetResultOpenClassWithResolvedFieldTypes() {
        return this.spreadsheetResultOpenClass;
    }

    public XlsMetaInfo getXlsMetaInfo() {
        return (XlsMetaInfo)this.xlsMetaInfo;
    }

    public void addField(IOpenField openField) {
        Map fields = this.fieldMap();
        IOpenField existedField = (IOpenField)fields.get(openField.getName());
        if (existedField != null) {
            if (openField instanceof DataOpenField && existedField instanceof DataOpenField && XlsNodeTypes.XLS_DATA.equals((Object)((DataOpenField)openField).getNodeType()) && XlsNodeTypes.XLS_DATA.equals((Object)((DataOpenField)existedField).getNodeType())) {
                return;
            }
            if (openField instanceof ConstantOpenField && existedField instanceof ConstantOpenField && Objects.equals(((ConstantOpenField)openField).getValue(), ((ConstantOpenField)existedField).getValue()) && openField.getType().equals(existedField.getType())) {
                return;
            }
            throw new DuplicatedFieldException("", openField.getName());
        }
        fields.put(openField.getName(), openField);
        this.addFieldToLowerCaseMap(openField);
    }

    public void addMethod(IOpenMethod method) {
        if (method instanceof OpenMethodDispatcher) {
            for (IOpenMethod candidate : ((OpenMethodDispatcher)method).getCandidates()) {
                this.addMethod(candidate);
            }
            return;
        }
        IOpenMethod m = WrapperLogic.wrapOpenMethod(method, this);
        IOpenMethod existedMethod = this.getDeclaredMethod(m.getName(), m.getSignature().getParameterTypes());
        if (existedMethod != null) {
            if (method instanceof TestSuiteMethod) {
                DuplicateMemberThrowExceptionHelper.throwDuplicateMethodExceptionIfMethodsAreNotTheSame(method, existedMethod);
                return;
            }
            if (!existedMethod.getType().equals(m.getType())) {
                String message = String.format("Method '%s' is already defined with another return type '%s'.", MethodUtil.printSignature((IOpenMethodHeader)m, (int)1), existedMethod.getType().getDisplayName(0));
                throw new DuplicatedMethodException(message, existedMethod, method);
            }
            if (existedMethod instanceof OpenMethodDispatcher) {
                OpenMethodDispatcher decorator = (OpenMethodDispatcher)existedMethod;
                decorator.addMethod(WrapperLogic.unwrapOpenMethod(m));
            } else if (!m.equals(existedMethod)) {
                OpenMethodDispatcher dispatcher = this.getOpenMethodDispatcher(existedMethod);
                IOpenMethod openMethod = WrapperLogic.wrapOpenMethod(dispatcher, this);
                this.overrideMethod(openMethod);
                dispatcher.addMethod(WrapperLogic.unwrapOpenMethod(m));
            }
        } else if (this.dispatchingValidationEnabled && !(m instanceof TestSuiteMethod) && this.isDimensionalPropertyPresented(m)) {
            OpenMethodDispatcher dispatcher = this.getOpenMethodDispatcher(m);
            IOpenMethod openMethod = WrapperLogic.wrapOpenMethod(dispatcher, this);
            super.addMethod(openMethod);
        } else {
            super.addMethod(m);
        }
    }

    private boolean isDimensionalPropertyPresented(IOpenMethod m) {
        List<TablePropertyDefinition> dimensionalPropertiesDef = TablePropertyDefinitionUtils.getDimensionalTableProperties();
        ITableProperties propertiesFromMethod = PropertiesHelper.getTableProperties(m);
        for (TablePropertyDefinition dimensionProperty : dimensionalPropertiesDef) {
            String propertyValue = propertiesFromMethod.getPropertyValueAsString(dimensionProperty.getName());
            if (!StringUtils.isNotEmpty((CharSequence)propertyValue)) continue;
            return true;
        }
        return false;
    }

    private OpenMethodDispatcher getOpenMethodDispatcher(IOpenMethod method) {
        IOpenMethod decorated = WrapperLogic.unwrapOpenMethod(method);
        MatchingOpenMethodDispatcher decorator = this.useDecisionTableDispatcher ? new OverloadedMethodsDispatcherTable(decorated, this) : new MatchingOpenMethodDispatcher(decorated, this);
        return decorator;
    }

    public void clearForExecutionMode() {
        super.clearForExecutionMode();
        this.dataBase.clearOddDataForExecutionMode();
        this.rulesModuleBindingContext = null;
        for (IOpenMethod openMethod : this.getMethods()) {
            this.clearForExecutionMode(openMethod);
        }
    }

    private void clearForExecutionMode(IOpenMethod openMethod) {
        if (openMethod instanceof OpenMethodDispatcher) {
            for (IOpenMethod candidate : ((OpenMethodDispatcher)openMethod).getCandidates()) {
                this.clearForExecutionMode(candidate);
            }
        } else if (openMethod instanceof ExecutableRulesMethod) {
            ((ExecutableRulesMethod)openMethod).clearForExecutionMode();
        }
    }

    public void completeOpenClassBuilding() {
        this.addTestSuiteMethodsFromDependencies();
    }

    private TestSuiteMethod createNewTestSuiteMethod(TestSuiteMethod testSuiteMethod) {
        IOpenMethod method = testSuiteMethod.getTestedMethod();
        IOpenMethod newTargetMethod = this.getDeclaredMethod(method.getName(), method.getSignature().getParameterTypes());
        TestSuiteMethod copy = new TestSuiteMethod(newTargetMethod, testSuiteMethod);
        copy.setModuleName(testSuiteMethod.getModuleName());
        return copy;
    }

    private void validateType(IOpenClass type) {
        if (type instanceof CustomSpreadsheetResultOpenClass) {
            for (IOpenClass t : this.getTypes()) {
                CustomSpreadsheetResultOpenClass csrType;
                if (!(t instanceof CustomSpreadsheetResultOpenClass) || !Objects.equals((csrType = (CustomSpreadsheetResultOpenClass)t).getName(), type.getName()) || !csrType.isBeanClassInitialized()) continue;
                throw new IllegalStateException(String.format("This module does not support adding '%s' custom spreadsheet result types. Bean class has already been initialized for existing custom spreadsheet result type.", csrType.getName()));
            }
        }
    }

    public void addType(IOpenClass type) {
        this.validateType(type);
        super.addType(type);
    }

    protected void addTestSuiteMethodsFromDependencies() {
        for (CompiledDependency dependency : this.getDependencies()) {
            for (IOpenMethod dependencyMethod : dependency.getCompiledOpenClass().getOpenClassWithErrors().getMethods()) {
                if (!(dependencyMethod instanceof TestSuiteMethod)) continue;
                TestSuiteMethod testSuiteMethod = (TestSuiteMethod)dependencyMethod;
                try {
                    TestSuiteMethod newTestSuiteMethod = this.createNewTestSuiteMethod(testSuiteMethod);
                    this.addMethod((IOpenMethod)newTestSuiteMethod);
                }
                catch (OpenlNotCheckedException e) {
                    this.addError(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cloner getCloner() {
        if (this.cloner == null) {
            XlsModuleOpenClass xlsModuleOpenClass = this;
            synchronized (xlsModuleOpenClass) {
                if (this.cloner == null) {
                    this.cloner = new OpenLArgumentsCloner();
                }
            }
        }
        return this.cloner;
    }

    private void addError(Throwable e) {
        BindHelper.processError((Throwable)e, (IBindingContext)this.rulesModuleBindingContext);
    }
}

