/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openl.exception.OpenLCompilationException;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.lang.xls.XlsSheetSourceCodeModule;
import org.openl.rules.lang.xls.syntax.HeaderSyntaxNode;
import org.openl.rules.lang.xls.syntax.SpreadsheetHeaderNode;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.syntax.XlsModuleSyntaxNode;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.rules.table.syntax.GridLocation;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.syntax.impl.Tokenizer;
import org.openl.types.IModuleInfo;
import org.openl.util.text.ILocation;
import org.openl.util.text.TextInterval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XlsHelper {
    private static final Map<String, String> TABLE_HEADERS;

    private XlsHelper() {
    }

    public static String getModuleName(XlsModuleSyntaxNode node) {
        if (node.getModule() instanceof IModuleInfo) {
            return ((IModuleInfo)node.getModule()).getModuleName();
        }
        String uri = node.getModule().getUri();
        try {
            URL url = new URL(uri);
            String fileName = url.getFile();
            int index = fileName.lastIndexOf(47);
            fileName = index < 0 ? fileName : fileName.substring(index + 1);
            index = fileName.lastIndexOf(46);
            if (index > 0) {
                fileName = fileName.substring(0, index);
            }
            return fileName;
        }
        catch (MalformedURLException e) {
            if ("<virtual_uri>".equals(uri)) {
                return "VirtualModule";
            }
            Logger log = LoggerFactory.getLogger(XlsHelper.class);
            log.error("Failed URI conversation to module name.", (Throwable)e);
            return "UndefinedXlsType";
        }
    }

    public static TableSyntaxNode createTableSyntaxNode(IGridTable table, XlsSheetSourceCodeModule source) throws OpenLCompilationException {
        GridCellSourceCodeModule src = new GridCellSourceCodeModule(table);
        IdentifierNode[] headerTokens = Tokenizer.tokenize((IOpenSourceCodeModule)src, (String)" \n\r");
        if (headerTokens.length == 0) {
            headerTokens = new IdentifierNode[]{Tokenizer.firstToken((IOpenSourceCodeModule)src, (String)" \n\r")};
        }
        IdentifierNode headerToken = headerTokens[0];
        String header = headerTokens[0].getIdentifier();
        String xlsType = TABLE_HEADERS.get(header);
        if (xlsType == null) {
            xlsType = XlsNodeTypes.XLS_OTHER.toString();
        }
        ArrayList<String> collectParameters = new ArrayList<String>();
        boolean isCollect = false;
        if ((header.equals("SimpleRules") || header.equals("SmartRules") || header.equals("SimpleLookup") || header.equals("SmartLookup")) && headerTokens.length > 1 && headerTokens[1].getIdentifier().equals("Collect")) {
            isCollect = true;
            if (headerTokens.length > 2 && headerTokens[2].getIdentifier().equals("as")) {
                int i = 3;
                collectParameters.add(headerTokens[i].getIdentifier());
                if (headerTokens[i + 1].getIdentifier().equals("and")) {
                    collectParameters.add(headerTokens[i += 2].getIdentifier());
                }
                TextInterval location = new TextInterval(headerToken.getLocation().getStart(), headerTokens[i].getLocation().getEnd());
                headerToken = new IdentifierNode(headerToken.getType(), (ILocation)location, header, headerToken.getModule());
            } else {
                TextInterval location = new TextInterval(headerToken.getLocation().getStart(), headerTokens[1].getLocation().getEnd());
                headerToken = new IdentifierNode(headerToken.getType(), (ILocation)location, header, headerToken.getModule());
            }
        }
        HeaderSyntaxNode headerNode = XlsNodeTypes.XLS_SPREADSHEET.toString().equals(xlsType) ? new SpreadsheetHeaderNode(src, headerToken) : new HeaderSyntaxNode(src, headerToken, isCollect, collectParameters.toArray(new String[0]));
        GridLocation pos = new GridLocation(table);
        return new TableSyntaxNode(xlsType, pos, source, table, headerNode);
    }

    static {
        HashMap<String, String> tableHeaders = new HashMap<String, String>();
        tableHeaders.put("Constants", XlsNodeTypes.XLS_CONSTANTS.toString());
        tableHeaders.put("DT", XlsNodeTypes.XLS_DT.toString());
        tableHeaders.put("Rules", XlsNodeTypes.XLS_DT.toString());
        tableHeaders.put("SimpleRules", XlsNodeTypes.XLS_DT.toString());
        tableHeaders.put("SmartRules", XlsNodeTypes.XLS_DT.toString());
        tableHeaders.put("SimpleLookup", XlsNodeTypes.XLS_DT.toString());
        tableHeaders.put("SmartLookup", XlsNodeTypes.XLS_DT.toString());
        tableHeaders.put("Conditions", XlsNodeTypes.XLS_CONDITIONS.toString());
        tableHeaders.put("Actions", XlsNodeTypes.XLS_ACTIONS.toString());
        tableHeaders.put("Returns", XlsNodeTypes.XLS_RETURNS.toString());
        tableHeaders.put("Spreadsheet", XlsNodeTypes.XLS_SPREADSHEET.toString());
        tableHeaders.put("Calc", XlsNodeTypes.XLS_SPREADSHEET.toString());
        tableHeaders.put("TBasic", XlsNodeTypes.XLS_TBASIC.toString());
        tableHeaders.put("Algorithm", XlsNodeTypes.XLS_TBASIC.toString());
        tableHeaders.put("ColumnMatch", XlsNodeTypes.XLS_COLUMN_MATCH.toString());
        tableHeaders.put("Data", XlsNodeTypes.XLS_DATA.toString());
        tableHeaders.put("Datatype", XlsNodeTypes.XLS_DATATYPE.toString());
        tableHeaders.put("Code", XlsNodeTypes.XLS_METHOD.toString());
        tableHeaders.put("Method", XlsNodeTypes.XLS_METHOD.toString());
        tableHeaders.put("Environment", XlsNodeTypes.XLS_ENVIRONMENT.toString());
        tableHeaders.put("Testmethod", XlsNodeTypes.XLS_TEST_METHOD.toString());
        tableHeaders.put("Test", XlsNodeTypes.XLS_TEST_METHOD.toString());
        tableHeaders.put("Runmethod", XlsNodeTypes.XLS_RUN_METHOD.toString());
        tableHeaders.put("Run", XlsNodeTypes.XLS_RUN_METHOD.toString());
        tableHeaders.put("TablePart", XlsNodeTypes.XLS_TABLEPART.toString());
        tableHeaders.put("Properties", XlsNodeTypes.XLS_PROPERTIES.toString());
        TABLE_HEADERS = Collections.unmodifiableMap(tableHeaders);
    }
}

