/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls;

import java.util.Date;
import org.openl.rules.lang.xls.OverloadedMethodsDictionary;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.formatters.Formats;
import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.table.properties.def.TablePropertyDefinitionUtils;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IOpenMethod;
import org.openl.util.StringUtils;

public final class TableSyntaxNodeUtils {
    private static final String ROUND_BRACKETS_WITH_ANY_TEXT = "\\(.*\\)";

    private TableSyntaxNodeUtils() {
    }

    public static String[] getTableDisplayValue(TableSyntaxNode tableSyntaxNode, int i, Formats formats) {
        return TableSyntaxNodeUtils.getTableDisplayValue(tableSyntaxNode, i, null, formats);
    }

    public static String[] getTableDisplayValue(TableSyntaxNode tableSyntaxNode, int i, OverloadedMethodsDictionary dictionary, Formats formats) {
        ITableProperties tableProperties = tableSyntaxNode.getTableProperties();
        String display = null;
        String name = null;
        if (tableProperties != null) {
            display = name = tableProperties.getName();
        }
        if (name == null) {
            name = TableSyntaxNodeUtils.str2name(tableSyntaxNode.getGridTable().getCell(0, 0).getStringValue(), tableSyntaxNode.getNodeType());
        }
        if (display == null) {
            display = tableSyntaxNode.getGridTable().getCell(0, 0).getStringValue();
        }
        String sfx = i < 2 ? "" : " (" + i + ")";
        String dimensionInfo = "";
        if (dictionary != null && tableProperties != null && tableSyntaxNode.getMember() instanceof IOpenMethod && dictionary.contains((IOpenMethod)tableSyntaxNode.getMember()) && dictionary.getAllMethodOverloads((IOpenMethod)tableSyntaxNode.getMember()).size() > 1) {
            String[] dimensionalPropertyNames;
            for (String dimensionalPropertyName : dimensionalPropertyNames = TablePropertyDefinitionUtils.getDimensionalTablePropertiesNames()) {
                Object propertyValue = tableProperties.getPropertyValue(dimensionalPropertyName);
                String value = formats != null && propertyValue instanceof Date ? formats.formatDateOrDateTime((Date)propertyValue) : tableProperties.getPropertyValueAsString(dimensionalPropertyName);
                if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
                String propertyInfo = dimensionalPropertyName + "=" + value;
                dimensionInfo = dimensionInfo + (StringUtils.isEmpty((CharSequence)dimensionInfo) ? "" : ", ") + propertyInfo;
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)dimensionInfo)) {
            sfx = sfx + " [" + dimensionInfo + "]";
        }
        return new String[]{name + sfx, display + sfx, display + sfx};
    }

    public static String str2name(String methodHeader, XlsNodeTypes tableType) {
        String resultName = methodHeader;
        if (StringUtils.isBlank((CharSequence)resultName)) {
            resultName = "NO NAME";
        } else if (tableType.equals((Object)XlsNodeTypes.XLS_DATATYPE)) {
            String[] tokens = StringUtils.split((String)resultName.replaceAll(ROUND_BRACKETS_WITH_ANY_TEXT, ""));
            if (tokens.length > 1) {
                resultName = tokens[1].trim();
            }
        } else if (tableType.equals((Object)XlsNodeTypes.XLS_DT) || tableType.equals((Object)XlsNodeTypes.XLS_SPREADSHEET) || tableType.equals((Object)XlsNodeTypes.XLS_TBASIC) || tableType.equals((Object)XlsNodeTypes.XLS_COLUMN_MATCH) || tableType.equals((Object)XlsNodeTypes.XLS_DATA) || tableType.equals((Object)XlsNodeTypes.XLS_METHOD) || tableType.equals((Object)XlsNodeTypes.XLS_TEST_METHOD) || tableType.equals((Object)XlsNodeTypes.XLS_RUN_METHOD) || tableType.equals((Object)XlsNodeTypes.XLS_CONSTANTS) || tableType.equals((Object)XlsNodeTypes.XLS_CONDITIONS) || tableType.equals((Object)XlsNodeTypes.XLS_ACTIONS) || tableType.equals((Object)XlsNodeTypes.XLS_RETURNS) || tableType.equals((Object)XlsNodeTypes.XLS_ENVIRONMENT) || tableType.equals((Object)XlsNodeTypes.XLS_PROPERTIES)) {
            String[] tokens = StringUtils.split((String)resultName.replaceAll(ROUND_BRACKETS_WITH_ANY_TEXT, ""));
            resultName = tokens[tokens.length - 1].trim();
        } else if (tableType.equals((Object)XlsNodeTypes.XLS_OTHER) && resultName != null && resultName.length() > 57) {
            resultName = resultName.substring(0, 57) + "...";
        }
        return resultName;
    }

    public static String getTestName(IOpenMethod testMethod) {
        IMemberMetaInfo mi = testMethod.getInfo();
        TableSyntaxNode tnode = (TableSyntaxNode)mi.getSyntaxNode();
        return TableSyntaxNodeUtils.getTableDisplayValue(tnode, 0, null)[0];
    }
}

