/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls;

import org.openl.rules.table.CompositeCell;
import org.openl.rules.table.CompositeGrid;
import org.openl.rules.table.GridRegion;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.IGridTable;

class HorizontalTablePartsCompositeGrid
extends CompositeGrid {
    public HorizontalTablePartsCompositeGrid(IGridTable[] tables) {
        super(tables, false);
    }

    @Override
    public ICell getCell(int column, int row) {
        CompositeGrid.Transform t = this.transform(0, 0);
        if (t == null) {
            return null;
        }
        ICell firstRowCell = t.grid().getCell(t.getCol(), t.getRow());
        if (row < firstRowCell.getHeight()) {
            IGridRegion reg = this.getRegionContaining(0, 0);
            GridRegion region = reg != null ? new GridRegion(reg.getTop(), reg.getLeft(), reg.getBottom(), reg.getLeft() + this.getWidth() - 1) : new GridRegion(row, column, row, column + this.getWidth() - 1);
            return new CompositeCell(column, row, region, firstRowCell, t.getGridTable());
        }
        CompositeGrid.Transform t1 = this.transform(0, firstRowCell.getHeight());
        if (t1 != null) {
            CompositeGrid.Transform t2;
            ICell propertiesCell = t1.grid().getCell(t1.getCol(), t1.getRow());
            if (row < firstRowCell.getHeight() + propertiesCell.getHeight() && "properties".equals(propertiesCell.getStringValue()) && (t2 = this.transform(propertiesCell.getWidth(), row)) != null) {
                ICell propertiesNameCell = t2.grid().getCell(t2.getCol(), t2.getRow());
                CompositeGrid.Transform t3 = this.transform(propertiesCell.getWidth() + propertiesNameCell.getWidth(), row);
                if (t3 != null) {
                    ICell propertiesValueCell = t3.grid().getCell(t3.getCol(), t3.getRow());
                    if (column >= propertiesCell.getWidth() + propertiesNameCell.getWidth()) {
                        IGridRegion reg = this.getRegionContaining(propertiesCell.getWidth() + propertiesNameCell.getWidth(), row);
                        GridRegion region = reg != null ? new GridRegion(reg.getTop(), reg.getLeft(), reg.getBottom(), reg.getLeft() + this.getWidth() - 1 - (propertiesCell.getWidth() + propertiesNameCell.getWidth())) : new GridRegion(row, column, row, column + this.getWidth() - 1 - (propertiesCell.getWidth() + propertiesNameCell.getWidth()));
                        return new CompositeCell(column, row, region, propertiesValueCell, t3.getGridTable());
                    }
                }
            }
        }
        return super.getCell(column, row);
    }
}

