/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.helpers;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.Deque;
import org.openl.meta.BigDecimalValue;
import org.openl.meta.BigIntegerValue;
import org.openl.meta.ByteValue;
import org.openl.meta.DoubleValue;
import org.openl.meta.FloatValue;
import org.openl.meta.IntValue;
import org.openl.meta.LongValue;
import org.openl.meta.ShortValue;

public final class RulesUtilsAdditional {
    private RulesUtilsAdditional() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fill(Object target, boolean notNullsForSimpleTypes, Deque<Class<?>> stack) {
        if (target == null) {
            return;
        }
        if (stack.contains(target.getClass())) {
            return;
        }
        if (target.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(target); ++i) {
                RulesUtilsAdditional.fill(Array.get(target, i), notNullsForSimpleTypes, stack);
            }
            return;
        }
        stack.push(target.getClass());
        try {
            for (Field field : target.getClass().getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                try {
                    Class<?> fieldType = field.getType();
                    field.setAccessible(true);
                    Object fieldValue = field.get(target);
                    if (fieldValue == null) {
                        Class<?> t = fieldType;
                        int dim = 0;
                        while (t.isArray()) {
                            t = t.getComponentType();
                            ++dim;
                        }
                        if (dim > 0) {
                            int[] dims = new int[dim];
                            for (int i = 0; i < dim; ++i) {
                                dims[i] = 1;
                            }
                            fieldValue = Array.newInstance(t, dims);
                            Object elem = RulesUtilsAdditional.instantiateValue(t, notNullsForSimpleTypes);
                            RulesUtilsAdditional.fill(elem, notNullsForSimpleTypes, stack);
                            Object arr = fieldValue;
                            for (int i = 0; i < dim - 1; ++i) {
                                arr = Array.get(arr, 0);
                            }
                            Array.set(arr, 0, elem);
                        } else {
                            fieldValue = RulesUtilsAdditional.instantiateValue(field.getType(), notNullsForSimpleTypes);
                        }
                        field.set(target, fieldValue);
                        RulesUtilsAdditional.fill(fieldValue, notNullsForSimpleTypes, stack);
                        continue;
                    }
                    RulesUtilsAdditional.fill(fieldValue, notNullsForSimpleTypes, stack);
                }
                catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                    // empty catch block
                }
            }
        }
        finally {
            stack.pop();
        }
    }

    private static Object instantiateValue(Class<?> fieldType, boolean notNullsForSimpleTypes) throws InstantiationException, IllegalAccessException {
        if (notNullsForSimpleTypes) {
            if (fieldType == Boolean.class) {
                return Boolean.FALSE;
            }
            if (fieldType == Byte.class) {
                return (byte)0;
            }
            if (fieldType == Short.class) {
                return (short)0;
            }
            if (fieldType == Integer.class) {
                return 0;
            }
            if (fieldType == Long.class) {
                return 0L;
            }
            if (fieldType == Float.class) {
                return Float.valueOf(0.0f);
            }
            if (fieldType == Double.class) {
                return 0.0;
            }
            if (fieldType == String.class) {
                return "";
            }
            if (fieldType == BigInteger.class) {
                return BigInteger.ZERO;
            }
            if (fieldType == BigDecimal.class) {
                return BigDecimal.ZERO;
            }
            if (fieldType == ByteValue.class) {
                return new ByteValue(0);
            }
            if (fieldType == ShortValue.class) {
                return new ShortValue(0);
            }
            if (fieldType == IntValue.class) {
                return new IntValue(0);
            }
            if (fieldType == LongValue.class) {
                return new LongValue(0L);
            }
            if (fieldType == FloatValue.class) {
                return new FloatValue(0.0f);
            }
            if (fieldType == DoubleValue.class) {
                return new DoubleValue(0.0);
            }
            if (fieldType == BigIntegerValue.class) {
                return BigIntegerValue.ZERO;
            }
            if (fieldType == BigDecimalValue.class) {
                return BigDecimalValue.ZERO;
            }
        }
        return fieldType.newInstance();
    }

    public static <T> T fill(T value) {
        return RulesUtilsAdditional.fill(value, false);
    }

    public static <T> T fill(T value, boolean notNullsForSimpleTypes) {
        if (value == null) {
            return null;
        }
        RulesUtilsAdditional.fill(value, notNullsForSimpleTypes, new ArrayDeque());
        return value;
    }
}

