/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.helpers;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.xml.bind.annotation.XmlRootElement;
import org.openl.meta.BigDecimalValue;
import org.openl.meta.BigIntegerValue;
import org.openl.meta.ByteValue;
import org.openl.meta.DoubleValue;
import org.openl.meta.FloatValue;
import org.openl.meta.IntValue;
import org.openl.meta.LongValue;
import org.openl.meta.ShortValue;
import org.openl.rules.helpers.INumberRange;
import org.openl.rules.helpers.IntRangeParser;
import org.openl.util.RangeWithBounds;

@XmlRootElement
public class IntRange
implements INumberRange {
    private static final int TO_INT_RANGE_CAST_DISTANCE = 38;
    protected long min;
    protected long max;

    public IntRange(long min, long max) {
        if (min > max) {
            throw new IllegalArgumentException(max + " must be greater or equal than " + min);
        }
        this.min = min;
        this.max = max;
    }

    public IntRange(long number) {
        this(number, number);
    }

    public IntRange() {
        this(0L, 0L);
    }

    public boolean contains(LongValue value) {
        if (value == null) {
            return false;
        }
        return this.contains(value.longValue());
    }

    public boolean contains(BigIntegerValue value) {
        if (value == null) {
            return false;
        }
        try {
            return this.contains(value.getValue().longValueExact());
        }
        catch (ArithmeticException e) {
            return false;
        }
    }

    public boolean contains(IntRange range) {
        return this.min <= range.min && this.max >= range.max;
    }

    public boolean contains(Integer value) {
        if (value == null) {
            return false;
        }
        return this.contains(value.longValue());
    }

    public boolean contains(Long value) {
        if (value == null) {
            return false;
        }
        return this.min <= value && value <= this.max;
    }

    public long getMax() {
        return this.max;
    }

    public long getMin() {
        return this.min;
    }

    @Override
    public boolean containsNumber(Number n) {
        return n != null && this.contains(n.longValue());
    }

    public IntRange(String range) {
        this(0L, 0L);
        RangeWithBounds res = IntRange.getRangeWithBounds(range);
        this.min = res.getMin().longValue();
        if (!res.getMin().equals(this.min)) {
            throw new IllegalArgumentException("Min value is out of int values range.");
        }
        if (res.getLeftBoundType() == RangeWithBounds.BoundType.EXCLUDING) {
            ++this.min;
        }
        this.max = res.getMax().longValue();
        if (!res.getMax().equals(this.max)) {
            throw new IllegalArgumentException("Max value is out of int values range.");
        }
        if (res.getRightBoundType() == RangeWithBounds.BoundType.EXCLUDING) {
            --this.max;
        }
        if (this.min > this.max) {
            throw new RuntimeException(this.max + " must be more or equal than " + this.min);
        }
    }

    private static RangeWithBounds getRangeWithBounds(String range) {
        return IntRangeParser.getInstance().parse(range);
    }

    public static IntRange autocast(byte x, IntRange y) {
        return new IntRange(x);
    }

    public static int distance(byte x, IntRange y) {
        return 38;
    }

    public static IntRange autocast(short x, IntRange y) {
        return new IntRange(x);
    }

    public static int distance(short x, IntRange y) {
        return 38;
    }

    public static IntRange autocast(int x, IntRange y) {
        return new IntRange(x);
    }

    public static int distance(int x, IntRange y) {
        return 38;
    }

    public static IntRange autocast(long x, IntRange y) {
        return new IntRange(x);
    }

    public static int distance(long x, IntRange y) {
        return 38;
    }

    public static IntRange cast(float x, IntRange y) {
        return new IntRange((long)x);
    }

    public static int distance(float x, IntRange y) {
        return 38;
    }

    public static IntRange cast(double x, IntRange y) {
        return new IntRange((long)x);
    }

    public static int distance(double x, IntRange y) {
        return 38;
    }

    public static IntRange cast(BigInteger x, IntRange y) {
        return new IntRange(x.longValue());
    }

    public static int distance(BigInteger x, IntRange y) {
        return 38;
    }

    public static IntRange cast(BigDecimal x, IntRange y) {
        return new IntRange(x.longValue());
    }

    public static int distance(BigDecimal x, IntRange y) {
        return 38;
    }

    public static IntRange cast(ByteValue x, IntRange y) {
        return new IntRange(x.longValue());
    }

    public static int distance(ByteValue x, IntRange y) {
        return 38;
    }

    public static IntRange cast(ShortValue x, IntRange y) {
        return new IntRange(x.longValue());
    }

    public static int distance(ShortValue x, IntRange y) {
        return 38;
    }

    public static IntRange cast(IntValue x, IntRange y) {
        return new IntRange(x.longValue());
    }

    public static int distance(IntValue x, IntRange y) {
        return 38;
    }

    public static IntRange cast(LongValue x, IntRange y) {
        return new IntRange(x.longValue());
    }

    public static int distance(LongValue x, IntRange y) {
        return 38;
    }

    public static IntRange cast(FloatValue x, IntRange y) {
        return new IntRange(x.longValue());
    }

    public static int distance(FloatValue x, IntRange y) {
        return 38;
    }

    public static IntRange cast(DoubleValue x, IntRange y) {
        return new IntRange(x.longValue());
    }

    public static int distance(DoubleValue x, IntRange y) {
        return 38;
    }

    public static IntRange cast(BigIntegerValue x, IntRange y) {
        return new IntRange(x.longValue());
    }

    public static int distance(BigIntegerValue x, IntRange y) {
        return 38;
    }

    public static IntRange cast(BigDecimalValue x, IntRange y) {
        return new IntRange(x.longValue());
    }

    public static int distance(BigDecimalValue x, IntRange y) {
        return 38;
    }

    public String toString() {
        if (this.min == Integer.MIN_VALUE) {
            return "<=" + this.max;
        }
        if (this.max == Integer.MAX_VALUE) {
            return ">=" + this.min;
        }
        return "[" + this.min + ".." + this.max + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.max ^ this.max >>> 32);
        result = 31 * result + (int)(this.min ^ this.min >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntRange other = (IntRange)obj;
        if (this.max != other.max) {
            return false;
        }
        return this.min == other.min;
    }
}

