/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.helpers;

import java.util.Objects;
import javax.xml.bind.annotation.XmlRootElement;
import org.openl.rules.helpers.ARangeParser;
import org.openl.rules.helpers.CharRangeParser;
import org.openl.rules.helpers.IntRange;
import org.openl.util.StringUtils;

@XmlRootElement
public class CharRange
extends IntRange {
    private static final int TO_CHAR_RANGE_CAST_DISTANCE = 38;

    public CharRange(char min, char max) {
        super(min, max);
    }

    public CharRange(char c) {
        super(c);
    }

    public CharRange(String range) {
        super(0L, 0L);
        Objects.requireNonNull(range, "CharRange value cannot be null");
        ARangeParser.ParseStruct parsed = CharRangeParser.getInstance().parse(range);
        this.min = ((Character)parsed.min).charValue();
        if (parsed.leftBoundType == ARangeParser.ParseStruct.BoundType.EXCLUDING) {
            ++this.min;
        }
        this.max = ((Character)parsed.max).charValue();
        if (parsed.rightBoundType == ARangeParser.ParseStruct.BoundType.EXCLUDING) {
            --this.max;
        }
        if (this.min > this.max) {
            throw new IllegalArgumentException(String.format("%s must be greater or equal than %s", parsed.max, parsed.min));
        }
    }

    @Override
    public String toString() {
        return this.printChar(this.min) + "-" + this.printChar(this.max);
    }

    private String printChar(long ch) {
        return CharRange.isPrintable(ch) ? String.valueOf((char)ch) : "'u" + Integer.toHexString((char)ch) + "'";
    }

    private static boolean isPrintable(long ch) {
        if (StringUtils.isSpaceOrControl((char)((char)ch))) {
            return false;
        }
        if (ch < 255L) {
            return true;
        }
        return Character.isUnicodeIdentifierPart((char)ch);
    }

    public boolean contains(Character value) {
        if (value == null) {
            return false;
        }
        return this.contains(Long.valueOf(value.charValue()));
    }

    public static CharRange autocast(char x, CharRange y) {
        return new CharRange(x);
    }

    public static int distance(char x, CharRange y) {
        return 38;
    }
}

