/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.helpers;

public class BooleanOperator {
    static final ComparableOperator LT = new ComparableOperator(){

        @Override
        public <T extends Comparable<T>> boolean compare(T c1, T c2) {
            return c1.compareTo(c2) < 0;
        }
    };
    static final ComparableOperator LE = new ComparableOperator(){

        @Override
        public <T extends Comparable<T>> boolean compare(T c1, T c2) {
            return c1.compareTo(c2) <= 0;
        }
    };
    static final ComparableOperator GE = new ComparableOperator(){

        @Override
        public <T extends Comparable<T>> boolean compare(T c1, T c2) {
            return c1.compareTo(c2) >= 0;
        }
    };
    static final ComparableOperator GT = new ComparableOperator(){

        @Override
        public <T extends Comparable<T>> boolean compare(T c1, T c2) {
            return c1.compareTo(c2) > 0;
        }
    };
    static final ComparableOperator EQ = new ComparableOperator(){

        @Override
        public <T extends Comparable<T>> boolean compare(T c1, T c2) {
            return c1.compareTo(c2) == 0;
        }
    };
    static final ComparableOperator NE = new ComparableOperator(){

        @Override
        public <T extends Comparable<T>> boolean compare(T c1, T c2) {
            return c1.compareTo(c2) != 0;
        }
    };
    ComparableOperator operator;

    public BooleanOperator(String s) {
        if ("<".equals(s)) {
            this.operator = LT;
        } else if ("<=".equals(s)) {
            this.operator = LE;
        } else if ("==".equals(s)) {
            this.operator = EQ;
        } else if ("!=".equals(s)) {
            this.operator = NE;
        } else if (">".equals(s)) {
            this.operator = GT;
        } else if (">=".equals(s)) {
            this.operator = GE;
        } else {
            throw new RuntimeException(String.format("Operator %s is not defined.", s));
        }
    }

    public <T extends Comparable<T>> boolean compare(T c1, T c2) {
        return this.operator.compare(c1, c2);
    }

    public boolean compare(double i1, double i2) {
        return this.operator.compare(i1, i2);
    }

    public boolean compare(int i1, int i2) {
        return this.operator.compare(i1, i2);
    }

    static interface ComparableOperator {
        public <T extends Comparable<T>> boolean compare(T var1, T var2);
    }
}

