/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.fuzzy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.openl.rules.fuzzy.Token;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;

public final class OpenLFuzzyUtils {
    private static final List<String> TOKENS_STRONG_MATCH = Arrays.asList("at", "on", "for", "to", "with", "of", "on", "by", "from");
    private static final double ACCEPTABLE_SIMILARITY_VALUE = 0.86;
    private static final int DEEP_LEVEL = 5;
    private static final ThreadLocal<Map<IOpenClass, Map<String, Map<Token, IOpenField[][]>>>> openClassRecursivelyCacheForWritableFields = ThreadLocal.withInitial(HashMap::new);
    private static final ThreadLocal<Map<IOpenClass, Map<String, Map<Token, IOpenField[][]>>>> openClassRecursivelyCacheForReadableFields = ThreadLocal.withInitial(HashMap::new);
    private static final ThreadLocal<Map<IOpenClass, Map<Token, IOpenField[]>>> openClassCacheForWritableFields = ThreadLocal.withInitial(HashMap::new);

    private OpenLFuzzyUtils() {
    }

    public static void clearCaches() {
        openClassCacheForWritableFields.remove();
        openClassRecursivelyCacheForReadableFields.remove();
        openClassRecursivelyCacheForWritableFields.remove();
    }

    public static Map<Token, IOpenField[][]> tokensMapToOpenClassWritableFieldsRecursively(IOpenClass openClass, String tokenPrefix, int startLevel) {
        return OpenLFuzzyUtils.tokensMapToOpenClassFieldsRecursively(openClass, tokenPrefix, startLevel, true);
    }

    public static Map<Token, IOpenField[][]> tokensMapToOpenClassReadableFieldsRecursively(IOpenClass openClass, String tokenPrefix, int startLevel) {
        return OpenLFuzzyUtils.tokensMapToOpenClassFieldsRecursively(openClass, tokenPrefix, startLevel, false);
    }

    private static Map<Token, IOpenField[][]> tokensMapToOpenClassFieldsRecursively(IOpenClass openClass, String tokenPrefix, int startLevel, boolean writable) {
        String tokenizedPrefix;
        Map<IOpenClass, Map<String, Map<Token, IOpenField[][]>>> cache = writable ? openClassRecursivelyCacheForWritableFields.get() : openClassRecursivelyCacheForReadableFields.get();
        Map cache1 = cache.computeIfAbsent(openClass, e -> new HashMap());
        HashMap<Token, IOpenField[][]> ret = (HashMap<Token, IOpenField[][]>)cache1.get(tokenizedPrefix = OpenLFuzzyUtils.toTokenString(tokenPrefix));
        if (ret == null) {
            Map<Token, LinkedList<LinkedList<IOpenField>>> map;
            if (StringUtils.isBlank((CharSequence)tokenPrefix)) {
                map = OpenLFuzzyUtils.buildTokensMapToOpenClassFieldsRecursively(openClass, startLevel, writable);
            } else {
                map = OpenLFuzzyUtils.buildTokensMapToOpenClassFieldsRecursively(openClass, startLevel, writable);
                HashMap<Token, LinkedList<LinkedList<IOpenField>>> updatedMap = new HashMap<Token, LinkedList<LinkedList<IOpenField>>>(map);
                for (Map.Entry<Token, LinkedList<LinkedList<IOpenField>>> entry : map.entrySet()) {
                    Token updatedToken = new Token(OpenLFuzzyUtils.toTokenString(tokenizedPrefix + " " + entry.getKey().getValue()), entry.getKey().getDistance());
                    updatedMap.put(updatedToken, entry.getValue());
                }
                map = updatedMap;
            }
            HashMap<Token, LinkedList[]> tmp = new HashMap<Token, LinkedList[]>();
            for (Map.Entry<Token, LinkedList<LinkedList<IOpenField>>> entry : map.entrySet()) {
                tmp.put(entry.getKey(), entry.getValue().toArray(new LinkedList[0]));
            }
            ret = new HashMap<Token, IOpenField[][]>();
            for (Map.Entry<Token, LinkedList<LinkedList<Object>>> entry : tmp.entrySet()) {
                IOpenField[][] m = new IOpenField[((LinkedList[])entry.getValue()).length][];
                int i = 0;
                for (LinkedList x : (LinkedList[])entry.getValue()) {
                    m[i] = x.toArray(new IOpenField[0]);
                    ++i;
                }
                ret.put(entry.getKey(), m);
            }
            cache1.put(tokenizedPrefix, Collections.unmodifiableMap(ret));
        }
        return ret;
    }

    public static boolean isEqualsFieldsChains(IOpenField[] fieldsChain1, IOpenField[] fieldsChain2) {
        if (fieldsChain1 == fieldsChain2) {
            return true;
        }
        return Arrays.deepEquals(fieldsChain1, fieldsChain2);
    }

    private static Map<Token, LinkedList<LinkedList<IOpenField>>> buildTokensMapToOpenClassFieldsRecursively(IOpenClass openClass, int deepLevel, boolean writable) {
        if (deepLevel >= 5) {
            return Collections.emptyMap();
        }
        HashMap<Token, LinkedList<LinkedList<IOpenField>>> ret = new HashMap<Token, LinkedList<LinkedList<IOpenField>>>();
        if (!openClass.isSimple()) {
            for (IOpenField field : openClass.getFields()) {
                IOpenClass type;
                if (field.isStatic() || field.isConst() || !(writable ? field.isWritable() : field.isReadable())) continue;
                String fieldName = field.getName();
                String t = OpenLFuzzyUtils.toTokenString(OpenLFuzzyUtils.phoneticFix(fieldName));
                LinkedList<IOpenField> fields = new LinkedList<IOpenField>();
                fields.add(field);
                LinkedList x = null;
                for (Map.Entry entry : ret.entrySet()) {
                    Token token = (Token)entry.getKey();
                    if (!token.getValue().equals(t) || ((Token)entry.getKey()).getDistance() != deepLevel) continue;
                    x = (LinkedList)entry.getValue();
                    break;
                }
                if (x == null) {
                    x = new LinkedList();
                    x.add(fields);
                    ret.put(new Token(t, deepLevel), x);
                } else {
                    x.add(fields);
                }
                if ((type = field.getType()).isSimple() || type.isArray()) continue;
                Map<Token, LinkedList<LinkedList<IOpenField>>> map = OpenLFuzzyUtils.buildTokensMapToOpenClassFieldsRecursively(type, deepLevel + 1, writable);
                for (Map.Entry<Token, LinkedList<LinkedList<IOpenField>>> entry : map.entrySet()) {
                    LinkedList<IOpenField> y1;
                    if (entry.getValue().isEmpty()) continue;
                    Token k = new Token(t + " " + entry.getKey().getValue(), entry.getKey().getDistance() + 1);
                    LinkedList v = ret.computeIfAbsent(k, e -> new LinkedList());
                    for (LinkedList linkedList : entry.getValue()) {
                        y1 = new LinkedList<IOpenField>(linkedList);
                        y1.addFirst(field);
                        v.add(y1);
                    }
                    v = ret.computeIfAbsent(entry.getKey(), e -> new LinkedList());
                    for (LinkedList linkedList : entry.getValue()) {
                        y1 = new LinkedList(linkedList);
                        y1.addFirst(field);
                        v.add(y1);
                    }
                }
            }
        }
        return ret;
    }

    public static String phoneticFix(String value) {
        if (value.length() > 1 && Character.isLowerCase(value.charAt(0)) && Character.isUpperCase(value.charAt(1))) {
            value = Character.toUpperCase(value.charAt(0)) + value.substring(1);
        }
        return value;
    }

    private static String[] concatTokens(String[] tokens, String pattern) {
        ArrayList<String> t = new ArrayList<String>();
        StringBuilder sbBuilder = new StringBuilder();
        boolean g = false;
        for (String s : tokens) {
            if (s.length() == 1 && s.matches(pattern)) {
                g = true;
                sbBuilder.append(s);
                continue;
            }
            if (g) {
                t.add(sbBuilder.toString());
                g = false;
                sbBuilder = new StringBuilder();
            }
            t.add(s);
        }
        if (g) {
            t.add(sbBuilder.toString());
        }
        return t.toArray(new String[0]);
    }

    private static String[] cleanUpTokens(String[] tokens) {
        ArrayList<String> t = new ArrayList<String>();
        for (String token : tokens) {
            String s = token.trim().toLowerCase();
            if (s.isEmpty()) continue;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < s.length(); ++i) {
                if (!Character.isLetterOrDigit(s.charAt(i))) continue;
                sb.append(s.charAt(i));
            }
            if (sb.toString().length() <= 0) continue;
            t.add(sb.toString());
        }
        return t.toArray(new String[0]);
    }

    public static String toTokenString(String source) {
        if (source == null) {
            return "";
        }
        String[] tokens = source.split("(?<=.)(?=\\p{Lu}|\\d|\\s|[_-]|\\.|,|;)");
        tokens = OpenLFuzzyUtils.concatTokens(tokens, "\\p{Lu}+");
        tokens = OpenLFuzzyUtils.concatTokens(tokens, "\\d+");
        tokens = OpenLFuzzyUtils.cleanUpTokens(tokens);
        StringBuilder sb = new StringBuilder();
        boolean f = false;
        for (String s : tokens) {
            if (!f) {
                f = true;
            } else {
                sb.append(" ");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static List<Pair<Integer, Integer>> findMaximumMatching(List<Pair<Integer, Integer>> edges) {
        int i;
        int n1 = 0;
        int n2 = 0;
        for (Pair<Integer, Integer> e : edges) {
            if ((Integer)e.getLeft() > n1) {
                n1 = (Integer)e.getLeft();
            }
            if ((Integer)e.getRight() <= n2) continue;
            n2 = (Integer)e.getRight();
        }
        int n = ++n1 + ++n2 + 2;
        int s = n1 + n2;
        int t = n1 + n2 + 1;
        int[][] edgesMatrix = new int[n][n];
        for (i = 0; i < n1; ++i) {
            edgesMatrix[s][i] = 1;
        }
        for (i = n1; i < n1 + n2; ++i) {
            edgesMatrix[i][t] = 1;
        }
        for (Pair<Integer, Integer> e : edges) {
            edgesMatrix[((Integer)e.getLeft()).intValue()][n1 + ((Integer)e.getRight()).intValue()] = 1;
        }
        block4: while (true) {
            int[] m = new int[n];
            Arrays.fill(m, -1);
            m[s] = 0;
            boolean[] f = new boolean[n];
            Arrays.fill(f, true);
            int[] d = new int[n];
            Arrays.fill(d, Integer.MAX_VALUE);
            d[s] = 0;
            for (int i2 = 0; i2 < n; ++i2) {
                int j;
                int k = -1;
                int min = Integer.MAX_VALUE;
                for (j = 0; j < n; ++j) {
                    if (!f[j] || d[j] >= min) continue;
                    min = d[j];
                    k = j;
                }
                if (k < 0) break;
                f[k] = false;
                for (j = 0; j < n; ++j) {
                    if (edgesMatrix[k][j] <= 0 || d[k] == Integer.MAX_VALUE || d[k] + edgesMatrix[k][j] >= d[j]) continue;
                    d[j] = d[k] + edgesMatrix[k][j];
                    m[j] = k;
                }
            }
            if (d[t] == Integer.MAX_VALUE || d[t] == 0) break;
            int j = t;
            while (true) {
                if (j == s) continue block4;
                edgesMatrix[m[j]][j] = edgesMatrix[m[j]][j] - 1;
                edgesMatrix[j][m[j]] = edgesMatrix[j][m[j]] + 1;
                j = m[j];
            }
            break;
        }
        ArrayList<Pair<Integer, Integer>> ret = new ArrayList<Pair<Integer, Integer>>();
        for (int i3 = 0; i3 < n1; ++i3) {
            for (int j = n1; j < n1 + n2; ++j) {
                if (edgesMatrix[j][i3] <= 0) continue;
                ret.add((Pair<Integer, Integer>)Pair.of((Object)i3, (Object)(j - n1)));
            }
        }
        return ret;
    }

    public static List<FuzzyResult> fuzzyExtract(String source, Token[] tokens, boolean ignoreDistances) {
        source = OpenLFuzzyUtils.toTokenString(source);
        String[] sourceTokens = source.split(" ");
        String[][] tokensList = new String[tokens.length][];
        for (int i = 0; i < tokens.length; ++i) {
            tokensList[i] = tokens[i].getValue().split(" ");
        }
        double[][][] distances = new double[tokensList.length][sourceTokens.length][];
        boolean[] sm = new boolean[sourceTokens.length];
        for (int k = 0; k < sourceTokens.length; ++k) {
            sm[k] = TOKENS_STRONG_MATCH.contains(sourceTokens[k]);
        }
        for (int i = 0; i < tokensList.length; ++i) {
            for (int k = 0; k < sourceTokens.length; ++k) {
                double[] w = new double[tokensList[i].length];
                for (int q = 0; q < tokensList[i].length; ++q) {
                    w[q] = sm[k] || TOKENS_STRONG_MATCH.contains(tokensList[i][q]) ? (Objects.equals(sourceTokens[k], tokensList[i][q]) ? 1.0 : 0.0) : StringUtils.getJaroWinklerDistance((CharSequence)sourceTokens[k], (CharSequence)tokensList[i][q]);
                }
                distances[i][k] = w;
            }
        }
        BuildBySimilarity buildBySimilarity1 = new BuildBySimilarity(distances, 1.0, sourceTokens, tokens, tokensList).invoke();
        BuildBySimilarity buildBySimilarity = new BuildBySimilarity(distances, 0.86, sourceTokens, tokens, tokensList).invoke();
        int maxMatchedTokens = buildBySimilarity.getMaxMatchedTokens();
        if (buildBySimilarity1.getMaxMatchedTokens() == buildBySimilarity.getMaxMatchedTokens()) {
            buildBySimilarity = buildBySimilarity1;
        } else {
            double a = 0.86;
            double b = 1.0;
            while (b - a > 1.0E-4) {
                double p = (a + b) / 2.0;
                BuildBySimilarity pSimilarity = new BuildBySimilarity(distances, p, sourceTokens, tokens, tokensList).invoke();
                if (pSimilarity.maxMatchedTokens == maxMatchedTokens) {
                    a = p;
                    buildBySimilarity = pSimilarity;
                    continue;
                }
                b = p;
            }
        }
        List<Pair<String, String>> similarity = buildBySimilarity.getSimilarity();
        int[] f = buildBySimilarity.getF();
        if (maxMatchedTokens == 0) {
            return Collections.emptyList();
        }
        int missedTokensMin = Integer.MAX_VALUE;
        int minDistance = Integer.MAX_VALUE;
        for (int i = 0; i < tokensList.length; ++i) {
            if (f[i] != maxMatchedTokens) continue;
            if (missedTokensMin > tokensList[i].length - f[i]) {
                missedTokensMin = tokensList[i].length - f[i];
            }
            if (minDistance <= tokens[i].getDistance()) continue;
            minDistance = tokens[i].getDistance();
        }
        ArrayList<Token> ret = new ArrayList<Token>();
        int best = 0;
        int bestL = Integer.MAX_VALUE;
        for (int i = 0; i < tokensList.length; ++i) {
            if (f[i] != maxMatchedTokens || tokensList[i].length - f[i] != missedTokensMin || !ignoreDistances && tokens[i].getDistance() != minDistance) continue;
            Pair<String, String> pair = similarity.get(i);
            if (!ignoreDistances) {
                int d = StringUtils.getFuzzyDistance((CharSequence)((CharSequence)pair.getRight()), (CharSequence)((CharSequence)pair.getLeft()), (Locale)Locale.ENGLISH);
                if (d > best) {
                    best = d;
                    bestL = StringUtils.getLevenshteinDistance((CharSequence)((CharSequence)pair.getRight()), (CharSequence)((CharSequence)pair.getLeft()));
                    ret.clear();
                    ret.add(tokens[i]);
                    continue;
                }
                if (d != best) continue;
                int l = StringUtils.getLevenshteinDistance((CharSequence)((CharSequence)pair.getRight()), (CharSequence)((CharSequence)pair.getLeft()));
                if (l < bestL) {
                    bestL = l;
                    ret.clear();
                    ret.add(tokens[i]);
                    continue;
                }
                if (l != bestL) continue;
                ret.add(tokens[i]);
                continue;
            }
            ret.add(tokens[i]);
        }
        int missedTokensMin1 = missedTokensMin;
        double acceptableSimilarity = buildBySimilarity.getAcceptableSimilarity();
        return ret.stream().map(e -> new FuzzyResult((Token)e, maxMatchedTokens, missedTokensMin1, sourceTokens.length - maxMatchedTokens, acceptableSimilarity)).collect(Collectors.toList());
    }

    private static class BuildBySimilarity {
        private final String[] sourceTokens;
        private final String[][] tokensList;
        private List<Pair<String, String>> similarity;
        private int maxMatchedTokens;
        private int[] f;
        private final double acceptableSimilarity;
        private final Token[] tokens;
        private final double[][][] distances;

        public BuildBySimilarity(double[][][] distances, double acceptableSimilarity, String[] sourceTokens, Token[] tokens, String[] ... tokensList) {
            this.sourceTokens = sourceTokens;
            this.tokens = tokens;
            this.tokensList = tokensList;
            this.acceptableSimilarity = acceptableSimilarity;
            this.distances = distances;
        }

        public List<Pair<String, String>> getSimilarity() {
            return this.similarity;
        }

        public int getMaxMatchedTokens() {
            return this.maxMatchedTokens;
        }

        public int[] getF() {
            return this.f;
        }

        public double getAcceptableSimilarity() {
            return this.acceptableSimilarity;
        }

        public BuildBySimilarity invoke() {
            this.similarity = new ArrayList<Pair<String, String>>();
            this.maxMatchedTokens = 0;
            this.f = new int[this.tokensList.length];
            for (int i = 0; i < this.tokensList.length; ++i) {
                int c = 0;
                ArrayList<String> source1 = new ArrayList<String>();
                ArrayList<String> target1 = new ArrayList<String>();
                ArrayList<Pair<Integer, Integer>> edges = new ArrayList<Pair<Integer, Integer>>();
                for (int k = 0; k < this.sourceTokens.length; ++k) {
                    for (int q = 0; q < this.tokensList[i].length; ++q) {
                        double d = this.distances[i][k][q];
                        if (!(d >= this.acceptableSimilarity)) continue;
                        edges.add((Pair<Integer, Integer>)Pair.of((Object)k, (Object)q));
                    }
                }
                List<Pair<Integer, Integer>> maximumMatching = OpenLFuzzyUtils.findMaximumMatching(edges);
                for (Pair<Integer, Integer> pair : maximumMatching) {
                    source1.add(this.sourceTokens[(Integer)pair.getLeft()]);
                    target1.add(this.tokensList[i][(Integer)pair.getRight()]);
                    ++c;
                }
                if (c >= this.tokens[i].getMinMatchedTokens()) {
                    if (this.maxMatchedTokens < c) {
                        this.maxMatchedTokens = c;
                    }
                    this.f[i] = c;
                    source1.sort(Comparator.naturalOrder());
                    target1.sort(Comparator.naturalOrder());
                } else {
                    this.f[i] = 0;
                    source1.clear();
                    target1.clear();
                }
                this.similarity.add((Pair<String, String>)Pair.of((Object)String.join((CharSequence)" ", source1), (Object)String.join((CharSequence)" ", target1)));
            }
            return this;
        }
    }

    public static final class FuzzyResult
    implements Comparable<FuzzyResult> {
        final Token token;
        final int foundTokensCount;
        final int missedTokensCount;
        final int unmatchedTokensCount;
        final double acceptableSimilarity;

        public FuzzyResult(Token token, int foundTokensCount, int missedTokensCount, int unmatchedTokensCount, double acceptableSimilarity) {
            this.token = token;
            this.foundTokensCount = foundTokensCount;
            this.missedTokensCount = missedTokensCount;
            this.unmatchedTokensCount = unmatchedTokensCount;
            this.acceptableSimilarity = acceptableSimilarity;
        }

        @Override
        public int compareTo(FuzzyResult o) {
            if (this.foundTokensCount > o.foundTokensCount) {
                return -1;
            }
            if (this.foundTokensCount < o.foundTokensCount) {
                return 1;
            }
            if (this.missedTokensCount > o.missedTokensCount) {
                return 1;
            }
            if (this.missedTokensCount < o.missedTokensCount) {
                return -1;
            }
            if (this.token.getDistance() < o.token.getDistance()) {
                return -1;
            }
            if (this.token.getDistance() > o.token.getDistance()) {
                return 1;
            }
            if (this.unmatchedTokensCount > o.unmatchedTokensCount) {
                return 1;
            }
            if (this.unmatchedTokensCount < o.unmatchedTokensCount) {
                return -1;
            }
            return Double.compare(o.acceptableSimilarity, this.acceptableSimilarity);
        }

        public Token getToken() {
            return this.token;
        }

        public int getFoundTokensCount() {
            return this.foundTokensCount;
        }

        public int getMissedTokensCount() {
            return this.missedTokensCount;
        }

        public double getAcceptableSimilarity() {
            return this.acceptableSimilarity;
        }

        public int getUnmatchedTokensCount() {
            return this.unmatchedTokensCount;
        }
    }
}

