/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.element;

import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundNode;
import org.openl.rules.dt.DTScale;
import org.openl.rules.dt.DecisionTable;
import org.openl.rules.dt.data.RuleExecutionObject;
import org.openl.rules.dt.element.ActionType;
import org.openl.rules.dt.element.FunctionalRow;
import org.openl.rules.dt.element.IAction;
import org.openl.rules.dt.element.RuleRow;
import org.openl.rules.dt.storage.IStorage;
import org.openl.rules.enumeration.DTEmptyResultProcessingEnum;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.ILogicalTable;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.StringSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.types.IDynamicObject;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.IParameterDeclaration;
import org.openl.types.NullParameterDeclaration;
import org.openl.types.impl.CompositeMethod;
import org.openl.types.impl.ParameterDeclaration;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.ClassUtils;
import org.openl.util.StringUtils;
import org.openl.vm.IRuntimeEnv;

public class Action
extends FunctionalRow
implements IAction {
    private static final String EXTRA_RET = "e$x$t$r$a$R$e$t";
    private boolean isSingleReturnParam;
    private IOpenClass returnType;
    private final ActionType actionType;
    private final boolean skipEmptyResult;

    public Action(String name, int row, ILogicalTable decisionTable, ActionType actionType, DTScale.RowScale scale, DecisionTable decisionTableInvocableMethod) {
        super(name, row, decisionTable, scale);
        this.actionType = actionType;
        this.skipEmptyResult = decisionTableInvocableMethod.getMethodProperties() != null && DTEmptyResultProcessingEnum.SKIP.equals((Object)decisionTableInvocableMethod.getMethodProperties().getEmptyResultProcessing());
    }

    @Override
    public boolean isAction() {
        return true;
    }

    @Override
    public boolean isCondition() {
        return false;
    }

    @Override
    public boolean isReturnAction() {
        return ActionType.RETURN == this.actionType;
    }

    @Override
    public boolean isCollectReturnKeyAction() {
        return ActionType.COLLECT_RETURN_KEY == this.actionType;
    }

    @Override
    public boolean isCollectReturnAction() {
        return ActionType.COLLECT_RETURN == this.actionType;
    }

    @Override
    public Object executeAction(int ruleN, Object target, Object[] params, IRuntimeEnv env) {
        if (target instanceof IDynamicObject) {
            target = new RuleExecutionObject(this.ruleExecutionType, (IDynamicObject)target, ruleN);
        }
        if (this.isSingleReturnParam) {
            if (this.skipEmptyResult && this.isEmpty(ruleN)) {
                return null;
            }
            Object[] dest = new Object[this.getNumberOfParams()];
            this.loadValues(dest, 0, ruleN, target, params, env);
            Object returnValue = dest[0];
            CompositeMethod method = this.getMethod();
            IOpenClass methodType = method.getType();
            if (returnValue == null || ClassUtils.isAssignable(returnValue.getClass(), (Class)methodType.getInstanceClass())) {
                return returnValue;
            }
            return this.executeActionInternal(ruleN, target, params, env);
        }
        return this.executeActionInternal(ruleN, target, params, env);
    }

    private Object executeActionInternal(int ruleN, Object target, Object[] params, IRuntimeEnv env) {
        if (this.skipEmptyResult && this.isEmpty(ruleN)) {
            return null;
        }
        return this.getMethod().invoke(target, this.mergeParams(target, params, env, ruleN), env);
    }

    private static IOpenClass extractMethodTypeForCollectReturnKeyAction(TableSyntaxNode tableSyntaxNode, IBindingContext bindingContext) {
        JavaOpenClass cType = null;
        if (tableSyntaxNode.getHeader().getCollectParameters().length > 0) {
            cType = bindingContext.findType("org.openl.this", tableSyntaxNode.getHeader().getCollectParameters()[0]);
        }
        return cType != null ? cType : JavaOpenClass.OBJECT;
    }

    private static IOpenClass extractMethodTypeForCollectReturnAction(TableSyntaxNode tableSyntaxNode, IOpenMethodHeader header, IBindingContext bindingContext) {
        IOpenClass type = header.getType();
        if (type.isArray()) {
            return type.getComponentClass();
        }
        if (ClassUtils.isAssignable((Class)type.getInstanceClass(), Collection.class)) {
            JavaOpenClass cType = null;
            if (tableSyntaxNode.getHeader().getCollectParameters().length > 0) {
                cType = bindingContext.findType("org.openl.this", tableSyntaxNode.getHeader().getCollectParameters()[0]);
            }
            return cType != null ? cType : JavaOpenClass.OBJECT;
        }
        if (ClassUtils.isAssignable((Class)type.getInstanceClass(), Map.class)) {
            JavaOpenClass cType = null;
            if (tableSyntaxNode.getHeader().getCollectParameters().length > 1) {
                cType = bindingContext.findType("org.openl.this", tableSyntaxNode.getHeader().getCollectParameters()[1]);
            }
            return cType != null ? cType : JavaOpenClass.OBJECT;
        }
        return type;
    }

    @Override
    public void prepareAction(IOpenMethodHeader header, IMethodSignature signature, OpenL openl, IBindingContext bindingContext, RuleRow ruleRow, IOpenClass ruleExecutionType, TableSyntaxNode tableSyntaxNode) throws Exception {
        this.returnType = header.getType();
        JavaOpenClass methodType = JavaOpenClass.VOID;
        if (this.isReturnAction()) {
            methodType = header.getType();
        } else if (this.isCollectReturnAction()) {
            methodType = Action.extractMethodTypeForCollectReturnAction(tableSyntaxNode, header, bindingContext);
        } else if (this.isCollectReturnKeyAction()) {
            methodType = Action.extractMethodTypeForCollectReturnKeyAction(tableSyntaxNode, bindingContext);
        }
        this.prepare((IOpenClass)methodType, signature, openl, bindingContext, ruleRow, ruleExecutionType, tableSyntaxNode);
        IParameterDeclaration[] params = this.getParams();
        CompositeMethod method = this.getMethod();
        String code = Optional.ofNullable(method.getMethodBodyBoundNode()).map(IBoundNode::getSyntaxNode).map(ISyntaxNode::getModule).map(IOpenSourceCodeModule::getCode).orElse(null);
        this.isSingleReturnParam = params.length == 1 && !NullParameterDeclaration.isAnyNull((IParameterDeclaration[])new IParameterDeclaration[]{params[0]}) && params[0].getName().equals(code);
    }

    @Override
    public IOpenClass getType() {
        return this.returnType;
    }

    @Override
    protected void prepareParams(IOpenClass declaringClass, IMethodSignature signature, IOpenClass methodType, IOpenSourceCodeModule methodSource, OpenL openl, IBindingContext bindingContext) throws Exception {
        if (EXTRA_RET.equals(methodSource.getCode()) && (this.isReturnAction() || this.isCollectReturnAction() || this.isCollectReturnKeyAction())) {
            ParameterDeclaration extraParam = new ParameterDeclaration(methodType, EXTRA_RET);
            this.params = new IParameterDeclaration[]{extraParam};
            this.paramInitialized = new BitSet(1);
            this.paramInitialized.set(0);
            this.paramsUniqueNames = new HashSet();
            this.paramsUniqueNames.add(extraParam.getName());
        } else {
            super.prepareParams(declaringClass, signature, methodType, methodSource, openl, bindingContext);
        }
    }

    @Override
    protected IOpenSourceCodeModule getExpressionSource(TableSyntaxNode tableSyntaxNode, IMethodSignature signature, IOpenClass methodType, IOpenClass declaringClass, OpenL openl, IBindingContext bindingContext) throws Exception {
        IOpenSourceCodeModule source = super.getExpressionSource(tableSyntaxNode, signature, methodType, declaringClass, openl, bindingContext);
        if ((this.isReturnAction() || this.isCollectReturnAction() || this.isCollectReturnKeyAction()) && StringUtils.isEmpty((CharSequence)source.getCode())) {
            if (this.hasDeclaredParams()) {
                super.prepareParams(declaringClass, signature, methodType, null, openl, bindingContext);
                return new StringSourceCodeModule(this.params[0].getName() != null ? this.params[0].getName() : EXTRA_RET, source.getUri());
            }
            return new StringSourceCodeModule(EXTRA_RET, source.getUri());
        }
        return source;
    }

    @Override
    public void removeDebugInformation() {
        super.removeDebugInformation();
        if (this.storage != null) {
            for (IStorage st : this.storage) {
                int rules = st.size();
                for (int i = 0; i < rules; ++i) {
                    Object paramValue = st.getValue(i);
                    if (!(paramValue instanceof CompositeMethod)) continue;
                    ((CompositeMethod)paramValue).removeDebugInformation();
                }
            }
        }
    }
}

