/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt;

import java.util.BitSet;
import org.openl.rules.dt.DecisionTableRuleNode;
import org.openl.rules.dt.IDecisionTableRuleNodeV2;
import org.openl.rules.dt.index.IRuleIndex;

public class RangeIndexDecisionTableRuleNode
extends DecisionTableRuleNode
implements IDecisionTableRuleNodeV2 {
    private final BitSet ruleSet;
    private final IRuleIndex nextIndex;

    public RangeIndexDecisionTableRuleNode(BitSet ruleSet, IRuleIndex nextIndex) {
        super(null);
        this.ruleSet = ruleSet;
        this.nextIndex = nextIndex;
    }

    @Override
    public BitSet getRuleSet() {
        return this.ruleSet;
    }

    @Override
    public int[] getRules() {
        int[] result = new int[this.ruleSet.cardinality()];
        int i = 0;
        int rule = this.ruleSet.nextSetBit(0);
        while (rule >= 0) {
            result[i++] = rule;
            if (rule == Integer.MAX_VALUE) break;
            rule = this.ruleSet.nextSetBit(rule + 1);
        }
        return result;
    }

    @Override
    public IRuleIndex getNextIndex() {
        return this.nextIndex;
    }

    @Override
    public boolean hasIndex() {
        return this.nextIndex != null;
    }
}

