/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt;

import org.openl.rules.dt.TwoDimensionDecisionTableTransformer;
import org.openl.rules.table.IGridTable;

public class LookupHeadersTransformer
extends TwoDimensionDecisionTableTransformer {
    private final int firstVerticalColumn;
    private final int[] horizontalHeaderOffsets;

    LookupHeadersTransformer(IGridTable entireTable, IGridTable lookupValuesTable, int retTableWidth, int firstVerticalColumn, int[] horizontalHeaderOffsets) {
        super(entireTable, lookupValuesTable, retTableWidth);
        this.firstVerticalColumn = firstVerticalColumn;
        this.horizontalHeaderOffsets = horizontalHeaderOffsets;
    }

    @Override
    public int getColumn(int col, int row) {
        if (col < this.firstVerticalColumn) {
            return super.getColumn(col, row);
        }
        if (col < this.firstVerticalColumn + this.horizontalHeaderOffsets.length && row < 3) {
            return this.horizontalHeaderOffsets[col - this.firstVerticalColumn];
        }
        return super.getColumn(col, row);
    }

    @Override
    public int getRow(int col, int row) {
        if (col < this.firstVerticalColumn) {
            return super.getRow(col, row);
        }
        if (col < this.firstVerticalColumn + this.horizontalHeaderOffsets.length && row < 3) {
            return row;
        }
        return super.getRow(col, row);
    }
}

