/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.openl.binding.IBoundMethodNode;
import org.openl.rules.dt.element.ICondition;
import org.openl.rules.lang.xls.binding.DTColumnsDefinition;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.types.impl.CompositeMethod;

public class DecisionTableUtils {
    private DecisionTableUtils() {
    }

    public static List<IdentifierNode> retrieveIdentifierNodes(ICondition dtCondition) {
        return DecisionTableUtils.retrieveIdentifierNodes((CompositeMethod)dtCondition.getMethod());
    }

    static List<IdentifierNode> retrieveIdentifierNodes(DTColumnsDefinition definition) {
        return DecisionTableUtils.retrieveIdentifierNodes(definition.getCompositeMethod());
    }

    public static List<IdentifierNode> retrieveIdentifierNodes(CompositeMethod dtCompositeMethod) {
        ArrayList<IdentifierNode> identifierNodes = new ArrayList<IdentifierNode>();
        IBoundMethodNode methodNode = dtCompositeMethod.getMethodBodyBoundNode();
        if (methodNode != null) {
            DecisionTableUtils.parseAndCollectIdentifierNodes(methodNode.getSyntaxNode(), new MutableBoolean(false), false, identifierNodes);
        }
        return identifierNodes;
    }

    private static void parseAndCollectIdentifierNodes(ISyntaxNode node, MutableBoolean chain, boolean inChain, List<IdentifierNode> identifierNodes) {
        for (int i = 0; i < node.getNumberOfChildren(); ++i) {
            ISyntaxNode child = node.getChild(i);
            String childType = child.getType();
            if ("identifier".equals(childType)) {
                if (chain.booleanValue()) continue;
                identifierNodes.add((IdentifierNode)child);
                if (!inChain) continue;
                chain.setTrue();
                continue;
            }
            if ("chain".equals(childType)) {
                boolean f = chain.booleanValue();
                DecisionTableUtils.parseAndCollectIdentifierNodes(child, chain, true, identifierNodes);
                chain.setValue(f);
                continue;
            }
            if ("function".equals(childType)) {
                DecisionTableUtils.parseAndCollectIdentifierNodes(child, new MutableBoolean(false), false, identifierNodes);
                continue;
            }
            if ("selectfirst.index".equals(childType) || "selectall.index".equals(childType) || "transform.index".equals(childType) || "transformunique.index".equals(childType)) {
                DecisionTableUtils.parseAndCollectIdentifierNodes(child, new MutableBoolean(false), false, identifierNodes);
                continue;
            }
            DecisionTableUtils.parseAndCollectIdentifierNodes(node.getChild(i), chain, inChain, identifierNodes);
        }
    }

    public static String getConditionSourceCode(ICondition dtCondition) {
        IBoundMethodNode methodNode = ((CompositeMethod)dtCondition.getMethod()).getMethodBodyBoundNode();
        return methodNode == null ? "" : methodNode.getSyntaxNode().getModule().getCode();
    }
}

