/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.impl.NumericStringComparator;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.engine.OpenLManager;
import org.openl.exception.OpenLCompilationException;
import org.openl.message.OpenLMessage;
import org.openl.message.OpenLMessagesUtils;
import org.openl.meta.BigDecimalValue;
import org.openl.meta.BigIntegerValue;
import org.openl.meta.ByteValue;
import org.openl.meta.DoubleValue;
import org.openl.meta.FloatValue;
import org.openl.meta.IntValue;
import org.openl.meta.LongValue;
import org.openl.meta.ShortValue;
import org.openl.meta.StringValue;
import org.openl.rules.binding.RuleRowHelper;
import org.openl.rules.calc.SpreadsheetResult;
import org.openl.rules.constants.ConstantOpenField;
import org.openl.rules.convertor.IString2DataConvertor;
import org.openl.rules.convertor.String2DataConvertorFactory;
import org.openl.rules.dt.DTHeader;
import org.openl.rules.dt.DTUnmatchedCompilationException;
import org.openl.rules.dt.DecisionTable;
import org.openl.rules.dt.DecisionTableColumnHeaders;
import org.openl.rules.dt.DecisionTableUtils;
import org.openl.rules.dt.DeclaredDTHeader;
import org.openl.rules.dt.FuzzyDTHeader;
import org.openl.rules.dt.FuzzyRulesDTHeader;
import org.openl.rules.dt.MatchType;
import org.openl.rules.dt.MatchedDefinition;
import org.openl.rules.dt.SimpleDTHeader;
import org.openl.rules.dt.SimpleReturnDTHeader;
import org.openl.rules.dt.UnmatchedDtHeader;
import org.openl.rules.fuzzy.OpenLFuzzyUtils;
import org.openl.rules.fuzzy.Token;
import org.openl.rules.helpers.CharRange;
import org.openl.rules.helpers.DateRange;
import org.openl.rules.helpers.DateRangeParser;
import org.openl.rules.helpers.DoubleRange;
import org.openl.rules.helpers.IntRange;
import org.openl.rules.helpers.StringRange;
import org.openl.rules.helpers.StringRangeParser;
import org.openl.rules.lang.xls.XlsSheetSourceCodeModule;
import org.openl.rules.lang.xls.XlsWorkbookSourceCodeModule;
import org.openl.rules.lang.xls.binding.DTColumnsDefinition;
import org.openl.rules.lang.xls.binding.XlsDefinitions;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.lang.xls.load.SimpleSheetLoader;
import org.openl.rules.lang.xls.load.SimpleWorkbookLoader;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.types.meta.DecisionTableMetaInfoReader;
import org.openl.rules.lang.xls.types.meta.MetaInfoReader;
import org.openl.rules.table.CompositeGrid;
import org.openl.rules.table.GridRegion;
import org.openl.rules.table.GridTable;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.IWritableGrid;
import org.openl.rules.table.LogicalTableHelper;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.rules.table.xls.XlsSheetGridModel;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.StringSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.IParameterDeclaration;
import org.openl.types.impl.AOpenClass;
import org.openl.types.impl.CompositeMethod;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.ClassUtils;
import org.openl.util.IOUtils;
import org.openl.util.StringTool;

public final class DecisionTableHelper {
    public static final String HORIZONTAL_VERTICAL_CONDITIONS_SPLITTER = "/";
    private static final String RET1_COLUMN_NAME = DecisionTableColumnHeaders.RETURN.getHeaderKey() + "1";
    private static final String CRET1_COLUMN_NAME = DecisionTableColumnHeaders.COLLECT_RETURN.getHeaderKey() + "1";
    private static final List<Class<?>> INT_TYPES = Arrays.asList(Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Byte.class, Short.class, Integer.class, Long.class, ByteValue.class, ShortValue.class, IntValue.class, LongValue.class, BigInteger.class, BigIntegerValue.class);
    private static final List<Class<?>> DOUBLE_TYPES = Arrays.asList(Float.TYPE, Double.TYPE, Float.class, Double.class, FloatValue.class, DoubleValue.class, BigDecimal.class, BigDecimalValue.class);
    private static final List<Class<?>> CHAR_TYPES = Arrays.asList(Character.TYPE, Character.class);
    private static final List<Class<?>> STRING_TYPES = Arrays.asList(String.class, StringValue.class);
    private static final List<Class<?>> DATE_TYPES = Collections.singletonList(Date.class);
    private static final List<Class<?>> RANGE_TYPES = Arrays.asList(IntRange.class, DoubleRange.class, CharRange.class, StringRange.class, DateRange.class);
    private static final List<Class<?>> IGNORED_CLASSES_FOR_COMPOUND_TYPE = Arrays.asList(null, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Character.TYPE, Void.TYPE, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Character.class, String.class, BigInteger.class, BigDecimal.class, Date.class, IntRange.class, DoubleRange.class, CharRange.class, StringRange.class, DateRange.class, ByteValue.class, ShortValue.class, IntValue.class, LongValue.class, FloatValue.class, DoubleValue.class, BigIntegerValue.class, BigDecimalValue.class, StringValue.class, Object.class, Map.class, SortedMap.class, Set.class, SortedSet.class, List.class, Collections.class, ArrayList.class, LinkedList.class, HashSet.class, LinkedHashSet.class, HashMap.class, TreeSet.class, TreeMap.class, LinkedHashMap.class);
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String FUZZY_RET_VARIABLE_NAME = "$Rn";
    private static final String[] MIN_MAX_ORDER = new String[]{"min", "max"};
    private static final String[] MAX_MIN_ORDER = new String[]{"max", "min"};
    private static final int FITS_MAX_LIMIT = 10000;
    private static final int MAX_NUMBER_OF_RETURNS = 3;

    private DecisionTableHelper() {
    }

    static boolean isValidConditionHeader(String s) {
        return s != null && s.length() >= 2 && s.charAt(0) == DecisionTableColumnHeaders.CONDITION.getHeaderKey().charAt(0) && s.substring(1).chars().allMatch(Character::isDigit);
    }

    static boolean isValidHConditionHeader(String headerStr) {
        return headerStr != null && headerStr.startsWith(DecisionTableColumnHeaders.HORIZONTAL_CONDITION.getHeaderKey()) && headerStr.length() > 2 && headerStr.substring(2).chars().allMatch(Character::isDigit);
    }

    static boolean isValidMergedConditionHeader(String headerStr) {
        return headerStr != null && headerStr.startsWith(DecisionTableColumnHeaders.MERGED_CONDITION.getHeaderKey()) && headerStr.length() > 2 && headerStr.substring(2).chars().allMatch(Character::isDigit);
    }

    static boolean isValidActionHeader(String s) {
        return s != null && s.length() >= 2 && s.charAt(0) == DecisionTableColumnHeaders.ACTION.getHeaderKey().charAt(0) && s.substring(1).chars().allMatch(Character::isDigit);
    }

    static boolean isValidRetHeader(String s) {
        return s != null && s.length() >= 3 && s.startsWith(DecisionTableColumnHeaders.RETURN.getHeaderKey()) && (s.length() == 3 || s.substring(3).chars().allMatch(Character::isDigit));
    }

    static boolean isValidKeyHeader(String s) {
        return s != null && s.length() >= 3 && s.startsWith(DecisionTableColumnHeaders.KEY.getHeaderKey()) && (s.length() == 3 || s.substring(3).chars().allMatch(Character::isDigit));
    }

    static boolean isValidCRetHeader(String s) {
        return s != null && s.length() >= 4 && s.startsWith(DecisionTableColumnHeaders.COLLECT_RETURN.getHeaderKey()) && (s.length() == 4 || s.substring(4).chars().allMatch(Character::isDigit));
    }

    static boolean isValidRuleHeader(String s) {
        return Objects.equals(s, DecisionTableColumnHeaders.RULE.getHeaderKey());
    }

    static boolean isConditionHeader(String s) {
        return DecisionTableHelper.isValidConditionHeader(s) || DecisionTableHelper.isValidHConditionHeader(s) || DecisionTableHelper.isValidMergedConditionHeader(s);
    }

    static ILogicalTable preprocessDecisionTableWithoutHeaders(TableSyntaxNode tableSyntaxNode, DecisionTable decisionTable, ILogicalTable originalTable, IBindingContext bindingContext) throws OpenLCompilationException {
        XlsSheetGridModel virtualGrid = DecisionTableHelper.createVirtualGrid();
        boolean isSmartLookupAndResultTitleInFirstRow = DecisionTableHelper.isSmartLookupAndResultTitleInFirstRow(tableSyntaxNode, originalTable);
        DecisionTableHelper.writeVirtualHeaders(tableSyntaxNode, decisionTable, originalTable, virtualGrid, isSmartLookupAndResultTitleInFirstRow, bindingContext);
        if (isSmartLookupAndResultTitleInFirstRow) {
            originalTable = DecisionTableHelper.cutResultTitleInFirstRow(originalTable);
        }
        int sizeOfVirtualGridTable = virtualGrid.getMaxColumnIndex(0) < originalTable.getSource().getWidth() ? originalTable.getSource().getWidth() - 1 : virtualGrid.getMaxColumnIndex(0) - 1;
        GridTable virtualGridTable = new GridTable(0, 0, 2, sizeOfVirtualGridTable, virtualGrid);
        CompositeGrid grid = new CompositeGrid(new IGridTable[]{virtualGridTable, originalTable.getSource()}, true);
        int sizeofGrid = virtualGridTable.getWidth() < originalTable.getSource().getWidth() ? originalTable.getSource().getWidth() - 1 : virtualGridTable.getWidth() - 1;
        return LogicalTableHelper.logicalTable(new GridTable(0, 0, originalTable.getSource().getHeight() + 3 - 1, sizeofGrid, grid));
    }

    private static FuzzyContext buildFuzzyContext(TableSyntaxNode tableSyntaxNode, DecisionTable decisionTable, int numberOfHConditions, IBindingContext bindingContext) {
        IOpenClass returnType;
        ParameterTokens parameterTokens = DecisionTableHelper.buildParameterTokens(decisionTable);
        if (numberOfHConditions == 0 && DecisionTableHelper.isCompoundReturnType(returnType = DecisionTableHelper.getCompoundReturnType(tableSyntaxNode, decisionTable, bindingContext))) {
            Map<Token, IOpenField[][]> returnTypeFuzzyTokens = OpenLFuzzyUtils.tokensMapToOpenClassWritableFieldsRecursively(returnType, returnType.getName(), 1);
            Token[] returnTokens = returnTypeFuzzyTokens.keySet().toArray(new Token[0]);
            return new FuzzyContext(parameterTokens, returnTokens, returnTypeFuzzyTokens, returnType);
        }
        return new FuzzyContext(parameterTokens);
    }

    public static boolean isSmartLookupAndResultTitleInFirstRow(TableSyntaxNode tableSyntaxNode, ILogicalTable originalTable) {
        if (DecisionTableHelper.isSmartLookupTable(tableSyntaxNode) && StringUtils.isNotBlank((CharSequence)originalTable.getCell(0, 0).getStringValue())) {
            ICell cell;
            int firstCellHeight = originalTable.getSource().getCell(0, 0).getHeight();
            int width = originalTable.getSource().getWidth();
            for (int w = originalTable.getSource().getCell(0, 0).getWidth(); w < width; w += cell.getWidth()) {
                cell = originalTable.getSource().getCell(w, 0);
                if (cell.getHeight() == firstCellHeight && !StringUtils.isNotBlank((CharSequence)cell.getStringValue())) continue;
                return false;
            }
            if (firstCellHeight < originalTable.getSource().getHeight()) {
                return originalTable.getSource().getCell(0, firstCellHeight).getWidth() != width;
            }
        }
        return false;
    }

    public static ILogicalTable cutResultTitleInFirstRow(ILogicalTable originalTable) {
        return (ILogicalTable)originalTable.getSubtable(0, 1, originalTable.getWidth(), originalTable.getHeight() - 1);
    }

    private static void writeVirtualHeaders(TableSyntaxNode tableSyntaxNode, DecisionTable decisionTable, ILogicalTable originalTable, IWritableGrid grid, boolean isSmartLookupAndResultTitleInFirstRow, IBindingContext bindingContext) throws OpenLCompilationException {
        Pair<Integer, WithVerticalTitles> p;
        ILogicalTable uncutOriginalTable = null;
        if (isSmartLookupAndResultTitleInFirstRow) {
            uncutOriginalTable = originalTable;
            originalTable = DecisionTableHelper.cutResultTitleInFirstRow(originalTable);
        }
        int numberOfHConditions = DecisionTableHelper.isLookup(tableSyntaxNode) ? DecisionTableHelper.getNumberOfHConditions(originalTable) : 0;
        int firstColumnHeight = originalTable.getSource().getCell(0, 0).getHeight();
        int firstColumnForHCondition = -1;
        WithVerticalTitles withVerticalTitles = WithVerticalTitles.NO;
        if (numberOfHConditions > 0 && (firstColumnForHCondition = ((Integer)(p = DecisionTableHelper.getFirstColumnForHCondition(originalTable, numberOfHConditions, firstColumnHeight, DecisionTableHelper.isSmartLookupTable(tableSyntaxNode))).getLeft()).intValue()) > 0) {
            withVerticalTitles = (WithVerticalTitles)((Object)p.getRight());
        }
        FuzzyContext fuzzyContext = DecisionTableHelper.buildFuzzyContext(tableSyntaxNode, decisionTable, numberOfHConditions, bindingContext);
        NumberOfColumnsUnderTitleCounter numberOfColumnsUnderTitleCounter = new NumberOfColumnsUnderTitleCounter(originalTable, firstColumnHeight);
        List<DTHeader> dtHeaders = DecisionTableHelper.getDTHeaders(tableSyntaxNode, decisionTable, originalTable, fuzzyContext, numberOfColumnsUnderTitleCounter, numberOfHConditions, firstColumnHeight, firstColumnForHCondition, withVerticalTitles, bindingContext);
        DeclaredDTHeader lookupReturnDtHeader = null;
        if (isSmartLookupAndResultTitleInFirstRow && (lookupReturnDtHeader = DecisionTableHelper.getLookupReturnDtHeader(tableSyntaxNode, decisionTable, uncutOriginalTable, dtHeaders, bindingContext)) == null) {
            IGridTable cellTable = (IGridTable)uncutOriginalTable.getSource().getSubtable(0, 0, 1, 1);
            GridCellSourceCodeModule sourceCodeModule = new GridCellSourceCodeModule(cellTable, bindingContext);
            SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)"Expected external return is not found.", (IOpenSourceCodeModule)sourceCodeModule);
            bindingContext.addError(error);
        }
        DecisionTableHelper.writeRule(decisionTable, originalTable, grid, dtHeaders, bindingContext);
        DecisionTableHelper.writeConditions(tableSyntaxNode, decisionTable, originalTable, grid, numberOfColumnsUnderTitleCounter, dtHeaders, numberOfHConditions, firstColumnHeight, firstColumnForHCondition, withVerticalTitles, bindingContext);
        DecisionTableHelper.writeUnmatchedColumns(decisionTable, originalTable, dtHeaders, firstColumnHeight, bindingContext);
        DecisionTableHelper.writeActions(decisionTable, originalTable, grid, dtHeaders, firstColumnHeight, bindingContext);
        DecisionTableHelper.writeReturns(tableSyntaxNode, decisionTable, uncutOriginalTable, originalTable, grid, fuzzyContext, dtHeaders, lookupReturnDtHeader, firstColumnHeight, bindingContext);
    }

    private static DeclaredDTHeader getLookupReturnDtHeader(TableSyntaxNode tableSyntaxNode, DecisionTable decisionTable, ILogicalTable originalTable, List<DTHeader> dtHeaders, IBindingContext bindingContext) {
        int retColumn = DecisionTableHelper.getRetColumn(dtHeaders);
        DeclaredDTHeader lookupReturnDtHeader = null;
        XlsDefinitions definitions = ((XlsModuleOpenClass)decisionTable.getDeclaringClass()).getXlsDefinitions();
        String title = OpenLFuzzyUtils.toTokenString(originalTable.getCell(0, 0).getStringValue());
        for (DTColumnsDefinition definition : definitions.getDtColumnsDefinitions()) {
            MatchedDefinition matchedDefinition;
            if (!definition.isReturn() || definition.getTitles().size() != 1 || !Objects.equals(definition.getTitles().iterator().next(), title) || (matchedDefinition = DecisionTableHelper.matchByDTColumnDefinition(decisionTable, definition, 1, bindingContext)) == null) continue;
            IParameterDeclaration[][] columnParameters = new IParameterDeclaration[][]{definition.getParameters(title).toArray(IParameterDeclaration.EMPTY)};
            if (lookupReturnDtHeader == null) {
                lookupReturnDtHeader = new DeclaredDTHeader(matchedDefinition.getUsedMethodParameterIndexes(), definition.getCompositeMethod(), columnParameters, retColumn, 0, 1, 1, matchedDefinition, true, false);
                continue;
            }
            bindingContext.addMessage(OpenLMessagesUtils.newWarnMessage((String)"Ambiguous matching of column titles to DT return columns. Use more appropriate titles for return columns.", (ISyntaxNode)tableSyntaxNode));
            return lookupReturnDtHeader;
        }
        return lookupReturnDtHeader;
    }

    private static int getRetColumn(List<DTHeader> dtHeaders) {
        return dtHeaders.stream().filter(e -> e.isCondition() || e.isAction()).mapToInt(e -> e.getColumn() + e.getWidth()).max().orElse(0);
    }

    private static void resolveConflictsInDeclaredDtHeaders(DecisionTable decisionTable, List<List<DTHeader>> fits) {
        HashSet<String> usedMethodSignatureIdentifiers = new HashSet<String>();
        for (int i = 0; i < decisionTable.getSignature().getNumberOfParameters(); ++i) {
            usedMethodSignatureIdentifiers.add(DecisionTableHelper.toLowerCase(decisionTable.getSignature().getParameterName(i)));
        }
        for (List<DTHeader> dtHeaders : fits) {
            HashMap<String, Integer> usedAllParameterIdentifiers = new HashMap<String, Integer>();
            HashSet<String> externalParameters = new HashSet<String>();
            for (DTHeader dtHeader : dtHeaders) {
                if (!(dtHeader instanceof DeclaredDTHeader)) continue;
                DeclaredDTHeader declaredDTHeader = (DeclaredDTHeader)dtHeader;
                for (int i = 0; i < declaredDTHeader.getColumnParameters().length; ++i) {
                    for (int j = 0; j < declaredDTHeader.getColumnParameters()[i].length; ++j) {
                        IParameterDeclaration parameterDeclaration = declaredDTHeader.getColumnParameters()[i][j];
                        if (parameterDeclaration == null) continue;
                        usedAllParameterIdentifiers.merge(parameterDeclaration.getName(), 1, Integer::sum);
                    }
                }
                externalParameters.addAll(declaredDTHeader.getMatchedDefinition().getDtColumnsDefinition().getExternalParameters());
            }
            HashMap<String, String> renamedParameters = new HashMap<String, String>();
            for (DTHeader dtHeader : dtHeaders) {
                IParameterDeclaration parameterDeclaration;
                int j;
                int i;
                if (!(dtHeader instanceof DeclaredDTHeader)) continue;
                DeclaredDTHeader declaredDTHeader = (DeclaredDTHeader)dtHeader;
                HashSet<String> usedLocalParameterIdentifiers = new HashSet<String>();
                for (i = 0; i < declaredDTHeader.getColumnParameters().length; ++i) {
                    for (j = 0; j < declaredDTHeader.getColumnParameters()[i].length; ++j) {
                        parameterDeclaration = declaredDTHeader.getColumnParameters()[i][j];
                        if (parameterDeclaration == null) continue;
                        usedLocalParameterIdentifiers.add(DecisionTableHelper.toLowerCase(parameterDeclaration.getName()));
                    }
                }
                for (i = 0; i < declaredDTHeader.getColumnParameters().length; ++i) {
                    for (j = 0; j < declaredDTHeader.getColumnParameters()[i].length; ++j) {
                        parameterDeclaration = declaredDTHeader.getColumnParameters()[i][j];
                        if (parameterDeclaration == null) continue;
                        String param = parameterDeclaration.getName();
                        String lowerCasedParam = DecisionTableHelper.toLowerCase(param);
                        if (usedMethodSignatureIdentifiers.contains(lowerCasedParam) || (Integer)usedAllParameterIdentifiers.get(param) > 1 && externalParameters.contains(param)) {
                            Integer v = (Integer)usedAllParameterIdentifiers.get(param);
                            if (v != null) {
                                if (v > 1) {
                                    usedAllParameterIdentifiers.put(param, v - 1);
                                } else {
                                    usedAllParameterIdentifiers.remove(param);
                                }
                            }
                            String newParamName = "_" + param;
                            String newParamNameLowerCased = DecisionTableHelper.toLowerCase(newParamName);
                            int k = 1;
                            while (usedMethodSignatureIdentifiers.contains(newParamNameLowerCased) || usedAllParameterIdentifiers.containsKey(newParamName) || usedLocalParameterIdentifiers.contains(newParamNameLowerCased)) {
                                newParamName = "_" + parameterDeclaration.getName() + "_" + k;
                                newParamNameLowerCased = DecisionTableHelper.toLowerCase(newParamName);
                                ++k;
                            }
                            param = newParamName;
                            usedAllParameterIdentifiers.put(newParamName, 1);
                        }
                        if (StringUtils.equalsIgnoreCase((CharSequence)parameterDeclaration.getName(), (CharSequence)param)) continue;
                        declaredDTHeader.getMatchedDefinition().renameParameterName(parameterDeclaration.getName(), param);
                        renamedParameters.put(parameterDeclaration.getName(), param);
                    }
                }
            }
            for (DTHeader dtHeader : dtHeaders) {
                if (!(dtHeader instanceof DeclaredDTHeader)) continue;
                DeclaredDTHeader declaredDTHeader = (DeclaredDTHeader)dtHeader;
                for (String externalParameter : declaredDTHeader.getMatchedDefinition().getDtColumnsDefinition().getExternalParameters()) {
                    String renamedParameter = (String)renamedParameters.get(externalParameter);
                    if (renamedParameter == null) continue;
                    declaredDTHeader.getMatchedDefinition().renameExternalParameter(externalParameter, renamedParameter);
                }
            }
        }
    }

    private static boolean isCompoundReturnType(IOpenClass compoundType) {
        if (IGNORED_CLASSES_FOR_COMPOUND_TYPE.contains(compoundType.getInstanceClass())) {
            return false;
        }
        if (compoundType.getConstructor(IOpenClass.EMPTY) == null) {
            return false;
        }
        if (ClassUtils.isAssignable((Class)compoundType.getInstanceClass(), SpreadsheetResult.class)) {
            return false;
        }
        int count = 0;
        for (IOpenField field : compoundType.getFields()) {
            if (field.isConst() || field.isStatic() || !field.isWritable()) continue;
            ++count;
        }
        return count > 0;
    }

    private static boolean isCompoundInputType(IOpenClass type) {
        if (IGNORED_CLASSES_FOR_COMPOUND_TYPE.contains(type.getInstanceClass())) {
            return false;
        }
        int count = 0;
        for (IOpenField field : type.getFields()) {
            if (field.isConst() || field.isStatic() || !field.isReadable()) continue;
            ++count;
        }
        return count > 0;
    }

    private static void validateCompoundReturnType(IOpenClass compoundType) throws OpenLCompilationException {
        try {
            compoundType.getInstanceClass().getConstructor(new Class[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new OpenLCompilationException(String.format("Invalid return type: There is no default constructor found in type '%s'.", compoundType.getDisplayName(0)));
        }
    }

    private static void writeReturnMetaInfo(TableSyntaxNode tableSyntaxNode, ICell cell, String description, String uri) {
        MetaInfoReader metaReader = tableSyntaxNode.getMetaInfoReader();
        if (metaReader instanceof DecisionTableMetaInfoReader) {
            DecisionTableMetaInfoReader metaInfoReader = (DecisionTableMetaInfoReader)metaReader;
            metaInfoReader.addReturn(cell.getTopLeftCellFromRegion().getAbsoluteRow(), cell.getTopLeftCellFromRegion().getAbsoluteColumn(), description, uri);
        }
    }

    private static IOpenClass getCompoundReturnType(TableSyntaxNode tableSyntaxNode, DecisionTable decisionTable, IBindingContext bindingContext) {
        IOpenClass compoundType = DecisionTableHelper.isCollect(tableSyntaxNode) ? (tableSyntaxNode.getHeader().getCollectParameters().length > 0 ? bindingContext.findType("org.openl.this", tableSyntaxNode.getHeader().getCollectParameters()[tableSyntaxNode.getHeader().getCollectParameters().length - 1]) : (decisionTable.getType().isArray() ? decisionTable.getType().getComponentClass() : decisionTable.getType())) : decisionTable.getType();
        return compoundType;
    }

    private static Pair<String, IOpenClass> buildStatementByFieldsChain(IOpenClass type, IOpenField[] fieldsChain) {
        StringBuilder fieldsChainSb = new StringBuilder();
        for (int i = 0; i < fieldsChain.length; ++i) {
            IOpenField openField = type.getField(fieldsChain[i].getName(), false);
            fieldsChainSb.append(openField.getName());
            if (i < fieldsChain.length - 1) {
                fieldsChainSb.append(".");
            }
            type = fieldsChain[i].getType();
        }
        return Pair.of((Object)fieldsChainSb.toString(), (Object)type);
    }

    private static void writeReturnWithReturnDtHeader(TableSyntaxNode tableSyntaxNode, ILogicalTable uncutOriginalTable, ILogicalTable originalTable, IWritableGrid grid, DeclaredDTHeader declaredReturn, String header, boolean lookupReturnHeader, IBindingContext bindingContext) {
        grid.setCellValue(declaredReturn.getColumn(), 0, header);
        grid.setCellValue(declaredReturn.getColumn(), 1, declaredReturn.getStatement());
        DTColumnsDefinition dtColumnsDefinition = declaredReturn.getMatchedDefinition().getDtColumnsDefinition();
        int c = declaredReturn.getColumn();
        block0: while (c < declaredReturn.getColumn() + declaredReturn.getWidthForMerge()) {
            ICell cell = lookupReturnHeader ? uncutOriginalTable.getSource().getCell(0, 0) : originalTable.getSource().getCell(c, 0);
            String d = cell.getStringValue();
            d = OpenLFuzzyUtils.toTokenString(d);
            for (String title : dtColumnsDefinition.getTitles()) {
                if (!lookupReturnHeader && !Objects.equals(d, title)) continue;
                List<IParameterDeclaration> parameters = dtColumnsDefinition.getParameters(title);
                ArrayList<String> parameterNames = new ArrayList<String>();
                ArrayList<IOpenClass> typeOfColumns = new ArrayList<IOpenClass>();
                int totalColumnsUnder = DecisionTableHelper.getTotalColumnsUnder(originalTable, c);
                for (int paramIndex = 0; paramIndex < parameters.size(); ++paramIndex) {
                    IOpenClass paramType;
                    IParameterDeclaration param = parameters.get(paramIndex);
                    if (param != null) {
                        String paramName = declaredReturn.getMatchedDefinition().getParameter(param.getName());
                        parameterNames.add(paramName);
                        String value = param.getType().getName() + (paramName != null ? " " + paramName : "");
                        grid.setCellValue(c, 2, value);
                        paramType = param.getType();
                    } else {
                        paramType = declaredReturn.getCompositeMethod().getType();
                    }
                    typeOfColumns.add(paramType);
                    if (!lookupReturnHeader) {
                        int h = originalTable.getSource().getCell(c, 0).getHeight();
                        int w1 = originalTable.getSource().getCell(c, h).getWidth();
                        if (paramType != null && paramType.isArray()) {
                            int tmpC = c;
                            for (int i = 0; i < totalColumnsUnder - parameters.size(); ++i) {
                                int w2 = originalTable.getSource().getCell(tmpC, h).getWidth();
                                w1 += w2;
                                tmpC += w2;
                            }
                        }
                        if (w1 > 1) {
                            grid.addMergedRegion(new GridRegion(2, c, 2, c + w1 - 1));
                        }
                        c += w1;
                        continue;
                    }
                    ++c;
                }
                if (bindingContext.isExecutionMode()) continue block0;
                StringBuilder sb = new StringBuilder();
                sb.append("Return: ").append(header);
                if (!StringUtils.isEmpty((CharSequence)declaredReturn.getStatement())) {
                    sb.append("\n").append("Expression: ").append(declaredReturn.getStatement().replaceAll("\n", " "));
                }
                DecisionTableMetaInfoReader.appendParameters(sb, parameterNames.toArray(EMPTY_STRING_ARRAY), typeOfColumns.toArray(IOpenClass.EMPTY));
                DecisionTableHelper.writeReturnMetaInfo(tableSyntaxNode, cell, sb.toString(), declaredReturn.getMatchedDefinition().getDtColumnsDefinition().getUri());
                continue block0;
            }
        }
        if (c - declaredReturn.getColumn() > 1) {
            for (int row = 0; row < 2; ++row) {
                grid.addMergedRegion(new GridRegion(row, declaredReturn.getColumn(), row, c - 1));
            }
        }
    }

    private static int getTotalColumnsUnder(ILogicalTable originalTable, int c) {
        int column = c;
        int totalColumnsUnder = 0;
        int maxColumn = c + originalTable.getSource().getCell(column, 0).getWidth();
        while (column < maxColumn) {
            int h = originalTable.getSource().getCell(column, 0).getHeight();
            column += originalTable.getSource().getCell(column, h).getWidth();
            ++totalColumnsUnder;
        }
        return totalColumnsUnder;
    }

    private static IOpenClass writeReturnStatement(IOpenClass type, IOpenField[] fieldsChain, Set<String> generatedNames, Map<String, Map<IOpenField, String>> variables, String insertStatement, Set<String> variableAssignments, StringBuilder sb) {
        if (fieldsChain == null) {
            return type;
        }
        String currentVariable = FUZZY_RET_VARIABLE_NAME;
        HashSet<String> variablesInChain = new HashSet<String>();
        variablesInChain.add(currentVariable);
        for (int j = 0; j < fieldsChain.length; ++j) {
            type = fieldsChain[j].getType();
            if (j < fieldsChain.length - 1) {
                String var;
                Map vm = variables.get(currentVariable);
                if (vm == null || vm.get(fieldsChain[j]) == null) {
                    var = RandomStringUtils.random((int)8, (boolean)true, (boolean)false);
                    while (generatedNames.contains(var)) {
                        var = RandomStringUtils.random((int)8, (boolean)true, (boolean)false);
                    }
                    generatedNames.add(var);
                    sb.append(type.getName()).append(" ").append(var).append("=new ").append(type.getName()).append("();");
                    sb.append("int ").append(var).append("_").append("=0;");
                    vm = variables.computeIfAbsent(currentVariable, e -> new HashMap());
                    vm.put(fieldsChain[j], var);
                    variableAssignments.add(currentVariable + "." + fieldsChain[j].getName() + "=" + var + "_>0?" + var + ":null;");
                } else {
                    var = vm.get(fieldsChain[j]);
                }
                currentVariable = var;
                variablesInChain.add(currentVariable);
                continue;
            }
            String localVar = currentVariable + "." + fieldsChain[j].getName();
            sb.append(localVar).append("=").append(insertStatement).append(";");
            if (variablesInChain.isEmpty()) continue;
            sb.append("if(").append(localVar).append("!=null){");
            for (String cv : variablesInChain) {
                sb.append(cv).append("_++;");
            }
            sb.append('}');
        }
        return type;
    }

    private static void writeInputParametersToReturnMetaInfo(DecisionTable decisionTable, String statementInInputParameters, String statementInReturn) {
        MetaInfoReader metaReader = decisionTable.getSyntaxNode().getMetaInfoReader();
        if (metaReader instanceof DecisionTableMetaInfoReader) {
            DecisionTableMetaInfoReader metaInfoReader = (DecisionTableMetaInfoReader)metaReader;
            metaInfoReader.addParameterToReturn(statementInInputParameters, statementInReturn);
        }
    }

    private static void writeInputParametersToReturn(TableSyntaxNode tableSyntaxNode, DecisionTable decisionTable, FuzzyContext fuzzyContext, List<DTHeader> dtHeaders, Set<String> generatedNames, Map<String, Map<IOpenField, String>> variables, Set<String> variableAssignments, StringBuilder sb, IBindingContext bindingContext) {
        List fuzzyReturns = dtHeaders.stream().filter(e -> e instanceof FuzzyDTHeader).map(e -> (FuzzyDTHeader)e).filter(FuzzyDTHeader::isReturn).collect(Collectors.toList());
        HashMap m = new HashMap();
        for (Token token : fuzzyContext.getFuzzyReturnTokens()) {
            IOpenField[][] returnTypeFieldsChains = fuzzyContext.getFieldsChainsForReturnToken(token);
            for (IOpenField[] returnTypeFieldsChain : returnTypeFieldsChains) {
                boolean f = false;
                for (Map.Entry entry : m.entrySet()) {
                    if (!OpenLFuzzyUtils.isEqualsFieldsChains((IOpenField[])entry.getKey(), returnTypeFieldsChain)) continue;
                    ((List)entry.getValue()).add(token);
                    f = true;
                    break;
                }
                if (f) continue;
                ArrayList<Token> tokens = new ArrayList<Token>();
                tokens.add(token);
                m.put(returnTypeFieldsChain, tokens);
            }
        }
        HashMap<Token, ArrayList<Pair>> bestFuzzyResultsMap = new HashMap<Token, ArrayList<Pair>>();
        for (Map.Entry entry : m.entrySet()) {
            IOpenField[] fieldsChain = (IOpenField[])entry.getKey();
            boolean foundInReturns = fuzzyReturns.stream().anyMatch(e -> OpenLFuzzyUtils.isEqualsFieldsChains(e.getFieldsChain(), fieldsChain));
            if (foundInReturns) continue;
            for (Token token : (List)entry.getValue()) {
                List<OpenLFuzzyUtils.FuzzyResult> fuzzyResults = OpenLFuzzyUtils.fuzzyExtract(token.getValue(), fuzzyContext.getParameterTokens().getTokens(), false);
                for (OpenLFuzzyUtils.FuzzyResult fuzzyResult : fuzzyResults) {
                    int paramIndex = fuzzyContext.getParameterTokens().getParameterIndex(fuzzyResult.getToken());
                    IOpenField[] paramFieldsChain = fuzzyContext.getParameterTokens().getFieldsChain(fuzzyResult.getToken());
                    ArrayList<Pair> resultList = (ArrayList<Pair>)bestFuzzyResultsMap.get(fuzzyResult.getToken());
                    if (resultList == null && (resultList = (List)bestFuzzyResultsMap.entrySet().stream().filter(e -> {
                        int eParamIndex = fuzzyContext.getParameterTokens().getParameterIndex((Token)e.getKey());
                        return paramIndex == eParamIndex && OpenLFuzzyUtils.isEqualsFieldsChains(paramFieldsChain, fuzzyContext.getParameterTokens().getFieldsChain((Token)e.getKey()));
                    }).map(Map.Entry::getValue).findFirst().orElse(null)) == null) {
                        resultList = new ArrayList<Pair>();
                        bestFuzzyResultsMap.put(fuzzyResult.getToken(), resultList);
                    }
                    if (resultList.isEmpty()) {
                        resultList.add(Pair.of((Object)fieldsChain, (Object)fuzzyResult));
                        continue;
                    }
                    Pair existedResult = (Pair)resultList.iterator().next();
                    int fuzzyResultCompare = fuzzyResult.compareTo((OpenLFuzzyUtils.FuzzyResult)existedResult.getRight());
                    if (fuzzyResultCompare > 0) continue;
                    if (fuzzyResultCompare < 0) {
                        resultList.clear();
                    }
                    boolean f = true;
                    for (Pair pair : resultList) {
                        if (!OpenLFuzzyUtils.isEqualsFieldsChains((IOpenField[])pair.getKey(), fieldsChain)) continue;
                        f = false;
                        break;
                    }
                    if (!f) continue;
                    resultList.add(Pair.of((Object)fieldsChain, (Object)fuzzyResult));
                }
            }
        }
        HashMap<String, Set> ambiguousReturnStatementMatching = new HashMap<String, Set>();
        for (Map.Entry entry : bestFuzzyResultsMap.entrySet()) {
            Token paramToken = (Token)entry.getKey();
            for (Pair pair : (List)entry.getValue()) {
                String statement;
                int paramIndex = fuzzyContext.getParameterTokens().getParameterIndex(paramToken);
                IOpenClass type = decisionTable.getSignature().getParameterType(paramIndex);
                IOpenField[] paramFieldsChain = fuzzyContext.getParameterTokens().getFieldsChain(paramToken);
                if (paramFieldsChain != null) {
                    Pair<String, IOpenClass> v = DecisionTableHelper.buildStatementByFieldsChain(type, paramFieldsChain);
                    statement = decisionTable.getSignature().getParameterName(paramIndex) + "." + (String)v.getKey();
                    type = (IOpenClass)v.getValue();
                } else {
                    statement = decisionTable.getSignature().getParameterName(paramIndex);
                }
                if (DecisionTableHelper.isCompoundInputType(type)) continue;
                IOpenField[] fieldsChain = (IOpenField[])pair.getKey();
                Pair<String, IOpenClass> p = DecisionTableHelper.buildStatementByFieldsChain(fuzzyContext.getFuzzyReturnType(), fieldsChain);
                IOpenCast cast = bindingContext.getCast(type, (IOpenClass)p.getValue());
                if (cast == null || !cast.isImplicit()) continue;
                DecisionTableHelper.writeReturnStatement(fuzzyContext.getFuzzyReturnType(), fieldsChain, generatedNames, variables, statement, variableAssignments, sb);
                String statementInReturn = fuzzyContext.getFuzzyReturnType().getName() + "." + (String)DecisionTableHelper.buildStatementByFieldsChain(fuzzyContext.getFuzzyReturnType(), fieldsChain).getKey();
                Set matchedStatements = ambiguousReturnStatementMatching.computeIfAbsent(statementInReturn, k -> new HashSet());
                matchedStatements.add(statement);
                if (bindingContext.isExecutionMode()) continue;
                DecisionTableHelper.writeInputParametersToReturnMetaInfo(decisionTable, statement, statementInReturn);
            }
        }
        ambiguousReturnStatementMatching.entrySet().stream().filter(e -> ((Set)e.getValue()).size() > 1).forEach(e -> bindingContext.addMessage(OpenLMessagesUtils.newWarnMessage((String)String.format("More than one input parameter is set to return '%s'.", e.getKey()), (ISyntaxNode)tableSyntaxNode)));
    }

    private static void writeFuzzyReturns(TableSyntaxNode tableSyntaxNode, DecisionTable decisionTable, ILogicalTable originalTable, IWritableGrid grid, FuzzyContext fuzzyContext, List<DTHeader> dtHeaders, IOpenClass compoundReturnType, String header, IBindingContext bindingContext) throws OpenLCompilationException {
        DecisionTableHelper.validateCompoundReturnType(compoundReturnType);
        List fuzzyReturns = dtHeaders.stream().filter(e -> e instanceof FuzzyDTHeader && e.isReturn()).map(e -> (FuzzyDTHeader)e).filter(e -> e.getFieldsChain() != null).collect(Collectors.toList());
        HashSet<String> variableAssignments = new HashSet<String>();
        if (fuzzyReturns.isEmpty()) {
            throw new IllegalStateException("DT headers are not found.");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(compoundReturnType.getName()).append(" ").append(FUZZY_RET_VARIABLE_NAME).append(" = new ").append(compoundReturnType.getName()).append("();");
        sb.append("int ").append(FUZZY_RET_VARIABLE_NAME).append("_").append(" = 0;");
        HashSet<String> generatedNames = new HashSet<String>();
        while (generatedNames.size() < fuzzyReturns.size()) {
            generatedNames.add(RandomStringUtils.random((int)8, (boolean)true, (boolean)false));
        }
        String[] compoundColumnParamNames = generatedNames.toArray(EMPTY_STRING_ARRAY);
        HashMap<String, Map<IOpenField, String>> variables = new HashMap<String, Map<IOpenField, String>>();
        DecisionTableHelper.writeInputParametersToReturn(tableSyntaxNode, decisionTable, fuzzyContext, dtHeaders, generatedNames, variables, variableAssignments, sb, bindingContext);
        int i = 0;
        for (FuzzyDTHeader fuzzyDTHeader : fuzzyReturns) {
            IOpenClass type = DecisionTableHelper.writeReturnStatement(compoundReturnType, fuzzyDTHeader.getFieldsChain(), generatedNames, variables, compoundColumnParamNames[i], variableAssignments, sb);
            grid.setCellValue(fuzzyDTHeader.getColumn(), 2, type.getName() + " " + compoundColumnParamNames[i]);
            if (fuzzyDTHeader.getWidth() > 1) {
                grid.addMergedRegion(new GridRegion(2, fuzzyDTHeader.getColumn(), 2, fuzzyDTHeader.getColumn() + fuzzyDTHeader.getWidth() - 1));
            }
            if (!bindingContext.isExecutionMode()) {
                int firstColumnHeight = originalTable.getCell(0, 0).getHeight();
                ICell cell = originalTable.getSource().getCell(fuzzyDTHeader.getColumn(), firstColumnHeight - 1);
                cell = cell.getTopLeftCellFromRegion();
                String statement = (String)DecisionTableHelper.buildStatementByFieldsChain(compoundReturnType, fuzzyDTHeader.getFieldsChain()).getKey();
                StringBuilder sb1 = new StringBuilder();
                sb1.append("Return: ").append(header);
                if (!StringUtils.isEmpty((CharSequence)statement)) {
                    sb1.append("\n").append("Expression: value for return ").append(compoundReturnType.getDisplayName(0)).append(".").append(statement);
                }
                DecisionTableMetaInfoReader.appendParameters(sb1, null, new IOpenClass[]{type});
                DecisionTableHelper.writeReturnMetaInfo(tableSyntaxNode, cell, sb1.toString(), null);
            }
            ++i;
        }
        variableAssignments.forEach(sb::append);
        sb.append(FUZZY_RET_VARIABLE_NAME).append("_ > 0 ? ").append(FUZZY_RET_VARIABLE_NAME).append(" : null;");
        String expression = sb.toString();
        if (expression.length() > SpreadsheetVersion.EXCEL2007.getMaxTextLength()) {
            throw new IllegalStateException("Generated expression is too long!");
        }
        grid.setCellValue(((FuzzyDTHeader)fuzzyReturns.get(0)).getColumn(), 0, header);
        grid.setCellValue(((FuzzyDTHeader)fuzzyReturns.get(0)).getColumn(), 1, expression);
        int j = fuzzyReturns.size() - 1;
        if (((FuzzyDTHeader)fuzzyReturns.get(j)).getColumn() + ((FuzzyDTHeader)fuzzyReturns.get(j)).getWidth() - ((FuzzyDTHeader)fuzzyReturns.get(0)).getColumn() > 1) {
            for (int row = 0; row < 2; ++row) {
                grid.addMergedRegion(new GridRegion(row, ((FuzzyDTHeader)fuzzyReturns.get(0)).getColumn(), row, ((FuzzyDTHeader)fuzzyReturns.get(j)).getColumn() + ((FuzzyDTHeader)fuzzyReturns.get(j)).getWidth() - 1));
            }
        }
    }

    private static void writeSimpleDTReturnHeader(TableSyntaxNode tableSyntaxNode, DecisionTable decisionTable, ILogicalTable originalTable, IWritableGrid grid, SimpleReturnDTHeader simpleReturnDTHeader, String header, int collectParameterIndex, IBindingContext bindingContext) {
        grid.setCellValue(simpleReturnDTHeader.getColumn(), 0, header);
        if (tableSyntaxNode.getHeader().getCollectParameters().length > 0) {
            grid.setCellValue(simpleReturnDTHeader.getColumn(), 2, tableSyntaxNode.getHeader().getCollectParameters()[collectParameterIndex]);
        }
        if (!bindingContext.isExecutionMode()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Return: ").append(header);
            ICell cell = originalTable.getSource().getCell(simpleReturnDTHeader.getColumn(), 0);
            if (!StringUtils.isEmpty((CharSequence)simpleReturnDTHeader.getStatement())) {
                sb.append("\n").append("Expression: ").append(simpleReturnDTHeader.getStatement());
            }
            DecisionTableMetaInfoReader.appendParameters(sb, null, new IOpenClass[]{decisionTable.getHeader().getType()});
            DecisionTableHelper.writeReturnMetaInfo(tableSyntaxNode, cell, sb.toString(), null);
        }
        if (simpleReturnDTHeader.getWidth() > 1) {
            for (int row = 0; row < 3; ++row) {
                grid.addMergedRegion(new GridRegion(row, simpleReturnDTHeader.getColumn(), row, simpleReturnDTHeader.getColumn() + simpleReturnDTHeader.getWidth() - 1));
            }
        }
    }

    private static void writeReturns(TableSyntaxNode tableSyntaxNode, DecisionTable decisionTable, ILogicalTable uncutOriginalTable, ILogicalTable originalTable, IWritableGrid grid, FuzzyContext fuzzyContext, List<DTHeader> dtHeaders, DeclaredDTHeader lookupReturnDtHeader, int firstColumnHeight, IBindingContext bindingContext) throws OpenLCompilationException {
        boolean isCollect = DecisionTableHelper.isCollect(tableSyntaxNode);
        if (DecisionTableHelper.isLookup(tableSyntaxNode)) {
            if (lookupReturnDtHeader != null) {
                DecisionTableHelper.writeReturnWithReturnDtHeader(tableSyntaxNode, uncutOriginalTable, originalTable, grid, lookupReturnDtHeader, isCollect ? CRET1_COLUMN_NAME : RET1_COLUMN_NAME, true, bindingContext);
            } else {
                int retColumn = DecisionTableHelper.getRetColumn(dtHeaders);
                grid.setCellValue(retColumn, 0, isCollect ? CRET1_COLUMN_NAME : RET1_COLUMN_NAME);
            }
            return;
        }
        if (dtHeaders.stream().filter(DTHeader::isReturn).anyMatch(e -> e.getColumn() + e.getWidth() - 1 >= originalTable.getSource().getWidth())) {
            throw new OpenLCompilationException("Wrong table structure: There is no column for return values.");
        }
        int retNum = 1;
        int cRetNum = 1;
        int i = 0;
        int collectParameterIndex = 0;
        int keyNum = 1;
        boolean skipFuzzyReturns = false;
        for (DTHeader dtHeader : dtHeaders) {
            if (!dtHeader.isReturn()) continue;
            if (dtHeader instanceof DeclaredDTHeader) {
                DecisionTableHelper.writeReturnWithReturnDtHeader(tableSyntaxNode, uncutOriginalTable, originalTable, grid, (DeclaredDTHeader)dtHeader, isCollect ? DecisionTableColumnHeaders.COLLECT_RETURN.getHeaderKey() + cRetNum++ : DecisionTableColumnHeaders.RETURN.getHeaderKey() + retNum++, false, bindingContext);
                continue;
            }
            if (dtHeader instanceof SimpleReturnDTHeader || dtHeader instanceof FuzzyDTHeader && ((FuzzyDTHeader)dtHeader).getFieldsChain() == null) {
                SimpleReturnDTHeader simpleDTReturnHeader;
                String header;
                boolean isKey = false;
                if (isCollect && tableSyntaxNode.getHeader().getCollectParameters().length > 1 && i == 0 && ClassUtils.isAssignable((Class)decisionTable.getType().getInstanceClass(), Map.class)) {
                    header = DecisionTableColumnHeaders.KEY.getHeaderKey() + keyNum++;
                    isKey = true;
                } else {
                    String string = header = isCollect ? DecisionTableColumnHeaders.COLLECT_RETURN.getHeaderKey() + cRetNum++ : DecisionTableColumnHeaders.RETURN.getHeaderKey() + retNum++;
                }
                if (dtHeader instanceof FuzzyDTHeader) {
                    FuzzyDTHeader fuzzyDTHeader = (FuzzyDTHeader)dtHeader;
                    simpleDTReturnHeader = new SimpleReturnDTHeader(fuzzyDTHeader.getStatement(), fuzzyDTHeader.getTitle(), fuzzyDTHeader.getColumn(), 0, fuzzyDTHeader.getWidth());
                } else {
                    simpleDTReturnHeader = (SimpleReturnDTHeader)dtHeader;
                }
                DecisionTableHelper.writeSimpleDTReturnHeader(tableSyntaxNode, decisionTable, originalTable, grid, simpleDTReturnHeader, header, collectParameterIndex, bindingContext);
                ++i;
                if (!isKey) continue;
                ++collectParameterIndex;
                continue;
            }
            if (!(dtHeader instanceof FuzzyDTHeader) || skipFuzzyReturns) continue;
            IOpenClass compoundReturnType = DecisionTableHelper.getCompoundReturnType(tableSyntaxNode, decisionTable, bindingContext);
            DecisionTableHelper.writeFuzzyReturns(tableSyntaxNode, decisionTable, originalTable, grid, fuzzyContext, dtHeaders, compoundReturnType, isCollect ? DecisionTableColumnHeaders.COLLECT_RETURN.getHeaderKey() + cRetNum++ : DecisionTableColumnHeaders.RETURN.getHeaderKey() + retNum++, bindingContext);
            skipFuzzyReturns = true;
        }
    }

    private static void writeDeclaredDtHeader(DecisionTable decisionTable, ILogicalTable originalTable, IWritableGrid grid, DeclaredDTHeader declaredDtHeader, String header, int firstColumnHeight, IBindingContext bindingContext) {
        int firstColumn;
        int column = declaredDtHeader.getColumn();
        grid.setCellValue(column, 0, header);
        grid.setCellValue(column, 1, declaredDtHeader.getStatement());
        int lastParamFirstColumn = firstColumn = column;
        ArrayList<String> parameterNames = new ArrayList<String>();
        ArrayList<IOpenClass> typeOfColumns = new ArrayList<IOpenClass>();
        for (int j = 0; j < declaredDtHeader.getColumnParameters().length; ++j) {
            for (int k = 0; k < declaredDtHeader.getColumnParameters()[j].length; ++k) {
                IParameterDeclaration param = declaredDtHeader.getColumnParameters()[j][k];
                if (param != null) {
                    String paramName = declaredDtHeader.getMatchedDefinition().getParameter(param.getName());
                    parameterNames.add(paramName);
                    grid.setCellValue(column, 2, param.getType().getName() + (paramName != null ? " " + paramName : ""));
                    typeOfColumns.add(param.getType());
                } else {
                    parameterNames.add(null);
                    typeOfColumns.add(declaredDtHeader.getCompositeMethod().getType());
                }
                int w1 = declaredDtHeader.isHCondition() ? 1 : originalTable.getSource().getCell(column, firstColumnHeight).getWidth();
                if (w1 > 1) {
                    grid.addMergedRegion(new GridRegion(2, column, 2, column + w1 - 1));
                }
                lastParamFirstColumn = column;
                column += w1;
            }
        }
        if (!bindingContext.isExecutionMode()) {
            for (int column1 = declaredDtHeader.getColumn(); column1 < declaredDtHeader.getColumn() + declaredDtHeader.getWidth(); column1 += originalTable.getSource().getCell(column1, declaredDtHeader.getRow()).getWidth()) {
                if (declaredDtHeader.isAction()) {
                    DecisionTableHelper.writeMetaInfoForAction(decisionTable, originalTable, column1, declaredDtHeader.getRow(), header, parameterNames.toArray(EMPTY_STRING_ARRAY), declaredDtHeader.getStatement(), typeOfColumns.toArray(IOpenClass.EMPTY), declaredDtHeader.getMatchedDefinition().getDtColumnsDefinition().getUri());
                    continue;
                }
                if (!declaredDtHeader.isCondition() || declaredDtHeader.isHCondition()) continue;
                DecisionTableHelper.writeMetaInfoForVCondition(originalTable, decisionTable, column1, declaredDtHeader.getRow(), header, parameterNames.toArray(EMPTY_STRING_ARRAY), declaredDtHeader.getStatement(), typeOfColumns.toArray(IOpenClass.EMPTY), declaredDtHeader.getMatchedDefinition().getDtColumnsDefinition().getUri());
            }
        }
        if (column < firstColumn + declaredDtHeader.getWidthForMerge()) {
            grid.addMergedRegion(new GridRegion(2, lastParamFirstColumn, 2, firstColumn + declaredDtHeader.getWidthForMerge() - 1));
            column = firstColumn + declaredDtHeader.getWidthForMerge();
        }
        if (column - firstColumn > 1) {
            for (int row = 0; row < 2; ++row) {
                grid.addMergedRegion(new GridRegion(row, firstColumn, row, column - 1));
            }
        }
    }

    private static void writeRule(DecisionTable decisionTable, ILogicalTable originalTable, IWritableGrid grid, List<DTHeader> dtHeaders, IBindingContext bindingContext) throws OpenLCompilationException {
        List rules = dtHeaders.stream().filter(DTHeader::isRule).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        if (!rules.isEmpty()) {
            if (rules.size() > 1) {
                String message = "Wrong table structure: Wrong number of rule numbers columns.";
                throw new OpenLCompilationException(message);
            }
            DTHeader rule = (DTHeader)rules.iterator().next();
            if (rule.getColumn() != 0) {
                String message = "Wrong table structure: Wrong rule numbers column index.";
                throw new OpenLCompilationException(message);
            }
            if (rule instanceof FuzzyRulesDTHeader) {
                FuzzyRulesDTHeader fuzzyRulesDTHeader = (FuzzyRulesDTHeader)rule;
                grid.setCellValue(fuzzyRulesDTHeader.getColumn(), 0, (Object)DecisionTableColumnHeaders.RULE);
                if (!bindingContext.isExecutionMode()) {
                    DecisionTableHelper.writeMetaInfoForRule(decisionTable, originalTable, fuzzyRulesDTHeader.getColumn(), 0);
                }
            }
        }
    }

    private static void writeActions(DecisionTable decisionTable, ILogicalTable originalTable, IWritableGrid grid, List<DTHeader> dtHeaders, int firstColumnHeight, IBindingContext bindingContext) throws OpenLCompilationException {
        List actions = dtHeaders.stream().filter(DTHeader::isAction).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        int num = 0;
        for (DTHeader action : actions) {
            if (action.getColumn() >= originalTable.getSource().getWidth()) {
                String message = "Wrong table structure: Wrong number of action columns.";
                throw new OpenLCompilationException(message);
            }
            DeclaredDTHeader declaredAction = (DeclaredDTHeader)action;
            String header = DecisionTableColumnHeaders.ACTION.getHeaderKey() + (num + 1);
            DecisionTableHelper.writeDeclaredDtHeader(decisionTable, originalTable, grid, declaredAction, header, firstColumnHeight, bindingContext);
            ++num;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean getMinMaxOrder(ILogicalTable originalTable, NumberOfColumnsUnderTitleCounter numberOfColumnsUnderTitleCounter, int firstColumnHeight, int column, IOpenClass type) {
        int h = firstColumnHeight;
        int height = originalTable.getSource().getHeight();
        int t1 = 0;
        int t2 = 0;
        IString2DataConvertor string2DataConverter = String2DataConvertorFactory.getConvertor(type.getInstanceClass());
        while (h < height) {
            Object o2;
            Object o1;
            ICell cell1 = originalTable.getSource().getCell(column, h);
            String s1 = cell1.getStringValue();
            try {
                o1 = string2DataConverter.parse(s1, null);
            }
            catch (IllegalArgumentException e) {
                h += cell1.getHeight();
                continue;
            }
            ICell cell2 = originalTable.getSource().getCell(column + numberOfColumnsUnderTitleCounter.getWidth(column, 0), h);
            String s2 = cell2.getStringValue();
            try {
                o2 = string2DataConverter.parse(s2, null);
            }
            catch (IllegalArgumentException e) {
                h += cell1.getHeight();
                continue;
            }
            try {
                if (JavaOpenClass.STRING.equals((Object)type) && o1 != null && o2 != null) {
                    int res = NumericStringComparator.INSTANCE.compare((CharSequence)((String)o1), (CharSequence)((String)o2));
                    if (res > 0) {
                        ++t1;
                        continue;
                    }
                    if (res >= 0) continue;
                    ++t2;
                    continue;
                }
                if (!(o1 instanceof Comparable) || !(o2 instanceof Comparable)) continue;
                int res = ((Comparable)o1).compareTo(o2);
                if (res > 0) {
                    ++t1;
                    continue;
                }
                if (res >= 0) continue;
                ++t2;
            }
            finally {
                h += cell1.getHeight();
            }
        }
        return t1 <= t2;
    }

    private static void writeUnmatchedColumns(DecisionTable decisionTable, ILogicalTable originalTable, List<DTHeader> dtHeaders, int firstColumnHeight, IBindingContext bindingContext) throws OpenLCompilationException {
        List unmatched = dtHeaders.stream().filter(e -> e instanceof UnmatchedDtHeader).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        for (DTHeader dtHeader : unmatched) {
            String message;
            int column = dtHeader.getColumn();
            if (column > originalTable.getSource().getWidth()) {
                message = "Wrong table structure: Columns count is less than parameters count";
                throw new OpenLCompilationException(message);
            }
            if (column == originalTable.getSource().getWidth()) {
                message = "Wrong table structure: There is no column for return values";
                throw new OpenLCompilationException(message);
            }
            if (!bindingContext.isExecutionMode()) {
                DecisionTableHelper.writeMetaInfoForUnmatched(originalTable, decisionTable, column, firstColumnHeight - 1);
            }
            GridCellSourceCodeModule eGridCellSourceCodeModule = new GridCellSourceCodeModule(originalTable.getSource(), dtHeader.getColumn(), firstColumnHeight - 1, bindingContext);
            SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)String.format("Smart table has unmatched title '%s'.", eGridCellSourceCodeModule.getCode()), (IOpenSourceCodeModule)eGridCellSourceCodeModule);
            bindingContext.addError(error);
        }
    }

    private static void writeConditions(TableSyntaxNode tableSyntaxNode, DecisionTable decisionTable, ILogicalTable originalTable, IWritableGrid grid, NumberOfColumnsUnderTitleCounter numberOfColumnsUnderTitleCounter, List<DTHeader> dtHeaders, int numberOfHConditions, int firstColumnHeight, int firstColumnForHCondition, WithVerticalTitles withVerticalTitles, IBindingContext bindingContext) throws OpenLCompilationException {
        List conditions = dtHeaders.stream().filter(e -> !(e instanceof UnmatchedDtHeader)).filter(DTHeader::isCondition).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        int numOfVCondition = 0;
        int numOfHCondition = 0;
        int firstColumnForHConditionsOrReturns = dtHeaders.stream().filter(e -> e.isCondition() && !e.isHCondition() || e.isAction()).mapToInt(e -> e.getColumn() + e.getWidth()).max().orElse(0);
        boolean isCollect = DecisionTableHelper.isCollect(tableSyntaxNode);
        HashMap<DTHeader, IOpenClass> hConditionTypes = new HashMap<DTHeader, IOpenClass>();
        for (DTHeader condition : conditions) {
            int column = condition.getColumn();
            if (!DecisionTableHelper.isLookup(tableSyntaxNode)) {
                String message;
                if (column > originalTable.getSource().getWidth()) {
                    message = "Wrong table structure: Columns count is less than parameters count";
                    throw new OpenLCompilationException(message);
                }
                if (column > originalTable.getSource().getWidth()) {
                    message = "Wrong table structure: There is no column for return values";
                    throw new OpenLCompilationException(message);
                }
            }
            String header = !condition.isHCondition() ? (!(++numOfVCondition != 1 || conditions.stream().filter(e -> !e.isHCondition()).count() >= 2L || isCollect && decisionTable.getType().isArray() && !decisionTable.getType().getComponentClass().isArray() || isCollect && ClassUtils.isAssignable((Class)decisionTable.getType().getInstanceClass(), Collection.class)) ? DecisionTableColumnHeaders.MERGED_CONDITION.getHeaderKey() + numOfVCondition : DecisionTableColumnHeaders.CONDITION.getHeaderKey() + numOfVCondition) : DecisionTableColumnHeaders.HORIZONTAL_CONDITION.getHeaderKey() + ++numOfHCondition;
            if (condition instanceof DeclaredDTHeader) {
                DecisionTableHelper.writeDeclaredDtHeader(decisionTable, originalTable, grid, (DeclaredDTHeader)condition, header, firstColumnHeight, bindingContext);
                continue;
            }
            grid.setCellValue(column, 0, header);
            int numberOfColumnsUnderTitle = numberOfColumnsUnderTitleCounter.get(column);
            IOpenClass type = DecisionTableHelper.getTypeForCondition(decisionTable, condition);
            if (condition instanceof FuzzyDTHeader && numberOfColumnsUnderTitle == 2 && condition.getWidthForMerge() == numberOfColumnsUnderTitleCounter.getWidth(column, 0) + numberOfColumnsUnderTitleCounter.getWidth(column, 1) && type.getInstanceClass() != null && (type.getInstanceClass().isPrimitive() || ClassUtils.isAssignable((Class)type.getInstanceClass(), Comparable.class))) {
                boolean minMaxOrder = DecisionTableHelper.getMinMaxOrder(originalTable, numberOfColumnsUnderTitleCounter, firstColumnHeight, column, type);
                String stringOperator = "";
                if (JavaOpenClass.STRING.equals((Object)type)) {
                    stringOperator = "string";
                }
                String statement = minMaxOrder ? "min " + stringOperator + "<= " + condition.getStatement() + " && " + condition.getStatement() + " " + stringOperator + "< max" : "max " + stringOperator + "> " + condition.getStatement() + " && " + condition.getStatement() + " " + stringOperator + ">= min";
                grid.setCellValue(column, 1, statement);
                grid.setCellValue(column, 2, type.getName() + " " + (minMaxOrder ? "min" : "max"));
                int w1 = numberOfColumnsUnderTitleCounter.getWidth(column, 0);
                if (w1 > 1) {
                    grid.addMergedRegion(new GridRegion(2, column, 2, column + w1 - 1));
                }
                grid.setCellValue(column + w1, 2, type.getName() + " " + (minMaxOrder ? "max" : "min"));
                int w2 = numberOfColumnsUnderTitleCounter.getWidth(column, 1);
                if (w2 > 1) {
                    grid.addMergedRegion(new GridRegion(2, column + w1, 2, column + w1 + w2 - 1));
                }
                if (condition.isHCondition()) continue;
                if (!bindingContext.isExecutionMode()) {
                    DecisionTableHelper.writeMetaInfoForVCondition(originalTable, decisionTable, condition.getColumn(), condition.getRow(), header, minMaxOrder ? MIN_MAX_ORDER : MAX_MIN_ORDER, statement, new IOpenClass[]{type, type}, null);
                }
                if (condition.getWidthForMerge() <= 1) continue;
                for (int row = 0; row < 2; ++row) {
                    grid.addMergedRegion(new GridRegion(row, column, row, column + condition.getWidthForMerge() - 1));
                }
                continue;
            }
            Triple<String[], IOpenClass, String> typeOfValue = DecisionTableHelper.getTypeForConditionColumn(decisionTable, originalTable, condition, numOfHCondition, firstColumnForHConditionsOrReturns, firstColumnHeight, numberOfColumnsUnderTitle, bindingContext);
            grid.setCellValue(column, 1, typeOfValue.getRight());
            grid.setCellValue(column, 2, ((String[])typeOfValue.getLeft()).length == 1 ? ((String[])typeOfValue.getLeft())[0] : ((String[])typeOfValue.getLeft())[0] + " " + ((String[])typeOfValue.getLeft())[1]);
            if (condition.isHCondition()) {
                hConditionTypes.put(condition, (IOpenClass)typeOfValue.getMiddle());
                continue;
            }
            if (!bindingContext.isExecutionMode()) {
                String[] stringArray;
                int n = condition.getColumn();
                int n2 = condition.getRow();
                if (((String[])typeOfValue.getLeft()).length == 1) {
                    stringArray = null;
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = ((String[])typeOfValue.getLeft())[1];
                }
                DecisionTableHelper.writeMetaInfoForVCondition(originalTable, decisionTable, n, n2, header, stringArray, (String)typeOfValue.getRight(), new IOpenClass[]{(IOpenClass)typeOfValue.getMiddle()}, null);
            }
            if (condition.getWidth() <= 1) continue;
            for (int row = 0; row < 3; ++row) {
                grid.addMergedRegion(new GridRegion(row, column, row, column + condition.getWidth() - 1));
            }
        }
        if (!bindingContext.isExecutionMode()) {
            DecisionTableHelper.writeMetaInfoForHConditions(originalTable, decisionTable, conditions, firstColumnForHCondition, withVerticalTitles, hConditionTypes);
        }
    }

    private static void writeMetaInfoForVCondition(ILogicalTable originalTable, DecisionTable decisionTable, int column, int row, String header, String[] parameterNames, String conditionStatement, IOpenClass[] typeOfColumns, String url) {
        Objects.requireNonNull(header);
        MetaInfoReader metaReader = decisionTable.getSyntaxNode().getMetaInfoReader();
        if (metaReader instanceof DecisionTableMetaInfoReader) {
            DecisionTableMetaInfoReader metaInfoReader = (DecisionTableMetaInfoReader)metaReader;
            ICell cell = originalTable.getSource().getCell(column, row);
            cell = cell.getTopLeftCellFromRegion();
            metaInfoReader.addCondition(cell.getAbsoluteRow(), cell.getAbsoluteColumn(), header, parameterNames, conditionStatement, typeOfColumns, url, null, false);
        }
    }

    private static void writeMetaInfoForUnmatched(ILogicalTable originalTable, DecisionTable decisionTable, int column, int row) {
        MetaInfoReader metaReader = decisionTable.getSyntaxNode().getMetaInfoReader();
        if (metaReader instanceof DecisionTableMetaInfoReader) {
            DecisionTableMetaInfoReader metaInfoReader = (DecisionTableMetaInfoReader)metaReader;
            ICell cell = originalTable.getSource().getCell(column, row);
            cell = cell.getTopLeftCellFromRegion();
            metaInfoReader.addUnmatched(cell.getAbsoluteRow(), cell.getAbsoluteColumn());
        }
    }

    private static void writeMetaInfoForRule(DecisionTable decisionTable, ILogicalTable originalTable, int column, int row) {
        MetaInfoReader metaReader = decisionTable.getSyntaxNode().getMetaInfoReader();
        if (metaReader instanceof DecisionTableMetaInfoReader) {
            DecisionTableMetaInfoReader metaInfoReader = (DecisionTableMetaInfoReader)metaReader;
            ICell cell = originalTable.getSource().getCell(column, row);
            cell = cell.getTopLeftCellFromRegion();
            metaInfoReader.addRule(cell.getAbsoluteRow(), cell.getAbsoluteColumn());
        }
    }

    private static void writeMetaInfoForAction(DecisionTable decisionTable, ILogicalTable originalTable, int column, int row, String header, String[] parameterNames, String conditionStatement, IOpenClass[] typeOfColumns, String url) {
        Objects.requireNonNull(header);
        MetaInfoReader metaReader = decisionTable.getSyntaxNode().getMetaInfoReader();
        if (metaReader instanceof DecisionTableMetaInfoReader) {
            DecisionTableMetaInfoReader metaInfoReader = (DecisionTableMetaInfoReader)metaReader;
            ICell cell = originalTable.getSource().getCell(column, row);
            cell = cell.getTopLeftCellFromRegion();
            metaInfoReader.addAction(cell.getAbsoluteRow(), cell.getAbsoluteColumn(), header, parameterNames, conditionStatement, typeOfColumns, url, null);
        }
    }

    private static void writeMetaInfoForHConditions(ILogicalTable originalTable, DecisionTable decisionTable, List<DTHeader> conditions, int firstColumnForHCondition, WithVerticalTitles withVerticalTitles, Map<DTHeader, IOpenClass> hConditionTypes) {
        int minColumn;
        MetaInfoReader metaInfoReader = decisionTable.getSyntaxNode().getMetaInfoReader();
        int j = 0;
        List hDtHeaders = conditions.stream().filter(DTHeader::isHCondition).collect(Collectors.toList());
        if (!WithVerticalTitles.NO.equals((Object)withVerticalTitles) && firstColumnForHCondition > 0) {
            DeclaredDTHeader declaredDTHeader;
            DTHeader lastVCondition;
            minColumn = firstColumnForHCondition - originalTable.getSource().getCell(firstColumnForHCondition - 1, 0).getWidth();
            List vDtHeaders = conditions.stream().filter(e -> e.isCondition() && !e.isHCondition()).collect(Collectors.toList());
            if (!vDtHeaders.isEmpty() && (lastVCondition = (DTHeader)vDtHeaders.get(vDtHeaders.size() - 1)) instanceof DeclaredDTHeader && !(declaredDTHeader = (DeclaredDTHeader)lastVCondition).isVerticalConditionWithMergedTitle()) {
                minColumn = hDtHeaders.stream().mapToInt(DTHeader::getColumn).min().orElse(0);
            }
        } else {
            minColumn = hDtHeaders.stream().mapToInt(DTHeader::getColumn).min().orElse(0);
        }
        int numOfCondition = 1;
        for (DTHeader condition : hDtHeaders) {
            ICell cell;
            for (int column = minColumn; column < originalTable.getSource().getWidth(); column += cell.getWidth()) {
                cell = originalTable.getSource().getCell(column, j);
                String cellValue = (cell = cell.getTopLeftCellFromRegion()).getStringValue();
                if (cellValue == null || !(metaInfoReader instanceof DecisionTableMetaInfoReader)) continue;
                IOpenClass type = hConditionTypes.get(condition);
                if (type == null) {
                    type = DecisionTableHelper.getTypeForCondition(decisionTable, condition);
                }
                ((DecisionTableMetaInfoReader)metaInfoReader).addCondition(cell.getAbsoluteRow(), cell.getAbsoluteColumn(), DecisionTableColumnHeaders.HORIZONTAL_CONDITION.getHeaderKey() + numOfCondition, null, condition.getStatement(), new IOpenClass[]{type}, condition instanceof DeclaredDTHeader ? ((DeclaredDTHeader)condition).getMatchedDefinition().getDtColumnsDefinition().getUri() : null, null, true);
            }
            j += originalTable.getSource().getCell(originalTable.getSource().getWidth() - 1, j).getHeight();
            ++numOfCondition;
        }
    }

    private static String toLowerCase(String x) {
        return x != null ? x.toLowerCase() : null;
    }

    private static MatchedDefinition matchByDTColumnDefinition(DecisionTable decisionTable, DTColumnsDefinition definition, int numberOfHConditions, IBindingContext bindingContext) {
        MatchType[] matchTypes;
        int j;
        int i;
        IOpenMethodHeader header = decisionTable.getHeader();
        boolean mayHaveCompilationErrors = false;
        if (definition.isReturn()) {
            IOpenClass methodReturnType = header.getType();
            IOpenClass definitionType = definition.getCompositeMethod().getType();
            IOpenCast openCast = bindingContext.getCast(definitionType, methodReturnType);
            if (openCast == null || !openCast.isImplicit()) {
                mayHaveCompilationErrors = true;
            }
        }
        List<IdentifierNode> identifierNodes = DecisionTableUtils.retrieveIdentifierNodes(definition);
        HashMap<String, IParameterDeclaration> completeParameters = new HashMap<String, IParameterDeclaration>();
        for (IParameterDeclaration parameter : definition.getParameters()) {
            if (parameter == null || parameter.getName() == null) continue;
            completeParameters.put(DecisionTableHelper.toLowerCase(parameter.getName()), parameter);
        }
        HashSet<String> methodParametersUsedInExpression = new HashSet<String>();
        HashMap<String, String> originalMethodParametersUsedInExpression = new HashMap<String, String>();
        for (IdentifierNode identifierNode : identifierNodes) {
            if (completeParameters.containsKey(DecisionTableHelper.toLowerCase(identifierNode.getIdentifier()))) continue;
            methodParametersUsedInExpression.add(DecisionTableHelper.toLowerCase(identifierNode.getIdentifier()));
            originalMethodParametersUsedInExpression.put(DecisionTableHelper.toLowerCase(identifierNode.getIdentifier()), identifierNode.getIdentifier());
        }
        HashMap<String, String> methodParametersToRename = new HashMap<String, String>();
        HashSet<Integer> usedMethodParameterIndexes = new HashSet<Integer>();
        Iterator itr = methodParametersUsedInExpression.iterator();
        MatchType matchType = MatchType.STRICT;
        HashMap<String, Integer> paramToIndex = new HashMap<String, Integer>();
        HashSet<Integer> usedParamIndexesByField = new HashSet<Integer>();
        while (itr.hasNext()) {
            String param = (String)itr.next();
            boolean found = false;
            block18: for (i = 0; i < definition.getHeader().getSignature().getNumberOfParameters(); ++i) {
                if (!param.equalsIgnoreCase(definition.getHeader().getSignature().getParameterName(i))) continue;
                paramToIndex.put(param, i);
                found = true;
                IOpenClass type = definition.getHeader().getSignature().getParameterType(i);
                for (int j2 = 0; j2 < header.getSignature().getNumberOfParameters(); ++j2) {
                    if (!param.equalsIgnoreCase(header.getSignature().getParameterName(j2)) || !type.isAssignableFrom(header.getSignature().getParameterType(j2))) continue;
                    usedMethodParameterIndexes.add(j2);
                    methodParametersToRename.put(param, header.getSignature().getParameterName(j2));
                    break block18;
                }
                break;
            }
            if (found) continue;
            int numberOfCandidates = 0;
            for (int i2 = 0; i2 < definition.getHeader().getSignature().getNumberOfParameters(); ++i2) {
                IOpenClass paramType = definition.getHeader().getSignature().getParameterType(i2);
                IOpenField field = paramType.getField(param, false);
                if (field == null) continue;
                for (j = 0; j < header.getSignature().getNumberOfParameters(); ++j) {
                    if (!paramType.isAssignableFrom(header.getSignature().getParameterType(j))) continue;
                    usedParamIndexesByField.add(j);
                    methodParametersToRename.put(param, field.getName());
                    ++numberOfCandidates;
                }
            }
            if (numberOfCandidates > 1) {
                mayHaveCompilationErrors = true;
            }
            itr.remove();
        }
        for (MatchType mt : matchTypes = new MatchType[]{MatchType.STRICT_CASTED, MatchType.METHOD_ARGS_RENAMED, MatchType.METHOD_ARGS_RENAMED_CASTED}) {
            for (String param : methodParametersUsedInExpression) {
                if (methodParametersToRename.containsKey(param)) continue;
                j = (Integer)paramToIndex.get(param);
                IOpenClass type = definition.getHeader().getSignature().getParameterType(j);
                boolean duplicatedMatch = false;
                for (int i3 = 0; i3 < header.getSignature().getNumberOfParameters(); ++i3) {
                    String newParam;
                    boolean predicate;
                    IOpenCast openCast = bindingContext.getCast(header.getSignature().getParameterType(i3), type);
                    switch (mt) {
                        case METHOD_ARGS_RENAMED_CASTED: {
                            predicate = openCast != null && openCast.isImplicit();
                            break;
                        }
                        case STRICT_CASTED: {
                            predicate = openCast != null && openCast.isImplicit() && param.equalsIgnoreCase(header.getSignature().getParameterName(i3));
                            break;
                        }
                        case METHOD_ARGS_RENAMED: {
                            predicate = type.isAssignableFrom(header.getSignature().getParameterType(i3));
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                    if (usedMethodParameterIndexes.contains(i3) || !predicate) continue;
                    if (duplicatedMatch) {
                        return null;
                    }
                    duplicatedMatch = true;
                    matchType = mt;
                    usedMethodParameterIndexes.add(i3);
                    switch (mt) {
                        case METHOD_ARGS_RENAMED_CASTED: 
                        case STRICT_CASTED: {
                            String typeName = type.getInstanceClass().getSimpleName();
                            if (bindingContext.findType("org.openl.this", typeName) == null) {
                                typeName = type.getJavaName();
                            }
                            newParam = "((" + typeName + ")" + header.getSignature().getParameterName(i3) + ")";
                            break;
                        }
                        case METHOD_ARGS_RENAMED: {
                            newParam = header.getSignature().getParameterName(i3);
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                    methodParametersToRename.put(param, newParam);
                }
            }
        }
        if (usedMethodParameterIndexes.size() != methodParametersUsedInExpression.size()) {
            if (numberOfHConditions > 0) {
                return null;
            }
            HashSet<String> u = new HashSet<String>();
            for (i = 0; i < header.getSignature().getNumberOfParameters(); ++i) {
                u.add(header.getSignature().getParameterName(i));
            }
            for (i = 0; i < header.getSignature().getNumberOfParameters(); ++i) {
                String lowParamName = DecisionTableHelper.toLowerCase(header.getSignature().getParameterName(i));
                if (usedMethodParameterIndexes.contains(i) || !methodParametersUsedInExpression.contains(lowParamName)) continue;
                String newParamName = "_" + (String)originalMethodParametersUsedInExpression.get(lowParamName);
                while (u.contains(newParamName)) {
                    newParamName = "_" + newParamName;
                }
                u.add(newParamName);
                methodParametersToRename.put(lowParamName, newParamName);
            }
            mayHaveCompilationErrors = true;
        }
        String code = definition.getExpression();
        HashSet<Integer> usedParamIndexes = new HashSet<Integer>(usedMethodParameterIndexes);
        usedParamIndexes.addAll(usedParamIndexesByField);
        int[] usedMethodParameterIndexesArray = ArrayUtils.toPrimitive((Integer[])usedParamIndexes.toArray(new Integer[0]));
        switch (matchType) {
            case STRICT: {
                return new MatchedDefinition(definition, code, usedMethodParameterIndexesArray, methodParametersToRename, identifierNodes, MatchType.STRICT, mayHaveCompilationErrors);
            }
            case STRICT_CASTED: {
                return new MatchedDefinition(definition, code, usedMethodParameterIndexesArray, methodParametersToRename, identifierNodes, MatchType.STRICT_CASTED, mayHaveCompilationErrors);
            }
            case METHOD_ARGS_RENAMED: {
                return new MatchedDefinition(definition, code, usedMethodParameterIndexesArray, methodParametersToRename, identifierNodes, MatchType.METHOD_ARGS_RENAMED, mayHaveCompilationErrors);
            }
            case METHOD_ARGS_RENAMED_CASTED: {
                return new MatchedDefinition(definition, code, usedMethodParameterIndexesArray, methodParametersToRename, identifierNodes, MatchType.METHOD_ARGS_RENAMED_CASTED, mayHaveCompilationErrors);
            }
        }
        return null;
    }

    private static ParameterTokens buildParameterTokens(DecisionTable decisionTable) {
        int i;
        int numberOfParameters = decisionTable.getSignature().getNumberOfParameters();
        HashMap<Token, Integer> tokenToParameterIndex = new HashMap<Token, Integer>();
        HashMap<Token, IOpenField[]> tokenToFieldsChain = new HashMap<Token, IOpenField[]>();
        HashSet<Token> tokens = new HashSet<Token>();
        HashSet<Token> tokensToIgnore = new HashSet<Token>();
        for (i = 0; i < numberOfParameters; ++i) {
            IOpenClass parameterType = decisionTable.getSignature().getParameterType(i);
            if (!DecisionTableHelper.isCompoundInputType(parameterType) || parameterType.isArray()) continue;
            Map<Token, IOpenField[][]> openClassFuzzyTokens = OpenLFuzzyUtils.tokensMapToOpenClassReadableFieldsRecursively(parameterType, decisionTable.getSignature().getParameterName(i), 1);
            for (Map.Entry<Token, IOpenField[][]> entry : openClassFuzzyTokens.entrySet()) {
                if (entry.getValue().length != 1 || tokensToIgnore.contains(entry.getKey())) continue;
                if (!tokens.contains(entry.getKey())) {
                    tokens.add(entry.getKey());
                    tokenToParameterIndex.put(entry.getKey(), i);
                    tokenToFieldsChain.put(entry.getKey(), entry.getValue()[0]);
                    continue;
                }
                tokens.remove(entry.getKey());
                tokenToParameterIndex.remove(entry.getKey());
                tokenToFieldsChain.remove(entry.getKey());
                tokensToIgnore.add(entry.getKey());
            }
        }
        for (i = 0; i < numberOfParameters; ++i) {
            String tokenString = OpenLFuzzyUtils.toTokenString(OpenLFuzzyUtils.phoneticFix(decisionTable.getSignature().getParameterName(i)));
            Token token = new Token(tokenString, 0);
            tokenToParameterIndex.put(token, i);
            tokens.add(token);
        }
        return new ParameterTokens(tokens.toArray(new Token[0]), tokenToParameterIndex, tokenToFieldsChain);
    }

    private static void matchWithFuzzySearchRec(DecisionTable decisionTable, ILogicalTable originalTable, IGridTable gridTable, FuzzyContext fuzzyContext, NumberOfColumnsUnderTitleCounter numberOfColumnsUnderTitleCounter, int numberOfHConditions, List<DTHeader> dtHeaders, int firstColumnHeight, int w, int h, List<String> parts, int sourceTableColumn, int firstColumnForHCondition, boolean skipNextColumn, WithVerticalTitles withVerticalTitles, boolean onlyReturns) {
        String mergedPartsTitle;
        int w0 = gridTable.getCell(w, h).getWidth();
        int h0 = gridTable.getCell(w, h).getHeight();
        String d = gridTable.getCell(w, h).getStringValue();
        if (sourceTableColumn + originalTable.getSource().getCell(sourceTableColumn, 0).getWidth() == firstColumnForHCondition && h == firstColumnHeight - 1 && (WithVerticalTitles.SLASH_IN_TITLE.equals((Object)withVerticalTitles) && StringUtils.isNotBlank((CharSequence)d) && d.contains(HORIZONTAL_VERTICAL_CONDITIONS_SPLITTER) || WithVerticalTitles.MERGED_COLUMN.equals((Object)withVerticalTitles) || WithVerticalTitles.EMPTY_COLUMN.equals((Object)withVerticalTitles))) {
            if (!onlyReturns) {
                ArrayList<String> hTitles = new ArrayList<String>(parts);
                String p = d;
                if (WithVerticalTitles.SLASH_IN_TITLE.equals((Object)withVerticalTitles)) {
                    p = d.substring(d.indexOf(HORIZONTAL_VERTICAL_CONDITIONS_SPLITTER) + 1).trim();
                }
                hTitles.add(p);
                int horizontal = 0;
                for (String hTitle : hTitles) {
                    String tokenizedTitleString = OpenLFuzzyUtils.toTokenString(hTitle);
                    Token[] tokens = fuzzyContext.getParameterTokens().getTokens();
                    tokens = DecisionTableHelper.addTrueFalseTokens(fuzzyContext.getMaxDistance(), tokens);
                    List<OpenLFuzzyUtils.FuzzyResult> fuzzyResults = OpenLFuzzyUtils.fuzzyExtract(tokenizedTitleString, tokens, true);
                    DecisionTableHelper.addFuzzyDtHeader(decisionTable, fuzzyContext, w, h, hTitle, sourceTableColumn + originalTable.getSource().getCell(sourceTableColumn, 0).getWidth(), 1, 1, fuzzyResults, dtHeaders, horizontal + 1);
                    ++horizontal;
                }
            }
            if (!WithVerticalTitles.SLASH_IN_TITLE.equals((Object)withVerticalTitles)) {
                return;
            }
            String p = d.substring(0, d.indexOf(HORIZONTAL_VERTICAL_CONDITIONS_SPLITTER)).trim();
            parts.add(p);
            mergedPartsTitle = p;
        } else {
            parts.add(d);
            mergedPartsTitle = String.join((CharSequence)" | ", parts);
        }
        if (h + h0 < firstColumnHeight) {
            int w1;
            for (int w2 = w; w2 < w + w0; w2 += w1) {
                w1 = gridTable.getCell(w2, h + h0).getWidth();
                DecisionTableHelper.matchWithFuzzySearchRec(decisionTable, originalTable, gridTable, fuzzyContext, numberOfColumnsUnderTitleCounter, numberOfHConditions, dtHeaders, firstColumnHeight, w2, h + h0, parts, sourceTableColumn, firstColumnForHCondition, skipNextColumn, withVerticalTitles, onlyReturns);
            }
        } else {
            String tokenizedTitleString = OpenLFuzzyUtils.toTokenString(mergedPartsTitle);
            if (fuzzyContext.isFuzzySupportsForReturnType()) {
                List<OpenLFuzzyUtils.FuzzyResult> fuzzyResults = OpenLFuzzyUtils.fuzzyExtract(mergedPartsTitle, fuzzyContext.getFuzzyReturnTokens(), true);
                for (OpenLFuzzyUtils.FuzzyResult fuzzyResult : fuzzyResults) {
                    IOpenField[][] fieldsChains;
                    for (IOpenField[] fieldsChain : fieldsChains = fuzzyContext.getFieldsChainsForReturnToken(fuzzyResult.getToken())) {
                        Objects.requireNonNull(fieldsChain);
                        dtHeaders.add(new FuzzyDTHeader(-1, null, mergedPartsTitle, fieldsChain, sourceTableColumn, sourceTableColumn + w, h, w0, w0, fuzzyResult, true, false));
                    }
                }
            }
            if (!onlyReturns) {
                Object[] tokens = fuzzyContext.getParameterTokens().getTokens();
                if (numberOfColumnsUnderTitleCounter.get(sourceTableColumn) == 1) {
                    tokens = firstColumnForHCondition < 0 && numberOfHConditions > 0 && Arrays.stream(decisionTable.getSignature().getParameterTypes()).anyMatch(e -> e.getInstanceClass() == Boolean.class || e.getInstanceClass() == Boolean.TYPE) ? (Token[])ArrayUtils.addAll((Object[])tokens, (Object[])new Token[]{new PredicateToken("is true", fuzzyContext.getMaxDistance() + 1, 2, true), new PredicateToken("is false", fuzzyContext.getMaxDistance() + 1, 2, false)}) : DecisionTableHelper.addTrueFalseTokens(fuzzyContext.getMaxDistance(), (Token[])tokens);
                    if (sourceTableColumn == 0) {
                        tokens = (Token[])ArrayUtils.addAll((Object[])tokens, (Object[])new Token[]{new RuleToken("rule", fuzzyContext.getMaxDistance() + 1, 1)});
                    }
                }
                List<OpenLFuzzyUtils.FuzzyResult> fuzzyResults = OpenLFuzzyUtils.fuzzyExtract(tokenizedTitleString, (Token[])tokens, true);
                DecisionTableHelper.addFuzzyDtHeader(decisionTable, fuzzyContext, w, h, mergedPartsTitle, sourceTableColumn, skipNextColumn ? w0 + originalTable.getSource().getCell(sourceTableColumn + w0, h).getWidth() : w0, w0, fuzzyResults, dtHeaders, 0);
            }
        }
        parts.remove(parts.size() - 1);
    }

    private static Token[] addTrueFalseTokens(int maxDistance, Token[] tokens) {
        return (Token[])ArrayUtils.addAll((Object[])tokens, (Object[])new Token[]{new PredicateToken("is true", maxDistance + 1, 2, true), new PredicateToken("is false", maxDistance + 1, 2, false), new PredicateToken("true", maxDistance + 1, 1, true), new PredicateToken("false", maxDistance + 1, 1, false)});
    }

    private static void addFuzzyDtHeader(DecisionTable decisionTable, FuzzyContext fuzzyContext, int w, int h, String title, int sourceTableColumn, int w0, int widthForMerge, List<OpenLFuzzyUtils.FuzzyResult> fuzzyResults, List<DTHeader> dtHeaders, int horizontal) {
        for (OpenLFuzzyUtils.FuzzyResult fuzzyResult : fuzzyResults) {
            Integer paramIndex = fuzzyContext.getParameterTokens().getParameterIndex(fuzzyResult.getToken());
            if (paramIndex != null) {
                IOpenField[] fieldsChain = fuzzyContext.getParameterTokens().getFieldsChain(fuzzyResult.getToken());
                StringBuilder conditionStatement = new StringBuilder(decisionTable.getSignature().getParameterName(paramIndex.intValue()));
                if (fieldsChain != null) {
                    Pair<String, IOpenClass> c = DecisionTableHelper.buildStatementByFieldsChain(decisionTable.getSignature().getParameterType(paramIndex.intValue()), fieldsChain);
                    String chainStatement = (String)c.getLeft();
                    conditionStatement.append(".");
                    conditionStatement.append(chainStatement);
                }
                dtHeaders.add(new FuzzyDTHeader(paramIndex, conditionStatement.toString(), title, fieldsChain, sourceTableColumn, horizontal > 0 ? sourceTableColumn + horizontal - 1 : sourceTableColumn + w, h, horizontal > 0 ? 1 : w0, horizontal > 0 ? 1 : widthForMerge, fuzzyResult, false, horizontal > 0));
                continue;
            }
            if (fuzzyResult.getToken() instanceof PredicateToken) {
                PredicateToken predicateToken = (PredicateToken)fuzzyResult.getToken();
                dtHeaders.add(new FuzzyDTHeader(predicateToken.isTrue() ? "true" : "false", title, new IOpenField[]{}, sourceTableColumn, horizontal > 0 ? sourceTableColumn + horizontal - 1 : sourceTableColumn, h, horizontal > 0 ? 1 : w0, horizontal > 0 ? 1 : widthForMerge, fuzzyResult, false, horizontal > 0));
            }
            if (sourceTableColumn != 0 || !(fuzzyResult.getToken() instanceof RuleToken)) continue;
            dtHeaders.add(new FuzzyRulesDTHeader(title, sourceTableColumn, h, w0, fuzzyResult));
        }
    }

    private static List<DTHeader> matchWithFuzzySearch(DecisionTable decisionTable, ILogicalTable originalTable, FuzzyContext fuzzyContext, NumberOfColumnsUnderTitleCounter numberOfColumnsUnderTitleCounter, int numberOfHConditions, int column, int lastColumn, List<DTHeader> dtHeaders, int firstColumnHeight, int firstColumnForHCondition, WithVerticalTitles withVerticalTitles, boolean onlyReturns) {
        if (onlyReturns && !fuzzyContext.isFuzzySupportsForReturnType()) {
            return Collections.emptyList();
        }
        if (numberOfHConditions > 0 && column >= lastColumn) {
            return Collections.emptyList();
        }
        int w = originalTable.getSource().getCell(column, 0).getWidth();
        IGridTable gt = (IGridTable)originalTable.getSource().getSubtable(column, 0, w, firstColumnHeight);
        ArrayList<DTHeader> newDtHeaders = new ArrayList<DTHeader>();
        int w0 = column + originalTable.getSource().getCell(column, 0).getWidth();
        boolean skipNextColumn = w0 + originalTable.getSource().getCell(w0, 0).getWidth() == firstColumnForHCondition && (WithVerticalTitles.EMPTY_COLUMN.equals((Object)withVerticalTitles) || WithVerticalTitles.MERGED_COLUMN.equals((Object)withVerticalTitles));
        DecisionTableHelper.matchWithFuzzySearchRec(decisionTable, originalTable, gt, fuzzyContext, numberOfColumnsUnderTitleCounter, numberOfHConditions, newDtHeaders, firstColumnHeight, 0, 0, new ArrayList<String>(), column, firstColumnForHCondition, skipNextColumn, withVerticalTitles, onlyReturns);
        dtHeaders.addAll(newDtHeaders);
        return Collections.unmodifiableList(newDtHeaders);
    }

    private static boolean isCompatibleHeaders(DTHeader a, DTHeader b) {
        DTHeader b1;
        DTHeader a1;
        int c1 = a.getColumn();
        int c2 = a.getColumn() + a.getWidth() - 1;
        int d1 = b.getColumn();
        int d2 = b.getColumn() + b.getWidth() - 1;
        if (c1 <= d1 && d1 <= c2 || c1 <= d2 && d2 <= c2 || d1 <= c2 && c2 <= d2 || d1 <= c1 && c1 <= d2) {
            return false;
        }
        if ((a.isRule() && b.isCondition() || a.isCondition() && b.isAction() || a.isAction() && b.isReturn() || a.isCondition() && b.isReturn()) && c1 >= d1) {
            return false;
        }
        if ((b.isRule() && a.isCondition() || b.isCondition() && a.isAction() || b.isAction() && a.isReturn() || b.isCondition() && a.isReturn()) && d1 >= c1) {
            return false;
        }
        if (a instanceof FuzzyDTHeader && b instanceof FuzzyDTHeader) {
            a1 = (FuzzyDTHeader)a;
            b1 = (FuzzyDTHeader)b;
            if (((FuzzyDTHeader)a1).isMethodParameterUsed() && ((FuzzyDTHeader)b1).isMethodParameterUsed() && ((FuzzyDTHeader)a1).isCondition() && ((FuzzyDTHeader)b1).isCondition() && ((FuzzyDTHeader)a1).getMethodParameterIndex() == ((FuzzyDTHeader)b1).getMethodParameterIndex() && Arrays.deepEquals(((FuzzyDTHeader)a1).getFieldsChain(), ((FuzzyDTHeader)b1).getFieldsChain())) {
                return false;
            }
            if (((FuzzyDTHeader)a1).isReturn() && ((FuzzyDTHeader)b1).isReturn() && DecisionTableHelper.fieldsChainsIsCrossed(((FuzzyDTHeader)a1).getFieldsChain(), ((FuzzyDTHeader)b1).getFieldsChain())) {
                return false;
            }
            if (!(a1.isHCondition() && b1.isHCondition() || ((FuzzyDTHeader)a1).isCondition() && ((FuzzyDTHeader)b1).isCondition() || ((FuzzyDTHeader)a1).isAction() && ((FuzzyDTHeader)b1).isAction() || ((FuzzyDTHeader)a1).isReturn() && ((FuzzyDTHeader)b1).isReturn() || ((FuzzyDTHeader)a1).getTopColumn() != ((FuzzyDTHeader)b1).getTopColumn())) {
                return false;
            }
        }
        if (a instanceof DeclaredDTHeader && b instanceof DeclaredDTHeader) {
            a1 = (DeclaredDTHeader)a;
            b1 = (DeclaredDTHeader)b;
            return !((DeclaredDTHeader)a1).getMatchedDefinition().getDtColumnsDefinition().equals(((DeclaredDTHeader)b1).getMatchedDefinition().getDtColumnsDefinition());
        }
        return true;
    }

    private static boolean bruteForceHeaders(ILogicalTable originalTable, int column, int lastColumn, int firstColumnHeight, List<DTHeader> dtHeaders, boolean[][] matrix, Map<Integer, List<Integer>> columnToIndex, int maxColumnIndex, List<Integer> usedIndexes, List<DTHeader> used, Set<Integer> usedParameterIndexes, List<List<DTHeader>> fits, Set<Integer> failedToFit, int numberOfParameters, int numberOfHConditions, int numberOfReturns, int fuzzyReturnsFlag, int counter) {
        ICell cell;
        boolean lastColumnReached;
        if (fits.size() > 10000) {
            return column >= maxColumnIndex;
        }
        List<Integer> indexes = columnToIndex.get(column);
        if (indexes == null || numberOfHConditions == 1 && (long)usedParameterIndexes.size() >= (long)(numberOfParameters - numberOfHConditions) + used.stream().filter(DTHeader::isHCondition).count()) {
            ArrayList<DTHeader> fit = new ArrayList<DTHeader>(used);
            while (!fit.isEmpty() && fit.get(fit.size() - 1) instanceof UnmatchedDtHeader) {
                fit.remove(fit.size() - 1);
            }
            if (!fit.isEmpty()) {
                fits.add(Collections.unmodifiableList(fit));
            }
        }
        boolean bl = lastColumnReached = column >= maxColumnIndex;
        if (indexes != null) {
            boolean last = true;
            for (Integer index : indexes) {
                int fuzzyReturnsFlag1;
                FuzzyDTHeader fuzzyDTHeader;
                boolean f = true;
                for (Integer usedIndex : usedIndexes) {
                    if (matrix[index][usedIndex]) continue;
                    f = false;
                    break;
                }
                if (!f) continue;
                DTHeader dtHeader = dtHeaders.get(index);
                boolean isFuzzyReturn = false;
                if (dtHeader instanceof FuzzyDTHeader && (fuzzyDTHeader = (FuzzyDTHeader)dtHeader).isReturn()) {
                    isFuzzyReturn = true;
                }
                if (isFuzzyReturn && fuzzyReturnsFlag == 2) continue;
                HashSet<Integer> usedParameterIndexesTo = new HashSet<Integer>(usedParameterIndexes);
                for (int i : dtHeader.getMethodParameterIndexes()) {
                    usedParameterIndexesTo.add(i);
                }
                int numberOfReturns1 = dtHeader.isReturn() && !isFuzzyReturn ? numberOfReturns + 1 : numberOfReturns;
                if (numberOfReturns1 + ((fuzzyReturnsFlag1 = isFuzzyReturn && fuzzyReturnsFlag != 1 ? fuzzyReturnsFlag + 1 : fuzzyReturnsFlag) > 1 ? 1 : 0) > 3) continue;
                last = false;
                usedIndexes.add(index);
                used.add(dtHeaders.get(index));
                lastColumnReached |= DecisionTableHelper.bruteForceHeaders(originalTable, column + dtHeader.getWidth(), lastColumn, firstColumnHeight, dtHeaders, matrix, columnToIndex, maxColumnIndex, usedIndexes, used, usedParameterIndexesTo, fits, failedToFit, numberOfParameters, numberOfHConditions, numberOfReturns1, fuzzyReturnsFlag1, counter + 1);
                usedIndexes.remove(usedIndexes.size() - 1);
                used.remove(used.size() - 1);
            }
            if (!indexes.isEmpty() && last) {
                failedToFit.addAll(indexes);
            }
        }
        if (!lastColumnReached && numberOfReturns + (fuzzyReturnsFlag > 1 ? 1 : 0) == 0 && column + (cell = originalTable.getSource().getCell(column, firstColumnHeight - 1)).getWidth() <= maxColumnIndex) {
            boolean isHorizontal = column + cell.getWidth() >= lastColumn;
            used.add(new UnmatchedDtHeader("", column, firstColumnHeight - 1, cell.getWidth(), isHorizontal));
            lastColumnReached = DecisionTableHelper.bruteForceHeaders(originalTable, column + cell.getWidth(), lastColumn, firstColumnHeight, dtHeaders, matrix, columnToIndex, maxColumnIndex, usedIndexes, used, usedParameterIndexes, fits, failedToFit, numberOfParameters, numberOfHConditions, numberOfReturns, fuzzyReturnsFlag, counter + 1);
            used.remove(used.size() - 1);
        }
        return lastColumnReached;
    }

    private static List<List<DTHeader>> filterHeadersByMax(List<List<DTHeader>> fits, ToLongFunction<List<DTHeader>> function, Predicate<List<DTHeader>> predicate) {
        long max = Long.MIN_VALUE;
        HashSet<Integer> functionIndexes = new HashSet<Integer>();
        HashSet<Integer> matchIndexes = new HashSet<Integer>();
        int index = 0;
        for (List<DTHeader> fit : fits) {
            if (predicate.test(fit)) {
                long current = function.applyAsLong(fit);
                if (current > max) {
                    max = current;
                    functionIndexes.clear();
                    functionIndexes.add(index);
                } else if (current == max) {
                    functionIndexes.add(index);
                }
            } else {
                matchIndexes.add(index);
            }
            ++index;
        }
        HashSet<Integer> indexes = new HashSet<Integer>(matchIndexes);
        indexes.addAll(functionIndexes);
        ArrayList<List<DTHeader>> newFits = new ArrayList<List<DTHeader>>();
        for (Integer i : indexes) {
            newFits.add(fits.get(i));
        }
        return newFits;
    }

    private static List<List<DTHeader>> filterHeadersByMin(List<List<DTHeader>> fits, ToLongFunction<List<DTHeader>> function, Predicate<List<DTHeader>> predicate) {
        long min = Long.MAX_VALUE;
        HashSet<Integer> functionIndexes = new HashSet<Integer>();
        HashSet<Integer> matchIndexes = new HashSet<Integer>();
        int index = 0;
        for (List<DTHeader> fit : fits) {
            if (predicate.test(fit)) {
                long current = function.applyAsLong(fit);
                if (current < min) {
                    min = current;
                    functionIndexes.clear();
                    functionIndexes.add(index);
                } else if (current == min) {
                    functionIndexes.add(index);
                }
            } else {
                matchIndexes.add(index);
            }
            ++index;
        }
        HashSet<Integer> indexes = new HashSet<Integer>(matchIndexes);
        indexes.addAll(functionIndexes);
        ArrayList<List<DTHeader>> newFits = new ArrayList<List<DTHeader>>();
        for (Integer i : indexes) {
            newFits.add(fits.get(i));
        }
        return newFits;
    }

    private static List<List<DTHeader>> filterHeadersByMatchType(DecisionTable decisionTable, List<List<DTHeader>> fits) {
        DecisionTableHelper.resolveConflictsInDeclaredDtHeaders(decisionTable, fits);
        MatchType[] matchTypes = MatchType.values();
        Arrays.sort(matchTypes, Comparator.comparingInt(MatchType::getPriority));
        for (MatchType type : matchTypes) {
            fits = DecisionTableHelper.filterHeadersByMax(fits, e -> e.stream().filter(x -> x instanceof DeclaredDTHeader).map(x -> (DeclaredDTHeader)x).filter(x -> type.equals((Object)x.getMatchedDefinition().getMatchType())).mapToLong(x -> x.getMatchedDefinition().getDtColumnsDefinition().getNumberOfTitles()).sum(), e -> true);
        }
        return fits;
    }

    private static boolean isLastDtColumnValid(DTHeader dtHeader, int maxColumn, int columnsForReturn) {
        if (dtHeader.isReturn()) {
            return dtHeader.getColumn() + dtHeader.getWidth() == maxColumn;
        }
        if (!dtHeader.isHCondition() && dtHeader.isCondition() || dtHeader.isAction()) {
            return dtHeader.getColumn() + dtHeader.getWidth() < maxColumn - columnsForReturn;
        }
        return true;
    }

    private static List<List<DTHeader>> filterWithWrongStructure(ILogicalTable originalTable, List<List<DTHeader>> fits, boolean twoColumnsInReturn) {
        int maxColumn = originalTable.getSource().getWidth();
        int w = 0;
        if (maxColumn > 0 && twoColumnsInReturn && maxColumn - (w = originalTable.getSource().getCell(maxColumn - 1, 0).getWidth()) > 0) {
            w += originalTable.getSource().getCell(maxColumn - 1 - w, 0).getWidth();
        }
        int w1 = w;
        return fits.stream().filter(e -> e.isEmpty() || DecisionTableHelper.isLastDtColumnValid((DTHeader)e.get(e.size() - 1), maxColumn, twoColumnsInReturn ? w1 : 0)).collect(Collectors.toList());
    }

    private static boolean fieldsChainsIsCrossed(IOpenField[] m1, IOpenField[] m2) {
        if (m1 == null && m2 == null) {
            return true;
        }
        if (m1 != null && m2 != null) {
            int i;
            for (i = 0; i < m1.length && i < m2.length && m1[i].equals(m2[i]); ++i) {
            }
            if (i == m1.length || i == m2.length) {
                return true;
            }
        }
        return false;
    }

    private static boolean isAmbiguousFits(List<List<DTHeader>> fits, Predicate<DTHeader> predicate) {
        if (fits.size() <= 1) {
            return false;
        }
        Object[] dtHeaders0 = (DTHeader[])fits.get(0).stream().filter(predicate).toArray(DTHeader[]::new);
        for (int i = 1; i < fits.size(); ++i) {
            Object[] dtHeaders1 = (DTHeader[])fits.get(i).stream().filter(predicate).toArray(DTHeader[]::new);
            if (Arrays.equals(dtHeaders0, dtHeaders1)) continue;
            return true;
        }
        return false;
    }

    private static boolean intersects(int b1, int e1, int b2, int e2) {
        return b2 <= b1 && b1 <= e2 || b2 <= e1 && e1 <= e2 || b1 <= b2 && b2 <= e1 || b1 <= e2 && e2 <= e1;
    }

    private static List<DTHeader> findStrongDtHeaders(ILogicalTable originalTable, List<DTHeader> dtHeaders) {
        boolean[] f = new boolean[dtHeaders.size()];
        Arrays.fill(f, false);
        for (int i = 0; i < dtHeaders.size() - 1; ++i) {
            for (int j = i + 1; j < dtHeaders.size(); ++j) {
                if (!(dtHeaders.get(i) instanceof DeclaredDTHeader) || !(dtHeaders.get(j) instanceof DeclaredDTHeader)) continue;
                DeclaredDTHeader d1 = (DeclaredDTHeader)dtHeaders.get(i);
                DeclaredDTHeader d2 = (DeclaredDTHeader)dtHeaders.get(j);
                if (d1.isHCondition() || d2.isHCondition() || d1.getColumn() == d2.getColumn() && d1.getWidth() == d2.getWidth() || !DecisionTableHelper.intersects(d1.getColumn(), d1.getColumn() + d1.getWidth() - 1, d2.getColumn(), d2.getColumn() + d2.getWidth() - 1)) continue;
                f[i] = true;
                f[j] = true;
            }
        }
        int lastColumn = originalTable.getSource().getWidth();
        ArrayList<DTHeader> ret = new ArrayList<DTHeader>();
        for (int i = 0; i < dtHeaders.size(); ++i) {
            DTHeader dtHeader = dtHeaders.get(i);
            if (!dtHeader.isHCondition() && (dtHeader.isCondition() || dtHeader.isAction()) && dtHeader.getColumn() + dtHeader.getWidth() >= lastColumn || !dtHeader.isHCondition() && f[i]) continue;
            ret.add(dtHeader);
        }
        return ret;
    }

    private static List<List<DTHeader>> fitFuzzyDtHeaders(List<List<DTHeader>> fits) {
        fits = DecisionTableHelper.filterHeadersByMax(fits, e -> e.stream().filter(x -> x instanceof FuzzyDTHeader).map(x -> (FuzzyDTHeader)x).mapToInt(x -> x.getFuzzyResult().getFoundTokensCount()).sum(), e -> true);
        fits = DecisionTableHelper.filterHeadersByMin(fits, e -> e.stream().filter(x -> x instanceof FuzzyDTHeader).map(x -> (FuzzyDTHeader)x).mapToInt(x -> x.getFuzzyResult().getMissedTokensCount()).sum(), e -> true);
        fits = DecisionTableHelper.filterHeadersByMin(fits, e -> e.stream().filter(x -> x instanceof FuzzyDTHeader).map(x -> (FuzzyDTHeader)x).mapToInt(x -> x.getFuzzyResult().getToken().getDistance()).sum(), e -> true);
        fits = DecisionTableHelper.filterHeadersByMin(fits, e -> e.stream().filter(x -> x instanceof FuzzyDTHeader).map(x -> (FuzzyDTHeader)x).mapToInt(x -> x.getFuzzyResult().getUnmatchedTokensCount()).sum(), e -> true);
        return fits;
    }

    private static boolean isTheSameFit(List<DTHeader> a, List<DTHeader> b) {
        if (a.size() == b.size()) {
            for (int i = 0; i < a.size(); ++i) {
                if (Objects.equals(a.get(i), b.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static List<List<DTHeader>> removeDuplicates(List<List<DTHeader>> fits) {
        ArrayList<List<DTHeader>> ret = new ArrayList<List<DTHeader>>();
        for (List<DTHeader> fit : fits) {
            boolean f = false;
            for (List list : ret) {
                if (!DecisionTableHelper.isTheSameFit(fit, list)) continue;
                f = true;
                break;
            }
            if (f) continue;
            ret.add(fit);
        }
        return ret;
    }

    private static List<DTHeader> fitDtHeaders(TableSyntaxNode tableSyntaxNode, DecisionTable decisionTable, ILogicalTable originalTable, List<DTHeader> dtHeaders, int lastColumn, int numberOfHConditions, boolean twoColumnsForReturn, int firstColumnHeight, IBindingContext bindingContext) throws OpenLCompilationException {
        int numberOfParameters = decisionTable.getSignature().getNumberOfParameters();
        boolean[][] matrix = new boolean[dtHeaders.size()][dtHeaders.size()];
        for (int i = 0; i < dtHeaders.size(); ++i) {
            for (int j = 0; j < dtHeaders.size(); ++j) {
                matrix[i][j] = true;
            }
        }
        HashMap<Integer, List<Integer>> columnToIndex = new HashMap<Integer, List<Integer>>();
        for (int i = 0; i < dtHeaders.size(); ++i) {
            List indexes = columnToIndex.computeIfAbsent(dtHeaders.get(i).getColumn(), ArrayList::new);
            indexes.add(i);
            for (int j = i; j < dtHeaders.size(); ++j) {
                if (i != j && DecisionTableHelper.isCompatibleHeaders(dtHeaders.get(i), dtHeaders.get(j))) continue;
                matrix[i][j] = false;
                matrix[j][i] = false;
            }
        }
        List<List<DTHeader>> fits = new ArrayList<List<DTHeader>>();
        HashSet<Integer> failedToFit = new HashSet<Integer>();
        DecisionTableHelper.bruteForceHeaders(originalTable, 0, lastColumn, firstColumnHeight, dtHeaders, matrix, columnToIndex, numberOfHConditions > 0 ? lastColumn + numberOfHConditions : originalTable.getSource().getWidth(), new ArrayList<Integer>(), new ArrayList<DTHeader>(), new HashSet<Integer>(), fits, failedToFit, numberOfParameters, numberOfHConditions, 0, 0, 0);
        if (fits.size() > 10000) {
            bindingContext.addMessage(OpenLMessagesUtils.newWarnMessage((String)"Ambiguous matching of column titles to DT conditions. Too many options are found.", (ISyntaxNode)tableSyntaxNode));
        }
        Predicate<List<DTHeader>> all = e -> true;
        fits = DecisionTableHelper.filterHeadersByMax(fits, e -> e.stream().map(DTHeader::getMethodParameterIndexes).filter(Objects::nonNull).flatMapToInt(Arrays::stream).distinct().count() <= (long)(numberOfParameters - numberOfHConditions) + e.stream().filter(DTHeader::isHCondition).count() ? 1L : 0L, all);
        fits = DecisionTableHelper.filterWithWrongStructure(originalTable, fits, twoColumnsForReturn);
        fits = DecisionTableHelper.filterHeadersByMax(fits, e -> e.stream().filter(x -> x instanceof DeclaredDTHeader).mapToLong(x -> ((DeclaredDTHeader)x).getMatchedDefinition().getDtColumnsDefinition().getNumberOfTitles()).sum(), all);
        fits = DecisionTableHelper.filterBasedOnDeclaredDtHeaders(fits);
        fits = numberOfHConditions == 0 ? fits.stream().filter(e -> e.stream().anyMatch(DTHeader::isReturn)).collect(Collectors.toList()) : fits.stream().filter(e -> e.stream().noneMatch(DTHeader::isReturn)).collect(Collectors.toList());
        fits = DecisionTableHelper.filterHeadersByMin(fits, DecisionTableHelper::countReturns, all);
        fits = DecisionTableHelper.filterHeadersByMin(fits, e -> e.stream().filter(e1 -> e1 instanceof UnmatchedDtHeader && !e1.isHCondition()).count(), all);
        fits = DecisionTableHelper.filterHeadersByMin(fits, e -> e.stream().filter(x -> x instanceof DeclaredDTHeader).map(x -> (DeclaredDTHeader)x).mapToLong(x -> x.getMatchedDefinition().isMayHaveCompilationErrors() ? 1L : 0L).sum(), e -> e.stream().anyMatch(x -> x instanceof DeclaredDTHeader));
        fits = DecisionTableHelper.filterHeadersByMatchType(decisionTable, fits);
        fits = DecisionTableHelper.filterHeadersByMax(fits, e -> e.stream().flatMapToInt(c -> Arrays.stream(c.getMethodParameterIndexes())).distinct().count(), e -> e.stream().anyMatch(x -> x.isCondition() && x instanceof DeclaredDTHeader));
        fits = DecisionTableHelper.filterHeadersByMin(fits, e -> e.stream().filter(x -> x instanceof SimpleReturnDTHeader).count(), e -> e.stream().anyMatch(DTHeader::isReturn));
        fits = DecisionTableHelper.fitFuzzyDtHeaders(fits);
        fits = DecisionTableHelper.removeDuplicates(fits);
        if (numberOfHConditions == 0 && fits.isEmpty()) {
            List<DTHeader> dths = dtHeaders;
            OptionalInt c = failedToFit.stream().mapToInt(e -> ((DTHeader)dths.get((int)e)).getColumn()).max();
            StringBuilder message = new StringBuilder();
            message.append("Failed to compile a decision table.");
            if (c.isPresent()) {
                int c0 = c.getAsInt();
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < firstColumnHeight; ++i) {
                    if (i > 0) {
                        sb.append(" ");
                        sb.append("|");
                        sb.append(" ");
                    }
                    sb.append(originalTable.getSource().getCell(c0, i).getStringValue());
                }
                message.append(" ");
                message.append("There is no match for column '").append((CharSequence)sb).append("'.");
            }
            throw new DTUnmatchedCompilationException(message.toString());
        }
        if (!fits.isEmpty()) {
            if (fits.size() > 1) {
                int mCount = 0;
                OpenLMessage warnMessage = null;
                if (DecisionTableHelper.isAmbiguousFits(fits, DTHeader::isCondition)) {
                    warnMessage = OpenLMessagesUtils.newWarnMessage((String)"Ambiguous matching of column titles to DT conditions. Use more appropriate titles for condition columns.", (ISyntaxNode)tableSyntaxNode);
                    ++mCount;
                }
                if (DecisionTableHelper.isAmbiguousFits(fits, DTHeader::isAction)) {
                    warnMessage = OpenLMessagesUtils.newWarnMessage((String)"Ambiguous matching of column titles to DT action columns. Use more appropriate titles for action columns.", (ISyntaxNode)tableSyntaxNode);
                    ++mCount;
                }
                if (DecisionTableHelper.isAmbiguousFits(fits, DTHeader::isReturn)) {
                    warnMessage = OpenLMessagesUtils.newWarnMessage((String)"Ambiguous matching of column titles to DT return columns. Use more appropriate titles for return columns.", (ISyntaxNode)tableSyntaxNode);
                    ++mCount;
                }
                if (mCount == 1) {
                    bindingContext.addMessage(warnMessage);
                } else if (mCount > 0) {
                    bindingContext.addMessage(OpenLMessagesUtils.newWarnMessage((String)"Ambiguous matching of column titles to DT columns. Use more appropriate titles.", (ISyntaxNode)tableSyntaxNode));
                }
            }
            fits = DecisionTableHelper.filterHeadersByMin(fits, e -> e.stream().filter(DTHeader::isReturn).count(), all);
            fits = DecisionTableHelper.filterHeadersByMin(fits, e -> e.stream().filter(DTHeader::isAction).count(), all);
            if ((fits = DecisionTableHelper.filterHeadersByMin(fits, e -> e.stream().filter(DTHeader::isCondition).count(), all)).stream().anyMatch(e -> e instanceof FuzzyDTHeader)) {
                fits = DecisionTableHelper.filterHeadersByMax(fits, e -> e.stream().filter(e1 -> e1 instanceof FuzzyDTHeader).mapToLong(e1 -> (long)((FuzzyDTHeader)e1).getFuzzyResult().getAcceptableSimilarity() * 1000000L).sum() / e.stream().filter(e1 -> e1 instanceof FuzzyDTHeader).count(), all);
            }
            return fits.get(0);
        }
        return Collections.emptyList();
    }

    private static long countReturns(List<DTHeader> dtHeaders) {
        int countReturns = 0;
        boolean fuzzyReturn = false;
        for (DTHeader dtHeader : dtHeaders) {
            if (!dtHeader.isReturn()) continue;
            if (dtHeader instanceof FuzzyDTHeader && ((FuzzyDTHeader)dtHeader).getFieldsChain() != null) {
                if (!fuzzyReturn) {
                    ++countReturns;
                }
                fuzzyReturn = true;
                continue;
            }
            fuzzyReturn = false;
            ++countReturns;
        }
        return countReturns;
    }

    private static List<List<DTHeader>> filterBasedOnDeclaredDtHeaders(List<List<DTHeader>> fits) {
        ArrayList<List<DTHeader>> ret = new ArrayList<List<DTHeader>>();
        for (List<DTHeader> fit : fits) {
            HashSet externalParameters = new HashSet();
            HashMap<String, Integer> parameters = new HashMap<String, Integer>();
            for (DTHeader dtHeader : fit) {
                if (!(dtHeader instanceof DeclaredDTHeader)) continue;
                DeclaredDTHeader declaredDTHeader = (DeclaredDTHeader)dtHeader;
                externalParameters.addAll(declaredDTHeader.getMatchedDefinition().getDtColumnsDefinition().getExternalParameters().stream().map(DecisionTableHelper::toLowerCase).collect(Collectors.toSet()));
                for (IParameterDeclaration parameter : declaredDTHeader.getMatchedDefinition().getDtColumnsDefinition().getParameters()) {
                    if (parameter == null || parameter.getName() == null) continue;
                    parameters.merge(DecisionTableHelper.toLowerCase(parameter.getName()), 1, Integer::sum);
                }
            }
            boolean f = true;
            for (String externalParameter : externalParameters) {
                if (parameters.containsKey(DecisionTableHelper.toLowerCase(externalParameter))) continue;
                f = false;
                break;
            }
            if (!f) continue;
            ret.add(fit);
        }
        return ret.isEmpty() ? fits : ret;
    }

    public static Pair<Integer, WithVerticalTitles> getFirstColumnForHCondition(ILogicalTable originalTable, int numberOfHConditions, int firstColumnHeight, boolean isSmartLookup) {
        int w = originalTable.getSource().getWidth();
        int ret = -1;
        for (int column = 0; column < w; column += originalTable.getSource().getCell(column, 0).getWidth()) {
            int rowsCount = DecisionTableHelper.calculateRowsCount(originalTable, column, firstColumnHeight);
            if (rowsCount != numberOfHConditions) {
                ret = -1;
            }
            if (rowsCount <= 1 || rowsCount != numberOfHConditions || ret >= 0) continue;
            ret = column;
        }
        if (isSmartLookup && ret < w - 1) {
            int begin = Math.max(ret, 0);
            int end = begin > 0 ? begin + 1 : originalTable.getSource().getWidth();
            for (int i = begin; i < end; i += originalTable.getSource().getCell(i, 0).getWidth()) {
                int w3;
                int w2;
                int w1;
                String value = originalTable.getSource().getCell(i, firstColumnHeight - 1).getStringValue();
                if (!StringUtils.isNotBlank((CharSequence)value) || !value.contains(HORIZONTAL_VERTICAL_CONDITIONS_SPLITTER)) continue;
                String part1 = value.substring(0, value.indexOf(HORIZONTAL_VERTICAL_CONDITIONS_SPLITTER));
                String part2 = value.substring(value.indexOf(HORIZONTAL_VERTICAL_CONDITIONS_SPLITTER) + 1);
                if (StringUtils.isNotBlank((CharSequence)part1) && StringUtils.isNotBlank((CharSequence)part2)) {
                    return Pair.of((Object)(i + originalTable.getSource().getCell(i, 0).getWidth()), (Object)((Object)WithVerticalTitles.SLASH_IN_TITLE));
                }
                if (StringUtils.isBlank((CharSequence)part1) && StringUtils.isNotBlank((CharSequence)part2)) {
                    return Pair.of((Object)(i + originalTable.getSource().getCell(i, 0).getWidth()), (Object)((Object)WithVerticalTitles.EMPTY_COLUMN));
                }
                if (i <= 0 || !StringUtils.isBlank((CharSequence)part1) || !StringUtils.isNotBlank((CharSequence)part2) || (w1 = originalTable.getSource().getCell(i - 1, firstColumnHeight).getWidth()) != (w2 = originalTable.getSource().getCell(i - 1, firstColumnHeight - 1).getWidth()) + (w3 = originalTable.getSource().getCell(i, firstColumnHeight - 1).getWidth())) continue;
                return Pair.of((Object)(i + originalTable.getSource().getCell(i, 0).getWidth()), (Object)((Object)WithVerticalTitles.MERGED_COLUMN));
            }
        }
        return Pair.of((Object)ret, (Object)((Object)WithVerticalTitles.NO));
    }

    private static boolean columnWithFormulas(ILogicalTable originalTable, int firstColumnHeight, int column) {
        ICell cell;
        int height = originalTable.getSource().getHeight();
        int c = 0;
        int t = 0;
        for (int h = firstColumnHeight; h < height; h += cell.getHeight()) {
            cell = originalTable.getSource().getCell(column, h);
            String s = cell.getStringValue();
            if (!StringUtils.isEmpty((CharSequence)(s != null ? s.trim() : null)) && !RuleRowHelper.isFormula(s)) {
                ++c;
            }
            ++t;
        }
        return c <= t / 2 + t % 2;
    }

    private static boolean conflictsWithStrongDtHeader(List<DTHeader> strongDtHeaders, WithVerticalTitles withVerticalTitles, int firstColumnForHCondition, int column, int width) {
        if (!WithVerticalTitles.NO.equals((Object)withVerticalTitles) && column + width == firstColumnForHCondition) {
            return false;
        }
        for (DTHeader dtHeader : strongDtHeaders) {
            if (!DecisionTableHelper.intersects(dtHeader.getColumn(), dtHeader.getColumn() + dtHeader.getWidth() - 1, column, column + width - 1)) continue;
            return true;
        }
        return false;
    }

    private static List<DTHeader> getDTHeaders(TableSyntaxNode tableSyntaxNode, DecisionTable decisionTable, ILogicalTable originalTable, FuzzyContext fuzzyContext, NumberOfColumnsUnderTitleCounter numberOfColumnsUnderTitleCounter, int numberOfHConditions, int firstColumnHeight, int firstColumnForHCondition, WithVerticalTitles withVerticalTitles, IBindingContext bindingContext) throws OpenLCompilationException {
        boolean isSmart = DecisionTableHelper.isSmart(tableSyntaxNode);
        int numberOfParameters = decisionTable.getSignature().getNumberOfParameters();
        boolean twoColumnsForReturn = DecisionTableHelper.isTwoColumnsForReturn(tableSyntaxNode, decisionTable);
        XlsDefinitions xlsDefinitions = ((XlsModuleOpenClass)decisionTable.getDeclaringClass()).getXlsDefinitions();
        int lastColumn = originalTable.getSource().getWidth();
        if (numberOfHConditions > 0 && firstColumnForHCondition > 0) {
            lastColumn = firstColumnForHCondition;
        }
        String returnTokenString = fuzzyContext != null && fuzzyContext.isFuzzySupportsForReturnType() ? OpenLFuzzyUtils.toTokenString(fuzzyContext.getFuzzyReturnType().getName()) : null;
        ArrayList<DTHeader> dtHeaders = new ArrayList<DTHeader>();
        int i = 0;
        int column = 0;
        if (isSmart) {
            while (column < lastColumn) {
                int w = originalTable.getSource().getCell(column, 0).getWidth();
                DecisionTableHelper.matchWithDtColumnsDefinitions(decisionTable, originalTable, column, xlsDefinitions, numberOfColumnsUnderTitleCounter, dtHeaders, firstColumnForHCondition, withVerticalTitles, firstColumnHeight, numberOfHConditions, bindingContext);
                column += w;
                ++i;
            }
        }
        List<DTHeader> strongDtHeaders = DecisionTableHelper.findStrongDtHeaders(originalTable, dtHeaders);
        i = 0;
        column = 0;
        SimpleReturnDTHeader lastSimpleReturnDTHeader = null;
        while (column < lastColumn) {
            int w = originalTable.getSource().getCell(column, 0).getWidth();
            int row = 0;
            if (!DecisionTableHelper.conflictsWithStrongDtHeader(strongDtHeaders, withVerticalTitles, firstColumnForHCondition, column, w)) {
                if (isSmart) {
                    List<DTHeader> fuzzyHeaders = DecisionTableHelper.matchWithFuzzySearch(decisionTable, originalTable, fuzzyContext, numberOfColumnsUnderTitleCounter, numberOfHConditions, column, lastColumn, dtHeaders, firstColumnHeight, firstColumnForHCondition, withVerticalTitles, false);
                    if (numberOfHConditions == 0) {
                        String titleForColumn = DecisionTableHelper.getTitleForColumn(originalTable, firstColumnHeight, column);
                        int width = originalTable.getSource().getCell(column, 0).getWidth();
                        lastSimpleReturnDTHeader = new SimpleReturnDTHeader(null, titleForColumn, column, row, width);
                        if (fuzzyContext != null && fuzzyContext.isFuzzySupportsForReturnType()) {
                            List<OpenLFuzzyUtils.FuzzyResult> returnTypeFuzzyExtractResult = OpenLFuzzyUtils.fuzzyExtract(titleForColumn, new Token[]{new Token(returnTokenString, -1)}, true);
                            if (!returnTypeFuzzyExtractResult.isEmpty()) {
                                dtHeaders.add(new FuzzyDTHeader(column, null, titleForColumn, null, column, column, row, width, width, returnTypeFuzzyExtractResult.get(0), true, false));
                            } else if (fuzzyHeaders.stream().noneMatch(DTHeader::isReturn) && numberOfColumnsUnderTitleCounter.get(column) == 1 && (column + w >= lastColumn || DecisionTableHelper.columnWithFormulas(originalTable, firstColumnHeight, column))) {
                                dtHeaders.add(lastSimpleReturnDTHeader);
                            }
                        } else {
                            dtHeaders.add(lastSimpleReturnDTHeader);
                        }
                    }
                } else {
                    if (numberOfHConditions == 0 && i >= numberOfParameters) {
                        DecisionTableHelper.matchWithFuzzySearch(decisionTable, originalTable, fuzzyContext, numberOfColumnsUnderTitleCounter, numberOfHConditions, column, lastColumn, dtHeaders, firstColumnHeight, firstColumnForHCondition, withVerticalTitles, true);
                    }
                    if (i < numberOfParameters - numberOfHConditions) {
                        SimpleDTHeader simpleDTHeader = new SimpleDTHeader(i, decisionTable.getSignature().getParameterName(i), null, column, row, w);
                        dtHeaders.add(simpleDTHeader);
                    } else if (numberOfHConditions == 0) {
                        SimpleReturnDTHeader simpleReturnDTHeader = new SimpleReturnDTHeader(null, null, column, row, w);
                        dtHeaders.add(simpleReturnDTHeader);
                    }
                }
            }
            column += w;
            ++i;
        }
        if (lastSimpleReturnDTHeader != null && dtHeaders.stream().noneMatch(DTHeader::isReturn)) {
            dtHeaders.add(lastSimpleReturnDTHeader);
        }
        List<DTHeader> fit = DecisionTableHelper.fitDtHeaders(tableSyntaxNode, decisionTable, originalTable, dtHeaders, lastColumn, numberOfHConditions, twoColumnsForReturn, firstColumnHeight, bindingContext);
        if (numberOfHConditions > 0) {
            int width;
            int maxColumnMatched = fit.stream().filter(e -> e.isCondition() && !e.isHCondition() || e.isAction()).mapToInt(e -> e.getColumn() + e.getWidth()).max().orElse(0);
            for (column = originalTable.getSource().getWidth() - 1; column > maxColumnMatched && DecisionTableHelper.calculateRowsCount(originalTable, column - 1, firstColumnHeight) == numberOfHConditions; --column) {
            }
            ArrayList<DTHeader> fitHCond = new ArrayList<DTHeader>(fit);
            for (int c = maxColumnMatched; c < column; ++c) {
                int num = numberOfColumnsUnderTitleCounter.get(c);
                int col1 = c;
                for (int j = 0; j < num; ++j) {
                    width = numberOfColumnsUnderTitleCounter.getWidth(c, j);
                    fitHCond.add(new UnmatchedDtHeader("", col1, 0, width, false));
                    col1 += width;
                }
            }
            boolean[] parameterIsUsed = new boolean[numberOfParameters];
            Arrays.fill(parameterIsUsed, false);
            for (DTHeader dtHeader : fit) {
                int[] nArray = dtHeader.getMethodParameterIndexes();
                width = nArray.length;
                for (int j = 0; j < width; ++j) {
                    int paramIndex = nArray[j];
                    parameterIsUsed[paramIndex] = true;
                }
            }
            int freeParameters = 0;
            for (boolean f : parameterIsUsed) {
                if (f) continue;
                ++freeParameters;
            }
            long hConditionsMatched = fit.stream().filter(e -> e.isHCondition() && !(e instanceof UnmatchedDtHeader)).count();
            if ((long)freeParameters + hConditionsMatched < (long)numberOfHConditions) {
                SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)"No input parameter found for horizontal condition.", (ISyntaxNode)tableSyntaxNode);
                bindingContext.addError(error);
                return fitHCond;
            }
            int j = 0;
            int c = 0;
            int len = fitHCond.size();
            for (int w = 0; w < numberOfParameters && (long)j < (long)numberOfHConditions - hConditionsMatched; ++w) {
                DTHeader dth;
                if (parameterIsUsed[w]) continue;
                while (!(c >= len || (dth = (DTHeader)fitHCond.get(c)) instanceof UnmatchedDtHeader && dth.isHCondition())) {
                    ++c;
                }
                if (c < len) {
                    fitHCond.set(c, new SimpleDTHeader(w, decisionTable.getSignature().getParameterName(w), column + j, j));
                    ++c;
                } else {
                    fitHCond.add(new SimpleDTHeader(w, decisionTable.getSignature().getParameterName(w), column + j, j));
                }
                ++j;
            }
            return Collections.unmodifiableList(fitHCond);
        }
        return fit;
    }

    private static String getTitleForColumn(ILogicalTable originalTable, int firstColumnHeight, int column) {
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < firstColumnHeight; ++j) {
            if (j > 0) {
                sb.append(" ");
            }
            sb.append(originalTable.getSource().getCell(column, 0).getStringValue());
        }
        return sb.toString();
    }

    public static int getNumberOfHConditions(ILogicalTable originalTable) {
        return DecisionTableHelper.calculateRowsCount(originalTable, originalTable.getSource().getWidth() - 1, originalTable.getSource().getCell(0, 0).getHeight());
    }

    private static boolean isTwoColumnsForReturn(TableSyntaxNode tableSyntaxNode, DecisionTable decisionTable) {
        return DecisionTableHelper.isCollect(tableSyntaxNode) && ClassUtils.isAssignable((Class)decisionTable.getType().getInstanceClass(), Map.class);
    }

    private static void matchWithDtColumnsDefinitions(DecisionTable decisionTable, ILogicalTable originalTable, int column, XlsDefinitions definitions, NumberOfColumnsUnderTitleCounter numberOfColumnsUnderTitleCounter, List<DTHeader> dtHeaders, int firstColumnForHCondition, WithVerticalTitles withVerticalTitles, int firstColumnHeight, int numberOfHConditions, IBindingContext bindingContext) {
        boolean skipNextColumn;
        boolean parseAsHorizontalVerticalTitle = WithVerticalTitles.SLASH_IN_TITLE.equals((Object)withVerticalTitles) && column + originalTable.getSource().getCell(column, 0).getWidth() == firstColumnForHCondition;
        int w0 = column + originalTable.getSource().getCell(column, 0).getWidth();
        boolean bl = skipNextColumn = w0 + originalTable.getSource().getCell(w0, 0).getWidth() == firstColumnForHCondition && (WithVerticalTitles.EMPTY_COLUMN.equals((Object)withVerticalTitles) || WithVerticalTitles.MERGED_COLUMN.equals((Object)withVerticalTitles));
        if (parseAsHorizontalVerticalTitle || originalTable.getSource().getCell(column, 0).getHeight() == firstColumnHeight) {
            for (DTColumnsDefinition definition : definitions.getDtColumnsDefinitions()) {
                MatchedDefinition matchedDefinition;
                Triple<String, String, Integer> extractedTitle;
                HashSet<String> titles = new HashSet<String>(definition.getTitles());
                Triple<String, String, Integer> lastExtractedTitle = extractedTitle = DecisionTableHelper.extractTokenizedVerticalTitleString(originalTable, column, firstColumnHeight, parseAsHorizontalVerticalTitle);
                int i = 0;
                int x = column;
                IParameterDeclaration[][] columnParameters = null;
                int numberOfColumnsUnderTitle = numberOfColumnsUnderTitleCounter.get(x);
                boolean f1 = DecisionTableHelper.isMatchedByUnderColumns(definition.getParameters((String)extractedTitle.getLeft()), numberOfColumnsUnderTitle);
                boolean f2 = !Objects.equals(extractedTitle.getLeft(), extractedTitle.getMiddle()) && DecisionTableHelper.isMatchedByUnderColumns(definition.getParameters((String)extractedTitle.getMiddle()), numberOfColumnsUnderTitle);
                boolean g = false;
                while (!titles.isEmpty() && (numberOfHConditions > 0 && x < firstColumnForHCondition || x < originalTable.getSource().getWidth()) && (f1 && titles.contains(extractedTitle.getLeft()) || f2 && titles.contains(extractedTitle.getMiddle()))) {
                    g = false;
                    if (f1) {
                        titles.remove(extractedTitle.getLeft());
                    } else {
                        titles.remove(extractedTitle.getMiddle());
                    }
                    for (String s : definition.getTitles()) {
                        if (f1 && s.equals(extractedTitle.getLeft())) {
                            g = true;
                            if (columnParameters == null) {
                                columnParameters = new IParameterDeclaration[definition.getNumberOfTitles()][];
                            }
                            columnParameters[i] = definition.getParameters((String)extractedTitle.getLeft()).toArray(IParameterDeclaration.EMPTY);
                            break;
                        }
                        if (!f2 || !s.equals(extractedTitle.getMiddle())) continue;
                        if (columnParameters == null) {
                            columnParameters = new IParameterDeclaration[definition.getNumberOfTitles()][];
                        }
                        columnParameters[i] = definition.getParameters((String)extractedTitle.getMiddle()).toArray(IParameterDeclaration.EMPTY);
                        break;
                    }
                    ++i;
                    int w = originalTable.getSource().getCell(x, 0).getWidth();
                    lastExtractedTitle = extractedTitle;
                    extractedTitle = DecisionTableHelper.extractTokenizedVerticalTitleString(originalTable, x += w, firstColumnHeight, parseAsHorizontalVerticalTitle);
                    parseAsHorizontalVerticalTitle = WithVerticalTitles.SLASH_IN_TITLE.equals((Object)withVerticalTitles) && column + originalTable.getSource().getCell(column, 0).getWidth() == firstColumnForHCondition;
                    numberOfColumnsUnderTitle = numberOfColumnsUnderTitleCounter.get(x);
                    f1 = DecisionTableHelper.isMatchedByUnderColumns(definition.getParameters((String)extractedTitle.getLeft()), numberOfColumnsUnderTitle);
                    f2 = !Objects.equals(extractedTitle.getLeft(), extractedTitle.getMiddle()) && DecisionTableHelper.isMatchedByUnderColumns(definition.getParameters((String)extractedTitle.getMiddle()), numberOfColumnsUnderTitle);
                }
                if (!titles.isEmpty() || (matchedDefinition = DecisionTableHelper.matchByDTColumnDefinition(decisionTable, definition, numberOfHConditions, bindingContext)) == null) continue;
                DeclaredDTHeader dtHeader = new DeclaredDTHeader(matchedDefinition.getUsedMethodParameterIndexes(), definition.getCompositeMethod(), columnParameters, column, (Integer)lastExtractedTitle.getRight(), x - column + (skipNextColumn ? originalTable.getSource().getCell(x, 0).getWidth() : 0), x - column, matchedDefinition, false, g && parseAsHorizontalVerticalTitle);
                dtHeaders.add(dtHeader);
            }
        }
        if (!WithVerticalTitles.NO.equals((Object)withVerticalTitles) && column + originalTable.getSource().getCell(column, 0).getWidth() == firstColumnForHCondition) {
            block3: for (DTColumnsDefinition definition : definitions.getDtColumnsDefinitions()) {
                if (definition.getNumberOfTitles() != 1) continue;
                String definitionTitle = definition.getTitles().iterator().next();
                int h = 0;
                int x = 0;
                while (h < firstColumnHeight) {
                    MatchedDefinition matchedDefinition;
                    int h0 = originalTable.getSource().getCell(column, h).getHeight();
                    String title = originalTable.getSource().getCell(column, h).getStringValue();
                    if (h + h0 >= firstColumnHeight && WithVerticalTitles.SLASH_IN_TITLE.equals((Object)withVerticalTitles)) {
                        title = title.substring(title.indexOf(HORIZONTAL_VERTICAL_CONDITIONS_SPLITTER) + 1).trim();
                    }
                    if (x < numberOfHConditions && Objects.equals(title = OpenLFuzzyUtils.toTokenString(title), definitionTitle) && (matchedDefinition = DecisionTableHelper.matchByDTColumnDefinition(decisionTable, definition, numberOfHConditions, bindingContext)) != null) {
                        IParameterDeclaration[][] columnParameters = new IParameterDeclaration[][]{definition.getParameters(title).toArray(IParameterDeclaration.EMPTY)};
                        DeclaredDTHeader vDtHeader = new DeclaredDTHeader(matchedDefinition.getUsedMethodParameterIndexes(), definition.getCompositeMethod(), columnParameters, column + originalTable.getSource().getCell(column, 0).getWidth() + x, h, 1, 1, matchedDefinition, true, false);
                        dtHeaders.add(vDtHeader);
                        continue block3;
                    }
                    h += h0;
                    ++x;
                }
            }
        }
    }

    private static Triple<String, String, Integer> extractTokenizedVerticalTitleString(ILogicalTable originalTable, int column, int firstColumnHeight, boolean parseAsHorizontalVerticalTitle) {
        String title;
        if (parseAsHorizontalVerticalTitle && StringUtils.isNotBlank((CharSequence)(title = originalTable.getSource().getCell(column, firstColumnHeight - 1).getStringValue())) && title.contains(HORIZONTAL_VERTICAL_CONDITIONS_SPLITTER)) {
            String cutTitle = title.substring(0, title.indexOf(HORIZONTAL_VERTICAL_CONDITIONS_SPLITTER)).trim();
            return Triple.of((Object)OpenLFuzzyUtils.toTokenString(cutTitle), (Object)OpenLFuzzyUtils.toTokenString(title), (Object)(firstColumnHeight - 1));
        }
        title = originalTable.getSource().getCell(column, 0).getStringValue();
        String tokenizedTitle = OpenLFuzzyUtils.toTokenString(title);
        return Triple.of((Object)tokenizedTitle, (Object)tokenizedTitle, (Object)0);
    }

    private static boolean isMatchedByUnderColumns(List<IParameterDeclaration> parameters, int numberOfColumnsUnderTitle) {
        boolean isAnyArrayTypePresented = parameters.stream().anyMatch(e -> e != null && e.getType() != null && e.getType().isArray());
        return isAnyArrayTypePresented ? numberOfColumnsUnderTitle >= parameters.size() : numberOfColumnsUnderTitle == parameters.size();
    }

    private static Pair<Boolean, String[]> parsableAsArray(String src, Class<?> componentType, IBindingContext bindingContext) {
        String[] values = StringTool.splitAndEscape((String)src, (String)",", (String)"\\");
        try {
            for (String value : values) {
                String2DataConvertorFactory.parse(componentType, value, bindingContext);
            }
        }
        catch (Exception e) {
            return Pair.of((Object)false, (Object)values);
        }
        return Pair.of((Object)true, (Object)values);
    }

    public static boolean parsableAs(String src, Class<?> clazz, IBindingContext bindingContext) {
        try {
            String2DataConvertorFactory.parse(clazz, src, bindingContext);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private static int calculateRowsCount(ILogicalTable originalTable, int column, int height) {
        int h = 0;
        int k = 0;
        while (h < height && h < originalTable.getSource().getHeight()) {
            h += originalTable.getSource().getCell(column, h).getHeight();
            ++k;
        }
        return k;
    }

    private static Triple<String[], IOpenClass, String> buildTripleForTypeForConditionColumn(Class<?> rangeClass, DTHeader condition, boolean isArray, boolean isMoreThanOneColumnIsUsed) {
        int type;
        if (isArray) {
            type = isMoreThanOneColumnIsUsed ? 2 : 1;
        } else {
            int n = type = isMoreThanOneColumnIsUsed ? 1 : 0;
        }
        if (type == 0) {
            return Triple.of((Object)new String[]{rangeClass.getSimpleName()}, (Object)JavaOpenClass.getOpenClass(rangeClass), (Object)condition.getStatement());
        }
        if (type == 1) {
            String paramName = "_" + condition.getStatement().replaceAll("\\.", "_");
            return Triple.of((Object)new String[]{rangeClass.getSimpleName() + "[]", paramName}, (Object)AOpenClass.getArrayType((IOpenClass)JavaOpenClass.getOpenClass(rangeClass), (int)1), (Object)("contains(" + paramName + ", " + condition.statement + ")"));
        }
        String paramName = "_" + condition.getStatement().replaceAll("\\.", "_");
        return Triple.of((Object)new String[]{rangeClass.getSimpleName() + "[][]", paramName}, (Object)AOpenClass.getArrayType((IOpenClass)JavaOpenClass.getOpenClass(rangeClass), (int)2), (Object)("contains(" + paramName + ", " + condition.statement + ")"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Triple<String[], IOpenClass, String> getTypeForConditionColumn(DecisionTable decisionTable, ILogicalTable originalTable, DTHeader condition, int indexOfHCondition, int firstColumnForHConditionsOrReturns, int firstColumnHeight, int numberOfColumnsUnderTitle, IBindingContext bindingContext) {
        String value;
        int valueNum;
        int numberOfColumnsForCondition;
        int skip;
        int width;
        IGridTable decisionValues;
        int column = condition.getColumn();
        IOpenClass type = DecisionTableHelper.getTypeForCondition(decisionTable, condition);
        if (condition.isHCondition()) {
            decisionValues = (IGridTable)originalTable.getSource().getRow(indexOfHCondition - 1);
            width = decisionValues.getWidth();
            skip = firstColumnForHConditionsOrReturns;
            numberOfColumnsForCondition = 1;
        } else {
            decisionValues = (IGridTable)originalTable.getSource().getColumns(column, column + numberOfColumnsUnderTitle - 1);
            width = decisionValues.getHeight();
            skip = firstColumnHeight;
            numberOfColumnsForCondition = numberOfColumnsUnderTitle;
        }
        boolean isAllParsableAsRangeFlag = true;
        boolean isAllLikelyNotRangeFlag = true;
        boolean isAllElementsLikelyNotRangeFlag = true;
        boolean isAllParsableAsSingleFlag = true;
        boolean isAllParsableAsDomainFlag = true;
        boolean isAllParsableAsDomainArrayFlag = true;
        boolean isAllParsableAsArrayFlag = true;
        boolean arraySeparatorFoundFlag = false;
        boolean isNotParsableAsSingleRangeButParsableAsRangesArrayFlag = false;
        boolean zeroStartedNumbersFoundFlag = false;
        boolean isIntType = INT_TYPES.contains(type.getInstanceClass());
        boolean isDoubleType = DOUBLE_TYPES.contains(type.getInstanceClass());
        boolean isCharType = CHAR_TYPES.contains(type.getInstanceClass());
        boolean isDateType = DATE_TYPES.contains(type.getInstanceClass());
        boolean isStringType = STRING_TYPES.contains(type.getInstanceClass());
        boolean isRangeType = RANGE_TYPES.contains(type.getInstanceClass());
        boolean canMadeDecisionAboutSingle = true;
        boolean[][] h = new boolean[width][numberOfColumnsForCondition];
        for (int i = 0; i < width; ++i) {
            Arrays.fill(h[i], true);
        }
        boolean isMoreThanOneColumnIsUsed = numberOfColumnsForCondition > 1;
        HashMap<Integer, LinkedHashSet> valuesMap = new HashMap<Integer, LinkedHashSet>();
        for (valueNum = skip; valueNum < width; ++valueNum) {
            int cellNum;
            IGridTable cellValues = condition.isHCondition() ? (IGridTable)decisionValues.getColumn(valueNum) : (IGridTable)decisionValues.getRow(valueNum);
            Set values = valuesMap.computeIfAbsent(valueNum, e -> new LinkedHashSet());
            for (cellNum = 0; cellNum < numberOfColumnsForCondition; ++cellNum) {
                ICell cell = cellValues.getCell(0, cellNum);
                value = cellValues.getCell(0, cellNum).getStringValue();
                if (value == null || StringUtils.isEmpty((CharSequence)value)) {
                    values.add(null);
                    h[valueNum][cellNum] = false;
                    continue;
                }
                values.add(new CellValue(cell));
            }
            cellNum = -1;
            block10: for (CellValue cellValue : values) {
                ++cellNum;
                if (cellValue == null) continue;
                String value2 = cellValue.getValue();
                if (RuleRowHelper.isFormula(value2) && !isRangeType) {
                    try {
                        bindingContext.pushErrors();
                        bindingContext.pushMessages();
                        StringSourceCodeModule expressionCellSourceCodeModule = new StringSourceCodeModule(value2.substring(value2.indexOf("=")).trim(), null);
                        CompositeMethod compositeMethod = OpenLManager.makeMethodWithUnknownType((OpenL)bindingContext.getOpenL(), (IOpenSourceCodeModule)expressionCellSourceCodeModule, (String)RandomStringUtils.random((int)16, (boolean)true, (boolean)false), (IMethodSignature)decisionTable.getSignature(), (IOpenClass)decisionTable.getDeclaringClass(), (IBindingContext)bindingContext);
                        IOpenClass cellType = compositeMethod.getType();
                        boolean bl = canMadeDecisionAboutSingle = canMadeDecisionAboutSingle && type.equals(cellType);
                        if (cellType.isArray() && RANGE_TYPES.contains(cellType.getComponentClass().getInstanceClass())) {
                            isAllParsableAsArrayFlag = false;
                            isNotParsableAsSingleRangeButParsableAsRangesArrayFlag = true;
                            isAllLikelyNotRangeFlag = false;
                            isAllElementsLikelyNotRangeFlag = false;
                        }
                        if (RANGE_TYPES.contains(cellType.getInstanceClass())) {
                            isAllParsableAsArrayFlag = false;
                            isAllLikelyNotRangeFlag = false;
                            isAllElementsLikelyNotRangeFlag = false;
                        }
                        if (cellType.isArray()) {
                            isAllParsableAsSingleFlag = false;
                            isNotParsableAsSingleRangeButParsableAsRangesArrayFlag = true;
                        }
                    }
                    finally {
                        bindingContext.popMessages();
                        bindingContext.popErrors();
                    }
                    h[valueNum][cellNum] = false;
                    continue;
                }
                ConstantOpenField constantOpenField = RuleRowHelper.findConstantField(bindingContext, value2);
                if (constantOpenField != null) {
                    if (constantOpenField.getType().isArray() && RANGE_TYPES.contains(constantOpenField.getType().getComponentClass().getInstanceClass())) {
                        isAllParsableAsArrayFlag = false;
                        isNotParsableAsSingleRangeButParsableAsRangesArrayFlag = true;
                        isAllLikelyNotRangeFlag = false;
                        isAllElementsLikelyNotRangeFlag = false;
                    }
                    if (RANGE_TYPES.contains(constantOpenField.getType().getInstanceClass())) {
                        isAllParsableAsArrayFlag = false;
                        isAllLikelyNotRangeFlag = false;
                        isAllElementsLikelyNotRangeFlag = false;
                    }
                    if (constantOpenField.getType().isArray()) {
                        isAllParsableAsSingleFlag = false;
                        isNotParsableAsSingleRangeButParsableAsRangesArrayFlag = true;
                    }
                    h[valueNum][cellNum] = false;
                    canMadeDecisionAboutSingle = canMadeDecisionAboutSingle && type.equals(constantOpenField.getType());
                    continue;
                }
                if (!arraySeparatorFoundFlag && value2.contains(",")) {
                    arraySeparatorFoundFlag = true;
                }
                try {
                    if ((isIntType || isDoubleType || isCharType) && isAllParsableAsSingleFlag && !DecisionTableHelper.parsableAs(value2, type.getInstanceClass(), bindingContext)) {
                        isAllParsableAsSingleFlag = false;
                        continue;
                    }
                    if (!isStringType) continue;
                    if (isAllParsableAsDomainFlag && (type.getDomain() == null || !type.getDomain().selectObject((Object)value2))) {
                        isAllParsableAsDomainFlag = false;
                    }
                    if (!isAllParsableAsDomainArrayFlag) continue;
                    if (type.getDomain() == null) {
                        isAllParsableAsDomainArrayFlag = false;
                        continue;
                    }
                    Pair<Boolean, String[]> splited = DecisionTableHelper.parsableAsArray(value2, type.getInstanceClass(), bindingContext);
                    for (String s : (String[])splited.getRight()) {
                        if (type.getDomain().selectObject((Object)s)) continue;
                        isAllParsableAsDomainArrayFlag = false;
                        continue block10;
                    }
                }
                catch (Exception splited) {
                }
            }
        }
        if (canMadeDecisionAboutSingle) {
            if ((isIntType || isDoubleType || isCharType) && isAllParsableAsSingleFlag || isStringType && isAllParsableAsDomainFlag) {
                return DecisionTableHelper.buildTripleForConditionColumnWithSimpleType(condition, type, false, isMoreThanOneColumnIsUsed);
            }
            if (isStringType && isAllParsableAsDomainArrayFlag) {
                return DecisionTableHelper.buildTripleForConditionColumnWithSimpleType(condition, type, true, isMoreThanOneColumnIsUsed);
            }
        }
        for (valueNum = skip; valueNum < width; ++valueNum) {
            Set values = (Set)valuesMap.get(valueNum);
            int cellNum = -1;
            block13: for (CellValue cellValue : values) {
                if (cellValue == null || !h[valueNum][++cellNum]) continue;
                value = cellValue.getValue();
                try {
                    Pair<Boolean, String[]> g;
                    Pair<Boolean, String[]> f;
                    if (isIntType) {
                        if (isAllParsableAsRangeFlag || !isNotParsableAsSingleRangeButParsableAsRangesArrayFlag) {
                            f = DecisionTableHelper.parsableAsArray(value, IntRange.class, bindingContext);
                            boolean parsableAsSingleRange = DecisionTableHelper.parsableAs(value, IntRange.class, bindingContext);
                            if (!((Boolean)f.getKey()).booleanValue() && !parsableAsSingleRange) {
                                isAllParsableAsRangeFlag = false;
                            }
                            if (((Boolean)f.getKey()).booleanValue() && ((String[])f.getValue()).length > 1 && !parsableAsSingleRange) {
                                isNotParsableAsSingleRangeButParsableAsRangesArrayFlag = true;
                            }
                        }
                        if (!isAllParsableAsArrayFlag) continue;
                        g = DecisionTableHelper.parsableAsArray(value, type.getInstanceClass(), bindingContext);
                        if (((Boolean)g.getKey()).booleanValue() && !zeroStartedNumbersFoundFlag) {
                            zeroStartedNumbersFoundFlag = Arrays.stream((Object[])g.getRight()).anyMatch(e -> e != null && e.length() > 1 && e.startsWith("0"));
                        }
                        if (((Boolean)g.getKey()).booleanValue()) continue;
                        isAllParsableAsArrayFlag = false;
                        continue;
                    }
                    if (isDoubleType) {
                        if (isAllParsableAsRangeFlag || !isNotParsableAsSingleRangeButParsableAsRangesArrayFlag) {
                            f = DecisionTableHelper.parsableAsArray(value, DoubleRange.class, bindingContext);
                            boolean parsableAsSingleRange = DecisionTableHelper.parsableAs(value, DoubleRange.class, bindingContext);
                            if (!((Boolean)f.getKey()).booleanValue() && !parsableAsSingleRange) {
                                isAllParsableAsRangeFlag = false;
                            }
                            if (((Boolean)f.getKey()).booleanValue() && ((String[])f.getValue()).length > 1 && !parsableAsSingleRange) {
                                isNotParsableAsSingleRangeButParsableAsRangesArrayFlag = true;
                            }
                        }
                        if (!isAllParsableAsArrayFlag) continue;
                        g = DecisionTableHelper.parsableAsArray(value, type.getInstanceClass(), bindingContext);
                        if (((Boolean)g.getKey()).booleanValue() && !zeroStartedNumbersFoundFlag) {
                            zeroStartedNumbersFoundFlag = Arrays.stream((Object[])g.getRight()).anyMatch(e -> e != null && e.length() > 1 && e.startsWith("0"));
                        }
                        if (((Boolean)g.getKey()).booleanValue()) continue;
                        isAllParsableAsArrayFlag = false;
                        continue;
                    }
                    if (isCharType) {
                        if (isAllParsableAsRangeFlag || !isNotParsableAsSingleRangeButParsableAsRangesArrayFlag) {
                            f = DecisionTableHelper.parsableAsArray(value, CharRange.class, bindingContext);
                            boolean parsableAsSingleRange = DecisionTableHelper.parsableAs(value, CharRange.class, bindingContext);
                            if (!((Boolean)f.getKey()).booleanValue() && !parsableAsSingleRange) {
                                isAllParsableAsRangeFlag = false;
                            }
                            if (((Boolean)f.getKey()).booleanValue() && ((String[])f.getValue()).length > 1 && !parsableAsSingleRange) {
                                isNotParsableAsSingleRangeButParsableAsRangesArrayFlag = true;
                            }
                        }
                        if (!isAllParsableAsArrayFlag || ((Boolean)(g = DecisionTableHelper.parsableAsArray(value, type.getInstanceClass(), bindingContext)).getKey()).booleanValue()) continue;
                        isAllParsableAsArrayFlag = false;
                        continue;
                    }
                    if (isDateType) {
                        Pair<Boolean, String[]> g2;
                        Object o = cellValue.getCell().getObjectValue();
                        if (o instanceof Date) continue;
                        if (o instanceof String && !DecisionTableHelper.parsableAs(value, type.getInstanceClass(), bindingContext)) {
                            isAllParsableAsSingleFlag = false;
                        }
                        Pair<Boolean, String[]> f2 = null;
                        if (isAllParsableAsRangeFlag || !isNotParsableAsSingleRangeButParsableAsRangesArrayFlag) {
                            f2 = DecisionTableHelper.parsableAsArray(value, DateRange.class, bindingContext);
                            boolean parsableAsSingleRange = DecisionTableHelper.parsableAs(value, DateRange.class, bindingContext);
                            if (isAllParsableAsRangeFlag && !((Boolean)f2.getKey()).booleanValue() && !parsableAsSingleRange) {
                                isAllParsableAsRangeFlag = false;
                            }
                            if (((Boolean)f2.getKey()).booleanValue() && ((String[])f2.getValue()).length > 1 && !parsableAsSingleRange) {
                                isNotParsableAsSingleRangeButParsableAsRangesArrayFlag = true;
                            }
                        }
                        if (isAllLikelyNotRangeFlag && o instanceof String && DateRangeParser.getInstance().likelyRangeThanDate(value)) {
                            isAllLikelyNotRangeFlag = false;
                        }
                        if (isAllElementsLikelyNotRangeFlag) {
                            if (f2 == null) {
                                f2 = DecisionTableHelper.parsableAsArray(value, DateRange.class, bindingContext);
                            }
                            String[] parsableAsSingleRange = (String[])f2.getValue();
                            int n = parsableAsSingleRange.length;
                            for (int i = 0; i < n; ++i) {
                                String v = parsableAsSingleRange[i];
                                if (!DateRangeParser.getInstance().likelyRangeThanDate(v)) continue;
                                isAllElementsLikelyNotRangeFlag = false;
                                break;
                            }
                        }
                        if (!isAllParsableAsArrayFlag || ((Boolean)(g2 = DecisionTableHelper.parsableAsArray(value, type.getInstanceClass(), bindingContext)).getKey()).booleanValue()) continue;
                        isAllParsableAsArrayFlag = false;
                        continue;
                    }
                    if (!isStringType) continue;
                    f = null;
                    if (isAllParsableAsRangeFlag || !isNotParsableAsSingleRangeButParsableAsRangesArrayFlag) {
                        f = DecisionTableHelper.parsableAsArray(value, StringRange.class, bindingContext);
                        if (isAllParsableAsRangeFlag && !((Boolean)f.getKey()).booleanValue() && !DecisionTableHelper.parsableAs(value, StringRange.class, bindingContext)) {
                            isAllParsableAsRangeFlag = false;
                        }
                        if (!isNotParsableAsSingleRangeButParsableAsRangesArrayFlag && ((Boolean)f.getKey()).booleanValue() && ((String[])f.getValue()).length > 1) {
                            isNotParsableAsSingleRangeButParsableAsRangesArrayFlag = true;
                        }
                    }
                    if (isAllLikelyNotRangeFlag && StringRangeParser.getInstance().likelyRangeThanString(value)) {
                        isAllLikelyNotRangeFlag = false;
                    }
                    if (!isAllElementsLikelyNotRangeFlag) continue;
                    if (f == null) {
                        f = DecisionTableHelper.parsableAsArray(value, StringRange.class, bindingContext);
                    }
                    for (String v : (String[])f.getValue()) {
                        if (!StringRangeParser.getInstance().likelyRangeThanString(v)) continue;
                        isAllElementsLikelyNotRangeFlag = false;
                        continue block13;
                    }
                }
                catch (Exception exception) {
                }
            }
        }
        if (isDateType && isAllParsableAsRangeFlag && ((!isNotParsableAsSingleRangeButParsableAsRangesArrayFlag ? !isAllLikelyNotRangeFlag : !isAllElementsLikelyNotRangeFlag) || !isAllParsableAsArrayFlag)) {
            return DecisionTableHelper.buildTripleForTypeForConditionColumn(DateRange.class, condition, isNotParsableAsSingleRangeButParsableAsRangesArrayFlag, isMoreThanOneColumnIsUsed);
        }
        if (isIntType && isAllParsableAsRangeFlag && (!isAllParsableAsArrayFlag || zeroStartedNumbersFoundFlag)) {
            return DecisionTableHelper.buildTripleForTypeForConditionColumn(IntRange.class, condition, isNotParsableAsSingleRangeButParsableAsRangesArrayFlag, isMoreThanOneColumnIsUsed);
        }
        if (isDoubleType && isAllParsableAsRangeFlag && (!isAllParsableAsArrayFlag || zeroStartedNumbersFoundFlag)) {
            return DecisionTableHelper.buildTripleForTypeForConditionColumn(DoubleRange.class, condition, isNotParsableAsSingleRangeButParsableAsRangesArrayFlag, isMoreThanOneColumnIsUsed);
        }
        if (isCharType && isAllParsableAsRangeFlag && !isAllParsableAsArrayFlag) {
            return DecisionTableHelper.buildTripleForTypeForConditionColumn(CharRange.class, condition, isNotParsableAsSingleRangeButParsableAsRangesArrayFlag, isMoreThanOneColumnIsUsed);
        }
        if (DecisionTableHelper.isSmart(decisionTable.getSyntaxNode()) && isStringType && !isAllParsableAsDomainFlag && isAllParsableAsRangeFlag && ((!isNotParsableAsSingleRangeButParsableAsRangesArrayFlag ? !isAllLikelyNotRangeFlag : !isAllElementsLikelyNotRangeFlag) || !isAllParsableAsArrayFlag)) {
            return DecisionTableHelper.buildTripleForTypeForConditionColumn(StringRange.class, condition, isNotParsableAsSingleRangeButParsableAsRangesArrayFlag, isMoreThanOneColumnIsUsed);
        }
        if (!type.isArray() && isAllParsableAsArrayFlag && (!isAllParsableAsSingleFlag || arraySeparatorFoundFlag)) {
            return DecisionTableHelper.buildTripleForConditionColumnWithSimpleType(condition, type, true, isMoreThanOneColumnIsUsed);
        }
        if (isAllParsableAsSingleFlag) {
            return DecisionTableHelper.buildTripleForConditionColumnWithSimpleType(condition, type, false, isMoreThanOneColumnIsUsed);
        }
        if (!type.isArray()) {
            if (isDateType) {
                return DecisionTableHelper.buildTripleForTypeForConditionColumn(DateRange.class, condition, true, isMoreThanOneColumnIsUsed);
            }
            if (isIntType) {
                return DecisionTableHelper.buildTripleForTypeForConditionColumn(IntRange.class, condition, true, isMoreThanOneColumnIsUsed);
            }
            if (isDoubleType) {
                return DecisionTableHelper.buildTripleForTypeForConditionColumn(DoubleRange.class, condition, true, isMoreThanOneColumnIsUsed);
            }
            if (isCharType) {
                return DecisionTableHelper.buildTripleForTypeForConditionColumn(CharRange.class, condition, true, isMoreThanOneColumnIsUsed);
            }
            if (isStringType && DecisionTableHelper.isSmart(decisionTable.getSyntaxNode()) && !isAllParsableAsDomainFlag) {
                return DecisionTableHelper.buildTripleForTypeForConditionColumn(StringRange.class, condition, true, isMoreThanOneColumnIsUsed);
            }
            return DecisionTableHelper.buildTripleForConditionColumnWithSimpleType(condition, type, true, isMoreThanOneColumnIsUsed);
        }
        return DecisionTableHelper.buildTripleForConditionColumnWithSimpleType(condition, type, false, isMoreThanOneColumnIsUsed);
    }

    private static Triple<String[], IOpenClass, String> buildTripleForConditionColumnWithSimpleType(DTHeader condition, IOpenClass type, boolean isArray, boolean isMoreThanOneColumnIsUsed) {
        int v;
        if (type.isArray() && type.getComponentClass().isArray()) {
            return Triple.of((Object)new String[]{type.getName()}, (Object)type, (Object)condition.getStatement());
        }
        if (isArray) {
            v = isMoreThanOneColumnIsUsed ? 2 : 1;
        } else {
            int n = v = isMoreThanOneColumnIsUsed ? 1 : 0;
        }
        if (v == 0) {
            return Triple.of((Object)new String[]{type.getName()}, (Object)type, (Object)condition.getStatement());
        }
        if (v == 1) {
            return Triple.of((Object)new String[]{type.getName() + "[]"}, (Object)AOpenClass.getArrayType((IOpenClass)type, (int)1), (Object)condition.getStatement());
        }
        return Triple.of((Object)new String[]{type.getName() + "[][]"}, (Object)AOpenClass.getArrayType((IOpenClass)type, (int)2), (Object)condition.getStatement());
    }

    private static IOpenClass getTypeForCondition(DecisionTable decisionTable, DTHeader condition) {
        if (condition instanceof FuzzyDTHeader) {
            FuzzyDTHeader fuzzyCondition = (FuzzyDTHeader)condition;
            if (fuzzyCondition.isMethodParameterUsed()) {
                if (fuzzyCondition.getFieldsChain() != null) {
                    return fuzzyCondition.getFieldsChain()[fuzzyCondition.getFieldsChain().length - 1].getType();
                }
            } else if (fuzzyCondition.getFuzzyResult().getToken() instanceof PredicateToken) {
                return JavaOpenClass.getOpenClass(Boolean.class);
            }
        } else if (condition instanceof DeclaredDTHeader) {
            DeclaredDTHeader declaredDTHeader = (DeclaredDTHeader)condition;
            return declaredDTHeader.getCompositeMethod().getType();
        }
        if (condition.isMethodParameterUsed()) {
            return decisionTable.getSignature().getParameterTypes()[condition.getMethodParameterIndex()];
        }
        throw new IllegalStateException();
    }

    @Deprecated
    public static XlsSheetGridModel createVirtualGrid() {
        XSSFWorkbook workbook = new XSSFWorkbook();
        try {
            Sheet sheet = workbook.createSheet();
            StringSourceCodeModule sourceCodeModule = new StringSourceCodeModule("", null);
            SimpleWorkbookLoader workbookLoader = new SimpleWorkbookLoader(sheet.getWorkbook());
            XlsWorkbookSourceCodeModule mockWorkbookSource = new XlsWorkbookSourceCodeModule((IOpenSourceCodeModule)sourceCodeModule, workbookLoader);
            XlsSheetSourceCodeModule mockSheetSource = new XlsSheetSourceCodeModule(new SimpleSheetLoader(sheet), mockWorkbookSource);
            return new XlsSheetGridModel(mockSheetSource);
        }
        catch (Exception e) {
            IOUtils.closeQuietly((AutoCloseable)workbook);
            throw e;
        }
    }

    public static boolean isCollect(TableSyntaxNode tableSyntaxNode) {
        return tableSyntaxNode.getHeader().isCollect();
    }

    public static boolean isSmart(TableSyntaxNode tableSyntaxNode) {
        return DecisionTableHelper.isSmartDecisionTable(tableSyntaxNode) || DecisionTableHelper.isSmartLookupTable(tableSyntaxNode);
    }

    public static boolean isSimple(TableSyntaxNode tableSyntaxNode) {
        return DecisionTableHelper.isSimpleDecisionTable(tableSyntaxNode) || DecisionTableHelper.isSimpleLookupTable(tableSyntaxNode);
    }

    public static boolean isLookup(TableSyntaxNode tableSyntaxNode) {
        return DecisionTableHelper.isSimpleLookupTable(tableSyntaxNode) || DecisionTableHelper.isSmartLookupTable(tableSyntaxNode);
    }

    public static boolean isSmartDecisionTable(TableSyntaxNode tableSyntaxNode) {
        String dtType = tableSyntaxNode.getHeader().getHeaderToken().getIdentifier();
        return "SmartRules".equals(dtType);
    }

    public static boolean isSimpleDecisionTable(TableSyntaxNode tableSyntaxNode) {
        String dtType = tableSyntaxNode.getHeader().getHeaderToken().getIdentifier();
        return "SimpleRules".equals(dtType);
    }

    public static boolean isSmartLookupTable(TableSyntaxNode tableSyntaxNode) {
        String dtType = tableSyntaxNode.getHeader().getHeaderToken().getIdentifier();
        return "SmartLookup".equals(dtType);
    }

    public static boolean isSimpleLookupTable(TableSyntaxNode tableSyntaxNode) {
        String dtType = tableSyntaxNode.getHeader().getHeaderToken().getIdentifier();
        return "SimpleLookup".equals(dtType);
    }

    public static boolean isRulesTable(TableSyntaxNode tableSyntaxNode) {
        String dtType = tableSyntaxNode.getHeader().getHeaderToken().getIdentifier();
        return "DT".equals(dtType) || "Rules".equals(dtType);
    }

    static int countHConditionsByHeaders(ILogicalTable table) {
        int width = table.getWidth();
        int cnt = 0;
        for (int i = 0; i < width; ++i) {
            String value = ((ILogicalTable)table.getColumn(i)).getSource().getCell(0, 0).getStringValue();
            if (value == null || !DecisionTableHelper.isValidHConditionHeader(value = value.toUpperCase())) continue;
            ++cnt;
        }
        return cnt;
    }

    static int countVConditionsByHeaders(ILogicalTable table) {
        int width = table.getWidth();
        int cnt = 0;
        for (int i = 0; i < width; ++i) {
            String value = ((ILogicalTable)table.getColumn(i)).getSource().getCell(0, 0).getStringValue();
            if (value == null || !DecisionTableHelper.isValidConditionHeader(value = value.toUpperCase()) && !DecisionTableHelper.isValidMergedConditionHeader(value)) continue;
            ++cnt;
        }
        return cnt;
    }

    static Pair<Integer, Integer> countAllHeaderTypes(ILogicalTable table) {
        int width = table.getWidth();
        int cnt = 0;
        int nonHeaderCnt = 0;
        for (int i = 0; i < width; ++i) {
            String value = ((ILogicalTable)table.getColumn(i)).getSource().getCell(0, 0).getStringValue();
            if (value == null || StringUtils.isEmpty((CharSequence)value)) continue;
            if (DecisionTableHelper.isConditionHeader(value = value.toUpperCase()) || DecisionTableHelper.isValidRetHeader(value) || DecisionTableHelper.isValidCRetHeader(value) || DecisionTableHelper.isValidActionHeader(value) || DecisionTableHelper.isValidKeyHeader(value) || DecisionTableHelper.isValidRuleHeader(value)) {
                ++cnt;
                continue;
            }
            ++nonHeaderCnt;
        }
        return Pair.of((Object)cnt, (Object)nonHeaderCnt);
    }

    private static class FuzzyContext {
        final ParameterTokens parameterTokens;
        Token[] returnTokens = null;
        Map<Token, IOpenField[][]> returnTypeFuzzyTokens = null;
        IOpenClass fuzzyReturnType;
        int maxDistance;

        private FuzzyContext(ParameterTokens parameterTokens) {
            this.parameterTokens = parameterTokens;
        }

        private FuzzyContext(ParameterTokens parameterTokens, Token[] returnTokens, Map<Token, IOpenField[][]> returnTypeFuzzyTokens, IOpenClass returnType) {
            this(parameterTokens);
            this.returnTokens = returnTokens;
            this.returnTypeFuzzyTokens = returnTypeFuzzyTokens;
            this.fuzzyReturnType = returnType;
            this.maxDistance = Arrays.stream(parameterTokens.getTokens()).mapToInt(Token::getDistance).max().orElse(0);
        }

        ParameterTokens getParameterTokens() {
            return this.parameterTokens;
        }

        Token[] getFuzzyReturnTokens() {
            return this.returnTokens;
        }

        IOpenField[][] getFieldsChainsForReturnToken(Token token) {
            return this.returnTypeFuzzyTokens.get(token);
        }

        boolean isFuzzySupportsForReturnType() {
            return this.returnTypeFuzzyTokens != null && this.returnTokens != null && this.fuzzyReturnType != null;
        }

        IOpenClass getFuzzyReturnType() {
            return this.fuzzyReturnType;
        }

        public int getMaxDistance() {
            return this.maxDistance;
        }
    }

    public static class NumberOfColumnsUnderTitleCounter {
        final ILogicalTable logicalTable;
        final int firstColumnHeight;
        final Map<Integer, List<Integer>> numberOfColumnsMap = new HashMap<Integer, List<Integer>>();

        private List<Integer> init(int column) {
            int w0;
            int w = this.logicalTable.getSource().getCell(column, 0).getWidth();
            ArrayList<Integer> w1 = new ArrayList<Integer>();
            for (int i = 0; i < w; i += w0) {
                w0 = this.logicalTable.getSource().getCell(column + i, this.firstColumnHeight).getWidth();
                w1.add(w0);
            }
            return w1;
        }

        public int get(int column) {
            List numberOfColumns = this.numberOfColumnsMap.computeIfAbsent(column, e -> this.init(column));
            return numberOfColumns.size();
        }

        public int getWidth(int column, int num) {
            List numberOfColumns = this.numberOfColumnsMap.computeIfAbsent(column, e -> this.init(column));
            return (Integer)numberOfColumns.get(num);
        }

        public NumberOfColumnsUnderTitleCounter(ILogicalTable logicalTable, int firstColumnHeight) {
            this.logicalTable = logicalTable;
            this.firstColumnHeight = firstColumnHeight;
        }
    }

    private static final class ParameterTokens {
        final Token[] tokens;
        final Map<Token, Integer> tokensToParameterIndex;
        final Map<Token, IOpenField[]> tokenToFieldsChain;

        ParameterTokens(Token[] tokens, Map<Token, Integer> tokensToParameterIndex, Map<Token, IOpenField[]> tokenToFieldsChain) {
            this.tokens = tokens;
            this.tokensToParameterIndex = tokensToParameterIndex;
            this.tokenToFieldsChain = tokenToFieldsChain;
        }

        IOpenField[] getFieldsChain(Token value) {
            return this.tokenToFieldsChain.get(value);
        }

        Integer getParameterIndex(Token value) {
            return this.tokensToParameterIndex.get(value);
        }

        public Token[] getTokens() {
            return this.tokens;
        }
    }

    private static class CellValue {
        String value;
        ICell cell;

        public CellValue(ICell cell) {
            this.value = cell.getStringValue();
            this.cell = cell;
        }

        public String getValue() {
            return this.value;
        }

        public ICell getCell() {
            return this.cell;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CellValue cellValue = (CellValue)o;
            return Objects.equals(this.value, cellValue.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }

    private static enum WithVerticalTitles {
        NO,
        SLASH_IN_TITLE,
        EMPTY_COLUMN,
        MERGED_COLUMN;

    }

    private static class RuleToken
    extends Token {
        public RuleToken(String value, int distance, int minMatchedTokens) {
            super(value, distance, minMatchedTokens);
        }
    }

    private static class PredicateToken
    extends Token {
        boolean isTrue;

        public PredicateToken(String value, int distance, int minMatchedTokens, boolean isTrue) {
            super(value, distance, minMatchedTokens);
            this.isTrue = isTrue;
        }

        public boolean isTrue() {
            return this.isTrue;
        }
    }
}

