/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.datatype.gen;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.Type;

public final class ASMUtils {
    private ASMUtils() {
    }

    public static Method findMethod(Map<String, List<Method>> methodsMap, String methodName, String descriptor) {
        List<Method> listOfMethods = methodsMap.get(methodName);
        if (listOfMethods != null) {
            for (Method method : listOfMethods) {
                if (!descriptor.equals(Type.getMethodDescriptor((Method)method))) continue;
                return method;
            }
        }
        return null;
    }

    public static Map<String, List<Method>> buildMap(Class<?> clazz) {
        HashMap<String, List<Method>> ret = new HashMap<String, List<Method>>();
        for (Method method : clazz.getMethods()) {
            List listOfMethods = ret.computeIfAbsent(method.getName(), e -> new ArrayList());
            listOfMethods.add(method);
        }
        return ret;
    }
}

