/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IMemberBoundNode;
import org.openl.engine.OpenLManager;
import org.openl.message.OpenLMessage;
import org.openl.message.OpenLMessagesUtils;
import org.openl.message.OpenLWarnMessage;
import org.openl.rules.OpenlToolAdaptor;
import org.openl.rules.binding.RulesModuleBindingContext;
import org.openl.rules.data.ColumnDescriptor;
import org.openl.rules.data.DataTableBindHelper;
import org.openl.rules.data.DataTableBoundNode;
import org.openl.rules.data.FieldChain;
import org.openl.rules.data.ITable;
import org.openl.rules.data.OpenlBasedDataTableModel;
import org.openl.rules.lang.xls.binding.ATableBoundNode;
import org.openl.rules.lang.xls.binding.AXlsTableBinder;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.types.meta.DataTableMetaInfoReader;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.LogicalTableHelper;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.rules.testmethod.TestMethodOpenClass;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.syntax.impl.Tokenizer;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.util.MessageUtils;
import org.openl.util.TableNameChecker;
import org.openl.util.text.ILocation;
import org.openl.util.text.TextInterval;

public class DataNodeBinder
extends AXlsTableBinder {
    public static final int TYPE_INDEX = 1;
    private static final int TABLE_NAME_INDEX = 2;

    protected ATableBoundNode makeNode(TableSyntaxNode tsn, XlsModuleOpenClass module, RulesModuleBindingContext bindingContext) {
        DataTableBoundNode boundNode = new DataTableBoundNode(tsn, module);
        if (!bindingContext.isExecutionMode()) {
            tsn.setMetaInfoReader(new DataTableMetaInfoReader(boundNode));
        }
        return boundNode;
    }

    protected ILogicalTable getTableBody(TableSyntaxNode tsn) {
        return DataTableBindHelper.getTableBody(tsn);
    }

    @Override
    public IMemberBoundNode preBind(TableSyntaxNode tableSyntaxNode, OpenL openl, RulesModuleBindingContext bindingContext, XlsModuleOpenClass module) throws Exception {
        IOpenClass tableType;
        DataTableBoundNode dataNode = (DataTableBoundNode)this.makeNode(tableSyntaxNode, module, bindingContext);
        ILogicalTable table = tableSyntaxNode.getTable();
        GridCellSourceCodeModule source = new GridCellSourceCodeModule(table.getSource(), (IBindingContext)bindingContext);
        IdentifierNode[] parsedHeader = Tokenizer.tokenize((IOpenSourceCodeModule)source, (String)" \n\r");
        if (parsedHeader.length < 3) {
            throw SyntaxNodeExceptionUtils.createError((String)"Data table format: Data <typename> <tablename>", (IOpenSourceCodeModule)source);
        }
        if ((parsedHeader = DataNodeBinder.mergeArraySymbols(parsedHeader)).length > 3) {
            throw SyntaxNodeExceptionUtils.createError((String)"Data table format: Data <typename> <tablename>", (IOpenSourceCodeModule)source);
        }
        String typeName = parsedHeader[1].getText();
        String tableName = parsedHeader[2].getText();
        if (TableNameChecker.isInvalidJavaIdentifier((String)tableName)) {
            String message = String.format("%s '%s' name error. Name can only have letters, digits, _, $ and should not start with a digit.", "Data table", tableName);
            bindingContext.addMessage(OpenLMessagesUtils.newWarnMessage((String)message, (ISyntaxNode)parsedHeader[2]));
        }
        if ((tableType = OpenLManager.makeType((OpenL)bindingContext.getOpenL(), (String)typeName, (IOpenSourceCodeModule)source, (IBindingContext)bindingContext)).getInstanceClass() == null) {
            String message = MessageUtils.getTypeDefinedErrorMessage((String)typeName);
            throw SyntaxNodeExceptionUtils.createError((String)message, (ISyntaxNode)parsedHeader[1]);
        }
        ITable dataTable = this.makeTable(module, tableSyntaxNode, tableName, tableType, (IBindingContext)bindingContext, openl, true);
        dataNode.setTable(dataTable);
        return dataNode;
    }

    private static IdentifierNode[] mergeArraySymbols(IdentifierNode[] parsedHeader) {
        int i;
        ArrayList<IdentifierNode> parsedHeader1 = new ArrayList<IdentifierNode>();
        parsedHeader1.add(parsedHeader[0]);
        StringBuilder sb = new StringBuilder();
        for (i = 2; i < parsedHeader.length - 1 && ("[]".equals(parsedHeader[i].getIdentifier()) || "]".equals(parsedHeader[i].getIdentifier()) || "[".equals(parsedHeader[i].getIdentifier())); ++i) {
            sb.append(parsedHeader[i].getIdentifier());
        }
        parsedHeader1.add(new IdentifierNode(parsedHeader[1].getType(), (ILocation)new TextInterval(parsedHeader[1].getLocation().getStart(), parsedHeader[i - 1].getLocation().getEnd()), parsedHeader[1].getIdentifier() + sb.toString(), parsedHeader[1].getModule()));
        parsedHeader1.addAll(Arrays.asList(parsedHeader).subList(i, parsedHeader.length));
        return parsedHeader1.toArray(new IdentifierNode[0]);
    }

    public void processTable(XlsModuleOpenClass xlsOpenClass, ITable tableToProcess, ILogicalTable tableBody, String tableName, IOpenClass tableType, IBindingContext bindingContext, OpenL openl, boolean hasColumnTitleRow) throws Exception {
        ColumnDescriptor[] descriptors;
        ILogicalTable dataWithTitleRows;
        if (tableBody == null) {
            String message = "There is no body in 'Data' table.";
            throw SyntaxNodeExceptionUtils.createError((String)message, (ISyntaxNode)tableToProcess.getTableSyntaxNode());
        }
        ILogicalTable horizDataTableBody = DataTableBindHelper.getHorizontalTable(tableBody, tableType);
        if (horizDataTableBody.getHeight() > 1) {
            ILogicalTable descriptorRows = DataTableBindHelper.getDescriptorRows(horizDataTableBody);
            dataWithTitleRows = DataTableBindHelper.getHorizontalDataWithTitle(horizDataTableBody);
            dataWithTitleRows = LogicalTableHelper.logicalTable(dataWithTitleRows.getSource(), descriptorRows, null);
            descriptors = this.makeDescriptors(tableToProcess, tableType, bindingContext, openl, hasColumnTitleRow, horizDataTableBody, descriptorRows, dataWithTitleRows);
            if (tableType instanceof TestMethodOpenClass) {
                DataNodeBinder.validateTestTableDescriptors(descriptors, tableToProcess, bindingContext);
            }
        } else {
            String message = "Invalid table structure: data table body should contain key and value columns.";
            throw SyntaxNodeExceptionUtils.createError((String)message, (ISyntaxNode)tableToProcess.getTableSyntaxNode());
        }
        OpenlBasedDataTableModel dataModel = new OpenlBasedDataTableModel(tableName, tableType, openl, descriptors, hasColumnTitleRow);
        OpenlToolAdaptor ota = new OpenlToolAdaptor(openl, bindingContext, tableToProcess.getTableSyntaxNode());
        xlsOpenClass.getDataBase().preLoadTable(tableToProcess, dataModel, dataWithTitleRows, ota);
    }

    private static void validateTestTableDescriptors(ColumnDescriptor[] descriptors, ITable tableToProcess, IBindingContext bindingContext) throws SyntaxNodeException {
        HashSet<String> runtimeContextProps = new HashSet<String>();
        HashSet<String> testRuntimeContextProps = new HashSet<String>();
        HashMap<String, String> duplicatedRuntimeContextProps = new HashMap<String, String>();
        for (ColumnDescriptor descriptor : descriptors) {
            IOpenField[] fields;
            IOpenField field;
            if (descriptor == null || !((field = descriptor.getField()) instanceof FieldChain) || (fields = ((FieldChain)field).getFields()).length != 2) continue;
            if (fields[1].isContextProperty()) {
                String contextProperty = fields[1].getContextProperty();
                if (runtimeContextProps.contains(contextProperty)) {
                    duplicatedRuntimeContextProps.put(contextProperty, fields[0].getName());
                }
                if (testRuntimeContextProps.contains(contextProperty)) {
                    throw SyntaxNodeExceptionUtils.createError((String)String.format("'%s' is redundant since this field is already defined in '%s' parameter.", "_context_." + contextProperty, fields[0].getName()), (ISyntaxNode)tableToProcess.getTableSyntaxNode());
                }
                runtimeContextProps.add(contextProperty);
                continue;
            }
            if (!fields[0].getName().equals("_context_")) continue;
            testRuntimeContextProps.add(fields[1].getName());
        }
        for (String prop : duplicatedRuntimeContextProps.keySet()) {
            bindingContext.addMessage((OpenLMessage)new OpenLWarnMessage(String.format("Multiple fields refer to the same context property '%s'. '%s.%s' will be applied.", prop, duplicatedRuntimeContextProps.get(prop), prop), (ISyntaxNode)tableToProcess.getTableSyntaxNode()));
        }
    }

    protected ColumnDescriptor[] makeDescriptors(ITable tableToProcess, IOpenClass tableType, IBindingContext bindingContext, OpenL openl, boolean hasColumnTitleRow, ILogicalTable horizDataTableBody, ILogicalTable descriptorRows, ILogicalTable dataWithTitleRows) throws Exception {
        return DataTableBindHelper.makeDescriptors(bindingContext, tableToProcess, tableType, openl, descriptorRows, dataWithTitleRows, DataTableBindHelper.hasForeignKeysRow(horizDataTableBody), hasColumnTitleRow, true);
    }

    public static void putSubTableForBusinessView(TableSyntaxNode tableSyntaxNode, IOpenClass tableType) {
        ILogicalTable tableBody = DataTableBindHelper.getTableBody(tableSyntaxNode);
        ILogicalTable dataWithTitle = DataTableBindHelper.getSubTableForBusinessView(tableBody, tableType);
        tableSyntaxNode.getSubTables().put("business", dataWithTitle);
    }

    protected ITable makeTable(XlsModuleOpenClass xlsOpenClass, TableSyntaxNode tableSyntaxNode, String tableName, IOpenClass tableType, IBindingContext bindingContext, OpenL openl, boolean useRegistered) throws Exception {
        ITable resultTable = useRegistered ? xlsOpenClass.getDataBase().registerTable(tableName, tableSyntaxNode) : xlsOpenClass.getDataBase().registerNewTable(tableName, tableSyntaxNode);
        ILogicalTable tableBody = DataTableBindHelper.getTableBody(tableSyntaxNode);
        this.processTable(xlsOpenClass, resultTable, tableBody, tableName, tableType, bindingContext, openl, true);
        DataNodeBinder.putSubTableForBusinessView(tableSyntaxNode, tableType);
        return resultTable;
    }
}

