/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.convertor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.openl.binding.IBindingContext;
import org.openl.classloader.OpenLClassLoader;
import org.openl.meta.BigDecimalValue;
import org.openl.meta.DoubleValue;
import org.openl.rules.convertor.IString2DataConverterWithContext;
import org.openl.rules.convertor.IString2DataConvertor;
import org.openl.rules.convertor.String2ArrayConvertor;
import org.openl.rules.convertor.String2BigDecimalConvertor;
import org.openl.rules.convertor.String2BigDecimalValueConverter;
import org.openl.rules.convertor.String2BigIntegerConvertor;
import org.openl.rules.convertor.String2BooleanConvertor;
import org.openl.rules.convertor.String2ByteConvertor;
import org.openl.rules.convertor.String2CalendarConvertor;
import org.openl.rules.convertor.String2CharConvertor;
import org.openl.rules.convertor.String2CharRangeConvertor;
import org.openl.rules.convertor.String2ClassConvertor;
import org.openl.rules.convertor.String2ConstructorConvertor;
import org.openl.rules.convertor.String2DateConvertor;
import org.openl.rules.convertor.String2DoubleConvertor;
import org.openl.rules.convertor.String2DoubleRangeConvertor;
import org.openl.rules.convertor.String2DoubleValueConvertor;
import org.openl.rules.convertor.String2EnumConvertor;
import org.openl.rules.convertor.String2FloatConvertor;
import org.openl.rules.convertor.String2InstantConverter;
import org.openl.rules.convertor.String2IntConvertor;
import org.openl.rules.convertor.String2IntRangeConvertor;
import org.openl.rules.convertor.String2LocalDateConvertor;
import org.openl.rules.convertor.String2LocalDateTimeConvertor;
import org.openl.rules.convertor.String2LocalTimeConvertor;
import org.openl.rules.convertor.String2LongConvertor;
import org.openl.rules.convertor.String2OpenClassConvertor;
import org.openl.rules.convertor.String2ShortConvertor;
import org.openl.rules.convertor.String2StringConvertor;
import org.openl.rules.convertor.String2StringRangeConvertor;
import org.openl.rules.convertor.String2ZonedDateTimeConvertor;
import org.openl.rules.helpers.CharRange;
import org.openl.rules.helpers.DoubleRange;
import org.openl.rules.helpers.IntRange;
import org.openl.rules.helpers.StringRange;
import org.openl.types.IOpenClass;

public class String2DataConvertorFactory {
    private static final HashMap<Class<?>, IString2DataConvertor<?>> convertors;
    private static final Map<Class<?>, IString2DataConvertor> convertorsCache;
    private static final ReadWriteLock convertorsLock;

    public static <T> T parse(Class<T> clazz, String data, IBindingContext bindingContext) {
        if (data == null) {
            return null;
        }
        IString2DataConvertor<T> convertor = String2DataConvertorFactory.getConvertor(clazz);
        if (convertor instanceof IString2DataConverterWithContext) {
            IString2DataConverterWithContext convertorCxt = (IString2DataConverterWithContext)((Object)convertor);
            return convertorCxt.parse(data, null, bindingContext);
        }
        return convertor.parse(data, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized <T> IString2DataConvertor<T> getConvertor(Class<T> clazz) {
        IString2DataConvertor<Object> convertor;
        Lock readLock = convertorsLock.readLock();
        try {
            readLock.lock();
            if (convertorsCache.containsKey(clazz)) {
                IString2DataConvertor iString2DataConvertor = convertorsCache.get(clazz);
                return iString2DataConvertor;
            }
        }
        finally {
            readLock.unlock();
        }
        if (clazz.isEnum()) {
            convertor = new String2EnumConvertor<T>(clazz);
        } else if (clazz.isArray()) {
            Class<?> componentType = clazz.getComponentType();
            convertor = new String2ArrayConvertor(componentType);
        } else {
            convertor = new String2ConstructorConvertor<T>(clazz);
        }
        Lock writeLock = convertorsLock.writeLock();
        try {
            writeLock.lock();
            convertorsCache.put(clazz, convertor);
        }
        finally {
            writeLock.unlock();
        }
        return convertor;
    }

    private static void unregisterConvertorForClass(Class<?> clazz) {
        Lock writeLock = convertorsLock.writeLock();
        try {
            writeLock.lock();
            convertorsCache.remove(clazz);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterClassLoader(ClassLoader classLoader) {
        Lock writeLock = convertorsLock.writeLock();
        try {
            writeLock.lock();
            ArrayList toRemove = new ArrayList();
            for (Class<Object> clazz : convertorsCache.keySet()) {
                if (convertors.containsKey(clazz)) continue;
                ClassLoader cl = clazz.getClassLoader();
                if (cl == classLoader) {
                    toRemove.add(clazz);
                }
                if (!(classLoader instanceof OpenLClassLoader) || !((OpenLClassLoader)classLoader).containsClassLoader(cl)) continue;
                toRemove.add(clazz);
            }
            for (Class<Object> clazz : toRemove) {
                String2DataConvertorFactory.unregisterConvertorForClass(clazz);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    static {
        convertorsCache = new WeakHashMap();
        convertorsLock = new ReentrantReadWriteLock();
        convertors = new HashMap();
        convertors.put(Object.class, new String2StringConvertor());
        convertors.put(Serializable.class, new String2StringConvertor());
        convertors.put(Comparable.class, new String2StringConvertor());
        convertors.put(Integer.TYPE, new String2IntConvertor());
        convertors.put(Double.TYPE, new String2DoubleConvertor());
        convertors.put(Character.TYPE, new String2CharConvertor());
        convertors.put(Boolean.TYPE, new String2BooleanConvertor());
        convertors.put(Long.TYPE, new String2LongConvertor());
        convertors.put(Byte.TYPE, new String2ByteConvertor());
        convertors.put(Short.TYPE, new String2ShortConvertor());
        convertors.put(Float.TYPE, new String2FloatConvertor());
        convertors.put(Integer.class, new String2IntConvertor());
        convertors.put(Byte.class, new String2ByteConvertor());
        convertors.put(Short.class, new String2ShortConvertor());
        convertors.put(Float.class, new String2FloatConvertor());
        convertors.put(Double.class, new String2DoubleConvertor());
        convertors.put(Character.class, new String2CharConvertor());
        convertors.put(CharSequence.class, new String2StringConvertor());
        convertors.put(Boolean.class, new String2BooleanConvertor());
        convertors.put(Long.class, new String2LongConvertor());
        convertors.put(String.class, new String2StringConvertor());
        convertors.put(Date.class, new String2DateConvertor());
        convertors.put(LocalDate.class, new String2LocalDateConvertor());
        convertors.put(LocalDateTime.class, new String2LocalDateTimeConvertor());
        convertors.put(LocalTime.class, new String2LocalTimeConvertor());
        convertors.put(ZonedDateTime.class, new String2ZonedDateTimeConvertor());
        convertors.put(Instant.class, new String2InstantConverter());
        convertors.put(Calendar.class, new String2CalendarConvertor());
        convertors.put(Class.class, new String2ClassConvertor());
        convertors.put(IOpenClass.class, new String2OpenClassConvertor());
        convertors.put(DoubleValue.class, new String2DoubleValueConvertor());
        convertors.put(IntRange.class, new String2IntRangeConvertor());
        convertors.put(DoubleRange.class, new String2DoubleRangeConvertor());
        convertors.put(CharRange.class, new String2CharRangeConvertor());
        convertors.put(StringRange.class, new String2StringRangeConvertor());
        convertors.put(BigInteger.class, new String2BigIntegerConvertor());
        convertors.put(BigDecimal.class, new String2BigDecimalConvertor());
        convertors.put(BigDecimalValue.class, new String2BigDecimalValueConverter());
        Lock writeLock = convertorsLock.writeLock();
        try {
            writeLock.lock();
            convertorsCache.putAll(convertors);
        }
        finally {
            writeLock.unlock();
        }
    }
}

