/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.convertor;

import java.lang.reflect.Array;
import org.openl.binding.IBindingContext;
import org.openl.rules.convertor.IString2DataConverterWithContext;
import org.openl.rules.convertor.IString2DataConvertor;
import org.openl.rules.convertor.String2DataConvertorFactory;
import org.openl.util.StringTool;

class String2ArrayConvertor<C, T>
implements IString2DataConvertor<T>,
IString2DataConverterWithContext<T> {
    public static final String ARRAY_ELEMENTS_SEPARATOR_ESCAPER = "\\";
    public static final String ARRAY_ELEMENTS_SEPARATOR = ",";
    private final Class<C> componentType;

    public String2ArrayConvertor(Class<C> componentType) {
        this.componentType = componentType;
    }

    @Override
    public T parse(String data, String format, IBindingContext cxt) {
        if (data == null) {
            return null;
        }
        if (data.length() == 0) {
            return (T)Array.newInstance(this.componentType, 0);
        }
        String[] elementValues = StringTool.splitAndEscape((String)data, (String)ARRAY_ELEMENTS_SEPARATOR, (String)ARRAY_ELEMENTS_SEPARATOR_ESCAPER);
        Object resultArray = Array.newInstance(this.componentType, elementValues.length);
        IString2DataConvertor<C> converter = String2DataConvertorFactory.getConvertor(this.componentType);
        int i = 0;
        for (String elementValue : elementValues) {
            Object element;
            if (elementValue.length() == 0) {
                element = null;
            } else if (cxt != null && converter instanceof IString2DataConverterWithContext) {
                IString2DataConverterWithContext convertorCxt = (IString2DataConverterWithContext)((Object)converter);
                element = convertorCxt.parse(elementValue, format, cxt);
            } else {
                element = converter.parse(elementValue, format);
            }
            Array.set(resultArray, i, element);
            ++i;
        }
        return (T)resultArray;
    }

    @Override
    public T parse(String data, String format) {
        return this.parse(data, format, null);
    }
}

