/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.convertor;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.openl.meta.BigDecimalValue;
import org.openl.meta.BigIntegerValue;
import org.openl.meta.ByteValue;
import org.openl.meta.DoubleValue;
import org.openl.meta.FloatValue;
import org.openl.meta.IntValue;
import org.openl.meta.LongValue;
import org.openl.meta.ShortValue;
import org.openl.meta.StringValue;
import org.openl.rules.convertor.IObjectToDataConvertor;
import org.openl.rules.convertor.LocaleDependConvertor;
import org.openl.rules.helpers.IntRange;
import org.openl.util.RuntimeExceptionWrapper;

public class ObjectToDataConvertorFactory {
    private static final Map<ClassCastPair, IObjectToDataConvertor> converters = new ConcurrentHashMap<ClassCastPair, IObjectToDataConvertor>();
    public static final IObjectToDataConvertor NO_Convertor;

    public static IObjectToDataConvertor getConvertor(Class<?> toClass, Class<?> fromClass) {
        Constructor ctr;
        if (toClass == fromClass) {
            return CopyConvertor.the;
        }
        ClassCastPair pair = new ClassCastPair(fromClass, toClass);
        IObjectToDataConvertor convertor = converters.get(pair);
        if (convertor != null) {
            return convertor;
        }
        Method method = ObjectToDataConvertorFactory.getValueOfMethod(toClass, fromClass);
        convertor = method != null ? new StaticMethodConvertor(method) : ((ctr = ConstructorUtils.getMatchingAccessibleConstructor(toClass, (Class[])new Class[]{fromClass})) != null ? new MatchedConstructorConvertor(ctr) : NO_Convertor);
        converters.put(pair, convertor);
        return convertor;
    }

    private static Method getValueOfMethod(Class<?> toClass, Class<?> fromClass) {
        if (fromClass == null) {
            return null;
        }
        Method method = MethodUtils.getAccessibleMethod(toClass, (String)"valueOf", (Class[])new Class[]{fromClass});
        return method == null ? MethodUtils.getAccessibleMethod(toClass, (String)"valueOf", (Class[])new Class[]{Object.class}) : method;
    }

    public static IObjectToDataConvertor registerConvertor(Class<?> toClass, Class<?> fromClass, IObjectToDataConvertor convertor) {
        ClassCastPair pair = new ClassCastPair(fromClass, toClass);
        return converters.put(pair, convertor);
    }

    static {
        try {
            converters.put(new ClassCastPair(Integer.class, IntRange.class), e -> new IntRange(((Integer)e).intValue()));
            converters.put(new ClassCastPair(Integer.TYPE, IntRange.class), e -> new IntRange(((Integer)e).intValue()));
            converters.put(new ClassCastPair(Double.class, DoubleValue.class), e -> new DoubleValue(((Double)e).doubleValue()));
            converters.put(new ClassCastPair(Double.class, Double.TYPE), CopyConvertor.the);
            converters.put(new ClassCastPair(Double.TYPE, Double.class), CopyConvertor.the);
            converters.put(new ClassCastPair(Integer.TYPE, Integer.class), CopyConvertor.the);
            converters.put(new ClassCastPair(Integer.class, Integer.TYPE), CopyConvertor.the);
            converters.put(new ClassCastPair(Double.TYPE, DoubleValue.class), e -> new DoubleValue(((Double)e).doubleValue()));
            converters.put(new ClassCastPair(Date.class, Calendar.class), e -> {
                Calendar cal = Calendar.getInstance(LocaleDependConvertor.getLocale());
                cal.setTime((Date)e);
                return cal;
            });
            converters.put(new ClassCastPair(Date.class, LocalDate.class), e -> Instant.ofEpochMilli(((Date)e).getTime()).atZone(ZoneId.systemDefault()).toLocalDate());
            converters.put(new ClassCastPair(Date.class, ZonedDateTime.class), e -> ZonedDateTime.ofInstant(Instant.ofEpochMilli(((Date)e).getTime()), ZoneId.systemDefault()));
            converters.put(new ClassCastPair(Date.class, Instant.class), e -> ((Date)e).toInstant());
            converters.put(new ClassCastPair(Date.class, LocalTime.class), e -> Instant.ofEpochMilli(((Date)e).getTime()).atZone(ZoneId.systemDefault()).toLocalTime());
            converters.put(new ClassCastPair(Date.class, LocalDateTime.class), e -> Instant.ofEpochMilli(((Date)e).getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime());
            converters.put(new ClassCastPair(ByteValue.class, Byte.class), new GetValueConvertor());
            converters.put(new ClassCastPair(ShortValue.class, Short.class), new GetValueConvertor());
            converters.put(new ClassCastPair(IntValue.class, Integer.class), new GetValueConvertor());
            converters.put(new ClassCastPair(LongValue.class, Long.class), new GetValueConvertor());
            converters.put(new ClassCastPair(FloatValue.class, Float.class), new GetValueConvertor());
            converters.put(new ClassCastPair(DoubleValue.class, Double.class), new GetValueConvertor());
            converters.put(new ClassCastPair(BigIntegerValue.class, BigInteger.class), new GetValueConvertor());
            converters.put(new ClassCastPair(BigDecimalValue.class, BigDecimal.class), new GetValueConvertor());
            converters.put(new ClassCastPair(StringValue.class, String.class), new GetValueConvertor());
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        NO_Convertor = e -> new UnsupportedOperationException();
    }

    public static class GetValueConvertor
    implements IObjectToDataConvertor {
        @Override
        public Object convert(Object data) {
            if (data != null) {
                Object value;
                Method getValueMethod;
                try {
                    getValueMethod = data.getClass().getMethod("getValue", new Class[0]);
                }
                catch (Exception e) {
                    throw RuntimeExceptionWrapper.wrap((Throwable)e);
                }
                try {
                    value = getValueMethod.invoke(data, new Object[0]);
                }
                catch (Exception e) {
                    throw RuntimeExceptionWrapper.wrap((Throwable)e);
                }
                return value;
            }
            return null;
        }
    }

    public static class CopyConvertor
    implements IObjectToDataConvertor {
        public static final CopyConvertor the = new CopyConvertor();

        @Override
        public Object convert(Object data) {
            return data;
        }
    }

    public static class StaticMethodConvertor
    implements IObjectToDataConvertor {
        private final Method staticMethod;

        public StaticMethodConvertor(Method staticMethod) {
            if (!Modifier.isStatic(staticMethod.getModifiers())) {
                throw new IllegalArgumentException("Income method should be static");
            }
            this.staticMethod = staticMethod;
        }

        @Override
        public Object convert(Object data) {
            try {
                return this.staticMethod.invoke(null, data);
            }
            catch (Exception e) {
                throw RuntimeExceptionWrapper.wrap((Throwable)e);
            }
        }
    }

    public static class MatchedConstructorConvertor
    implements IObjectToDataConvertor {
        private final Constructor<?> ctr;

        public MatchedConstructorConvertor(Constructor<?> ctr) {
            this.ctr = ctr;
        }

        @Override
        public Object convert(Object data) {
            try {
                return this.ctr.newInstance(data);
            }
            catch (Exception e) {
                throw RuntimeExceptionWrapper.wrap((Throwable)e);
            }
        }
    }

    public static class ClassCastPair {
        private final Class<?> from;
        private final Class<?> to;

        public ClassCastPair(Class<?> from, Class<?> to) {
            this.from = from;
            this.to = to;
        }

        public Class<?> getFrom() {
            return this.from;
        }

        public Class<?> getTo() {
            return this.to;
        }

        public int hashCode() {
            return this.to.hashCode() + this.from.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ClassCastPair)) {
                return false;
            }
            ClassCastPair pair = (ClassCastPair)obj;
            return this.from == pair.from && this.to == pair.to;
        }
    }
}

