/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.context;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.openl.rules.context.IRulesRuntimeContext;
import org.openl.rules.context.IRulesRuntimeContextOptimizationForOpenMethodDispatcher;
import org.openl.rules.enumeration.CaProvincesEnum;
import org.openl.rules.enumeration.CaRegionsEnum;
import org.openl.rules.enumeration.CountriesEnum;
import org.openl.rules.enumeration.CurrenciesEnum;
import org.openl.rules.enumeration.LanguagesEnum;
import org.openl.rules.enumeration.RegionsEnum;
import org.openl.rules.enumeration.UsRegionsEnum;
import org.openl.rules.enumeration.UsStatesEnum;
import org.openl.rules.types.OpenMethodDispatcher;
import org.openl.types.IOpenMethod;

public class DefaultRulesRuntimeContext
implements IRulesRuntimeContext,
IRulesRuntimeContextOptimizationForOpenMethodDispatcher,
Serializable {
    private static final long serialVersionUID = 670283457423670894L;
    private Map<String, Object> internalMap = new HashMap<String, Object>();
    private transient Map<IOpenMethod, IOpenMethod> cache = null;
    private Date currentDate = null;
    private Date requestDate = null;
    private String lob = null;
    private String nature = null;
    private UsStatesEnum usState = null;
    private CountriesEnum country = null;
    private UsRegionsEnum usRegion = null;
    private CurrenciesEnum currency = null;
    private LanguagesEnum lang = null;
    private RegionsEnum region = null;
    private CaProvincesEnum caProvince = null;
    private CaRegionsEnum caRegion = null;
    public static final Map<String, Class<?>> CONTEXT_PROPERTIES;

    @Override
    public Object getValue(String name) {
        return this.internalMap.get(name);
    }

    public String toString() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(out);
        DefaultRulesRuntimeContext.verbosePrint(printStream, null, this.internalMap, new ArrayDeque());
        return out.toString();
    }

    @Override
    public IOpenMethod getMethodForOpenMethodDispatcher(OpenMethodDispatcher openMethodDispatcher) {
        if (this.cache == null) {
            return null;
        }
        return this.cache.get(openMethodDispatcher);
    }

    @Override
    public void putMethodForOpenMethodDispatcher(OpenMethodDispatcher openMethodDispatcher, IOpenMethod method) {
        if (this.cache == null) {
            this.cache = new HashMap<IOpenMethod, IOpenMethod>();
        }
        this.cache.put(openMethodDispatcher, method);
    }

    private static void verbosePrint(PrintStream out, Object label, Map<?, ?> map, ArrayDeque<Map<?, ?>> lineage) {
        DefaultRulesRuntimeContext.printIndent(out, lineage.size());
        if (map == null) {
            if (label != null) {
                out.print(label);
                out.print(" = ");
            }
            out.print("null\r\n");
            return;
        }
        if (label != null) {
            out.print(label);
            out.print(" = \r\n");
        }
        DefaultRulesRuntimeContext.printIndent(out, lineage.size());
        out.print("{\r\n");
        lineage.push(map);
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object childKey = entry.getKey();
            Object childValue = entry.getValue();
            if (childValue instanceof Map && !lineage.contains(childValue)) {
                DefaultRulesRuntimeContext.verbosePrint(out, childKey == null ? "null" : childKey, (Map)childValue, lineage);
                continue;
            }
            DefaultRulesRuntimeContext.printIndent(out, lineage.size());
            out.print(childKey);
            out.print(" = ");
            if (!lineage.contains(childValue)) {
                out.print(childValue);
            } else if (lineage.getFirst().equals(childValue)) {
                out.print("(this Map)");
            } else {
                out.print("(ancestor[?] Map)");
            }
            out.print("\r\n");
        }
        lineage.pop();
        DefaultRulesRuntimeContext.printIndent(out, lineage.size());
        out.print("}\r\n");
    }

    private static void printIndent(PrintStream out, int indent) {
        for (int i = 0; i < indent; ++i) {
            out.print("    ");
        }
    }

    @Override
    public IRulesRuntimeContext clone() throws CloneNotSupportedException {
        DefaultRulesRuntimeContext defaultRulesRuntimeContext = (DefaultRulesRuntimeContext)super.clone();
        defaultRulesRuntimeContext.internalMap = new HashMap<String, Object>(this.internalMap);
        return defaultRulesRuntimeContext;
    }

    @Override
    public void setValue(String name, Object value) {
        if ("currentDate".equals(name)) {
            this.setCurrentDate((Date)value);
            return;
        }
        if ("requestDate".equals(name)) {
            this.setRequestDate((Date)value);
            return;
        }
        if ("lob".equals(name)) {
            this.setLob((String)value);
            return;
        }
        if ("nature".equals(name)) {
            this.setNature((String)value);
            return;
        }
        if ("usState".equals(name)) {
            this.setUsState((UsStatesEnum)((Object)value));
            return;
        }
        if ("country".equals(name)) {
            this.setCountry((CountriesEnum)((Object)value));
            return;
        }
        if ("usRegion".equals(name)) {
            this.setUsRegion((UsRegionsEnum)((Object)value));
            return;
        }
        if ("currency".equals(name)) {
            this.setCurrency((CurrenciesEnum)((Object)value));
            return;
        }
        if ("lang".equals(name)) {
            this.setLang((LanguagesEnum)((Object)value));
            return;
        }
        if ("region".equals(name)) {
            this.setRegion((RegionsEnum)((Object)value));
            return;
        }
        if ("caProvince".equals(name)) {
            this.setCaProvince((CaProvincesEnum)((Object)value));
            return;
        }
        if ("caRegion".equals(name)) {
            this.setCaRegion((CaRegionsEnum)((Object)value));
            return;
        }
    }

    @Override
    public Date getCurrentDate() {
        return this.currentDate;
    }

    @Override
    public void setCurrentDate(Date currentDate) {
        this.currentDate = currentDate;
        this.internalMap.put("currentDate", currentDate);
        this.cache = null;
    }

    @Override
    public Date getRequestDate() {
        return this.requestDate;
    }

    @Override
    public void setRequestDate(Date requestDate) {
        this.requestDate = requestDate;
        this.internalMap.put("requestDate", requestDate);
        this.cache = null;
    }

    @Override
    public String getLob() {
        return this.lob;
    }

    @Override
    public void setLob(String lob) {
        this.lob = lob;
        this.internalMap.put("lob", lob);
        this.cache = null;
    }

    @Override
    public String getNature() {
        return this.nature;
    }

    @Override
    public void setNature(String nature) {
        this.nature = nature;
        this.internalMap.put("nature", nature);
        this.cache = null;
    }

    @Override
    public UsStatesEnum getUsState() {
        return this.usState;
    }

    @Override
    public void setUsState(UsStatesEnum usState) {
        this.usState = usState;
        this.internalMap.put("usState", (Object)usState);
        this.cache = null;
    }

    @Override
    public CountriesEnum getCountry() {
        return this.country;
    }

    @Override
    public void setCountry(CountriesEnum country) {
        this.country = country;
        this.internalMap.put("country", (Object)country);
        this.cache = null;
    }

    @Override
    public UsRegionsEnum getUsRegion() {
        return this.usRegion;
    }

    @Override
    public void setUsRegion(UsRegionsEnum usRegion) {
        this.usRegion = usRegion;
        this.internalMap.put("usRegion", (Object)usRegion);
        this.cache = null;
    }

    @Override
    public CurrenciesEnum getCurrency() {
        return this.currency;
    }

    @Override
    public void setCurrency(CurrenciesEnum currency) {
        this.currency = currency;
        this.internalMap.put("currency", (Object)currency);
        this.cache = null;
    }

    @Override
    public LanguagesEnum getLang() {
        return this.lang;
    }

    @Override
    public void setLang(LanguagesEnum lang) {
        this.lang = lang;
        this.internalMap.put("lang", (Object)lang);
        this.cache = null;
    }

    @Override
    public RegionsEnum getRegion() {
        return this.region;
    }

    @Override
    public void setRegion(RegionsEnum region) {
        this.region = region;
        this.internalMap.put("region", (Object)region);
        this.cache = null;
    }

    @Override
    public CaProvincesEnum getCaProvince() {
        return this.caProvince;
    }

    @Override
    public void setCaProvince(CaProvincesEnum caProvince) {
        this.caProvince = caProvince;
        this.internalMap.put("caProvince", (Object)caProvince);
        this.cache = null;
    }

    @Override
    public CaRegionsEnum getCaRegion() {
        return this.caRegion;
    }

    @Override
    public void setCaRegion(CaRegionsEnum caRegion) {
        this.caRegion = caRegion;
        this.internalMap.put("caRegion", (Object)caRegion);
        this.cache = null;
    }

    static {
        TreeMap<String, Class<CaRegionsEnum>> contextFields = new TreeMap<String, Class<CaRegionsEnum>>();
        contextFields.put("currentDate", Date.class);
        contextFields.put("requestDate", Date.class);
        contextFields.put("lob", String.class);
        contextFields.put("nature", String.class);
        contextFields.put("usState", UsStatesEnum.class);
        contextFields.put("country", CountriesEnum.class);
        contextFields.put("usRegion", UsRegionsEnum.class);
        contextFields.put("currency", CurrenciesEnum.class);
        contextFields.put("lang", LanguagesEnum.class);
        contextFields.put("region", RegionsEnum.class);
        contextFields.put("caProvince", CaProvincesEnum.class);
        contextFields.put("caRegion", CaRegionsEnum.class);
        CONTEXT_PROPERTIES = Collections.unmodifiableMap(contextFields);
    }

    public static class IRulesRuntimeContextAdapter
    extends XmlAdapter<DefaultRulesRuntimeContext, IRulesRuntimeContext> {
        public DefaultRulesRuntimeContext marshal(IRulesRuntimeContext v) {
            return (DefaultRulesRuntimeContext)v;
        }

        public IRulesRuntimeContext unmarshal(DefaultRulesRuntimeContext v) {
            return v;
        }
    }
}

