/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.cmatch.matcher;

import org.openl.rules.cmatch.matcher.IMatcher;
import org.openl.rules.convertor.IString2DataConvertor;
import org.openl.rules.convertor.String2DataConvertorFactory;
import org.openl.rules.helpers.INumberRange;

public class NumberMatchMatcher
implements IMatcher {
    private final Class<?> directClass;
    private final Class<?> rangeClass;

    public NumberMatchMatcher(Class<?> directClass, Class<?> rangeClass) {
        this.directClass = directClass;
        this.rangeClass = rangeClass;
    }

    @Override
    public Object fromString(String checkValue) {
        if (checkValue.length() == 0) {
            return null;
        }
        try {
            IString2DataConvertor<?> convertor = String2DataConvertorFactory.getConvertor(this.directClass);
            return convertor.parse(checkValue, null);
        }
        catch (RuntimeException e) {
            RuntimeException directParseException = e;
            try {
                IString2DataConvertor<?> convertor = String2DataConvertorFactory.getConvertor(this.rangeClass);
                return convertor.parse(checkValue, null);
            }
            catch (Exception e2) {
                throw directParseException;
            }
        }
    }

    protected Class<?> getDirectClass() {
        return this.directClass;
    }

    @Override
    public boolean match(Object var, Object checkValue) {
        if (checkValue == null) {
            return false;
        }
        if (checkValue instanceof INumberRange) {
            INumberRange range = (INumberRange)checkValue;
            return range.containsNumber((Number)var);
        }
        return checkValue.equals(var);
    }
}

