/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.cmatch.algorithm;

import java.util.LinkedList;
import java.util.List;
import org.openl.binding.IBindingContext;
import org.openl.rules.binding.RuleRowHelper;
import org.openl.rules.cmatch.ColumnMatch;
import org.openl.rules.cmatch.MatchNode;
import org.openl.rules.cmatch.SubValue;
import org.openl.rules.cmatch.TableRow;
import org.openl.rules.cmatch.algorithm.ArgumentsHelper;
import org.openl.rules.cmatch.algorithm.ColumnDefinition;
import org.openl.rules.cmatch.algorithm.MatchAlgorithmCompiler;
import org.openl.rules.cmatch.algorithm.WeightAlgorithmExecutor;
import org.openl.rules.cmatch.matcher.IMatcher;
import org.openl.rules.cmatch.matcher.MatcherFactory;
import org.openl.rules.constants.ConstantOpenField;
import org.openl.rules.convertor.IString2DataConvertor;
import org.openl.rules.convertor.String2DataConvertorFactory;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IOpenClass;
import org.openl.types.java.JavaOpenClass;

public class WeightAlgorithmCompiler
extends MatchAlgorithmCompiler {
    public static final String WEIGHT = "weight";
    public static final String ROW_TOTAL_SCORE = "Total Score";
    public static final String ROW_SCORE = "Score";
    public static final int ROW_TOTAL_SCORE_IDX = 1;
    public static final int ROW_SCORE_IDX = 2;
    protected static final List<ColumnDefinition> WEIGHT_COLUMN_DEFINITION = new LinkedList<ColumnDefinition>();
    private static final WeightAlgorithmExecutor WEIGHT_EXECUTOR = new WeightAlgorithmExecutor();

    @Override
    protected void assignExecutor(ColumnMatch columnMatch) {
        columnMatch.setAlgorithmExecutor(WEIGHT_EXECUTOR);
    }

    @Override
    protected MatchNode buildTree(List<TableRow> rows, MatchNode[] nodes) throws SyntaxNodeException {
        MatchNode rootNode = new MatchNode(-1);
        for (int i = this.getSpecialRowCount(); i < rows.size(); ++i) {
            MatchNode node = nodes[i];
            TableRow row = rows.get(i);
            SubValue nameSV = row.get("names")[0];
            int indent = nameSV.getIndent();
            if (indent != 0) {
                String msg = "Sub node are prohibited here.";
                throw SyntaxNodeExceptionUtils.createError((String)msg, (IOpenSourceCodeModule)nameSV.getStringValue().asSourceCodeModule());
            }
            rootNode.add(node);
        }
        return rootNode;
    }

    @Override
    protected void checkSpecialRows(ColumnMatch columnMatch) throws SyntaxNodeException {
        super.checkSpecialRows(columnMatch);
        List<TableRow> rows = columnMatch.getRows();
        this.checkRowName(rows.get(1), ROW_TOTAL_SCORE);
        this.checkRowName(rows.get(2), ROW_SCORE);
    }

    @Override
    protected List<ColumnDefinition> getColumnDefinition() {
        return WEIGHT_COLUMN_DEFINITION;
    }

    @Override
    protected int getSpecialRowCount() {
        return 3;
    }

    @Override
    protected void parseSpecialRows(IBindingContext bindingContext, ColumnMatch columnMatch) throws SyntaxNodeException {
        super.parseSpecialRows(bindingContext, columnMatch);
        int retValuesCount = columnMatch.getReturnValues().length;
        MatchNode totalScore = new MatchNode(1);
        TableRow totalScoreRow = columnMatch.getRows().get(1);
        SubValue operationSV = totalScoreRow.get("operation")[0];
        IMatcher totalScoreMatcher = MatcherFactory.getMatcher(operationSV.getString(), (IOpenClass)JavaOpenClass.getOpenClass(Integer.class));
        if (totalScoreMatcher == null) {
            String msg = "Column operation of special row Total Score must be defined.";
            throw SyntaxNodeExceptionUtils.createError((String)msg, (IOpenSourceCodeModule)operationSV.getStringValue().asSourceCodeModule());
        }
        totalScore.setMatcher(totalScoreMatcher);
        this.parseCheckValues(bindingContext, columnMatch, totalScoreRow, totalScore, retValuesCount);
        columnMatch.setTotalScore(totalScore);
        TableRow scoreRow = columnMatch.getRows().get(2);
        operationSV = scoreRow.get("operation")[0];
        if (!"".equals(operationSV.getString())) {
            String msg = "Column operation of special row Score must be empty.";
            throw SyntaxNodeExceptionUtils.createError((String)msg, (IOpenSourceCodeModule)operationSV.getStringValue().asSourceCodeModule());
        }
        Object[] objScores = this.parseValues(bindingContext, columnMatch, scoreRow, (IOpenClass)JavaOpenClass.getOpenClass(Integer.class));
        int[] scores = new int[retValuesCount];
        for (int i = 0; i < retValuesCount; ++i) {
            scores[i] = (Integer)objScores[i];
        }
        columnMatch.setColumnScores(scores);
    }

    @Override
    protected MatchNode[] prepareNodes(IBindingContext bindingContext, ColumnMatch columnMatch, ArgumentsHelper argumentsHelper, int retValuesCount) throws SyntaxNodeException {
        MatchNode[] nodes = super.prepareNodes(bindingContext, columnMatch, argumentsHelper, retValuesCount);
        List<TableRow> rows = columnMatch.getRows();
        for (int i = this.getSpecialRowCount(); i < rows.size(); ++i) {
            Integer rowWeight;
            TableRow row = rows.get(i);
            SubValue weightSV = row.get(WEIGHT)[0];
            ConstantOpenField constantOpenField = RuleRowHelper.findConstantField(bindingContext, weightSV.getString());
            if (constantOpenField != null && constantOpenField.getValue() != null) {
                this.setMetaInfoForConstant(bindingContext, columnMatch, weightSV, weightSV.getString(), constantOpenField);
                rowWeight = (Integer)RuleRowHelper.castConstantToExpectedType(bindingContext, constantOpenField, (IOpenClass)JavaOpenClass.getOpenClass(Integer.class));
            } else {
                IString2DataConvertor<Integer> convertor = String2DataConvertorFactory.getConvertor(Integer.class);
                rowWeight = convertor.parse(weightSV.getString(), null);
            }
            nodes[i].setWeight(rowWeight);
        }
        return nodes;
    }

    @Override
    protected void validateTree(MatchNode rootNode, List<TableRow> rows, MatchNode[] nodes) {
    }

    static {
        WEIGHT_COLUMN_DEFINITION.addAll(MATCH_COLUMN_DEFINITION);
        WEIGHT_COLUMN_DEFINITION.add(new ColumnDefinition(WEIGHT, false));
    }
}

