/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.openl.binding.impl.AllowOnlyStrictFieldMatchType;
import org.openl.rules.calc.CustomSpreadsheetResultOpenClass;
import org.openl.rules.calc.SpreadsheetResultOpenClass;
import org.openl.rules.calc.SpreadsheetResultRootDictionaryContext;
import org.openl.rules.calc.SpreadsheetStructureBuilder;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.Point;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.java.CustomJavaOpenClass;
import org.openl.util.ClassUtils;
import org.openl.util.CollectionUtils;
import org.slf4j.LoggerFactory;

@XmlRootElement
@CustomJavaOpenClass(type=SpreadsheetResultOpenClass.class, variableInContextFinder=SpreadsheetResultRootDictionaryContext.class)
@AllowOnlyStrictFieldMatchType
public class SpreadsheetResult
implements Serializable {
    private static final int MAX_WIDTH = 4;
    private static final int MAX_HEIGHT = 10;
    private static final int MAX_DEPTH = 2;
    private static final int MAX_VALUE_LENGTH = 10240;
    Object[][] results;
    String[] columnNames;
    String[] rowNames;
    transient String[] rowNamesForResultModel;
    transient String[] columnNamesForResultModel;
    transient Map<String, Point> fieldsCoordinates;
    transient boolean tableStructureDetails;
    private transient ILogicalTable logicalTable;
    private transient CustomSpreadsheetResultOpenClass customSpreadsheetResultOpenClass;
    private static final ThreadLocal<Integer> DEPTH_LOCAL_THREAD = new ThreadLocal();

    public SpreadsheetResult() {
    }

    public SpreadsheetResult(Object[][] results, String[] rowNames, String[] columnNames) {
        this(results, rowNames, columnNames, new String[rowNames.length], new String[columnNames.length], null);
        this.initFieldsCoordinates();
    }

    public SpreadsheetResult(Object[][] results, String[] rowNames, String[] columnNames, String[] rowNamesForResultModel, String[] columnNamesForResultModel, Map<String, Point> fieldsCoordinates) {
        this.rowNames = Objects.requireNonNull(rowNames);
        this.columnNames = Objects.requireNonNull(columnNames);
        this.rowNamesForResultModel = Objects.requireNonNull(rowNamesForResultModel);
        this.columnNamesForResultModel = Objects.requireNonNull(columnNamesForResultModel);
        if (rowNames.length != rowNamesForResultModel.length) {
            throw new IllegalArgumentException("The length of rowNames is not equal to the length of rowNamesForResultModel.");
        }
        if (columnNames.length != columnNamesForResultModel.length) {
            throw new IllegalArgumentException("The length of columnNames is not equal to the length of columnNamesForResultModel.");
        }
        this.results = results;
        this.fieldsCoordinates = fieldsCoordinates;
    }

    public SpreadsheetResult(SpreadsheetResult spr) {
        this(spr.results, spr.rowNames, spr.columnNames, spr.rowNamesForResultModel, spr.columnNamesForResultModel, spr.fieldsCoordinates);
        this.logicalTable = spr.logicalTable;
        this.customSpreadsheetResultOpenClass = spr.customSpreadsheetResultOpenClass;
        this.tableStructureDetails = spr.tableStructureDetails;
    }

    public boolean isFieldUsedInModel(String fieldName) {
        Point point = this.fieldsCoordinates.get(fieldName);
        if (point != null) {
            return this.columnNamesForResultModel[point.getColumn()] != null && this.rowNamesForResultModel[point.getRow()] != null;
        }
        return false;
    }

    static Map<String, Point> buildFieldsCoordinates(String[] columnNames, String[] rowNames) {
        HashMap<String, Point> fieldsCoordinates = new HashMap<String, Point>();
        if (columnNames != null && rowNames != null) {
            long nonNullsColumnsCount = Arrays.stream(columnNames).filter(Objects::nonNull).count();
            long nonNullsRowsCount = Arrays.stream(rowNames).filter(Objects::nonNull).count();
            boolean isSingleColumn = nonNullsColumnsCount == 1L;
            boolean isSingleRow = nonNullsRowsCount == 1L;
            for (int i = 0; i < rowNames.length; ++i) {
                for (int j = 0; j < columnNames.length; ++j) {
                    if (columnNames[j] == null || rowNames[i] == null) continue;
                    fieldsCoordinates.put(SpreadsheetStructureBuilder.getSpreadsheetCellFieldName(columnNames[j], rowNames[i]), Point.get(j, i));
                    if (isSingleColumn) {
                        fieldsCoordinates.put("$" + rowNames[i], Point.get(j, i));
                        continue;
                    }
                    if (!isSingleRow) continue;
                    fieldsCoordinates.put("$" + columnNames[j], Point.get(j, i));
                }
            }
        }
        return fieldsCoordinates;
    }

    private void initFieldsCoordinates() {
        this.fieldsCoordinates = SpreadsheetResult.buildFieldsCoordinates(this.columnNames, this.rowNames);
    }

    @XmlTransient
    public int getHeight() {
        return this.rowNames.length;
    }

    public Object[][] getResults() {
        return this.results;
    }

    public void setResults(Object[][] results) {
        this.results = (Object[][])results.clone();
    }

    @XmlTransient
    public int getWidth() {
        return this.columnNames.length;
    }

    public String[] getColumnNames() {
        return (String[])this.columnNames.clone();
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
    }

    public String[] getRowNames() {
        return (String[])this.rowNames.clone();
    }

    public void setRowNames(String[] rowNames) {
        this.rowNames = rowNames;
    }

    @XmlTransient
    public boolean isTableStructureDetails() {
        return this.tableStructureDetails;
    }

    public void setTableStructureDetails(boolean tableStructureDetails) {
        this.tableStructureDetails = tableStructureDetails;
    }

    public Object getValue(int row, int column) {
        return this.results[row][column];
    }

    public void setFieldValue(String name, Object value) {
        Point fieldCoordinates;
        if (this.fieldsCoordinates == null) {
            this.initFieldsCoordinates();
        }
        if ((fieldCoordinates = this.fieldsCoordinates.get(name)) != null) {
            this.setValue(fieldCoordinates.getRow(), fieldCoordinates.getColumn(), value);
        }
    }

    protected void setValue(int row, int column, Object value) {
        this.results[row][column] = value;
    }

    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    public String getRowName(int row) {
        return this.rowNames[row];
    }

    @XmlTransient
    public ILogicalTable getLogicalTable() {
        return this.logicalTable;
    }

    public void setLogicalTable(ILogicalTable logicalTable) {
        this.logicalTable = logicalTable;
    }

    public Object getFieldValue(String name) {
        Point fieldCoordinates;
        if (this.fieldsCoordinates == null) {
            this.initFieldsCoordinates();
        }
        if ((fieldCoordinates = this.fieldsCoordinates.get(name)) != null) {
            return this.getValue(fieldCoordinates.getRow(), fieldCoordinates.getColumn());
        }
        return null;
    }

    public boolean hasField(String name) {
        if (this.fieldsCoordinates == null) {
            this.initFieldsCoordinates();
        }
        return this.fieldsCoordinates.get(name) != null;
    }

    public String toString() {
        try {
            if (CollectionUtils.isEmpty((Object[])this.rowNames) || CollectionUtils.isEmpty((Object[])this.columnNames)) {
                return "[EMPTY]";
            }
            return this.printTable();
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).debug(e.getMessage(), (Throwable)e);
            return super.toString();
        }
    }

    private String truncateStringValue(String value) {
        if (value == null) {
            return "";
        }
        if (value.length() > 10240) {
            return value.substring(0, 10240) + " ... TRUNCATED ...";
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String printTable() {
        StringBuilder sb = new StringBuilder();
        Integer d = DEPTH_LOCAL_THREAD.get();
        d = d != null ? d : 0;
        try {
            DEPTH_LOCAL_THREAD.set(d + 1);
            int maxWidth = Math.min(4, this.getWidth());
            int maxHeight = Math.min(10, this.getHeight());
            int[] width = new int[maxWidth + 1];
            for (int i1 = 0; i1 <= maxHeight; ++i1) {
                for (int j1 = 0; j1 <= maxWidth; ++j1) {
                    width[j1] = Math.max(width[j1], i1 > 0 && j1 > 0 && this.getValue(i1 - 1, j1 - 1) instanceof SpreadsheetResult && d > 2 ? "... TRUNCATED TABLE ...".length() : this.truncateStringValue(this.getStringValue(j1, i1)).length());
                }
            }
            for (int i = 0; i <= maxHeight; ++i) {
                for (int j = 0; j <= maxWidth; ++j) {
                    if (j != 0) {
                        sb.append(" | ");
                    }
                    String cell = i > 0 && j > 0 && this.getValue(i - 1, j - 1) instanceof SpreadsheetResult && d > 2 ? "... TRUNCATED TABLE ..." : this.truncateStringValue(this.getStringValue(j, i));
                    sb.append(cell);
                    for (int k = 0; k < width[j] - cell.length(); ++k) {
                        sb.append(' ');
                    }
                }
                sb.append('\n');
            }
            if (this.getWidth() > 4 || this.getHeight() > 10) {
                sb.append("... TRUNCATED TABLE ...");
            }
        }
        finally {
            if (d == 0) {
                DEPTH_LOCAL_THREAD.remove();
            } else {
                DEPTH_LOCAL_THREAD.set(d);
            }
        }
        return sb.toString();
    }

    private String getStringValue(int col, int row) {
        if (col == 0 && row == 0) {
            return "-X-";
        }
        if (col == 0) {
            return this.getRowName(row - 1);
        }
        if (row == 0) {
            return this.getColumnName(col - 1);
        }
        Object value = this.getValue(row - 1, col - 1);
        if (value == null) {
            return "";
        }
        String s = Arrays.deepToString(new Object[]{value});
        return s.substring(1, s.length() - 1);
    }

    @XmlTransient
    public CustomSpreadsheetResultOpenClass getCustomSpreadsheetResultOpenClass() {
        return this.customSpreadsheetResultOpenClass;
    }

    public void setCustomSpreadsheetResultOpenClass(CustomSpreadsheetResultOpenClass customSpreadsheetResultOpenClass) {
        this.customSpreadsheetResultOpenClass = customSpreadsheetResultOpenClass;
    }

    public Map<String, Object> toMap() {
        return this.toMap(null);
    }

    private Object toPlain(XlsModuleOpenClass module) {
        if (module == null) {
            return this.toMap(null);
        }
        if (this.getCustomSpreadsheetResultOpenClass() != null) {
            IOpenClass openClass = module.findType(this.getCustomSpreadsheetResultOpenClass().getName());
            if (openClass instanceof CustomSpreadsheetResultOpenClass) {
                return ((CustomSpreadsheetResultOpenClass)openClass).createBean(this);
            }
            throw new IllegalStateException(String.format("Custom spreadsheet type '%s' is not found in the module.", this.getCustomSpreadsheetResultOpenClass().getName()));
        }
        return this.toMap(module);
    }

    private Map<String, Object> toMap(XlsModuleOpenClass module) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (this.columnNames != null && this.rowNames != null) {
            String[][] TableDetails;
            long nonNullsColumnsCount = Arrays.stream(this.columnNamesForResultModel).filter(Objects::nonNull).count();
            long nonNullsRowsCount = Arrays.stream(this.rowNamesForResultModel).filter(Objects::nonNull).count();
            boolean isSingleRow = nonNullsRowsCount == 1L;
            boolean isSingleColumn = nonNullsColumnsCount == 1L;
            boolean isTableStructureDetailsPresented = this.tableStructureDetails;
            String[][] stringArray = TableDetails = isTableStructureDetailsPresented ? new String[this.rowNames.length][this.columnNames.length] : (String[][])null;
            if (this.customSpreadsheetResultOpenClass != null) {
                CustomSpreadsheetResultOpenClass csrt = module != null ? (CustomSpreadsheetResultOpenClass)module.findType(this.customSpreadsheetResultOpenClass.getName()) : this.customSpreadsheetResultOpenClass;
                Map<String, String> xmlNamesMap = csrt.getXmlNamesMap();
                for (Map.Entry<String, List<IOpenField>> e : csrt.getBeanFieldsMap().entrySet()) {
                    List<IOpenField> openFields = e.getValue();
                    for (IOpenField openField : openFields) {
                        Point p = this.fieldsCoordinates.get(openField.getName());
                        if (p == null || this.columnNamesForResultModel[p.getColumn()] == null || this.rowNamesForResultModel[p.getRow()] == null) continue;
                        values.put(xmlNamesMap.get(e.getKey()), SpreadsheetResult.convertSpreadsheetResult(module, this.getValue(p.getRow(), p.getColumn())));
                        if (!isTableStructureDetailsPresented) continue;
                        TableDetails[p.getRow()][p.getColumn()] = xmlNamesMap.get(e.getKey());
                    }
                }
            } else {
                for (int i = 0; i < this.rowNamesForResultModel.length; ++i) {
                    for (int j = 0; j < this.columnNamesForResultModel.length; ++j) {
                        if (this.columnNamesForResultModel[j] == null || this.rowNamesForResultModel[i] == null) continue;
                        String fName = isSingleColumn ? this.rowNamesForResultModel[i] : (isSingleRow ? this.columnNamesForResultModel[j] : this.columnNamesForResultModel[j] + "_" + this.rowNamesForResultModel[i]);
                        String fNewName = fName;
                        int k = 1;
                        while (values.containsKey(fNewName)) {
                            fNewName = fName + k;
                            ++k;
                        }
                        values.put(fNewName, SpreadsheetResult.convertSpreadsheetResult(module, this.getValue(i, j)));
                        if (!isTableStructureDetailsPresented) continue;
                        TableDetails[i][j] = fNewName;
                    }
                }
            }
            if (this.tableStructureDetails) {
                values.put(CustomSpreadsheetResultOpenClass.findNonConflictFieldName(values.keySet(), "TableDetails"), TableDetails);
                values.put(CustomSpreadsheetResultOpenClass.findNonConflictFieldName(values.keySet(), "RowNames"), this.rowNames);
                values.put(CustomSpreadsheetResultOpenClass.findNonConflictFieldName(values.keySet(), "ColumnNames"), this.columnNames);
            }
        }
        return values;
    }

    private static Object convertSpreadsheetResult(XlsModuleOpenClass module, Object v) {
        if (v instanceof SpreadsheetResult) {
            SpreadsheetResult spreadsheetResult = (SpreadsheetResult)v;
            if (spreadsheetResult.getCustomSpreadsheetResultOpenClass() == null) {
                return SpreadsheetResult.convertSpreadsheetResult(module, v, module.getSpreadsheetResultOpenClassWithResolvedFieldTypes().toCustomSpreadsheetResultOpenClass().getBeanClass());
            }
            return SpreadsheetResult.convertSpreadsheetResult(module, v, null);
        }
        return SpreadsheetResult.convertSpreadsheetResult(module, v, null);
    }

    public static Object convertSpreadsheetResult(XlsModuleOpenClass module, Object v, Class<?> toType) {
        if (v == null) {
            return null;
        }
        if (v instanceof Collection) {
            Collection newCollection;
            Collection collection = (Collection)v;
            try {
                newCollection = (Collection)v.getClass().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                return v;
            }
            for (Object o : collection) {
                newCollection.add(SpreadsheetResult.convertSpreadsheetResult(module, o));
            }
            return newCollection;
        }
        if (v instanceof Map) {
            Map newMap;
            Map map = (Map)v;
            try {
                newMap = (Map)v.getClass().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                return v;
            }
            for (Map.Entry e : map.entrySet()) {
                newMap.put(SpreadsheetResult.convertSpreadsheetResult(module, e.getKey()), SpreadsheetResult.convertSpreadsheetResult(module, e.getValue()));
            }
            return newMap;
        }
        if (v.getClass().isArray()) {
            Class<?> componentType = v.getClass().getComponentType();
            Class<?> t = v.getClass();
            while (t.isArray()) {
                t = t.getComponentType();
            }
            int len = Array.getLength(v);
            if (ClassUtils.isAssignable(t, SpreadsheetResult.class)) {
                Object tmpArray = Array.newInstance(toType != null && toType.isArray() ? toType.getComponentType() : Object.class, len);
                for (int i = 0; i < len; ++i) {
                    try {
                        Array.set(tmpArray, i, SpreadsheetResult.convertSpreadsheetResult(module, Array.get(v, i), toType != null && toType.isArray() ? toType.getComponentType() : null));
                        continue;
                    }
                    catch (Exception e) {
                        SpreadsheetResult.convertSpreadsheetResult(module, Array.get(v, i), toType != null && toType.isArray() ? toType.getComponentType() : null);
                    }
                }
                if (toType != null && toType.isArray() && Object.class != toType.getComponentType()) {
                    return tmpArray;
                }
                Class<?> c = null;
                boolean f = true;
                for (int i = 0; i < len; ++i) {
                    Object v1 = Array.get(tmpArray, i);
                    if (v1 == null) continue;
                    if (c == null) {
                        c = v1.getClass();
                        continue;
                    }
                    if (c.equals(v1.getClass())) continue;
                    f = false;
                }
                if (f && c != null) {
                    Object newArray = Array.newInstance(c, len);
                    for (int i = 0; i < len; ++i) {
                        Array.set(newArray, i, Array.get(tmpArray, i));
                    }
                    return newArray;
                }
                return tmpArray;
            }
            if (ClassUtils.isAssignable(SpreadsheetResult.class, t) || ClassUtils.isAssignable(t, Map.class) || ClassUtils.isAssignable(t, Collection.class)) {
                Object newArray = Array.newInstance(componentType, len);
                for (int i = 0; i < len; ++i) {
                    Array.set(newArray, i, SpreadsheetResult.convertSpreadsheetResult(module, Array.get(v, i), componentType));
                }
                return newArray;
            }
            return v;
        }
        if (v instanceof SpreadsheetResult) {
            SpreadsheetResult spreadsheetResult = (SpreadsheetResult)v;
            if (Map.class == toType) {
                return spreadsheetResult.toMap(module);
            }
            if (toType == null && spreadsheetResult.getCustomSpreadsheetResultOpenClass() == null || toType != null && toType == module.getSpreadsheetResultOpenClassWithResolvedFieldTypes().toCustomSpreadsheetResultOpenClass().getBeanClass()) {
                return module.getSpreadsheetResultOpenClassWithResolvedFieldTypes().toCustomSpreadsheetResultOpenClass().createBean(spreadsheetResult);
            }
            return spreadsheetResult.toPlain(module);
        }
        return v;
    }
}

