/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc;

import org.openl.binding.IBindingContext;
import org.openl.binding.ICastFactory;
import org.openl.binding.exception.FieldNotFoundException;
import org.openl.binding.impl.CastToWiderType;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.binding.impl.component.ComponentBindingContext;
import org.openl.binding.impl.component.ComponentOpenClass;
import org.openl.exception.OpenLCompilationException;
import org.openl.rules.calc.SpreadsheetOpenClass;
import org.openl.rules.calc.element.SpreadsheetCellField;
import org.openl.rules.calc.element.SpreadsheetRangeField;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.NullOpenClass;

public class SpreadsheetContext
extends ComponentBindingContext {
    public SpreadsheetContext(IBindingContext delegate, SpreadsheetOpenClass type) {
        super(delegate, (ComponentOpenClass)type);
    }

    public IOpenField findRange(String namespace, String rangeStartName, String rangeEndName) throws OpenLCompilationException {
        int ey;
        int sy;
        int ex;
        String key = namespace + ":" + rangeStartName + ":" + rangeEndName;
        IOpenField fstart = this.findVar(namespace, rangeStartName, true);
        if (fstart == null) {
            throw new FieldNotFoundException("Cannot find range start: ", rangeStartName, null);
        }
        IOpenField fend = this.findVar(namespace, rangeEndName, true);
        if (fend == null) {
            throw new FieldNotFoundException("Cannot find range end: ", rangeEndName, null);
        }
        if (!(fstart instanceof SpreadsheetCellField)) {
            throw new FieldNotFoundException("Range start must point to the cell: ", rangeStartName, null);
        }
        if (!(fend instanceof SpreadsheetCellField)) {
            throw new FieldNotFoundException("Range end must point to the cell: ", rangeEndName, null);
        }
        int sx = ((SpreadsheetCellField)fstart).getCell().getColumnIndex();
        if (sx > (ex = ((SpreadsheetCellField)fend).getCell().getColumnIndex())) {
            int p = sx;
            sx = ex;
            ex = p;
        }
        if ((sy = ((SpreadsheetCellField)fstart).getCell().getRowIndex()) > (ey = ((SpreadsheetCellField)fend).getCell().getRowIndex())) {
            int p = sy;
            sy = ey;
            ey = p;
        }
        int w = ex - sx + 1;
        int h = ey - sy + 1;
        RangeTypeCollector rangeTypeCollector = new RangeTypeCollector(fstart.getType());
        this.iterateThroughTheRange(sx, sy, w, h, rangeTypeCollector);
        IOpenClass rangeType = rangeTypeCollector.getRangeType();
        if (NullOpenClass.class.isAssignableFrom(rangeType.getClass())) {
            throw new OpenLCompilationException(String.format("Range %s:%s contains only undefined type values.", rangeStartName, rangeEndName));
        }
        CastsCollector castsCollector = new CastsCollector(rangeType, w, h);
        this.iterateThroughTheRange(sx, sy, w, h, castsCollector);
        if (castsCollector.isImplicitCastNotSupported() || rangeType.getInstanceClass() == null) {
            throw new OpenLCompilationException(String.format("Types in range %s:%s cannot be implicit casted to '%s'.", rangeStartName, rangeEndName, rangeType.getDisplayName(0)));
        }
        return new SpreadsheetRangeField(key, rangeStartName + ":" + rangeEndName, sx, sy, ex, ey, rangeType, castsCollector.getCasts(), fstart.getDeclaringClass());
    }

    private void iterateThroughTheRange(int startColumn, int startRow, int columnsInRange, int rowsInRange, SpreadsheetFieldCollector collector) {
        ComponentOpenClass componentOpenClass = this.getComponentOpenClass();
        SpreadsheetContext componentBindingContext = this;
        while (componentOpenClass != null) {
            for (IOpenField f : componentOpenClass.getDeclaredFields()) {
                if (!(f instanceof SpreadsheetCellField)) continue;
                SpreadsheetCellField field = (SpreadsheetCellField)f;
                int columnInRange = field.getCell().getColumnIndex() - startColumn;
                int rowInRange = field.getCell().getRowIndex() - startRow;
                if (columnInRange < 0 || columnInRange >= columnsInRange || rowInRange < 0 || rowInRange >= rowsInRange) continue;
                collector.collect(columnInRange, rowInRange, field);
            }
            if (componentBindingContext.getDelegate() instanceof ComponentBindingContext) {
                componentBindingContext = (ComponentBindingContext)componentBindingContext.getDelegate();
                componentOpenClass = componentBindingContext.getComponentOpenClass();
                continue;
            }
            componentOpenClass = null;
        }
    }

    private final class RangeTypeCollector
    implements SpreadsheetFieldCollector {
        private IOpenClass rangeType;

        private RangeTypeCollector(IOpenClass initialRangeType) {
            this.rangeType = initialRangeType;
        }

        @Override
        public void collect(int columnInRange, int rowInRange, SpreadsheetCellField field) {
            this.rangeType = CastToWiderType.create((ICastFactory)SpreadsheetContext.this, (IOpenClass)this.rangeType, (IOpenClass)field.getType()).getWiderType();
        }

        IOpenClass getRangeType() {
            return this.rangeType;
        }
    }

    private final class CastsCollector
    implements SpreadsheetFieldCollector {
        private final IOpenClass rangeType;
        private final IOpenCast[][] casts;
        private boolean implicitCastNotSupported;

        private CastsCollector(IOpenClass rangeType, int columnsInRange, int rowsInRange) {
            this.rangeType = rangeType;
            this.casts = new IOpenCast[columnsInRange][rowsInRange];
        }

        @Override
        public void collect(int columnInRange, int rowInRange, SpreadsheetCellField field) {
            if (this.casts[columnInRange][rowInRange] == null && !this.rangeType.equals(field.getType())) {
                this.casts[columnInRange][rowInRange] = SpreadsheetContext.this.getCast(field.getType(), this.rangeType);
                if (!this.casts[columnInRange][rowInRange].isImplicit()) {
                    this.casts[columnInRange][rowInRange] = null;
                }
                if (this.casts[columnInRange][rowInRange] == null) {
                    this.implicitCastNotSupported = true;
                }
            }
        }

        IOpenCast[][] getCasts() {
            return this.casts;
        }

        boolean isImplicitCastNotSupported() {
            return this.implicitCastNotSupported;
        }
    }

    private static interface SpreadsheetFieldCollector {
        public void collect(int var1, int var2, SpreadsheetCellField var3);
    }
}

