/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc;

import java.util.Objects;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.rules.binding.RecursiveSpreadsheetMethodPreBindingException;
import org.openl.rules.calc.ASpreadsheetField;
import org.openl.rules.calc.CustomSpreadsheetResultOpenClass;
import org.openl.rules.calc.IOriginalDeclaredClassesOpenField;
import org.openl.rules.calc.SpreadsheetCellsLoopException;
import org.openl.rules.calc.SpreadsheetResult;
import org.openl.rules.calc.UnexpectedSpreadsheetResultFieldTypeException;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.ClassUtils;
import org.openl.vm.IRuntimeEnv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomSpreadsheetResultField
extends ASpreadsheetField
implements IOriginalDeclaredClassesOpenField {
    private static final Logger LOG = LoggerFactory.getLogger(CustomSpreadsheetResultField.class);
    protected IOpenField field;
    private final IOpenClass[] declaringClasses;

    public CustomSpreadsheetResultField(CustomSpreadsheetResultOpenClass declaringClass, IOpenField field) {
        super((IOpenClass)declaringClass, field.getName(), null);
        this.field = Objects.requireNonNull(field, "field cannot be null");
        this.declaringClasses = new IOpenClass[]{declaringClass};
    }

    public CustomSpreadsheetResultField(IOpenClass declaringClass, String name, IOpenClass type) {
        super(declaringClass, name, type);
        this.declaringClasses = new IOpenClass[]{declaringClass};
    }

    public Object get(Object target, IRuntimeEnv env) {
        if (this.field != null) {
            throw new IllegalStateException("Spreadsheet cell type is not resolved at compile time");
        }
        if (target == null) {
            return this.getType().nullObject();
        }
        Object res = ((SpreadsheetResult)target).getFieldValue(this.getName());
        return this.processResult(res);
    }

    public IOpenClass getType() {
        if (this.field != null) {
            try {
                this.setType(this.field.getType());
                this.field = null;
            }
            catch (RecursiveSpreadsheetMethodPreBindingException | SpreadsheetCellsLoopException e) {
                return JavaOpenClass.OBJECT;
            }
        }
        return super.getType();
    }

    protected Object processResult(Object res) {
        if (res != null) {
            if (!ClassUtils.isAssignable(res.getClass(), (Class)this.getType().getInstanceClass())) {
                return this.convertWithFailSafeCast(res);
            }
            return res;
        }
        return this.getType().nullObject();
    }

    protected final Object convertWithFailSafeCast(Object res) {
        IOpenCast cast = ((CustomSpreadsheetResultOpenClass)this.getDeclaringClass()).getModule().getObjectToDataOpenCastConvertor().getConvertor(res.getClass(), this.getType().getInstanceClass());
        if (cast != null && cast.isImplicit()) {
            return cast.convert(res);
        }
        throw new UnexpectedSpreadsheetResultFieldTypeException(String.format("Unexpected type for field '%s' in '%s'. Expected type '%s', but found '%s'.", this.getName(), this.getDeclaringClass().getName(), this.getType().getDisplayName(2), res.getClass().getTypeName()));
    }

    public boolean isWritable() {
        return true;
    }

    public void set(Object target, Object value, IRuntimeEnv env) {
        if (target != null) {
            ((SpreadsheetResult)target).setFieldValue(this.getName(), value);
        }
    }

    @Override
    public IOpenClass[] getDeclaringClasses() {
        return this.declaringClasses;
    }
}

