/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;

public class CellsHeaderExtractor {
    private static final Pattern COMMA = Pattern.compile("\\s*,\\s*");
    private String[] rowNames;
    private String[] columnNames;
    private Set<String> dependentSpreadsheetTypes;
    private final ILogicalTable columnNamesTable;
    private final ILogicalTable rowNamesTable;
    private final String spreadsheetSignature;
    static final String DEPENDENT_CSR_REGEX = "^.*\\s*:\\s*SpreadsheetResult[^\\s\\[\\]].*";
    private static final Pattern CSR_IN_RETURN_PATTERN = Pattern.compile("\\s*Spreadsheet\\s*SpreadsheetResult([^\\s\\[\\]]+).+");
    private static final Pattern PARAMETERS_PATTERN = Pattern.compile("\\((.+)\\)");
    private static final Pattern CSR_TYPE_PATTERN = Pattern.compile("\\s*SpreadsheetResult([^\\s\\[\\]]+).+");

    public CellsHeaderExtractor(String spreadsheetSignature, ILogicalTable columnNamesTable, ILogicalTable rowNamesTable) {
        this.spreadsheetSignature = spreadsheetSignature;
        this.columnNamesTable = columnNamesTable;
        this.rowNamesTable = rowNamesTable;
    }

    public ILogicalTable getColumnNamesTable() {
        return this.columnNamesTable;
    }

    public int getWidth() {
        return this.columnNamesTable == null ? 0 : this.columnNamesTable.getWidth();
    }

    public ILogicalTable getRowNamesTable() {
        return this.rowNamesTable;
    }

    public int getHeight() {
        return this.rowNamesTable == null ? 0 : this.rowNamesTable.getHeight();
    }

    public String[] getRowNames() {
        if (this.rowNames == null) {
            int height = this.getHeight();
            this.rowNames = new String[height];
            for (int row = 0; row < height; ++row) {
                IGridTable nameCell = ((ILogicalTable)((ILogicalTable)this.rowNamesTable.getRow(row)).getColumn(0)).getSource();
                this.rowNames[row] = nameCell.getCell(0, 0).getStringValue();
            }
        }
        return this.rowNames;
    }

    public String[] getColumnNames() {
        if (this.columnNames == null) {
            int width = this.getWidth();
            this.columnNames = new String[width];
            for (int col = 0; col < width; ++col) {
                IGridTable nameCell = ((ILogicalTable)((ILogicalTable)this.columnNamesTable.getColumn(col)).getRow(0)).getSource();
                this.columnNames[col] = nameCell.getCell(0, 0).getStringValue();
            }
        }
        return this.columnNames;
    }

    public Set<String> getDependentSignatureSpreadsheetTypes() {
        if (this.dependentSpreadsheetTypes == null) {
            this.dependentSpreadsheetTypes = new HashSet<String>();
            this.dependentSpreadsheetTypes.addAll(CellsHeaderExtractor.getSignatureDependencies(this.spreadsheetSignature));
        }
        return this.dependentSpreadsheetTypes;
    }

    static List<String> getSignatureDependencies(String signature) {
        ArrayList<String> dependentSpreadsheets = new ArrayList<String>();
        Matcher matcher = CSR_IN_RETURN_PATTERN.matcher(signature);
        if (matcher.matches()) {
            dependentSpreadsheets.add(matcher.group(1));
        }
        if ((matcher = PARAMETERS_PATTERN.matcher(signature)).find()) {
            String allParams = matcher.group(1);
            for (String param : COMMA.split(allParams)) {
                Matcher paramMatcher = CSR_TYPE_PATTERN.matcher(param);
                if (!paramMatcher.matches()) continue;
                dependentSpreadsheets.add(paramMatcher.group(1));
            }
        }
        return dependentSpreadsheets;
    }
}

