/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;
import org.openl.binding.ICastFactory;
import org.openl.binding.impl.CastToWiderType;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.binding.impl.module.ModuleSpecificType;
import org.openl.rules.calc.CustomSpreadsheetResultField;
import org.openl.rules.calc.CustomSpreadsheetResultOpenClass;
import org.openl.rules.calc.IOriginalDeclaredClassesOpenField;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.util.ClassUtils;

public class CastingCustomSpreadsheetResultField
extends CustomSpreadsheetResultField {
    private List<Pair<IOpenClass, IOpenCast>> casts;
    private IOpenClass type;
    private final Collection<IOpenField> fields;
    private final IOpenClass[] declaringClasses;

    public CastingCustomSpreadsheetResultField(CustomSpreadsheetResultOpenClass declaringClass, String name, IOpenField field1, IOpenField field2) {
        super((IOpenClass)declaringClass, name, null);
        Objects.requireNonNull(field1, "field1 cannot be null");
        Objects.requireNonNull(field2, "field2 cannot be null");
        this.fields = new ArrayList<IOpenField>(this.extractFields(field1));
        this.fields.addAll(this.extractFields(field2));
        ArrayList<IOpenClass> declaringClasses = new ArrayList<IOpenClass>();
        this.extractFieldDeclaringClasses(field1, declaringClasses);
        this.extractFieldDeclaringClasses(field2, declaringClasses);
        this.declaringClasses = declaringClasses.toArray(IOpenClass.EMPTY);
    }

    private Collection<IOpenField> extractFields(IOpenField field) {
        ArrayList<IOpenField> ret = new ArrayList<IOpenField>();
        if (field instanceof CastingCustomSpreadsheetResultField) {
            CastingCustomSpreadsheetResultField castingCustomSpreadsheetResultField = (CastingCustomSpreadsheetResultField)field;
            ret.addAll(castingCustomSpreadsheetResultField.fields);
        } else {
            ret.add(field);
        }
        return ret;
    }

    public CustomSpreadsheetResultOpenClass getDeclaringClass() {
        return (CustomSpreadsheetResultOpenClass)super.getDeclaringClass();
    }

    @Override
    protected Object processResult(Object res) {
        if (this.type == null) {
            throw new IllegalStateException("Spreadsheet cell type is not resolved at compile time");
        }
        if (res == null) {
            return this.getType().nullObject();
        }
        if (this.casts != null) {
            for (Pair<IOpenClass, IOpenCast> cast : this.casts) {
                if (!ClassUtils.isAssignable(res.getClass(), (Class)((IOpenClass)cast.getKey()).getInstanceClass())) continue;
                return ((IOpenCast)cast.getValue()).convert(res);
            }
        }
        if (!ClassUtils.isAssignable(res.getClass(), (Class)this.getType().getInstanceClass())) {
            return this.convertWithFailSafeCast(res);
        }
        return res;
    }

    private void initLazyFields() {
        if (this.type == null) {
            if (this.getDeclaringClass().getModule().getRulesModuleBindingContext() == null) {
                throw new IllegalStateException("Spreadsheet cell type is not resolved at compile time");
            }
            HashSet<IOpenClass> types = new HashSet<IOpenClass>();
            for (IOpenField f : this.fields) {
                types.add(f.getType());
            }
            if (types.size() == 1) {
                this.type = (IOpenClass)types.iterator().next();
                this.casts = null;
            } else {
                Iterator itr = types.iterator();
                IOpenClass t = this.useModuleTypeIfNeed((IOpenClass)itr.next());
                while (itr.hasNext()) {
                    IOpenClass t1 = this.useModuleTypeIfNeed((IOpenClass)itr.next());
                    CastToWiderType castToWiderType = CastToWiderType.create((ICastFactory)this.getDeclaringClass().getModule().getRulesModuleBindingContext(), (IOpenClass)t, (IOpenClass)t1);
                    t = castToWiderType.getWiderType();
                }
                this.casts = new ArrayList<Pair<IOpenClass, IOpenCast>>();
                this.type = t;
                for (IOpenClass type : types) {
                    IOpenCast cast = this.getDeclaringClass().getModule().getRulesModuleBindingContext().getCast(type, this.type);
                    this.casts.add((Pair<IOpenClass, IOpenCast>)Pair.of((Object)type, (Object)cast));
                }
            }
        }
    }

    private IOpenClass useModuleTypeIfNeed(IOpenClass t) {
        IOpenClass p;
        if (t instanceof ModuleSpecificType && (p = this.getDeclaringClass().getModule().getRulesModuleBindingContext().findType("org.openl.this", t.getName())) != null) {
            return p;
        }
        return t;
    }

    @Override
    public IOpenClass getType() {
        this.initLazyFields();
        return this.type;
    }

    @Override
    public IOpenClass[] getDeclaringClasses() {
        return (IOpenClass[])this.declaringClasses.clone();
    }

    private void extractFieldDeclaringClasses(IOpenField field, List<IOpenClass> declaringClasses) {
        if (declaringClasses.contains(field.getDeclaringClass())) {
            return;
        }
        if (field instanceof IOriginalDeclaredClassesOpenField) {
            IOpenClass[] fieldDeclaringClasses = ((IOriginalDeclaredClassesOpenField)field).getDeclaringClasses();
            declaringClasses.addAll(Arrays.asList(fieldDeclaringClasses));
        } else {
            declaringClasses.add(field.getDeclaringClass());
        }
    }
}

