/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.binding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openl.binding.IBindingContext;
import org.openl.binding.ICastFactory;
import org.openl.binding.exception.AmbiguousMethodException;
import org.openl.binding.exception.DuplicatedTypeException;
import org.openl.binding.impl.method.MethodSearch;
import org.openl.binding.impl.method.NullVarArgsOpenMethod;
import org.openl.binding.impl.method.VarArgsOpenMethod;
import org.openl.binding.impl.module.ModuleBindingContext;
import org.openl.binding.impl.module.ModuleOpenClass;
import org.openl.binding.impl.module.ModuleSpecificType;
import org.openl.engine.OpenLSystemProperties;
import org.openl.meta.IMetaInfo;
import org.openl.meta.TableMetaInfo;
import org.openl.rules.binding.PreBinderMethods;
import org.openl.rules.binding.RecursiveOpenMethodPreBinder;
import org.openl.rules.binding.RecursiveSpreadsheetMethodPreBindingException;
import org.openl.rules.calc.CustomSpreadsheetResultOpenClass;
import org.openl.rules.calc.SpreadsheetResultOpenClass;
import org.openl.rules.context.IRulesRuntimeContext;
import org.openl.rules.context.RulesRuntimeContextFactory;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.runtime.IRuntimeContext;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IMethodCaller;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.IParameterDeclaration;
import org.openl.types.impl.CastingMethodCaller;
import org.openl.types.impl.MethodSignature;
import org.openl.types.impl.OpenMethodHeader;
import org.openl.types.impl.ParameterDeclaration;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.CollectionUtils;
import org.openl.util.MessageUtils;
import org.openl.vm.IRuntimeEnv;
import org.slf4j.LoggerFactory;

public class RulesModuleBindingContext
extends ModuleBindingContext {
    public static final String GLOBAL_PROPERTIES_KEY = "Properties:Global";
    public static final String MODULE_PROPERTIES_KEY = "Properties:Module";
    public static final String CATEGORY_PROPERTIES_KEY = "Properties:Category:";
    private final Map<String, TableSyntaxNode> bindedTables = new HashMap<String, TableSyntaxNode>();
    private final List<IOpenMethod> internalMethods;
    private final PreBinderMethods preBinderMethods = new PreBinderMethods();
    private boolean ignoreCustomSpreadsheetResultCompilation = false;

    public RulesModuleBindingContext(IBindingContext delegate, XlsModuleOpenClass module) {
        super(delegate, (ModuleOpenClass)module);
        this.internalMethods = new ArrayList<IOpenMethod>();
        this.internalMethods.add(new CurrentRuntimeContextMethod());
        this.internalMethods.add(new EmptyRuntimeContextMethod());
        this.internalMethods.add(new RestoreRuntimeContextMethod());
        this.internalMethods.add(new SetRuntimeContextMethod());
        this.internalMethods.add(new ModifyRuntimeContextMethod());
    }

    public void registerTableSyntaxNode(String key, TableSyntaxNode tsn) {
        this.bindedTables.put(key, tsn);
    }

    public boolean isTableSyntaxNodePresented(String key) {
        return this.bindedTables.containsKey(key);
    }

    public TableSyntaxNode getTableSyntaxNode(String key) {
        return this.bindedTables.get(key);
    }

    public IMethodCaller findMethodCaller(String namespace, String methodName, IOpenClass[] parTypes) {
        IMethodCaller method;
        List select = CollectionUtils.findAll((Iterable)this.preBinderMethods.values().stream().map(IOpenMethod.class::cast).collect(Collectors.toList()), e -> Objects.equals(methodName, e.getName()));
        try {
            method = MethodSearch.findMethod((String)methodName, (IOpenClass[])parTypes, (ICastFactory)this, (Iterable)select);
            if (method != null) {
                RecursiveOpenMethodPreBinder openMethodBinder = this.extractOpenMethodPrebinder(method);
                if (openMethodBinder.isPreBindStarted()) {
                    if (OpenLSystemProperties.isCustomSpreadsheetTypesSupported(this.getExternalParams()) && openMethodBinder.isReturnsCustomSpreadsheetResult()) {
                        throw new RecursiveSpreadsheetMethodPreBindingException();
                    }
                    method = super.findMethodCaller(namespace, methodName, parTypes);
                    if (method == null) {
                        List internalSelect = CollectionUtils.findAll(this.internalMethods, e -> Objects.equals(methodName, e.getName()));
                        method = MethodSearch.findMethod((String)methodName, (IOpenClass[])parTypes, (ICastFactory)this, (Iterable)internalSelect);
                    }
                    if (method != null) {
                        return method;
                    }
                    throw new IllegalStateException("Method compilation is failed with the circular reference to itself.");
                }
                this.preBindMethod(openMethodBinder.getHeader());
            }
        }
        catch (AmbiguousMethodException e2) {
            e2.getMatchingMethods().stream().map(m -> this.extractOpenMethodPrebinder((IMethodCaller)m).getHeader()).forEach(this::preBindMethod);
        }
        method = super.findMethodCaller(namespace, methodName, parTypes);
        if (method == null) {
            List internalSelect = CollectionUtils.findAll(this.internalMethods, e -> Objects.equals(methodName, e.getName()));
            method = MethodSearch.findMethod((String)methodName, (IOpenClass[])parTypes, (ICastFactory)this, (Iterable)internalSelect);
        }
        return method;
    }

    private RecursiveOpenMethodPreBinder extractOpenMethodPrebinder(IMethodCaller method) {
        if (method instanceof RecursiveOpenMethodPreBinder) {
            return (RecursiveOpenMethodPreBinder)method;
        }
        if (method instanceof CastingMethodCaller) {
            return (RecursiveOpenMethodPreBinder)method.getMethod();
        }
        if (method instanceof VarArgsOpenMethod) {
            return (RecursiveOpenMethodPreBinder)((VarArgsOpenMethod)method).getDelegate();
        }
        if (method instanceof NullVarArgsOpenMethod) {
            return (RecursiveOpenMethodPreBinder)((NullVarArgsOpenMethod)method).getDelegate();
        }
        throw new IllegalStateException("It should not happen.");
    }

    public XlsModuleOpenClass getModule() {
        return (XlsModuleOpenClass)super.getModule();
    }

    public IOpenClass addType(String namespace, IOpenClass type) throws DuplicatedTypeException {
        String typeName = type.getName();
        if (type instanceof ModuleSpecificType) {
            ModuleSpecificType moduleRelatedType = (ModuleSpecificType)type;
            IOpenClass openClass = super.findType(namespace, typeName);
            if (openClass == moduleRelatedType) {
                return openClass;
            }
            if (openClass == null) {
                IOpenClass copyOfType = moduleRelatedType.makeCopyForModule((ModuleOpenClass)this.getModule());
                this.getModule().addType(copyOfType);
                return copyOfType;
            }
            ModuleSpecificType existingModuleRelatedOpenClass = (ModuleSpecificType)openClass;
            existingModuleRelatedOpenClass.updateWithType(type);
            return openClass;
        }
        return super.addType(namespace, type);
    }

    public IOpenClass findType(String namespace, String typeName) {
        IOpenClass openClass = super.findType(namespace, typeName);
        if (OpenLSystemProperties.isCustomSpreadsheetTypesSupported(this.getExternalParams())) {
            CustomSpreadsheetResultOpenClass csrOpenClass;
            if (openClass instanceof SpreadsheetResultOpenClass) {
                return this.getModule().getSpreadsheetResultOpenClassWithResolvedFieldTypes();
            }
            if (openClass instanceof CustomSpreadsheetResultOpenClass && !(csrOpenClass = (CustomSpreadsheetResultOpenClass)openClass).isIgnoreCompilation()) {
                String methodName = typeName.substring("SpreadsheetResult".length());
                this.preBinderMethods.findByMethodName(methodName).forEach(openMethodBinder -> {
                    if (openMethodBinder.isReturnsCustomSpreadsheetResult()) {
                        this.preBindMethod(openMethodBinder.getHeader());
                    }
                });
            }
        }
        return openClass;
    }

    public void addBinderMethod(OpenMethodHeader openMethodHeader, RecursiveOpenMethodPreBinder method) {
        if (!this.isExecutionMode() && OpenLSystemProperties.isCustomSpreadsheetTypesSupported(this.getExternalParams()) && method.isReturnsCustomSpreadsheetResult()) {
            String sprTypeName = "SpreadsheetResult" + method.getName();
            IOpenClass openClass = this.findType("org.openl.this", sprTypeName);
            if (openClass instanceof CustomSpreadsheetResultOpenClass) {
                CustomSpreadsheetResultOpenClass customSpreadsheetResultOpenClass = (CustomSpreadsheetResultOpenClass)openClass;
                customSpreadsheetResultOpenClass.setMetaInfo((IMetaInfo)new TableMetaInfo("Spreadsheet", method.getName(), method.getTableSyntaxNode().getUri()));
            } else {
                throw new IllegalStateException(MessageUtils.getTypeNotFoundMessage((String)sprTypeName));
            }
        }
        this.preBinderMethods.put((IOpenMethodHeader)openMethodHeader, method);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void preBindMethod(OpenMethodHeader openMethodHeader) {
        Optional<RecursiveOpenMethodPreBinder> prebindingOpenMethodPreBinder;
        Collection<RecursiveOpenMethodPreBinder> openMethodBinders;
        if (openMethodHeader == null) {
            return;
        }
        RecursiveOpenMethodPreBinder openMethodBinder = this.preBinderMethods.get((IOpenMethodHeader)openMethodHeader);
        if (openMethodBinder == null) {
            return;
        }
        String customSpreadsheetResultTypeName = "SpreadsheetResult" + openMethodHeader.getName();
        boolean isCustomSpreadsheetResultEnabled = OpenLSystemProperties.isCustomSpreadsheetTypesSupported(this.getExternalParams());
        if (isCustomSpreadsheetResultEnabled && openMethodBinder.isReturnsCustomSpreadsheetResult()) {
            if (this.isIgnoreCustomSpreadsheetResultCompilation()) {
                return;
            }
            openMethodBinders = this.preBinderMethods.findByMethodName(openMethodHeader.getName());
            openMethodBinders = openMethodBinders.stream().filter(RecursiveOpenMethodPreBinder::isReturnsCustomSpreadsheetResult).collect(Collectors.toList());
            IOpenClass openClass = super.findType("org.openl.this", customSpreadsheetResultTypeName);
            if (!(openClass instanceof CustomSpreadsheetResultOpenClass)) throw new IllegalStateException(MessageUtils.getTypeNotFoundMessage((String)customSpreadsheetResultTypeName));
            CustomSpreadsheetResultOpenClass csroc = (CustomSpreadsheetResultOpenClass)openClass;
            csroc.setIgnoreCompilation(true);
        } else {
            openMethodBinders = Collections.singletonList(openMethodBinder);
        }
        if ((prebindingOpenMethodPreBinder = openMethodBinders.stream().filter(RecursiveOpenMethodPreBinder::isPreBindStarted).findAny()).isPresent()) {
            if (!OpenLSystemProperties.isCustomSpreadsheetTypesSupported(this.getExternalParams()) || !prebindingOpenMethodPreBinder.get().isReturnsCustomSpreadsheetResult()) throw new IllegalStateException("Method compilation is failed with the circular reference to itself.");
            throw new RecursiveSpreadsheetMethodPreBindingException();
        }
        openMethodBinders.forEach(RecursiveOpenMethodPreBinder::startPreBind);
        openMethodBinders.forEach(RecursiveOpenMethodPreBinder::preBind);
        openMethodBinders.forEach(e -> this.preBinderMethods.remove((IOpenMethodHeader)e.getHeader()));
        openMethodBinders.forEach(RecursiveOpenMethodPreBinder::finishPreBind);
    }

    private boolean isIgnoreCustomSpreadsheetResultCompilation() {
        return this.ignoreCustomSpreadsheetResultCompilation;
    }

    public void setIgnoreCustomSpreadsheetResultCompilation(boolean ignoreCustomSpreadsheetResultCompilation) {
        this.ignoreCustomSpreadsheetResultCompilation = ignoreCustomSpreadsheetResultCompilation;
    }

    protected boolean isComponentSpecificOpenClass(IOpenClass componentOpenClass) {
        return componentOpenClass instanceof CustomSpreadsheetResultOpenClass || componentOpenClass instanceof SpreadsheetResultOpenClass;
    }

    public static final class ModifyRuntimeContextMethod
    implements IOpenMethod {
        static final String MODIFY_CONTEXT_METHOD_NAME = "modifyContext";

        public Object invoke(Object target, Object[] params, IRuntimeEnv env) {
            if (env.isContextManagingSupported()) {
                try {
                    IRulesRuntimeContext runtimeContext = ((IRulesRuntimeContext)env.getContext()).clone();
                    runtimeContext.setValue((String)params[0], params[1]);
                    env.pushContext((IRuntimeContext)runtimeContext);
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {}
            } else {
                LoggerFactory.getLogger(RulesModuleBindingContext.class).warn("Failed to modify runtime context. Runtime context does not support context modifications.");
            }
            return null;
        }

        public IOpenMethod getMethod() {
            return this;
        }

        public String getName() {
            return MODIFY_CONTEXT_METHOD_NAME;
        }

        public String getDisplayName(int mode) {
            return MODIFY_CONTEXT_METHOD_NAME;
        }

        public boolean isStatic() {
            return false;
        }

        public IOpenClass getType() {
            return JavaOpenClass.VOID;
        }

        public IMemberMetaInfo getInfo() {
            return null;
        }

        public IOpenClass getDeclaringClass() {
            return null;
        }

        public IMethodSignature getSignature() {
            return new MethodSignature(new IParameterDeclaration[]{new ParameterDeclaration((IOpenClass)JavaOpenClass.STRING, "property"), new ParameterDeclaration((IOpenClass)JavaOpenClass.OBJECT, "value")});
        }

        public boolean isConstructor() {
            return false;
        }
    }

    public static final class SetRuntimeContextMethod
    implements IOpenMethod {
        static final String SET_CONTEXT_METHOD_NAME = "setContext";

        public Object invoke(Object target, Object[] params, IRuntimeEnv env) {
            if (env.isContextManagingSupported()) {
                IRulesRuntimeContext runtimeContext = (IRulesRuntimeContext)params[0];
                env.pushContext((IRuntimeContext)runtimeContext);
            } else {
                LoggerFactory.getLogger(RulesModuleBindingContext.class).warn("Failed to set runtime context. Runtime context does not support context modifications.");
            }
            return null;
        }

        public IOpenMethod getMethod() {
            return this;
        }

        public String getName() {
            return SET_CONTEXT_METHOD_NAME;
        }

        public String getDisplayName(int mode) {
            return SET_CONTEXT_METHOD_NAME;
        }

        public boolean isStatic() {
            return false;
        }

        public IOpenClass getType() {
            return JavaOpenClass.VOID;
        }

        public IMemberMetaInfo getInfo() {
            return null;
        }

        public IOpenClass getDeclaringClass() {
            return null;
        }

        public IMethodSignature getSignature() {
            return new MethodSignature(new IParameterDeclaration[]{new ParameterDeclaration((IOpenClass)JavaOpenClass.getOpenClass(IRulesRuntimeContext.class), "context")});
        }

        public boolean isConstructor() {
            return false;
        }
    }

    public static final class RestoreRuntimeContextMethod
    implements IOpenMethod {
        static final String RESTORE_CONTEXT_METHOD_NAME = "restoreContext";

        public Object invoke(Object target, Object[] params, IRuntimeEnv env) {
            if (env.isContextManagingSupported()) {
                env.popContext();
            } else {
                LoggerFactory.getLogger(RulesModuleBindingContext.class).warn("Failed to restore runtime context. Runtime context does not support context modifications.");
            }
            return null;
        }

        public IOpenMethod getMethod() {
            return this;
        }

        public String getName() {
            return RESTORE_CONTEXT_METHOD_NAME;
        }

        public String getDisplayName(int mode) {
            return RESTORE_CONTEXT_METHOD_NAME;
        }

        public boolean isStatic() {
            return false;
        }

        public IOpenClass getType() {
            return JavaOpenClass.VOID;
        }

        public IMemberMetaInfo getInfo() {
            return null;
        }

        public IOpenClass getDeclaringClass() {
            return null;
        }

        public IMethodSignature getSignature() {
            return IMethodSignature.VOID;
        }

        public boolean isConstructor() {
            return false;
        }
    }

    public static final class EmptyRuntimeContextMethod
    implements IOpenMethod {
        static final String EMPTY_CONTEXT_METHOD_NAME = "emptyContext";

        public Object invoke(Object target, Object[] params, IRuntimeEnv env) {
            return RulesRuntimeContextFactory.buildRulesRuntimeContext();
        }

        public IOpenMethod getMethod() {
            return this;
        }

        public String getName() {
            return EMPTY_CONTEXT_METHOD_NAME;
        }

        public String getDisplayName(int mode) {
            return EMPTY_CONTEXT_METHOD_NAME;
        }

        public boolean isStatic() {
            return false;
        }

        public IOpenClass getType() {
            return JavaOpenClass.getOpenClass(IRulesRuntimeContext.class);
        }

        public IMemberMetaInfo getInfo() {
            return null;
        }

        public IOpenClass getDeclaringClass() {
            return null;
        }

        public IMethodSignature getSignature() {
            return IMethodSignature.VOID;
        }

        public boolean isConstructor() {
            return false;
        }
    }

    public static final class CurrentRuntimeContextMethod
    implements IOpenMethod {
        static final String CURRENT_CONTEXT_METHOD_NAME = "getContext";

        public Object invoke(Object target, Object[] params, IRuntimeEnv env) {
            IRulesRuntimeContext context = (IRulesRuntimeContext)env.getContext();
            try {
                return context.clone();
            }
            catch (CloneNotSupportedException e) {
                LoggerFactory.getLogger(RulesModuleBindingContext.class).warn("Failed to clone runtime context. Runtime context managing may work incorrectly.", (Throwable)e);
                return context;
            }
        }

        public IOpenMethod getMethod() {
            return this;
        }

        public String getName() {
            return CURRENT_CONTEXT_METHOD_NAME;
        }

        public String getDisplayName(int mode) {
            return CURRENT_CONTEXT_METHOD_NAME;
        }

        public boolean isStatic() {
            return false;
        }

        public IOpenClass getType() {
            return JavaOpenClass.getOpenClass(IRulesRuntimeContext.class);
        }

        public IMemberMetaInfo getInfo() {
            return null;
        }

        public IOpenClass getDeclaringClass() {
            return null;
        }

        public IMethodSignature getSignature() {
            return IMethodSignature.VOID;
        }

        public boolean isConstructor() {
            return false;
        }
    }
}

