/*
 * Decompiled with CFR 0.152.
 */
package org.openl.j;

import org.openl.grammar.bexgrammar.BExGrammar;
import org.openl.grammar.bexgrammar.ParseException;
import org.openl.grammar.bexgrammar.Token;
import org.openl.grammar.bexgrammar.TokenMgrError;
import org.openl.j.BracketMatcher;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.util.text.ILocation;
import org.openl.util.text.TextInterval;

public class BExGrammarWithParsingHelp
extends BExGrammar {
    private static final String ENCOUNTERED_PREFIX_EMPTY = "Encountered \"\"";
    private static final String WAS_EXPECTING = "Was expecting:";
    private static final String WAS_EXPECTING_ONE_OF = "Was expecting one of:";

    private static String addEscapes(String str) {
        StringBuilder retval = new StringBuilder();
        block8: for (int i = 0; i < str.length(); ++i) {
            switch (str.charAt(i)) {
                case '\u0000': {
                    continue block8;
                }
                case '\b': {
                    retval.append("\\b");
                    continue block8;
                }
                case '\t': {
                    retval.append("\\t");
                    continue block8;
                }
                case '\n': {
                    retval.append("\\n");
                    continue block8;
                }
                case '\f': {
                    retval.append("\\f");
                    continue block8;
                }
                case '\r': {
                    retval.append("\\r");
                    continue block8;
                }
                default: {
                    char ch = str.charAt(i);
                    if (ch < ' ' || ch > '~') {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u").append(s.substring(s.length() - 4));
                        continue block8;
                    }
                    retval.append(ch);
                }
            }
        }
        return retval.toString();
    }

    public void parseTopNode(String type) {
        try {
            switch (type) {
                case "method.body": {
                    this.parseTopNodeInternal();
                    break;
                }
                case "method.header": {
                    this.parseMethodHeader();
                    break;
                }
                case "module": {
                    this.parseModuleInternal();
                    break;
                }
                case "param.declaration": {
                    this.parseParamDeclaration();
                    break;
                }
                case "type": {
                    this.parseType();
                }
            }
        }
        catch (ParseException pe) {
            SyntaxNodeException sne = this.reparseTokens();
            if (sne == null) {
                String msg = pe.getMessage();
                TextInterval pos = this.pos(pe.currentToken);
                if (msg.startsWith(ENCOUNTERED_PREFIX_EMPTY) && pe.currentToken.next != null) {
                    msg = "Encountered \"" + pe.currentToken.next + "\"" + msg.substring(ENCOUNTERED_PREFIX_EMPTY.length());
                    pos = this.pos(pe.currentToken.next);
                } else if (msg.contains(WAS_EXPECTING) || msg.contains(WAS_EXPECTING_ONE_OF)) {
                    pos = this.pos(pe.currentToken.next);
                }
                sne = new SyntaxNodeException(msg, null, (ILocation)pos, this.module);
            }
            this.syntaxError = sne;
        }
        catch (TokenMgrError err) {
            TextInterval loc = this.pos(err.getMessage(), this.token);
            this.syntaxError = new SyntaxNodeException(err.getMessage(), null, (ILocation)loc, this.module);
        }
        catch (Exception e) {
            this.syntaxError = new SyntaxNodeException("Failed to parse an expression.", (Throwable)e, (ILocation)this.pos(this.token), this.module);
        }
    }

    private SyntaxNodeException reparseTokens() {
        BracketMatcher bm;
        block9: {
            Token t;
            BracketMatcher.BracketsStackObject bso;
            BExGrammar be = new BExGrammar();
            be.setModule(this.module);
            be.ReInit(this.module.getCharacterStream());
            bm = new BracketMatcher();
            do {
                try {
                    t = be.getNextToken();
                }
                catch (TokenMgrError err) {
                    TextInterval loc = this.pos(err.getMessage(), this.token);
                    return new SyntaxNodeException(err.getMessage(), null, (ILocation)loc, this.module);
                }
                if (t.kind == 0) break block9;
            } while ((bso = bm.addToken(t.image, t)) == null);
            switch (bso.getErrorCode()) {
                case UNEXPECTED: {
                    String message = String.format("Unexpected bracket '%s'", BExGrammarWithParsingHelp.addEscapes(t.image));
                    return new SyntaxNodeException(message, null, (ILocation)this.pos(t), this.module);
                }
                case MISMATCHED: {
                    Token t2 = (Token)bso.getId();
                    String message = String.format("Mismatched: opened with '%s' and closed with '%s'", BExGrammarWithParsingHelp.addEscapes(t2.image.substring(0, 1)), BExGrammarWithParsingHelp.addEscapes(t.image));
                    return new SyntaxNodeException(message, null, (ILocation)this.pos(t2, t), this.module);
                }
                case UNMATCHED: {
                    throw new IllegalStateException("UNMATCHED error type shouldn't appear here");
                }
            }
            throw new IllegalStateException("Unknown BracketMatchError = " + (Object)((Object)bso.getErrorCode()));
        }
        BracketMatcher.BracketsStackObject bso = bm.checkAtTheEnd();
        if (bso != null) {
            Token t = (Token)bso.getId();
            String message = String.format("Need to close '%s'", BExGrammarWithParsingHelp.addEscapes(t.image));
            return new SyntaxNodeException(message, null, (ILocation)this.pos(t), this.module);
        }
        return null;
    }
}

