/*
 * Decompiled with CFR 0.152.
 */
package org.openl.excel.parser.sax;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.openl.excel.parser.AlignedValue;
import org.openl.excel.parser.ExcelParseException;
import org.openl.excel.parser.MergedCell;
import org.openl.excel.parser.ParserDateUtil;
import org.openl.excel.parser.sax.MinimalStyleTable;
import org.openl.excel.parser.sax.NumberFormat;
import org.openl.util.NumberUtils;
import org.openl.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class SheetHandler
extends DefaultHandler {
    private static final int MAX_ESTIMATED_CELLS_COUNT = 2560000;
    private final Logger log = LoggerFactory.getLogger(SheetHandler.class);
    private final SharedStringsTable sharedStringsTable;
    private final ParserDateUtil parserDateUtil;
    private final boolean use1904Windowing;
    private final MinimalStyleTable stylesTable;
    private final LruCache<Integer, String> lruCache = new LruCache(50);
    private Object[][] cells = new Object[0][];
    private CellAddress start = CellAddress.A1;
    private CellAddress effectiveStart = null;
    private CellAddress effectiveEnd = null;
    private CellAddress current;
    private boolean vIsOpen;
    private boolean isInlineStringOpen;
    private final StringBuilder value = new StringBuilder();
    private XmlCellType nextDataType;
    private int formatIndex;
    private String formatString;
    private Short indent;
    private final List<CellRangeAddress> mergedCells = new ArrayList<CellRangeAddress>();

    SheetHandler(SharedStringsTable sharedStringsTable, boolean use1904Windowing, MinimalStyleTable stylesTable, ParserDateUtil parserDateUtil) {
        this.sharedStringsTable = sharedStringsTable;
        this.use1904Windowing = use1904Windowing;
        this.stylesTable = stylesTable;
        this.parserDateUtil = parserDateUtil;
    }

    public Object[][] getCells() {
        return this.cells;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) {
        block6: {
            String ref;
            String[] cellsRefs;
            block9: {
                NumberFormat numberFormat;
                int styleIndex;
                block14: {
                    String cellType;
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block8: {
                                        block7: {
                                            block5: {
                                                if (uri != null && !uri.equals("http://schemas.openxmlformats.org/spreadsheetml/2006/main")) {
                                                    return;
                                                }
                                                if (!"dimension".equals(name)) break block5;
                                                this.initializeCells(attributes.getValue("ref"));
                                                break block6;
                                            }
                                            if (!this.isTextTag(localName)) break block7;
                                            this.vIsOpen = true;
                                            this.value.setLength(0);
                                            break block6;
                                        }
                                        if (!"is".equals(localName)) break block8;
                                        this.isInlineStringOpen = true;
                                        break block6;
                                    }
                                    if (!"c".equals(localName)) break block9;
                                    this.nextDataType = XmlCellType.NUMBER;
                                    this.formatIndex = -1;
                                    this.formatString = null;
                                    String cellRef = attributes.getValue("r");
                                    this.current = new CellAddress(cellRef);
                                    String cellStyleStr = attributes.getValue("s");
                                    styleIndex = cellStyleStr != null ? Integer.parseInt(cellStyleStr) : 0;
                                    this.indent = this.stylesTable == null ? null : this.stylesTable.getIndent(styleIndex);
                                    cellType = attributes.getValue("t");
                                    if (!"b".equals(cellType)) break block10;
                                    this.nextDataType = XmlCellType.BOOLEAN;
                                    break block6;
                                }
                                if (!"e".equals(cellType)) break block11;
                                this.nextDataType = XmlCellType.ERROR;
                                break block6;
                            }
                            if (!"inlineStr".equals(cellType)) break block12;
                            this.nextDataType = XmlCellType.INLINE_STRING;
                            break block6;
                        }
                        if (!"s".equals(cellType)) break block13;
                        this.nextDataType = XmlCellType.SHARED_STRING_TABLE_STRING;
                        break block6;
                    }
                    if (!"str".equals(cellType)) break block14;
                    this.nextDataType = XmlCellType.FORMULA;
                    break block6;
                }
                if (this.stylesTable == null || (numberFormat = this.stylesTable.getFormat(styleIndex)) == null) break block6;
                this.formatIndex = numberFormat.getFormatIndex();
                this.formatString = numberFormat.getFormatString();
                break block6;
            }
            if ("mergeCell".equals(localName) && (cellsRefs = (ref = attributes.getValue("ref")).split(":")).length > 1) {
                int row;
                this.mergedCells.add(CellRangeAddress.valueOf((String)ref));
                CellAddress from = new CellAddress(cellsRefs[0]);
                CellAddress to = new CellAddress(cellsRefs[1]);
                int firstMergeRow = from.getRow();
                int firstMergeCol = from.getColumn();
                int lastMergeRow = to.getRow();
                int lastMergeCol = to.getColumn();
                for (row = firstMergeRow; row <= lastMergeRow; ++row) {
                    for (int col = firstMergeCol + 1; col <= lastMergeCol; ++col) {
                        this.setCell(row - this.start.getRow(), col - this.start.getColumn(), MergedCell.MERGE_WITH_LEFT);
                    }
                }
                for (row = firstMergeRow + 1; row <= lastMergeRow; ++row) {
                    this.setCell(row - this.start.getRow(), firstMergeCol - this.start.getColumn(), MergedCell.MERGE_WITH_UP);
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) {
        if (uri != null && !uri.equals("http://schemas.openxmlformats.org/spreadsheetml/2006/main")) {
            return;
        }
        Object parsedValue = null;
        if (this.isTextTag(localName)) {
            this.vIsOpen = false;
            switch (this.nextDataType) {
                case BOOLEAN: {
                    char first = this.value.charAt(0);
                    parsedValue = first != '0';
                    break;
                }
                case FORMULA: 
                case INLINE_STRING: {
                    parsedValue = StringUtils.trimToNull((String)this.value.toString());
                    break;
                }
                case SHARED_STRING_TABLE_STRING: {
                    String sstIndex = this.value.toString();
                    try {
                        int idx = Integer.parseInt(sstIndex);
                        String strValue = (String)this.lruCache.get(idx);
                        if (strValue == null && !this.lruCache.containsKey(idx)) {
                            strValue = this.sharedStringsTable.getItemAt(idx).toString();
                            this.lruCache.put(idx, strValue);
                        }
                        parsedValue = StringUtils.trimToNull((String)strValue);
                        break;
                    }
                    catch (NumberFormatException ex) {
                        throw new ExcelParseException("Failed to parse SST index '" + sstIndex, ex);
                    }
                }
                case NUMBER: {
                    String n = this.value.toString();
                    try {
                        if (n.isEmpty()) {
                            parsedValue = null;
                            break;
                        }
                        double d = Double.parseDouble(n);
                        if (DateUtil.isValidExcelDate((double)d) && this.parserDateUtil.isADateFormat(this.formatIndex, this.formatString)) {
                            parsedValue = DateUtil.getJavaDate((double)d, (boolean)this.use1904Windowing);
                            break;
                        }
                        parsedValue = NumberUtils.intOrDouble((double)d);
                        break;
                    }
                    catch (NumberFormatException e) {
                        throw new ExcelParseException("Cannot get a number from string " + n, e);
                    }
                }
                default: {
                    this.log.debug("Skipped data type: {}", (Object)this.nextDataType);
                }
            }
            int row = this.current.getRow() - this.start.getRow();
            int col = this.current.getColumn() - this.start.getColumn();
            if (this.indent != null && this.indent != 0) {
                parsedValue = new AlignedValue(parsedValue, this.indent);
            }
            this.setCell(row, col, parsedValue);
        } else if ("is".equals(localName)) {
            this.isInlineStringOpen = false;
        }
    }

    private void setCell(int row, int col, Object parsedValue) {
        int rowShift = 0;
        int colShift = 0;
        if (row < 0) {
            rowShift = -row;
            row = 0;
        }
        if (col < 0) {
            colShift = -col;
            col = 0;
        }
        int rowCount = this.cells.length;
        int maxRows = Math.max(row + 1, rowCount + rowShift);
        int columnCount = rowCount == 0 ? 0 : this.cells[0].length;
        int maxCols = Math.max(col + 1, columnCount + colShift);
        if (rowShift > 0 || colShift > 0) {
            this.start = new CellAddress(this.start.getRow() - rowShift, this.start.getColumn() - colShift);
        }
        if (maxRows > rowCount || maxCols > columnCount) {
            int newRows = maxRows > rowCount ? Math.max(maxRows, rowCount + (rowCount >> 1)) : maxRows;
            int newCols = maxCols > columnCount ? Math.max(maxCols, columnCount + (columnCount >> 1)) : columnCount;
            this.log.debug("Extend cells array. Current: {}:{}, new: {}:{}", new Object[]{rowCount, columnCount, newRows, newCols});
            Object[][] copy = new Object[newRows][newCols];
            this.arrayCopy(this.cells, copy, rowShift, colShift);
            this.cells = copy;
        }
        this.cells[row][col] = parsedValue;
        if (parsedValue != null && !(parsedValue instanceof MergedCell)) {
            int curRow = row + this.start.getRow();
            int curCol = col + this.start.getColumn();
            if (this.effectiveStart == null) {
                this.effectiveEnd = this.effectiveStart = new CellAddress(curRow, curCol);
            } else {
                if (curRow < this.effectiveStart.getRow() || curCol < this.effectiveStart.getColumn()) {
                    int minRow = Math.min(curRow, this.effectiveStart.getRow());
                    int minCol = Math.min(curCol, this.effectiveStart.getColumn());
                    this.effectiveStart = new CellAddress(minRow, minCol);
                }
                if (curRow > this.effectiveEnd.getRow() || curCol > this.effectiveEnd.getColumn()) {
                    int maxRow = Math.max(curRow, this.effectiveEnd.getRow());
                    int maxCol = Math.max(curCol, this.effectiveEnd.getColumn());
                    this.effectiveEnd = new CellAddress(maxRow, maxCol);
                }
            }
        }
    }

    private boolean isTextTag(String name) {
        return "v".equals(name) || "inlineStr".equals(name) || "t".equals(name) && this.isInlineStringOpen;
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.vIsOpen) {
            this.value.append(ch, start, length);
        }
    }

    @Override
    public void endDocument() {
        int rowCount = this.cells.length;
        if (rowCount == 0 || this.cells[0].length == 0) {
            return;
        }
        if (this.effectiveStart == null || this.effectiveEnd == null) {
            this.cells = new Object[0][];
            return;
        }
        for (CellRangeAddress mergedCell : this.mergedCells) {
            int r = mergedCell.getFirstRow() - this.start.getRow();
            int c = mergedCell.getFirstColumn() - this.start.getColumn();
            if (r < 0 || c < 0 || this.cells[r][c] == null || mergedCell.getLastRow() <= this.effectiveEnd.getRow() && mergedCell.getLastColumn() <= this.effectiveEnd.getColumn()) continue;
            int maxRow = Math.max(mergedCell.getLastRow(), this.effectiveEnd.getRow());
            int maxCol = Math.max(mergedCell.getLastColumn(), this.effectiveEnd.getColumn());
            this.effectiveEnd = new CellAddress(maxRow, maxCol);
        }
        int rows = this.effectiveEnd.getRow() - this.effectiveStart.getRow() + 1;
        int cols = this.effectiveEnd.getColumn() - this.effectiveStart.getColumn() + 1;
        int columnCount = this.cells[0].length;
        if (rows < rowCount || cols < columnCount) {
            this.log.debug("Optimize cells array. Current: {}:{}, new: {}:{}", new Object[]{rowCount, columnCount, rows, cols});
            int fromRow = this.effectiveStart.getRow() - this.start.getRow();
            int fromCol = this.effectiveStart.getColumn() - this.start.getColumn();
            Object[][] copy = new Object[rows][cols];
            for (int i = 0; i < copy.length; ++i) {
                System.arraycopy(this.cells[fromRow + i], fromCol, copy[i], 0, cols);
            }
            this.cells = copy;
            this.start = this.effectiveStart;
        }
    }

    private void initializeCells(String dimension) {
        String[] cellsRefs = dimension.split(":");
        this.start = new CellAddress(cellsRefs[0]);
        if (cellsRefs.length == 1) {
            this.log.debug("Array size: 1:1");
            this.cells = new Object[1][1];
        } else {
            int endColumn;
            int cols;
            int startRow = this.start.getRow();
            int startColumn = this.start.getColumn();
            CellAddress end = new CellAddress(cellsRefs[1]);
            int endRow = end.getRow();
            int rows = endRow - startRow + 1;
            if (rows * (cols = (endColumn = end.getColumn()) - startColumn + 1) > 2560000) {
                rows = Math.max(1, 2560000 / cols);
            }
            this.log.debug("Array size: {}:{}", (Object)rows, (Object)cols);
            this.cells = new Object[rows][cols];
        }
    }

    private void arrayCopy(Object[][] from, Object[][] to, int toRow, int toCol) {
        for (int i = 0; i < from.length; ++i) {
            System.arraycopy(from[i], 0, to[toRow + i], toCol, from[i].length);
        }
    }

    public CellAddress getStart() {
        return this.start;
    }

    private static enum XmlCellType {
        BOOLEAN,
        ERROR,
        FORMULA,
        INLINE_STRING,
        SHARED_STRING_TABLE_STRING,
        NUMBER;

    }

    private static class LruCache<A, B>
    extends LinkedHashMap<A, B> {
        private static final long serialVersionUID = -6937158218983475882L;
        private final int maxEntries;

        LruCache(int maxEntries) {
            super(maxEntries + 1, 1.0f, true);
            this.maxEntries = maxEntries;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<A, B> eldest) {
            return super.size() > this.maxEntries;
        }
    }
}

