/*
 * Decompiled with CFR 0.152.
 */
package org.openl.excel.parser.event.style;

import org.apache.poi.hssf.record.FontRecord;
import org.apache.poi.hssf.record.PaletteRecord;
import org.openl.excel.parser.event.style.PoiUtils;
import org.openl.rules.table.ui.ICellFont;

class OpenLCellFont
implements ICellFont {
    private static final short BOLDWEIGHT_BOLD = 700;
    private final FontRecord font;
    private final PaletteRecord palette;

    public OpenLCellFont(FontRecord font, PaletteRecord palette) {
        this.font = font;
        this.palette = palette;
    }

    @Override
    public short[] getFontColor() {
        return PoiUtils.toRgb(this.palette, this.font.getColorPaletteIndex());
    }

    @Override
    public String getName() {
        return this.font.getFontName();
    }

    @Override
    public int getSize() {
        return (short)(this.font.getFontHeight() / 20);
    }

    @Override
    public boolean isBold() {
        return this.font.getBoldWeight() == 700;
    }

    @Override
    public boolean isItalic() {
        return this.font.isItalic();
    }

    @Override
    public boolean isStrikeout() {
        return this.font.isStruckout();
    }

    @Override
    public boolean isUnderlined() {
        return this.font.getUnderline() != 0;
    }
}

