/*
 * Decompiled with CFR 0.152.
 */
package org.openl.excel.parser;

import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.DateUtil;

public final class ParserDateUtil {
    private final Map<CacheKey, Boolean> cache = new HashMap<CacheKey, Boolean>();

    public boolean isADateFormat(int formatIndex, String formatString) {
        CacheKey key = new CacheKey(formatIndex, formatString);
        return this.cache.computeIfAbsent(key, e -> DateUtil.isADateFormat((int)formatIndex, (String)formatString));
    }

    public void reset() {
        this.cache.clear();
    }

    private static class CacheKey {
        final int formatIndex;
        final String formatString;

        public CacheKey(int formatIndex, String formatString) {
            this.formatIndex = formatIndex;
            this.formatString = formatString;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.formatIndex;
            result = 31 * result + (this.formatString == null ? 0 : this.formatString.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (this.formatIndex != other.formatIndex) {
                return false;
            }
            return !(this.formatString == null ? other.formatString != null : !this.formatString.equals(other.formatString));
        }
    }
}

