/*
 * Decompiled with CFR 0.152.
 */
package org.openl.excel.grid;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openl.excel.grid.ParsedGrid;
import org.openl.excel.grid.SequentialXlsSheetSourceCodeModule;
import org.openl.excel.parser.ExcelReader;
import org.openl.excel.parser.ExcelReaderFactory;
import org.openl.excel.parser.SheetDescriptor;
import org.openl.exception.OpenLCompilationException;
import org.openl.message.OpenLMessage;
import org.openl.message.OpenLMessagesUtils;
import org.openl.rules.lang.xls.IncludeSearcher;
import org.openl.rules.lang.xls.TablePart;
import org.openl.rules.lang.xls.TablePartProcessor;
import org.openl.rules.lang.xls.XlsHelper;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.lang.xls.XlsSheetSourceCodeModule;
import org.openl.rules.lang.xls.XlsWorkbookSourceCodeModule;
import org.openl.rules.lang.xls.syntax.OpenlSyntaxNode;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.syntax.WorkbookSyntaxNode;
import org.openl.rules.lang.xls.syntax.WorksheetSyntaxNode;
import org.openl.rules.lang.xls.syntax.XlsModuleSyntaxNode;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.rules.table.syntax.GridLocation;
import org.openl.rules.table.xls.XlsSheetGridModel;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.URLSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.code.Dependency;
import org.openl.syntax.code.DependencyType;
import org.openl.syntax.code.IDependency;
import org.openl.syntax.code.IParsedCode;
import org.openl.syntax.code.impl.ParsedCode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.util.ParserUtils;
import org.openl.util.StringTool;
import org.openl.util.StringUtils;
import org.openl.util.text.ILocation;
import org.openl.util.text.LocationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequentialXlsLoader {
    private final Logger log = LoggerFactory.getLogger(SequentialXlsLoader.class);
    private final Collection<String> imports = new HashSet<String>();
    private final IncludeSearcher includeSeeker;
    private OpenlSyntaxNode openl;
    private final List<SyntaxNodeException> errors = new ArrayList<SyntaxNodeException>();
    private final Collection<OpenLMessage> messages = new LinkedHashSet<OpenLMessage>();
    private final Set<String> preprocessedWorkBooks = new HashSet<String>();
    private final List<WorkbookSyntaxNode> workbookNodes = new ArrayList<WorkbookSyntaxNode>();
    private final List<IDependency> dependencies = new ArrayList<IDependency>();

    public SequentialXlsLoader(IncludeSearcher includeSeeker) {
        this.includeSeeker = includeSeeker;
    }

    private WorksheetSyntaxNode[] createWorksheetNodes(TablePartProcessor tablePartProcessor, XlsWorkbookSourceCodeModule workbookSourceModule) {
        String path;
        IOpenSourceCodeModule source = workbookSourceModule.getSource();
        if ("<virtual_uri>".equals(source.getUri())) {
            int nsheets = workbookSourceModule.getWorkbookLoader().getNumberOfSheets();
            WorksheetSyntaxNode[] sheetNodes = new WorksheetSyntaxNode[nsheets];
            for (int i = 0; i < nsheets; ++i) {
                XlsSheetSourceCodeModule sheetSource = new XlsSheetSourceCodeModule(i, workbookSourceModule);
                IGridTable[] tables = new XlsSheetGridModel(sheetSource).getTables();
                sheetNodes[i] = this.createWorksheetSyntaxNode(tablePartProcessor, sheetSource, tables);
            }
            return sheetNodes;
        }
        ExcelReaderFactory factory = ExcelReaderFactory.sequentialFactory();
        try {
            path = workbookSourceModule.getSourceFile().getAbsolutePath();
        }
        catch (Exception ex) {
            path = null;
        }
        try (ExcelReader excelReader = path == null ? factory.create(source.getByteStream()) : factory.create(path);){
            List<? extends SheetDescriptor> sheets = excelReader.getSheets();
            boolean use1904Windowing = excelReader.isUse1904Windowing();
            int nsheets = sheets.size();
            WorksheetSyntaxNode[] sheetNodes = new WorksheetSyntaxNode[nsheets];
            for (int i = 0; i < nsheets; ++i) {
                SheetDescriptor sheet = sheets.get(i);
                SequentialXlsSheetSourceCodeModule sheetSource = new SequentialXlsSheetSourceCodeModule(workbookSourceModule, sheet);
                Object[][] cells = excelReader.getCells(sheet);
                IGridTable[] tables = new ParsedGrid(path, sheetSource, sheet, cells, use1904Windowing).getTables();
                sheetNodes[i] = this.createWorksheetSyntaxNode(tablePartProcessor, sheetSource, tables);
            }
            WorksheetSyntaxNode[] worksheetSyntaxNodeArray = sheetNodes;
            return worksheetSyntaxNodeArray;
        }
    }

    private void addError(SyntaxNodeException error) {
        this.errors.add(error);
    }

    public IParsedCode parse(IOpenSourceCodeModule source) {
        this.preprocessWorkbook(source);
        WorkbookSyntaxNode[] workbooksArray = this.workbookNodes.toArray(new WorkbookSyntaxNode[0]);
        XlsModuleSyntaxNode syntaxNode = new XlsModuleSyntaxNode(workbooksArray, source, this.openl, Collections.unmodifiableCollection(this.imports));
        SyntaxNodeException[] parsingErrors = this.errors.toArray(SyntaxNodeException.EMPTY_ARRAY);
        return new ParsedCode((ISyntaxNode)syntaxNode, source, parsingErrors, this.messages, this.dependencies.toArray(new IDependency[0]));
    }

    private void preprocessEnvironmentTable(TableSyntaxNode tableSyntaxNode, XlsSheetSourceCodeModule source) {
        ILogicalTable logicalTable = tableSyntaxNode.getTable();
        int height = logicalTable.getHeight();
        for (int i = 1; i < height; ++i) {
            ILogicalTable row = (ILogicalTable)logicalTable.getRow(i);
            String value = ((ILogicalTable)row.getColumn(0)).getSource().getCell(0, 0).getStringValue();
            if (StringUtils.isNotBlank((CharSequence)value)) {
                value = value.trim();
            }
            if ("language".equals(value)) {
                this.preprocessOpenlTable(row.getSource(), source);
                continue;
            }
            if ("dependency".equals(value)) {
                this.preprocessDependency(tableSyntaxNode, row.getSource());
                continue;
            }
            if ("include".equals(value)) {
                this.preprocessIncludeTable(tableSyntaxNode, row.getSource(), source);
                continue;
            }
            if ("import".equals(value)) {
                this.preprocessImportTable(row.getSource());
                continue;
            }
            if (ParserUtils.isBlankOrCommented((String)value)) {
                this.log.debug("Comment: {}", (Object)value);
                continue;
            }
            String message = String.format("Error in Environment table: unrecognized keyword '%s'", value);
            this.messages.add(OpenLMessagesUtils.newWarnMessage((String)message, (ISyntaxNode)tableSyntaxNode));
        }
    }

    private void preprocessDependency(TableSyntaxNode tableSyntaxNode, IGridTable gridTable) {
        int height = gridTable.getHeight();
        for (int i = 0; i < height; ++i) {
            String dependency = gridTable.getCell(1, i).getStringValue();
            if (!StringUtils.isNotBlank((CharSequence)dependency)) continue;
            dependency = dependency.trim();
            IdentifierNode node = new IdentifierNode("dependency", (ILocation)LocationUtils.createTextInterval((String)dependency), dependency, (IOpenSourceCodeModule)new GridCellSourceCodeModule(gridTable, 1, i, null));
            node.setParent((ISyntaxNode)tableSyntaxNode);
            Dependency moduleDependency = new Dependency(DependencyType.MODULE, node);
            this.dependencies.add((IDependency)moduleDependency);
        }
    }

    private void preprocessImportTable(IGridTable table) {
        int height = table.getHeight();
        for (int i = 0; i < height; ++i) {
            String singleImport = table.getCell(1, i).getStringValue();
            if (!StringUtils.isNotBlank((CharSequence)singleImport)) continue;
            this.addImport(singleImport.trim());
        }
    }

    private void addImport(String singleImport) {
        this.imports.add(singleImport);
    }

    protected static String getParentAndMergePaths(String p1, String p2) {
        p1 = p1.replaceAll("\\\\", "/");
        p2 = p2.replaceAll("\\\\", "/");
        String[] pp1 = p1.split("/");
        String[] pp2 = p2.split("/");
        ArrayList<String> result = new ArrayList<String>();
        int len = p1.endsWith("/") ? pp1.length : pp1.length - 1;
        for (int i = 0; i < len; ++i) {
            if (pp1[i].equals(".")) continue;
            if (pp1[i].equals("..") && !result.isEmpty() && !((String)result.get(result.size() - 1)).equals("..")) {
                result.remove(result.size() - 1);
                continue;
            }
            result.add(pp1[i]);
        }
        for (String s : pp2) {
            if (s.equals(".")) continue;
            if (!result.isEmpty() && s.equals("..")) {
                result.remove(result.size() - 1);
                continue;
            }
            result.add(s);
        }
        return String.join((CharSequence)"/", result);
    }

    private void preprocessIncludeTable(TableSyntaxNode tableSyntaxNode, IGridTable table, XlsSheetSourceCodeModule sheetSource) {
        int height = table.getHeight();
        for (int i = 0; i < height; ++i) {
            String include = table.getCell(1, i).getStringValue();
            if (!StringUtils.isNotBlank((CharSequence)include)) continue;
            include = include.trim();
            IOpenSourceCodeModule src = null;
            if (include.startsWith("<")) {
                try {
                    Matcher matcher = Pattern.compile("<([^<>]+)>").matcher(include);
                    matcher.find();
                    src = this.includeSeeker.findInclude(matcher.group(1));
                }
                catch (Exception e) {
                    this.messages.addAll(OpenLMessagesUtils.newErrorMessages((Throwable)e));
                }
                if (src == null) {
                    this.registerIncludeError(tableSyntaxNode, table, i, include, null);
                    continue;
                }
            } else {
                try {
                    String newURL = SequentialXlsLoader.getParentAndMergePaths(sheetSource.getWorkbookSource().getFileUri(), StringTool.encodeURL((String)include));
                    src = new URLSourceCodeModule(new URL(newURL));
                }
                catch (Exception t) {
                    this.registerIncludeError(tableSyntaxNode, table, i, include, t);
                    continue;
                }
            }
            try {
                this.preprocessWorkbook(src);
                continue;
            }
            catch (Exception t) {
                this.registerIncludeError(tableSyntaxNode, table, i, include, t);
            }
        }
    }

    private void registerIncludeError(TableSyntaxNode tableSyntaxNode, IGridTable table, int i, String include, Exception t) {
        SyntaxNodeException se = SyntaxNodeExceptionUtils.createError((String)("Include '" + include + "' is not found."), (Throwable)t, (ILocation)LocationUtils.createTextInterval((String)include), (IOpenSourceCodeModule)new GridCellSourceCodeModule(table, 1, i, null));
        this.addError(se);
    }

    private void preprocessOpenlTable(IGridTable table, XlsSheetSourceCodeModule source) {
        String openlName = table.getCell(1, 0).getStringValue();
        if (StringUtils.isNotBlank((CharSequence)openlName)) {
            openlName = openlName.trim();
        }
        this.setOpenl(new OpenlSyntaxNode(openlName, new GridLocation(table), source));
    }

    private TableSyntaxNode preprocessTable(IGridTable table, XlsSheetSourceCodeModule source, TablePartProcessor tablePartProcessor) throws OpenLCompilationException {
        TableSyntaxNode tsn = XlsHelper.createTableSyntaxNode(table, source);
        String type = tsn.getType();
        if (type.equals(XlsNodeTypes.XLS_ENVIRONMENT.toString())) {
            this.preprocessEnvironmentTable(tsn, source);
        } else if (type.equals(XlsNodeTypes.XLS_TABLEPART.toString())) {
            try {
                tablePartProcessor.register(table, source);
            }
            catch (Exception | LinkageError t) {
                tsn = new TableSyntaxNode(XlsNodeTypes.XLS_OTHER.toString(), tsn.getGridLocation(), source, table, tsn.getHeader());
                SyntaxNodeException sne = SyntaxNodeExceptionUtils.createError((Throwable)t, (ISyntaxNode)tsn);
                this.addError(sne);
            }
        }
        return tsn;
    }

    private void preprocessWorkbook(IOpenSourceCodeModule source) {
        String uri = source.getUri();
        if (this.preprocessedWorkBooks.contains(uri)) {
            return;
        }
        this.preprocessedWorkBooks.add(uri);
        TablePartProcessor tablePartProcessor = new TablePartProcessor();
        XlsWorkbookSourceCodeModule workbookSourceModule = new XlsWorkbookSourceCodeModule(source);
        WorksheetSyntaxNode[] sheetNodes = this.createWorksheetNodes(tablePartProcessor, workbookSourceModule);
        this.workbookNodes.add(this.createWorkbookNode(tablePartProcessor, workbookSourceModule, sheetNodes));
        this.messages.addAll(tablePartProcessor.getMessages());
    }

    private WorkbookSyntaxNode createWorkbookNode(TablePartProcessor tablePartProcessor, XlsWorkbookSourceCodeModule workbookSourceModule, WorksheetSyntaxNode[] sheetNodes) {
        TableSyntaxNode[] mergedNodes = new TableSyntaxNode[]{};
        try {
            List<TablePart> tableParts = tablePartProcessor.mergeAllNodes();
            int n = tableParts.size();
            mergedNodes = new TableSyntaxNode[n];
            for (int i = 0; i < n; ++i) {
                mergedNodes[i] = this.preprocessTable(tableParts.get(i).getTable(), tableParts.get(i).getSource(), tablePartProcessor);
            }
        }
        catch (OpenLCompilationException e) {
            this.messages.add(OpenLMessagesUtils.newErrorMessage((OpenLCompilationException)e));
        }
        return new WorkbookSyntaxNode(sheetNodes, mergedNodes, workbookSourceModule);
    }

    private WorksheetSyntaxNode createWorksheetSyntaxNode(TablePartProcessor tablePartProcessor, XlsSheetSourceCodeModule sheetSource, IGridTable[] tables) {
        ArrayList<TableSyntaxNode> tableNodes = new ArrayList<TableSyntaxNode>();
        for (IGridTable table : tables) {
            try {
                TableSyntaxNode tsn = this.preprocessTable(table, sheetSource, tablePartProcessor);
                tableNodes.add(tsn);
            }
            catch (OpenLCompilationException e) {
                this.messages.add(OpenLMessagesUtils.newErrorMessage((OpenLCompilationException)e));
            }
        }
        return new WorksheetSyntaxNode(tableNodes.toArray(TableSyntaxNode.EMPTY_ARRAY), sheetSource);
    }

    private void setOpenl(OpenlSyntaxNode openl) {
        if (this.openl == null) {
            this.openl = openl;
        } else if (!this.openl.getOpenlName().equals(openl.getOpenlName())) {
            SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)"Only one openl statement is allowed", null, (ISyntaxNode)openl);
            this.addError(error);
        }
    }
}

