/*
 * Decompiled with CFR 0.152.
 */
package org.openl.engine;

import java.util.Map;
import org.openl.util.BooleanUtils;

public class OpenLSystemProperties {
    public static final String CUSTOM_SPREADSHEET_TYPE_PROPERTY = "custom.spreadsheet.type";
    public static final String DISPATCHING_VALIDATION = "dispatching.validation";
    public static final String DISPATCHING_MODE_PROPERTY = "dispatching.mode";
    public static final String DISPATCHING_MODE_JAVA = "java";
    public static final String DISPATCHING_MODE_DT = "dt";

    private OpenLSystemProperties() {
    }

    public static boolean isDTDispatchingMode(Map<String, Object> externalParameters) {
        String dispatchingMode = OpenLSystemProperties.getProperty(externalParameters, DISPATCHING_MODE_PROPERTY);
        return DISPATCHING_MODE_DT.equalsIgnoreCase(dispatchingMode);
    }

    public static boolean isDispatchingValidationEnabled(Map<String, Object> externalParameters) {
        String dispatchingValidation = OpenLSystemProperties.getProperty(externalParameters, DISPATCHING_VALIDATION);
        return BooleanUtils.toBoolean((Object)dispatchingValidation);
    }

    public static boolean isCustomSpreadsheetTypesSupported(Map<String, Object> externalParameters) {
        String customSpreadsheetType = OpenLSystemProperties.getProperty(externalParameters, CUSTOM_SPREADSHEET_TYPE_PROPERTY);
        return BooleanUtils.toBoolean((Object)customSpreadsheetType, (boolean)true);
    }

    private static String getProperty(Map<String, Object> externalParameters, String property) {
        String value = externalParameters != null && externalParameters.containsKey(property) ? externalParameters.get(property).toString() : System.getProperty(property);
        return value;
    }
}

