/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import java.util.Optional;
import org.openl.binding.IBoundNode;
import org.openl.binding.impl.MethodBoundNode;
import org.openl.binding.impl.MethodUsage;
import org.openl.binding.impl.NodeUsage;
import org.openl.binding.impl.NodeUsageCreator;
import org.openl.binding.impl.method.NullVarArgsOpenMethod;
import org.openl.binding.impl.method.VarArgsOpenMethod;
import org.openl.rules.types.impl.MatchingOpenMethodDispatcher;
import org.openl.types.IMethodCaller;
import org.openl.types.IOpenMethod;
import org.openl.types.impl.ExecutableMethod;
import org.openl.types.impl.MethodDelegator;
import org.openl.types.java.JavaOpenConstructor;
import org.openl.util.text.ILocation;
import org.openl.util.text.TextInfo;

final class MethodBoundNodeUsageCreator
implements NodeUsageCreator {
    private MethodBoundNodeUsageCreator() {
    }

    @Override
    public boolean accept(IBoundNode boundNode) {
        return boundNode instanceof MethodBoundNode;
    }

    @Override
    public Optional<NodeUsage> create(IBoundNode boundNode, String sourceString, int startIndex) {
        MethodBoundNode methodBoundNode = (MethodBoundNode)boundNode;
        ILocation location = methodBoundNode.getSyntaxNode().getSourceLocation();
        IMethodCaller methodCaller = methodBoundNode.getMethodCaller();
        if (methodCaller != null && location != null && location.isTextLocation()) {
            IOpenMethod method = methodCaller instanceof NullVarArgsOpenMethod ? ((NullVarArgsOpenMethod)methodCaller).getDelegate() : (methodCaller instanceof VarArgsOpenMethod ? ((VarArgsOpenMethod)methodCaller).getDelegate() : (methodCaller instanceof IOpenMethod ? (IOpenMethod)methodCaller : methodCaller.getMethod()));
            if (method instanceof ExecutableMethod || method instanceof MatchingOpenMethodDispatcher || method instanceof MethodDelegator) {
                TextInfo info = new TextInfo(sourceString);
                int pstart = location.getStart().getAbsolutePosition(info) + startIndex;
                int pend = pstart + method.getName().length();
                return Optional.of(new MethodUsage(pstart, pend, method));
            }
            if (method instanceof JavaOpenConstructor && methodBoundNode.getSyntaxNode().getNumberOfChildren() > 0) {
                TextInfo info = new TextInfo(sourceString);
                location = methodBoundNode.getSyntaxNode().getChild(0).getSourceLocation();
                if (location != null && location.isTextLocation()) {
                    int pstart = location.getStart().getAbsolutePosition(info) + startIndex;
                    String x = sourceString.substring(pstart);
                    int pend = pstart + x.indexOf(method.getDeclaringClass().getDisplayName(0)) + method.getDeclaringClass().getDisplayName(0).length();
                    return Optional.of(new MethodUsage(pstart, pend, method));
                }
            }
        }
        return Optional.empty();
    }

    public static MethodBoundNodeUsageCreator getInstance() {
        return Holder.INSTANCE;
    }

    private static class Holder {
        private static final MethodBoundNodeUsageCreator INSTANCE = new MethodBoundNodeUsageCreator();

        private Holder() {
        }
    }
}

