/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import java.util.Optional;
import org.openl.binding.IBoundNode;
import org.openl.binding.impl.ConstructorNode;
import org.openl.binding.impl.ConstructorUsage;
import org.openl.binding.impl.MethodBoundNode;
import org.openl.binding.impl.NodeUsage;
import org.openl.binding.impl.NodeUsageCreator;
import org.openl.syntax.ISyntaxNode;
import org.openl.types.IOpenMethod;
import org.openl.util.text.ILocation;
import org.openl.util.text.TextInfo;

public class ConstructorNodeCreator
implements NodeUsageCreator {
    private ConstructorNodeCreator() {
    }

    @Override
    public boolean accept(IBoundNode boundNode) {
        return boundNode instanceof ConstructorNode;
    }

    @Override
    public Optional<NodeUsage> create(IBoundNode boundNode, String sourceString, int startIndex) {
        int pstart;
        ConstructorNode constructorNode = (ConstructorNode)boundNode;
        TextInfo info = new TextInfo(sourceString);
        MethodBoundNode methodBoundNode = constructorNode.getConstructor();
        ISyntaxNode syntaxNode = methodBoundNode.getSyntaxNode();
        IOpenMethod method = methodBoundNode.getMethodCaller().getMethod();
        ILocation location = syntaxNode.getSourceLocation();
        int pend = pstart = startIndex + location.getStart().getAbsolutePosition(info);
        if (sourceString.indexOf(method.getDeclaringClass().getPackageName()) == pstart) {
            pend += method.getDeclaringClass().getPackageName().length() + 1;
        }
        return Optional.of(new ConstructorUsage(constructorNode, pstart, pend += method.getDeclaringClass().getDisplayName(0).length(), method));
    }

    public static ConstructorNodeCreator getInstance() {
        return Holder.INSTANCE;
    }

    private static class Holder {
        private static final ConstructorNodeCreator INSTANCE = new ConstructorNodeCreator();

        private Holder() {
        }
    }
}

