/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.Constraint;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.IntBoolExp;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.IntExpConst;
import org.openl.ie.constrainer.impl.ConstraintExpEqualsValue;
import org.openl.ie.constrainer.impl.ExpressionImpl;
import org.openl.ie.constrainer.impl.IntBoolExpEqValue;
import org.openl.ie.constrainer.impl.IntBoolExpLessExp;
import org.openl.ie.constrainer.impl.IntExpAddExp;
import org.openl.ie.constrainer.impl.IntExpAddValue;

public abstract class IntExpImpl
extends ExpressionImpl
implements IntExp {
    public static String domainToString(int min, int max) {
        return min == max ? "[" + min + "]" : "[" + min + ".." + max + "]";
    }

    public IntExpImpl(Constrainer constrainer) {
        this(constrainer, "");
    }

    public IntExpImpl(Constrainer constrainer, String name) {
        super(constrainer, name);
    }

    @Override
    public IntExp add(int value) {
        return this.getIntExp(IntExpAddValue.class, (IntExp)this, value);
    }

    @Override
    public IntExp add(IntExp exp) {
        return this.getIntExp(IntExpAddExp.class, (IntExp)this, exp);
    }

    @Override
    public boolean bound() {
        return this.min() == this.max();
    }

    @Override
    public boolean contains(int value) {
        return value >= this.min() && value <= this.max();
    }

    @Override
    public String domainToString() {
        return IntExpImpl.domainToString(this.min(), this.max());
    }

    @Override
    public IntBoolExp eq(int value) {
        return this.getIntBoolExp(IntBoolExpEqValue.class, (IntExp)this, value);
    }

    @Override
    public Constraint equals(int value) {
        return new ConstraintExpEqualsValue(this, value);
    }

    @Override
    public IntBoolExp ge(int value) {
        return this.gt(value - 1);
    }

    @Override
    public IntBoolExp gt(int value) {
        return this.gt(this.getIntExp(IntExpConst.class, value));
    }

    @Override
    public IntBoolExp gt(IntExp exp) {
        return this.getIntBoolExp(IntBoolExpLessExp.class, exp, this);
    }

    @Override
    public boolean isLinear() {
        return false;
    }

    @Override
    public void iterateDomain(IntExp.IntDomainIterator it) throws Failure {
        for (int i = this.min(); i <= this.max(); ++i) {
            boolean res;
            if (!this.contains(i) || (res = it.doSomethingOrStop(i))) continue;
            return;
        }
    }

    @Override
    public IntBoolExp le(int value) {
        return this.lt(value + 1);
    }

    @Override
    public IntBoolExp lt(int value) {
        return this.lt(this.getIntExp(IntExpConst.class, value));
    }

    @Override
    public IntBoolExp lt(IntExp exp) {
        return this.getIntBoolExp(IntBoolExpLessExp.class, (IntExp)this, exp);
    }

    @Override
    public void propagate() throws Failure {
    }

    @Override
    public void removeRange(int min, int max) throws Failure {
        this.removeRangeInternal(min, max);
    }

    protected void removeRangeInternal(int min, int max) throws Failure {
    }

    @Override
    public void removeValue(int value) throws Failure {
        int min = this.min();
        if (value == min) {
            this.setMin(min + 1);
        } else {
            int max = this.max();
            if (value == max) {
                this.setMax(max - 1);
            } else {
                this.removeValueInternal(value);
            }
        }
    }

    protected void removeValueInternal(int value) throws Failure {
    }

    @Override
    public void setValue(int value) throws Failure {
        this.setMin(value);
        this.setMax(value);
    }

    @Override
    public int size() {
        return this.max() - this.min() + 1;
    }

    @Override
    public String toString() {
        return this.name() + this.domainToString();
    }

    @Override
    public int value() throws Failure {
        int min = this.min();
        if (min != this.max()) {
            this._constrainer.fail("Attempt to get value of an unbound expression" + this);
        }
        return min;
    }

    @Override
    public int valueUnsafe() {
        return this.min();
    }
}

