/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.IntBoolExp;
import org.openl.ie.constrainer.Observer;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.IntBoolExpForSubject;

final class IntBoolExpAnd
extends IntBoolExpForSubject {
    private final IntBoolExp _exp1;
    private final IntBoolExp _exp2;

    public IntBoolExpAnd(IntBoolExp exp1, IntBoolExp exp2) {
        super(exp1.constrainer());
        this._exp1 = exp1;
        this._exp2 = exp2;
        if (this.constrainer().showInternalNames()) {
            this._name = "(" + exp1.name() + "&&" + exp2.name() + ")";
        }
        this.setDomainMinMaxSafe();
        this._exp1.attachObserver(new ObserverBoolExpAnd(this._exp2));
        this._exp2.attachObserver(new ObserverBoolExpAnd(this._exp1));
    }

    @Override
    protected boolean isSubjectFalse() {
        return this._exp1.isFalse() || this._exp2.isFalse();
    }

    @Override
    protected boolean isSubjectTrue() {
        return this._exp1.isTrue() && this._exp2.isTrue();
    }

    @Override
    protected void setSubjectFalse() throws Failure {
        if (this._exp1.isTrue()) {
            this._exp2.setFalse();
        }
        if (this._exp2.isTrue()) {
            this._exp1.setFalse();
        }
    }

    @Override
    protected void setSubjectTrue() throws Failure {
        this._exp1.setTrue();
        this._exp2.setTrue();
    }

    class ObserverBoolExpAnd
    extends Observer {
        final IntBoolExp _exp2;

        public ObserverBoolExpAnd(IntBoolExp exp2) {
            this._exp2 = exp2;
        }

        @Override
        public Object master() {
            return IntBoolExpAnd.this;
        }

        @Override
        public int subscriberMask() {
            return 6;
        }

        @Override
        public void update(Subject subject, EventOfInterest interest) throws Failure {
            if (interest.isMaxEvent()) {
                IntBoolExpAnd.this.setDomainMax(0);
            } else {
                IntBoolExpAnd.this.setDomainMin(this._exp2.min());
                IntBoolExpAnd.this.setDomainMax(this._exp2.max());
                this._exp2.setMin(IntBoolExpAnd.this._min);
                this._exp2.setMax(IntBoolExpAnd.this._max);
            }
        }
    }
}

