/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import java.io.Serializable;
import java.util.Arrays;

final class BitArray
implements Serializable {
    private static final int BITS_PER_WORD = 32;
    int[] _bits;
    final int _size;

    BitArray(int size) {
        this._bits = new int[(size - 1) / 32 + 1];
        this._size = size;
        Arrays.fill(this._bits, -1);
    }

    boolean at(int index) {
        return (this._bits[index / 32] & 1 << index) != 0;
    }

    void set(int index, boolean val) {
        if (val) {
            int n = index / 32;
            this._bits[n] = this._bits[n] | 1 << index;
        } else {
            int n = index / 32;
            this._bits[n] = this._bits[n] & ~(1 << index);
        }
    }

    int size() {
        return this._size;
    }
}

