/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.ConstrainerObjectImpl;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.IntExpConst;
import org.openl.ie.constrainer.impl.IntExpAddArray1;
import org.openl.ie.tools.FastVector;

public final class IntExpArray
extends ConstrainerObjectImpl {
    private final IntExp[] _data;

    public IntExpArray(Constrainer c, FastVector v) {
        this(c, v.size());
        for (int i = 0; i < this._data.length; ++i) {
            this._data[i] = (IntExp)v.elementAt(i);
        }
    }

    public IntExpArray(Constrainer c, int size) {
        super(c);
        this._data = new IntExp[size];
    }

    public IntExpArray(Constrainer c, int size, int min, int max, String array_name) {
        this(c, size);
        this.name(array_name);
        for (int i = 0; i < this._data.length; ++i) {
            this._data[i] = c.addIntVar(min, max, array_name + "(" + i + ")");
        }
    }

    public IntExpArray(Constrainer c, int size, int min, int max, String array_name, int int_domain) {
        this(c, size);
        this.name(array_name);
        for (int i = 0; i < this._data.length; ++i) {
            this._data[i] = c.addIntVar(min, max, array_name + "(" + i + ")", int_domain);
        }
    }

    public IntExpArray(Constrainer c, IntExp e0) {
        this(c, 1);
        this._data[0] = e0;
    }

    public IntExpArray(Constrainer c, IntExp e0, IntExp e1) {
        this(c, 2);
        this._data[0] = e0;
        this._data[1] = e1;
    }

    public IntExpArray(Constrainer c, IntExp e0, IntExp e1, IntExp e2) {
        this(c, 3);
        this._data[0] = e0;
        this._data[1] = e1;
        this._data[2] = e2;
    }

    public IntExpArray(Constrainer c, IntExp e0, IntExp e1, IntExp e2, IntExp e3) {
        this(c, 4);
        this._data[0] = e0;
        this._data[1] = e1;
        this._data[2] = e2;
        this._data[3] = e3;
    }

    public IntExpArray(Constrainer c, IntExp e0, IntExp e1, IntExp e2, IntExp e3, IntExp e4) {
        this(c, 5);
        this._data[0] = e0;
        this._data[1] = e1;
        this._data[2] = e2;
        this._data[3] = e3;
        this._data[4] = e4;
    }

    public IntExpArray(Constrainer c, IntExp e0, IntExp e1, IntExp e2, IntExp e3, IntExp e4, IntExp e5) {
        this(c, 6);
        this._data[0] = e0;
        this._data[1] = e1;
        this._data[2] = e2;
        this._data[3] = e3;
        this._data[4] = e4;
        this._data[5] = e5;
    }

    public IntExpArray(Constrainer c, IntExp e0, IntExp e1, IntExp e2, IntExp e3, IntExp e4, IntExp e5, IntExp e6) {
        this(c, 7);
        this._data[0] = e0;
        this._data[1] = e1;
        this._data[2] = e2;
        this._data[3] = e3;
        this._data[4] = e4;
        this._data[5] = e5;
        this._data[6] = e6;
    }

    public IntExpArray(Constrainer c, IntExp e0, IntExp e1, IntExp e2, IntExp e3, IntExp e4, IntExp e5, IntExp e6, IntExp e7) {
        this(c, 8);
        this._data[0] = e0;
        this._data[1] = e1;
        this._data[2] = e2;
        this._data[3] = e3;
        this._data[4] = e4;
        this._data[5] = e5;
        this._data[6] = e6;
        this._data[7] = e7;
    }

    public IntExpArray(Constrainer c, IntExp e0, IntExp e1, IntExp e2, IntExp e3, IntExp e4, IntExp e5, IntExp e6, IntExp e7, IntExp e8) {
        this(c, 9);
        this._data[0] = e0;
        this._data[1] = e1;
        this._data[2] = e2;
        this._data[3] = e3;
        this._data[4] = e4;
        this._data[5] = e5;
        this._data[6] = e6;
        this._data[7] = e7;
        this._data[8] = e8;
    }

    public IntExpArray(Constrainer c, IntExp[] vars) {
        super(c);
        this._data = new IntExp[vars.length];
        System.arraycopy(vars, 0, this._data, 0, vars.length);
    }

    public IntExpArray(Constrainer c, List<IntExp> v) {
        this(c, v.size());
        for (int i = 0; i < this._data.length; ++i) {
            this._data[i] = v.get(i);
        }
    }

    public IntExp[] data() {
        return this._data;
    }

    public IntExp elementAt(int idx) {
        return this._data[idx];
    }

    public IntExp get(int idx) {
        return this._data[idx];
    }

    public int max() {
        int max = Integer.MIN_VALUE;
        for (IntExp datum : this._data) {
            int maxi = datum.max();
            if (maxi <= max) continue;
            max = maxi;
        }
        return max;
    }

    public IntExpArray merge(IntExpArray array) {
        int i;
        ArrayList<IntExp> new_data = new ArrayList<IntExp>(this._data.length + array._data.length);
        for (i = 0; i < this._data.length; ++i) {
            new_data.add(this._data[i]);
        }
        for (i = 0; i < array._data.length; ++i) {
            new_data.add(array._data[i]);
        }
        return new IntExpArray(this.constrainer(), new_data);
    }

    public int min() {
        int min = Integer.MAX_VALUE;
        for (IntExp datum : this._data) {
            int mini = datum.min();
            if (mini >= min) continue;
            min = mini;
        }
        return min;
    }

    @Override
    public void name(String name) {
        this.symbolicName(name);
    }

    public void set(IntExp exp, int idx) {
        this._data[idx] = exp;
    }

    public int size() {
        return this._data.length;
    }

    public void sort(Comparator<IntExp> c) {
        Arrays.sort(this._data, c);
    }

    public IntExp sum() {
        switch (this.size()) {
            case 0: {
                return (IntExp)this._constrainer.expressionFactory().getExpression(IntExpConst.class, new Object[]{this._constrainer, 0});
            }
            case 1: {
                return this._data[0];
            }
            case 2: {
                return this._data[0].add(this._data[1]);
            }
        }
        return (IntExp)this._constrainer.expressionFactory().getExpression(IntExpAddArray1.class, new Object[]{this._constrainer, this});
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        for (int i = 0; i < this._data.length; ++i) {
            if (i > 0) {
                buf.append(" ");
            }
            buf.append(this._data[i]);
        }
        buf.append("]");
        return buf.toString();
    }
}

