/*
 * Decompiled with CFR 0.152.
 */
package org.openl.grammar;

import org.openl.util.text.IPosition;
import org.openl.util.text.TextInfo;

public class JavaCC30Position
implements IPosition {
    private final int jcc30line;
    private final int jcc30col;

    public JavaCC30Position(int jcc30line, int jcc30col) {
        this.jcc30col = jcc30col;
        this.jcc30line = jcc30line;
    }

    public int getAbsolutePosition(TextInfo info) {
        if (this.jcc30line == 0) {
            return 0;
        }
        int line = this.jcc30line - 1;
        int linePos = info.getPosition(line);
        int colPos = Math.min(info.getLine(line).length(), this.jcc30col - 1);
        return linePos + colPos;
    }

    public int getColumn(TextInfo info) {
        if (this.jcc30line == 0) {
            return 0;
        }
        int line = this.jcc30line - 1;
        int colPos = Math.min(info.getLine(line).length(), this.jcc30col - 1);
        return colPos + 1;
    }

    public int getLine(TextInfo info) {
        return this.jcc30line - 1;
    }

    public String toString() {
        return "(" + this.jcc30line + "," + this.jcc30col + ")";
    }
}

