/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Arrays;
import org.openl.util.ArrayTool;

public class MathUtils {
    private static <T extends Number> double[] numberArrayToDoubleArray(T[] values) {
        if (values == null) {
            return null;
        }
        double[] doubleArray = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            doubleArray[i] = ((Number)values[i]).doubleValue();
        }
        return doubleArray;
    }

    private static double[] byteArrayToDoubleArray(byte[] values) {
        if (values == null) {
            return null;
        }
        double[] doubleArray = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            doubleArray[i] = values[i];
        }
        return doubleArray;
    }

    private static double[] shortArrayToDoubleArray(short[] values) {
        if (values == null) {
            return null;
        }
        double[] doubleArray = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            doubleArray[i] = values[i];
        }
        return doubleArray;
    }

    private static double[] intArrayToDoubleArray(int[] values) {
        if (values == null) {
            return null;
        }
        double[] doubleArray = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            doubleArray[i] = values[i];
        }
        return doubleArray;
    }

    private static double[] longArrayToDoubleArray(long[] values) {
        if (values == null) {
            return null;
        }
        double[] doubleArray = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            doubleArray[i] = values[i];
        }
        return doubleArray;
    }

    private static double[] floatArrayToDoubleArray(float[] values) {
        if (values == null) {
            return null;
        }
        double[] doubleArray = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            doubleArray[i] = values[i];
        }
        return doubleArray;
    }

    public static <T extends Comparable<T>> T small(T[] values, int position) {
        if (values == null) {
            return null;
        }
        int index = position - 1;
        values = (Comparable[])ArrayTool.removeNulls(values);
        MathUtils.validateIndex(index < 0 || values.length <= index, position);
        Object[] v = (Comparable[])values.clone();
        Arrays.sort(v);
        return (T)v[index];
    }

    public static Byte small(byte[] values, int position) {
        if (values == null) {
            return null;
        }
        int index = position - 1;
        MathUtils.validateIndex(index < 0 || values.length <= index, position);
        byte[] v = (byte[])values.clone();
        Arrays.sort(v);
        return v[index];
    }

    public static Short small(short[] values, int position) {
        if (values == null) {
            return null;
        }
        int index = position - 1;
        MathUtils.validateIndex(index < 0 || values.length <= index, position);
        short[] v = (short[])values.clone();
        Arrays.sort(v);
        return v[index];
    }

    public static Integer small(int[] values, int position) {
        if (values == null) {
            return null;
        }
        int index = position - 1;
        MathUtils.validateIndex(index < 0 || values.length <= index, position);
        int[] v = (int[])values.clone();
        Arrays.sort(v);
        return v[index];
    }

    public static Long small(long[] values, int position) {
        if (values == null) {
            return null;
        }
        int index = position - 1;
        MathUtils.validateIndex(index < 0 || values.length <= index, position);
        long[] v = (long[])values.clone();
        Arrays.sort(v);
        return v[index];
    }

    public static Float small(float[] values, int position) {
        if (values == null) {
            return null;
        }
        int index = position - 1;
        MathUtils.validateIndex(index < 0 || values.length <= index, position);
        float[] v = (float[])values.clone();
        Arrays.sort(v);
        return Float.valueOf(v[index]);
    }

    public static Double small(double[] values, int position) {
        if (values == null) {
            return null;
        }
        int index = position - 1;
        MathUtils.validateIndex(index < 0 || values.length <= index, position);
        double[] v = (double[])values.clone();
        Arrays.sort(v);
        return v[index];
    }

    public static <T extends Comparable<T>> T big(T[] values, int position) {
        if (values == null) {
            return null;
        }
        int index = position - 1;
        values = (Comparable[])ArrayTool.removeNulls(values);
        MathUtils.validateIndex(index < 0 || values.length <= index, position);
        Object[] v = (Comparable[])values.clone();
        Arrays.sort(v);
        return (T)v[v.length - 1 - index];
    }

    public static Byte big(byte[] values, int position) {
        if (values == null) {
            return null;
        }
        int index = position - 1;
        MathUtils.validateIndex(index < 0 || values.length <= index, position);
        byte[] v = (byte[])values.clone();
        Arrays.sort(v);
        return v[v.length - 1 - index];
    }

    public static Short big(short[] values, int position) {
        if (values == null) {
            return null;
        }
        int index = position - 1;
        MathUtils.validateIndex(index < 0 || values.length <= index, position);
        short[] v = (short[])values.clone();
        Arrays.sort(v);
        return v[v.length - 1 - index];
    }

    public static Integer big(int[] values, int position) {
        if (values == null) {
            return null;
        }
        int index = position - 1;
        MathUtils.validateIndex(index < 0 || values.length <= index, position);
        int[] v = (int[])values.clone();
        Arrays.sort(v);
        return v[v.length - 1 - index];
    }

    public static Long big(long[] values, int position) {
        if (values == null) {
            return null;
        }
        int index = position - 1;
        MathUtils.validateIndex(index < 0 || values.length <= index, position);
        long[] v = (long[])values.clone();
        Arrays.sort(v);
        return v[v.length - 1 - index];
    }

    public static Float big(float[] values, int position) {
        if (values == null) {
            return null;
        }
        int index = position - 1;
        MathUtils.validateIndex(index < 0 || values.length <= index, position);
        float[] v = (float[])values.clone();
        Arrays.sort(v);
        return Float.valueOf(v[v.length - 1 - index]);
    }

    public static Double big(double[] values, int position) {
        if (values == null) {
            return null;
        }
        int index = position - 1;
        MathUtils.validateIndex(index < 0 || values.length <= index, position);
        double[] v = (double[])values.clone();
        Arrays.sort(v);
        return v[v.length - 1 - index];
    }

    private static void validateIndex(boolean throwException, int position) {
        if (throwException) {
            throw new IllegalArgumentException(String.format("There is no position '%d' in the given array.", position));
        }
    }

    public static Byte sum(byte[] values) {
        if (values == null) {
            return null;
        }
        byte sum = 0;
        for (byte a : values) {
            sum = (byte)(sum + a);
        }
        return sum;
    }

    public static Short sum(short[] values) {
        if (values == null) {
            return null;
        }
        short sum = 0;
        for (short a : values) {
            sum = (short)(sum + a);
        }
        return sum;
    }

    public static Integer sum(int[] values) {
        if (values == null) {
            return null;
        }
        int sum = 0;
        for (int a : values) {
            sum += a;
        }
        return sum;
    }

    public static Long sum(long[] values) {
        if (values == null) {
            return null;
        }
        long sum = 0L;
        for (long a : values) {
            sum += a;
        }
        return sum;
    }

    public static Float sum(float[] values) {
        if (values == null) {
            return null;
        }
        float sum = 0.0f;
        for (float a : values) {
            sum += a;
        }
        return Float.valueOf(sum);
    }

    public static Double sum(double[] values) {
        if (values == null) {
            return null;
        }
        double sum = 0.0;
        for (double a : values) {
            sum += a;
        }
        return sum;
    }

    public static <T extends Number> Double median(T[] values) {
        if (values == null) {
            return null;
        }
        if ((values = (Number[])ArrayTool.removeNulls(values)).length == 0) {
            return null;
        }
        double[] doubleArray = MathUtils.numberArrayToDoubleArray(values);
        return MathUtils.median(doubleArray);
    }

    public static Float median(Float[] values) {
        Double median = MathUtils.median((Number[])values);
        return median == null ? null : Float.valueOf(median.floatValue());
    }

    public static BigDecimal median(BigInteger[] values) {
        if (values == null) {
            return null;
        }
        int length = (values = ArrayTool.removeNulls(values)).length;
        if (length == 0) {
            return null;
        }
        if (length == 1) {
            return new BigDecimal(values[0]);
        }
        if (length == 2) {
            BigDecimal v = new BigDecimal(values[0].add(values[1]));
            return v.divide(BigDecimal.valueOf(2L));
        }
        Object[] copy = Arrays.copyOf(values, length);
        Arrays.sort(copy);
        int index = --length >> 1;
        if (length % 2 == 0) {
            return new BigDecimal((BigInteger)copy[index]);
        }
        BigDecimal v = new BigDecimal(((BigInteger)copy[index]).add((BigInteger)copy[index + 1]));
        return v.divide(BigDecimal.valueOf(2L));
    }

    public static BigDecimal median(BigDecimal[] values) {
        if (values == null) {
            return null;
        }
        int length = (values = ArrayTool.removeNulls(values)).length;
        if (length == 0) {
            return null;
        }
        if (length == 1) {
            return values[0];
        }
        if (length == 2) {
            BigDecimal v = values[0].add(values[1]);
            return new BigDecimal("0.5").multiply(v);
        }
        Object[] copy = Arrays.copyOf(values, length);
        Arrays.sort(copy);
        int index = --length >> 1;
        if (length % 2 == 0) {
            return copy[index];
        }
        BigDecimal v = ((BigDecimal)copy[index]).add((BigDecimal)copy[index + 1]);
        return new BigDecimal("0.5").multiply(v);
    }

    public static Double median(double[] values) {
        if (values == null) {
            return null;
        }
        int length = values.length;
        if (length == 0) {
            return null;
        }
        if (length == 1) {
            return values[0];
        }
        if (length == 2) {
            return (values[0] + values[1]) * 0.5;
        }
        double[] copy = Arrays.copyOf(values, length);
        Arrays.sort(copy);
        int index = --length >> 1;
        if (length % 2 == 0) {
            return copy[index];
        }
        return (copy[index] + copy[index + 1]) * 0.5;
    }

    public static Double median(byte[] values) {
        return MathUtils.median(MathUtils.byteArrayToDoubleArray(values));
    }

    public static Double median(short[] values) {
        return MathUtils.median(MathUtils.shortArrayToDoubleArray(values));
    }

    public static Double median(int[] values) {
        return MathUtils.median(MathUtils.intArrayToDoubleArray(values));
    }

    public static Double median(long[] values) {
        return MathUtils.median(MathUtils.longArrayToDoubleArray(values));
    }

    public static Float median(float[] values) {
        Double median = MathUtils.median(MathUtils.floatArrayToDoubleArray(values));
        return median == null ? null : Float.valueOf(median.floatValue());
    }

    public static byte mod(byte number, byte divisor) {
        long quotient = MathUtils.quotient(number, divisor);
        byte intPart = (byte)quotient;
        if (quotient < 0L) {
            intPart = (byte)(intPart - 1);
        }
        return (byte)(number - intPart * divisor);
    }

    public static short mod(short number, short divisor) {
        long quotient = MathUtils.quotient(number, divisor);
        short intPart = (short)quotient;
        if (quotient < 0L) {
            intPart = (short)(intPart - 1);
        }
        return (short)(number - intPart * divisor);
    }

    public static int mod(int number, int divisor) {
        long quotient = MathUtils.quotient(number, divisor);
        int intPart = (int)quotient;
        if (quotient < 0L) {
            --intPart;
        }
        return number - intPart * divisor;
    }

    public static long mod(long number, long divisor) {
        long quotient;
        long intPart = quotient = MathUtils.quotient(number, divisor);
        if (quotient < 0L) {
            --intPart;
        }
        return number - intPart * divisor;
    }

    public static float mod(float number, float divisor) {
        long quotient = MathUtils.quotient(number, divisor);
        float intPart = quotient;
        if (quotient < 0L) {
            intPart -= 1.0f;
        }
        return number - intPart * divisor;
    }

    public static double mod(double number, double divisor) {
        long quotient = MathUtils.quotient(number, divisor);
        double intPart = quotient;
        if (quotient < 0L) {
            intPart -= 1.0;
        }
        return number - intPart * divisor;
    }

    public static Byte mod(Byte number, Byte divisor) {
        if (number == null || divisor == null) {
            return (byte)0;
        }
        return MathUtils.mod((byte)number, (byte)divisor);
    }

    public static Short mod(Short number, Short divisor) {
        if (number == null || divisor == null) {
            return (short)0;
        }
        return MathUtils.mod((short)number, (short)divisor);
    }

    public static Integer mod(Integer number, Integer divisor) {
        if (number == null || divisor == null) {
            return 0;
        }
        return MathUtils.mod((int)number, (int)divisor);
    }

    public static Long mod(Long number, Long divisor) {
        if (number == null || divisor == null) {
            return 0L;
        }
        return MathUtils.mod((long)number, (long)divisor);
    }

    public static Float mod(Float number, Float divisor) {
        if (number == null || divisor == null) {
            return Float.valueOf(0.0f);
        }
        return Float.valueOf(MathUtils.mod(number.floatValue(), divisor.floatValue()));
    }

    public static Double mod(Double number, Double divisor) {
        if (number == null || divisor == null) {
            return 0.0;
        }
        return MathUtils.mod((double)number, (double)divisor);
    }

    public static BigInteger mod(BigInteger number, BigInteger divisor) {
        long quotient;
        if (number == null || divisor == null) {
            return BigInteger.ZERO;
        }
        long intPart = quotient = MathUtils.quotient(number, divisor);
        if (quotient < 0L) {
            --intPart;
        }
        return number.subtract(BigInteger.valueOf(intPart).multiply(divisor));
    }

    public static BigDecimal mod(BigDecimal number, BigDecimal divisor) {
        long quotient;
        if (number == null || divisor == null) {
            return BigDecimal.ZERO;
        }
        long intPart = quotient = MathUtils.quotient(number, divisor);
        if (quotient < 0L) {
            --intPart;
        }
        return number.subtract(BigDecimal.valueOf(intPart).multiply(divisor));
    }

    public static long quotient(byte number, byte divisor) {
        return number / divisor;
    }

    public static long quotient(short number, short divisor) {
        return number / divisor;
    }

    public static long quotient(int number, int divisor) {
        return number / divisor;
    }

    public static long quotient(long number, long divisor) {
        return number / divisor;
    }

    public static long quotient(float number, float divisor) {
        return (long)(number / divisor);
    }

    public static long quotient(double number, double divisor) {
        return (long)(number / divisor);
    }

    public static long quotient(Byte number, Byte divisor) {
        if (number == null || divisor == null) {
            return 0L;
        }
        return MathUtils.quotient((byte)number, (byte)divisor);
    }

    public static long quotient(Short number, Short divisor) {
        if (number == null || divisor == null) {
            return 0L;
        }
        return MathUtils.quotient((short)number, (short)divisor);
    }

    public static long quotient(Integer number, Integer divisor) {
        if (number == null || divisor == null) {
            return 0L;
        }
        return MathUtils.quotient((int)number, (int)divisor);
    }

    public static long quotient(Long number, Long divisor) {
        if (number == null || divisor == null) {
            return 0L;
        }
        return MathUtils.quotient((long)number, (long)divisor);
    }

    public static long quotient(Float number, Float divisor) {
        if (number == null || divisor == null) {
            return 0L;
        }
        return MathUtils.quotient(number.floatValue(), divisor.floatValue());
    }

    public static long quotient(Double number, Double divisor) {
        if (number == null || divisor == null) {
            return 0L;
        }
        return MathUtils.quotient((double)number, (double)divisor);
    }

    public static long quotient(BigInteger number, BigInteger divisor) {
        if (number == null || divisor == null) {
            return 0L;
        }
        return MathUtils.divide(number, divisor).longValue();
    }

    public static long quotient(BigDecimal number, BigDecimal divisor) {
        if (number == null || divisor == null) {
            return 0L;
        }
        return MathUtils.divide(number, divisor).longValue();
    }

    public static BigDecimal divide(BigDecimal number, BigDecimal divisor) {
        if (number == null || divisor == null) {
            return null;
        }
        return number.divide(divisor, MathContext.DECIMAL128);
    }

    public static BigInteger divide(BigInteger number, BigInteger divisor) {
        if (number == null || divisor == null) {
            return null;
        }
        return number.divide(divisor);
    }
}

