/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;

public class CategorizedMap {
    private final HashMap<String, Category> categories = new HashMap();
    protected final HashMap<String, Object> all = new HashMap();

    private Object findByCategory(String str) {
        Category c = this.getCategory(str);
        while ((c = c.parent) != null) {
            Object res = this.all.get(c.getCategory());
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public Object get(Object key) {
        return this.getCategorized((String)key);
    }

    private Object getCategorized(String category) {
        Object res = this.all.get(category);
        return res != null ? res : this.findByCategory(category);
    }

    public synchronized Category getCategory(String cc) {
        Category c = this.categories.get(cc);
        if (c == null) {
            c = new Category(cc);
            this.setParent(c);
            this.categories.put(cc, c);
            if (c.parent != null) {
                this.reassignParents(c.getParentDistance(), c.getParent());
            } else {
                this.reassignParents(-1, null);
            }
        }
        return c;
    }

    public Object put(Object key, Object value) {
        return this.putCategorized((String)key, value);
    }

    private Object putCategorized(String category, Object value) {
        if (!this.all.containsKey(category)) {
            this.getCategory(category);
        }
        return this.all.put(category, value);
    }

    private synchronized void reassignParents(int parentDistance, Category parent) {
        for (Category c : this.categories.values()) {
            if (c.getParent() != parent || c.getParentDistance() <= parentDistance) continue;
            this.setParent(c);
        }
    }

    protected synchronized void setParent(Category cc) {
        int index;
        String search = cc.getCategory();
        int i = 1;
        while ((index = search.lastIndexOf(46)) >= 0) {
            Category parent = this.categories.get(search = search.substring(0, index));
            if (parent != null) {
                cc.setParentDistance(i);
                cc.setParent(parent);
                return;
            }
            ++i;
        }
        cc.setParent(null);
        cc.setParentDistance(0);
    }

    public Collection<Object> values() {
        return this.all.values();
    }

    private static class Category {
        private Category parent;
        private int parentDistance;
        private final String category;

        private Category(String category) {
            this.category = category;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return Objects.equals(this.category, ((Category)o).category);
        }

        public int hashCode() {
            return Objects.hashCode(this.category);
        }

        public String getCategory() {
            return this.category;
        }

        public Category getParent() {
            return this.parent;
        }

        public int getParentDistance() {
            return this.parentDistance;
        }

        public void setParent(Category category) {
            this.parent = category;
        }

        public void setParentDistance(int i) {
            this.parentDistance = i;
        }
    }
}

