/*
 * Decompiled with CFR 0.152.
 */
package org.openl.info;

import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.openl.info.OpenLLogger;
import org.openl.info.OpenLVersion;

final class SysInfoLogger
extends OpenLLogger {
    SysInfoLogger() {
    }

    @Override
    protected String getName() {
        return "sys";
    }

    @Override
    protected void discover() {
        this.log("System info:");
        try {
            this.log("    Java : {} v{} ({})", System.getProperty("java.vendor"), System.getProperty("java.version"), System.getProperty("java.class.version"));
            this.log("      OS : {} v{} ({})", System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"));
        }
        catch (Exception ignored) {
            this.log("##### Cannot access to the System properties");
        }
        try {
            Runtime runtime = Runtime.getRuntime();
            this.log("     ENV : {} CPU / Max={} MiB / Allocated={} MiB / Free={} MiB ", Integer.toString(runtime.availableProcessors()), this.toMiB(runtime.maxMemory()), this.toMiB(runtime.totalMemory()), this.toMiB(runtime.freeMemory()));
        }
        catch (Exception ignored) {
            this.log("##### Cannot access to the Runtime environment");
        }
        try {
            this.log("    Time : {} ({} - {})", new SimpleDateFormat("yyyy-MM-dd   HH:mm:ss.SSS XXX (z)").format(new Date()), TimeZone.getDefault().getID(), TimeZone.getDefault().getDisplayName());
            this.log("  Locale : {}", Locale.getDefault());
        }
        catch (Exception ignored) {
            this.log("##### Cannot access to the TimeZone or Locale");
        }
        try {
            this.log("Work dir : {}", Paths.get("", new String[0]).toAbsolutePath());
        }
        catch (Exception ignored) {
            this.log("##### Cannot access to the FileSystem");
        }
        try {
            this.log("App path : {}", OpenLVersion.class.getProtectionDomain().getCodeSource().getLocation().getPath());
        }
        catch (Exception ignored) {
            this.log("##### Cannot access to the Application location");
        }
    }

    private String toMiB(long bytes) {
        return String.valueOf((double)(bytes / 262144L) / 4.0);
    }
}

