/*
 * Decompiled with CFR 0.152.
 */
package org.openl.info;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class OpenLLogger {
    private final Logger logger;

    OpenLLogger() {
        String name = this.getName();
        this.logger = LoggerFactory.getLogger((String)("OpenL." + name));
    }

    protected abstract String getName();

    public final void log() {
        if (this.logger.isInfoEnabled()) {
            try {
                this.discover();
            }
            catch (Exception exc) {
                this.logger.info("##### {} ", (Object)exc.toString());
            }
        }
    }

    protected final void log(String text) {
        this.logger.info(text);
    }

    protected final void log(String text, String ... args) {
        this.logger.info(text, (Object[])args);
    }

    protected final void log(String text, String arg1) {
        this.logger.info(text, (Object)arg1);
    }

    protected final void log(String text, String arg1, String arg2) {
        this.logger.info(text, (Object)arg1, (Object)arg2);
    }

    protected final void log(String text, Object arg1) {
        this.logSimpleObject(text, arg1);
        this.logComplexObject(arg1);
    }

    protected final void log(String text, Object arg1, Object arg2) {
        this.logSimpleObject(text, arg1, arg2);
        this.logComplexObject(arg2);
    }

    protected abstract void discover() throws Exception;

    private String toString(Object o) {
        if (o == null) {
            return "<null>";
        }
        if (o.getClass().isArray()) {
            int length = Array.getLength(o);
            return "<" + o.getClass().getComponentType().getSimpleName() + "[" + length + "]>";
        }
        if (o.getClass().isEnum()) {
            return "<" + o.getClass().getName() + "." + ((Enum)o).name() + "]>";
        }
        return o.toString();
    }

    private void logSimpleObject(String text, Object arg1, Object arg2) {
        this.logger.info(text, (Object)this.toString(arg1), (Object)this.toString(arg2));
    }

    private void logSimpleObject(String text, Object arg1) {
        this.logger.info(text, (Object)this.toString(arg1));
    }

    private void logComplexObject(Object value) {
        block8: {
            PropertyDescriptor[] pds;
            BeanInfo bi;
            block10: {
                block9: {
                    if (!(value instanceof Map)) break block9;
                    int i = 0;
                    for (Map.Entry entry : ((Map)value).entrySet()) {
                        this.logSimpleObject("    '{}' = {}", entry.getKey(), entry.getValue());
                        if (i++ < 50) continue;
                        this.log("    #### More than 50 elements");
                        break block8;
                    }
                    break block8;
                }
                if (!(value instanceof Collection)) break block10;
                int i = 0;
                for (Object item : (Collection)value) {
                    this.logSimpleObject("    [{}] = {}", i++, item);
                    if (i < 10) continue;
                    this.log("    #### More than 10 elements");
                    break block8;
                }
                break block8;
            }
            if (this.isSimpleType(value)) break block8;
            try {
                bi = Introspector.getBeanInfo(value.getClass());
            }
            catch (Exception e) {
                return;
            }
            for (PropertyDescriptor pd : pds = bi.getPropertyDescriptors()) {
                String propName = pd.getName();
                if ("class".equals(propName)) continue;
                try {
                    Method readMethod = pd.getReadMethod();
                    if (readMethod != null) {
                        Object propValue = readMethod.invoke(value, new Object[0]);
                        this.logSimpleObject("    {} = {}", propName, propValue);
                        continue;
                    }
                    this.log("    {} = <no access>", propName);
                }
                catch (Exception ex) {
                    this.log("    {} = <exception>", propName);
                }
            }
        }
    }

    private boolean isSimpleType(Object o) {
        return o == null || o instanceof Number || o instanceof CharSequence || o instanceof Class || o instanceof URL || o instanceof URI || o instanceof File || o instanceof Path || o instanceof Iterable || o instanceof Map || o.getClass().isArray() || o.getClass().isEnum() || o.getClass().isAnnotation() || o.getClass().isInterface() || o.getClass().isPrimitive() || o.getClass().getName().startsWith("java") || o.getClass().getName().startsWith("org.apache.naming");
    }
}

