/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.generators.annotations;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import javax.tools.StandardLocation;
import org.openjdk.jmh.generators.annotations.APMetadataInfo;
import org.openjdk.jmh.generators.core.GeneratorDestination;
import org.openjdk.jmh.generators.core.MetadataInfo;
import org.openjdk.jmh.util.Utils;

public class APGeneratorDestinaton
implements GeneratorDestination {
    private final ProcessingEnvironment processingEnv;

    public APGeneratorDestinaton(RoundEnvironment roundEnv, ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
    }

    public OutputStream newResource(String resourcePath) throws IOException {
        return this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", resourcePath, new Element[0]).openOutputStream();
    }

    public InputStream getResource(String resourcePath) throws IOException {
        return this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", resourcePath).openInputStream();
    }

    public Writer newClass(String className) throws IOException {
        return this.processingEnv.getFiler().createSourceFile(className, new Element[0]).openWriter();
    }

    public void printError(String message) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message);
    }

    public void printError(String message, MetadataInfo element) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message, ((APMetadataInfo)element).getElement());
    }

    public void printError(String message, Throwable throwable) {
        this.printError(message + " " + Utils.throwableToString((Throwable)throwable));
    }

    public void printWarning(String message) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, message);
    }

    public void printWarning(String message, MetadataInfo element) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, message, ((APMetadataInfo)element).getElement());
    }

    public void printWarning(String message, Throwable throwable) {
        this.printWarning(message + " " + Utils.throwableToString((Throwable)throwable));
    }

    public void printNote(String message) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, message);
    }
}

